/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.mail;

import com.sun.portal.wireless.taglibs.base.CommandTag;
import com.sun.portal.wireless.taglibs.base.Util;
import com.sun.portal.wireless.taglibs.mail.FolderBean;
import com.sun.portal.wireless.taglibs.mail.LineBean;
import com.sun.portal.wireless.taglibs.mail.MailContext;
import com.sun.portal.wireless.taglibs.mail.MailUtils;
import com.sun.portal.wireless.taglibs.mail.MsgBean;
import com.sun.portal.wireless.taglibs.mail.ViewBean;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

public class FetchTag
extends CommandTag {
    private static final String SHARED_FOLDERS = "Shared Folders";
    private static final String SHARED_FOLDERS_NAMESPACE = "Shared Folders/User";
    String collection = null;
    String id = null;
    String sd = null;
    String sb = null;
    MailContext mc;

    public boolean execute() throws JspException {
        block8: {
            try {
                this.mc = MailContext.getContext(((TagSupport)this).pageContext);
            }
            catch (Exception e) {
                throw new JspException(((Object)((Object)this)).getClass().getName() + ".execute():  Couldn't get mail context:  " + e.getMessage());
            }
            try {
                if (this.collection.equals("messages")) {
                    this.doMsgsFetch();
                    break block8;
                }
                if (this.collection.equals("folders")) {
                    this.doFoldersFetch();
                    break block8;
                }
                if (this.collection.equals("lines")) {
                    this.doLinesFetch();
                    break block8;
                }
                if (this.collection.equals("presetmsgs")) {
                    this.mc.doPresetMessagesFetch();
                    break block8;
                }
                Util.logWarning((String)(((Object)((Object)this)).getClass().getName() + ".execute():  Unknown collection type specified"));
                this.release();
                this.mc.setErrorCode("");
                return false;
            }
            catch (MessagingException me) {
                Util.logWarning((String)(((Object)((Object)this)).getClass().getName() + ".execute():  Possible error while fetching collection type: " + this.collection), (Throwable)me);
                return false;
            }
        }
        this.release();
        return true;
    }

    public void release() {
        super.release();
        this.collection = null;
        this.id = null;
        this.sd = null;
        this.sb = null;
    }

    public void setCollection(String str) {
        this.collection = str;
    }

    public void setSb(String str) {
        this.sb = this.evalAttribute(str);
    }

    public void setSd(String str) {
        this.sd = this.evalAttribute(str);
    }

    public void setid(String str) {
        this.id = this.evalAttribute(str);
    }

    private void doFoldersFetch() throws JspException, MessagingException {
        Folder tmp = null;
        try {
            Store store;
            if (this.id == null || this.id.length() == 0) {
                store = this.mc.getMailStore();
                tmp = store.getDefaultFolder();
            } else {
                store = this.mc.getMailStore();
                if (this.id.equals(SHARED_FOLDERS)) {
                    this.id = SHARED_FOLDERS_NAMESPACE;
                }
                tmp = store.getFolder(this.id);
            }
        }
        catch (MessagingException e) {
            throw new JspException(((Object)((Object)this)).getClass().getName() + ".doFoldersFetch() failed:  " + e.toString());
        }
        if (tmp != null) {
            if (!tmp.exists()) {
                this.mc.setErrorCode("MAIL_005");
                throw new MessagingException("Folder (" + this.id + ") does not exist!");
            }
        } else {
            throw new JspException(((Object)((Object)this)).getClass().getName() + ":  Currentfolder is null.");
        }
        Folder[] f = tmp.list();
        Object[] fdrs = MailUtils.toFolderBeanArray(f);
        MailUtils.setSortDirection(this.sd);
        this.sortArray(fdrs, "folders");
        this.mc.setFoldersCollection((FolderBean[])fdrs);
    }

    private void doLinesFetch() throws JspException {
        int i = 0;
        i = Integer.parseInt(this.id);
        MsgBean[] msgs = this.mc.getMsgsCollection();
        if (msgs == null) {
            throw new JspException(((Object)((Object)this)).getClass().getName() + ".doLinesFetch():  No messages collection");
        }
        if (i < 0) {
            i = 0;
        }
        if (i > msgs.length - 1) {
            i = msgs.length - 1;
        }
        this.mc.setMsg(msgs[i]);
        this.mc.setMsgIdx(i);
        int lineLength = this.mc.getLineLength();
        LineBean[] lines = lineLength == 0 ? msgs[i].toLines() : msgs[i].toLines(lineLength);
        this.mc.setLinesCollection(lines);
    }

    private void doMsgsFetch() throws JspException, MessagingException {
        Object[] msgs;
        Folder tmp = null;
        if (this.id != null && this.id.length() > 0) {
            String oldName;
            try {
                Store store = this.mc.getMailStore();
                tmp = store.getFolder(this.id);
            }
            catch (MessagingException e) {
                throw new JspException(((Object)((Object)this)).getClass().getName() + ".doMsgsFetch():  failed:  " + e.toString());
            }
            if (!tmp.exists()) {
                this.mc.setErrorCode("MAIL_005");
                throw new MessagingException("Folder (" + this.id + ") does not exist!");
            }
            Folder curFolder = this.mc.getCurrentFolder().getFolder();
            String newName = tmp.getFullName();
            if (newName.equals(oldName = curFolder.getFullName())) {
                tmp = curFolder;
            } else {
                try {
                    if (curFolder.isOpen()) {
                        curFolder.close(true);
                    }
                }
                catch (MessagingException e) {
                    // empty catch block
                }
                this.mc.setCurrentFolder(new FolderBean(tmp));
                this.mc.setCurrentView("-1");
            }
        } else {
            tmp = this.mc.getCurrentFolder().getFolder();
        }
        if (tmp != null) {
            msgs = null;
            if (!tmp.isOpen()) {
                try {
                    tmp.open(2);
                }
                catch (MessagingException e) {
                    try {
                        tmp.open(1);
                        this.mc.setCurrentFolder(new FolderBean(tmp));
                    }
                    catch (MessagingException me) {
                        this.mc.setErrorCode("MAIL_006");
                        throw me;
                    }
                }
            }
            ViewBean view = this.mc.getCurrentViewBean();
            try {
                Message[] notDeleted = tmp.search(view.getRules());
                msgs = MailUtils.toBeanArray(notDeleted, this.mc.getFrom(), this.mc.getTimeZone());
            }
            catch (MessagingException e) {
                this.mc.setErrorCode("MAIL_007");
                throw e;
            }
        }
        throw new JspException(((Object)((Object)this)).getClass().getName() + ".doMsgsFetch():  Specified folder is null.");
        MailUtils.setSortDirection(this.sd);
        this.sortArray(msgs, this.sb);
        this.mc.setMsgsCollection((MsgBean[])msgs);
    }

    private void sortArray(Object[] in, String field) throws JspException {
        if (field == null) {
            field = "inbox";
        }
        List<Object> arr = Arrays.asList(in);
        Collator collate = Collator.getInstance(this.mc.getLocale());
        Comparator comp = null;
        if (field.equals("inbox")) {
            MailUtils.inboxOrder(in);
        } else if (field.equals("subject")) {
            comp = new MailUtils.MsgSubjectComparator(collate);
            MailUtils.prefetch((MsgBean[])in, "Subject");
            Arrays.sort(in, comp);
        } else if (field.equals("folders")) {
            comp = new MailUtils.FolderComparator(collate);
            Arrays.sort(in, comp);
        } else if (field.equals("from")) {
            comp = new MailUtils.MsgFromComparator(collate);
            MailUtils.prefetch((MsgBean[])in, "From");
            Arrays.sort(in, comp);
        } else if (field.equals("date")) {
            comp = new MailUtils.MsgDateComparator();
            MailUtils.prefetch((MsgBean[])in, "Date");
            Arrays.sort(in, comp);
        } else if (field.equals("id")) {
            comp = new MailUtils.MsgIdComparator();
            Arrays.sort(in, comp);
        } else if (field.equals("seen")) {
            comp = new MailUtils.MsgSeenComparator();
            Arrays.sort(in, comp);
        } else if (field.equals("recent")) {
            comp = new MailUtils.MsgRecentComparator();
            Arrays.sort(in, comp);
        } else {
            throw new JspException("Unknown sort field specified:" + field);
        }
    }
}

