/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.profile;

import com.aligo.profile.ProfileNames;
import com.aligo.profile.UAProfileBase;
import com.aligo.profile.interfaces.UAProfile;
import com.iplanet.services.cdm.Client;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class UAProfileClient
implements UAProfile {
    private Client client_;
    private HashMap additionalAttrs_;
    public static String COMMA = ",";
    public static String PIPE = "|";
    public static String X = "X";
    public static String CLIENT_TYPE = "clientType";
    public static String CONTENT_TYPE = "contentType";
    public static String FILE_PATH = "filePath";
    public static String PARENT_ID = "parentId";
    public static String USER_AGENT = "userAgent";
    public static String BLUE_TOOTH_PROFILE = "BluetoothProfile";
    public static String BITS_PER_PIXEL = "BitsPerPixel";
    public static String COLOR_CAPABLE = "ColorCapable";
    public static String CPU = "CPU";
    public static String IMAGE_CAPABLE = "ImageCapable";
    public static String INPUT_CHARSET = "InputCharset";
    public static String KEYBOARD = "Keyboard";
    public static String MODEL = "Model";
    public static String NUMBER_OF_SOFT_KEYS = "NumberOfSoftKeys";
    public static String OUTPUT_CHARSET = "OutputCharset";
    public static String PIXEL_ASPECT_RATIO = "PixelAspectRatio";
    public static String POINTING_RESOLUTION = "PointingResolution";
    public static String SCREEN_SIZE = "ScreenSize";
    public static String SCREEN_SIZE_CHAR = "ScreenSizeChar";
    public static String SOUND_OUTPUT_CAPABLE = "SoundOutputCapable";
    public static String STANDARD_FONT_PROPORTIONAL = "StandardFondProportional";
    public static String TEXT_INPUT_CAPABLE = "TextInputCapable";
    public static String VENDOR = "Vendor";
    public static String VOICE_INPUT_CAPABLE = "VoiceInputCapable";
    public static String ACCEPT_DOWNLOADABLE_SOFTWARE = "AcceptDownloadableSoftware";
    public static String AUDIO_INPUT_ENCODER = "AudioInputEncoder";
    public static String CCPP_ACCEPT = "CcppAccept";
    public static String CCPP_ACCEPT_CHARSET = "CcppAccept-Charset";
    public static String CCPP_ACCEPT_ENCODING = "CcppAccept-Encoding";
    public static String CCPP_ACCEPT_LANGUAGE = "CcppAccept-Language";
    public static String DOWNLOADABLE_SOFTWARE_SUPPORT = "DownloadableSoftwareSupport";
    public static String JAVA_ENABLED = "JavaEnabled";
    public static String JAVA_PLATFORM = "JavaPlatform";
    public static String JVM_VERSION = "JVMVersion";
    public static String MEXE_CLASSMARK = "MexeClassmark";
    public static String MEXE_CLASSMARKS = "MexeClassmarks";
    public static String MEXE_SECURE_DOMAINS = "MexeSecureDomains";
    public static String MEXE_SPEC = "MexeSpec";
    public static String OS_NAME = "OSName";
    public static String OS_VENDOR = "OSVendor";
    public static String OS_VERSION = "OSVersion";
    public static String SOFTWARE_NUMBER = "SoftwareNumber";
    public static String VIDEO_INPUT_ENCODER = "VideoInputEncoder";
    public static String CURRENT_BEARER_SERVICE = "CurrentBearerService";
    public static String SECURITY_SUPPORT = "SecuritySupport";
    public static String SUPPORTED_BEARERS = "SupportedBearers";
    public static String SUPPORTED_BLUETOOTH_VERSION = "SupportedBluetoothVersion";
    public static String BROWSER_NAME = "BrowserName";
    public static String BROWSER_VERSION = "BrowserVersion";
    public static String DOWNLOADABLE_BROWSER_APPS = "DownloadableBrowserApps";
    public static String FRAMES_CAPABLE = "FramesCapable";
    public static String HTML_VERSION = "HtmlVersion";
    public static String JAVA_APPLET_ENABLED = "JavaAppletEnabled";
    public static String JAVA_SCRIPT_ENABLED = "JavaScriptEnabled";
    public static String JAVA_SCRIPT_VERSION = "JavaScriptVersion";
    public static String PREFERENCES_FOR_FRAMES = "PreferencesForFrames";
    public static String TABLES_CAPABLE = "TablesCapable";
    public static String XHTML_MODULES = "XhtmlModules";
    public static String XHTML_VERSION = "XhtmlVersion";
    public static String SUPPORTED_PICTOGRAM_SET = "SupportedPictogramSet";
    public static String WAP_DEVICE_CLASS = "WapDeviceClass";
    public static String WAP_PUSH_MSG_PRIORITY = "WapPushMsgPriority";
    public static String WAP_PUSH_MSG_SIZE = "WapPushMsgSize";
    public static String WAP_VERSION = "WapVersion";
    public static String WML_DECK_SIZE = "WmlDeckSize";
    public static String WML_SCRIPT_LIBRARIES = "WmlScriptLibraries";
    public static String WML_SCRIPT_VERSION = "WmlScriptVersion";
    public static String WML_VERSION = "WmlVersion";
    public static String WTAI_LIBRARIES = "WtaiLibraries";
    public static String WTA_VERSION = "WtaVersion";
    public static String PUSH_ACCEPT = "Push-Accept";
    public static String PUSH_ACCEPT_CHARSET = "Push-Accept-Charset";
    public static String PUSH_ACCEPT_ENCODING = "Push-Accept-Encoding";
    public static String PUSH_ACCEPT_LANGUAGE = "Push-Accept-Language";
    public static String PUSH_ACCEPT_APPID = "Push-Accept-AppID";
    public static String PUSH_MSG_SIZE = "Push-MsgSize";
    public static String PUSH_MAX_PUSH_REQ = "Push-MaxPushReq";
    public static String PDU_SIZE = WML_DECK_SIZE;
    private String xmlID;
    private String amlID;
    private int iPDUSize = -1;

    public UAProfileClient() {
    }

    public UAProfileClient(Client client) {
        this.setClient(client);
    }

    public void setClient(Client client) {
        this.client_ = client;
        this.xmlID = null;
        this.amlID = null;
    }

    public String getAmlID() {
        if (this.amlID == null) {
            Set parents = this.getClientProperties(PARENT_ID);
            String tamlID = this.getToken(parents, -2);
            this.amlID = tamlID != null ? ProfileNames.convert(tamlID) : null;
        }
        return this.amlID;
    }

    public String getXmlID() {
        if (this.xmlID == null) {
            Set parents = this.getClientProperties(PARENT_ID);
            this.xmlID = ProfileNames.convert(this.getToken(parents, -1));
        }
        return this.xmlID;
    }

    public Date getCreated() {
        return null;
    }

    public Date getLastModified() {
        return null;
    }

    public String getLocation() {
        return "Client";
    }

    public Boolean getAllowOverride() {
        return Boolean.FALSE;
    }

    public boolean allowOverride() {
        return false;
    }

    public String getBaseProfileID() {
        Set parents = this.getClientProperties(PARENT_ID);
        return ProfileNames.convert(this.getToken(parents, 0));
    }

    public UAProfileBase getBaseProfile() {
        return null;
    }

    public HashMap getAdditionalAttributes() {
        return null;
    }

    public String getKeyboard() {
        return this.getClientProperty(KEYBOARD);
    }

    public Boolean getImageCapable() {
        String imgCap = this.getClientProperty(IMAGE_CAPABLE);
        return Boolean.valueOf(imgCap);
    }

    public boolean isImageCapable() {
        return this.getImageCapable();
    }

    public Boolean getVoiceInputCapable() {
        String voiceInputCap = this.getClientProperty(VOICE_INPUT_CAPABLE);
        return Boolean.valueOf(voiceInputCap);
    }

    public boolean isVoiceInputCapable() {
        return this.getVoiceInputCapable();
    }

    public String getVendor() {
        return this.getClientProperty(VENDOR);
    }

    public String getModel() {
        return this.getClientProperty(MODEL);
    }

    public String getScreenSize() {
        return this.getClientProperty(SCREEN_SIZE);
    }

    public String getScreenSizeChar() {
        return this.getClientProperty(SCREEN_SIZE_CHAR);
    }

    public int getScreenHeight() {
        return this.getIntToken(this.getScreenSize().toUpperCase(), X, 1);
    }

    public int getScreenHeightChar() {
        return this.getIntToken(this.getScreenSizeChar().toUpperCase(), X, 1);
    }

    public int getScreenWidth() {
        return this.getIntToken(this.getScreenSize().toUpperCase(), X, 0);
    }

    public int getScreenWidthChar() {
        return this.getIntToken(this.getScreenSizeChar().toUpperCase(), X, 0);
    }

    public String getPixelAspectRatio() {
        return this.getClientProperty(PIXEL_ASPECT_RATIO);
    }

    public int getPixelAspectRatioWidth() {
        return this.getIntToken(this.getPixelAspectRatio().toUpperCase(), X, 0);
    }

    public int getPixelAspectRatioHeight() {
        return this.getIntToken(this.getPixelAspectRatio().toUpperCase(), X, 1);
    }

    public Boolean getStandardFontProportional() {
        return Boolean.valueOf(this.getClientProperty(STANDARD_FONT_PROPORTIONAL));
    }

    public boolean isStandardFontProportional() {
        return this.getStandardFontProportional();
    }

    public String getCPU() {
        return this.getClientProperty(CPU);
    }

    public int getBitsPerPixel() {
        return this.toInt(this.getClientProperty(BITS_PER_PIXEL));
    }

    public String[] getOutputCharSet() {
        return this.getTokens(this.getClientProperty(OUTPUT_CHARSET), COMMA);
    }

    public Boolean getTextInputCapable() {
        return Boolean.valueOf(this.getClientProperty(TEXT_INPUT_CAPABLE));
    }

    public boolean isTextInputCapable() {
        return this.getTextInputCapable();
    }

    public int getNumberOfSoftKeys() {
        return this.toInt(this.getClientProperty(NUMBER_OF_SOFT_KEYS));
    }

    public Boolean getSoundOutputCapable() {
        return Boolean.valueOf(this.getClientProperty(SOUND_OUTPUT_CAPABLE));
    }

    public boolean isSoundOutputCapable() {
        return this.getSoundOutputCapable();
    }

    public Boolean getColorCapable() {
        return Boolean.valueOf(this.getClientProperty(COLOR_CAPABLE));
    }

    public boolean isColorCapable() {
        return this.getColorCapable();
    }

    public String[] getInputCharSet() {
        return this.getTokens(this.getClientProperty(INPUT_CHARSET), COMMA);
    }

    public String getPointingResolution() {
        return this.getClientProperty(POINTING_RESOLUTION);
    }

    public String[] getVideoInputEncoder() {
        return this.getTokens(this.getClientProperty(VIDEO_INPUT_ENCODER), COMMA);
    }

    public Boolean getAcceptDownloadableSoftware() {
        return Boolean.valueOf(this.getClientProperty(ACCEPT_DOWNLOADABLE_SOFTWARE));
    }

    public boolean acceptDownloadableSoftware() {
        return this.getAcceptDownloadableSoftware();
    }

    public String[] getAudioInputEncoder() {
        return this.getTokens(this.getClientProperty(AUDIO_INPUT_ENCODER), COMMA);
    }

    public String getMexeClassmark() {
        return this.getClientProperty(MEXE_CLASSMARK);
    }

    public String getRecipientAppAgent() {
        return this.getClientProperty(USER_AGENT);
    }

    public String getOSName() {
        return this.getClientProperty(OS_NAME);
    }

    public String getOSVendor() {
        return this.getClientProperty(OS_VENDOR);
    }

    public String getOSVersion() {
        return this.getClientProperty(OS_VERSION);
    }

    public String getSoftwareNumber() {
        return this.getClientProperty(SOFTWARE_NUMBER);
    }

    public String getMexeSpec() {
        return this.getClientProperty(MEXE_SPEC);
    }

    public String[] getDownloadableSoftwareSupport() {
        return this.getTokens(this.getClientProperty(DOWNLOADABLE_SOFTWARE_SUPPORT), COMMA);
    }

    public String[] getJVMVersion() {
        return this.getTokens(this.getClientProperty(JVM_VERSION), COMMA);
    }

    public String[] getSupportedBearers() {
        return this.getTokens(this.getClientProperty(SUPPORTED_BEARERS), COMMA);
    }

    public String getCurrentBearerService() {
        return this.getClientProperty(CURRENT_BEARER_SERVICE);
    }

    public String getSecuritySupport() {
        return this.getClientProperty(SECURITY_SUPPORT);
    }

    public Boolean getFramesCapable() {
        return Boolean.valueOf(this.getClientProperty(FRAMES_CAPABLE));
    }

    public boolean isFramesCapable() {
        return this.getFramesCapable();
    }

    public String getJavaScriptVersion() {
        return this.getClientProperty(JAVA_SCRIPT_VERSION);
    }

    public String getBrowserName() {
        return this.getClientProperty(BROWSER_NAME);
    }

    public String getBrowserVersion() {
        return this.getClientProperty(BROWSER_VERSION);
    }

    public String[] getCcppAcceptLanguage() {
        return this.getTokens(this.getClientProperty(CCPP_ACCEPT_LANGUAGE), COMMA);
    }

    public String[] getDownloadableBrowserApps() {
        return this.getTokens(this.getClientProperty(DOWNLOADABLE_BROWSER_APPS), COMMA);
    }

    public Boolean getPreferenceForFrames() {
        return Boolean.valueOf(this.getClientProperty(PREFERENCES_FOR_FRAMES));
    }

    public boolean hasPreferenceForFrames() {
        return this.getPreferenceForFrames();
    }

    public String[] getCcppAcceptCharSet() {
        return this.getTokens(this.getClientProperty(CCPP_ACCEPT_CHARSET), COMMA);
    }

    public Boolean getTablesCapable() {
        return Boolean.valueOf(this.getClientProperty(TABLES_CAPABLE));
    }

    public boolean isTablesCapable() {
        return this.getTablesCapable();
    }

    public String[] getCcppAcceptEncoding() {
        return this.getTokens(this.getClientProperty(CCPP_ACCEPT_ENCODING), COMMA);
    }

    public String getXhtmlVersion() {
        return this.getClientProperty(XHTML_VERSION);
    }

    public String getHtmlVersion() {
        return this.getClientProperty(HTML_VERSION);
    }

    public String[] getXhtmlModules() {
        return this.getTokens(this.getClientProperty(XHTML_MODULES), COMMA);
    }

    public String[] getCcppAccept() {
        return this.getTokens(this.getClientProperty(CCPP_ACCEPT), COMMA);
    }

    public String[] getWmlScriptVersion() {
        return this.getTokens(this.getClientProperty(WML_SCRIPT_VERSION), COMMA);
    }

    public String[] getWmlScriptLibraries() {
        return this.getTokens(this.getClientProperty(WML_SCRIPT_LIBRARIES), COMMA);
    }

    public int getWapPushMsgSize() {
        return this.toInt(this.getClientProperty(WAP_PUSH_MSG_SIZE));
    }

    public int getPDUSize() {
        if (this.iPDUSize == -1) {
            return this.toInt(this.getClientProperty(PDU_SIZE));
        }
        return this.iPDUSize;
    }

    public String getWapPushMsgPriority() {
        return this.getClientProperty(WAP_PUSH_MSG_PRIORITY);
    }

    public String[] getWtaiLibraries() {
        return this.getTokens(this.getClientProperty(WTAI_LIBRARIES), COMMA);
    }

    public String[] getWmlVersion() {
        return this.getTokens(this.getClientProperty(WML_VERSION), COMMA);
    }

    public String getWapVersion() {
        return this.getClientProperty(WAP_VERSION);
    }

    public String getWapDeviceClass() {
        return this.getClientProperty(WAP_DEVICE_CLASS);
    }

    public boolean changedAfter(Date date) {
        return false;
    }

    public boolean equals(UAProfile profile) {
        return false;
    }

    public String toString() {
        return null;
    }

    public void setPDUSize(int pduSize) {
        this.iPDUSize = pduSize;
    }

    private String reverse(String source) {
        return new StringBuffer(source).reverse().toString();
    }

    private String getToken(String source, String delim, int number) {
        StringTokenizer st = new StringTokenizer(source, delim);
        String token = null;
        boolean done = false;
        int index = 0;
        while (st.hasMoreTokens() && !done) {
            String currtoken = st.nextToken();
            if (index >= number) {
                token = currtoken;
                done = true;
            }
            ++index;
        }
        return token;
    }

    private int getIntToken(String source, String delim, int number) {
        String stoken = this.getToken(source, delim, number);
        return this.toInt(stoken);
    }

    private int toInt(String str) {
        int val = -1;
        try {
            val = Integer.parseInt(str);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return val;
    }

    private String[] getTokens(String source, String delim) {
        StringTokenizer st = new StringTokenizer(source, delim);
        String[] tokens = new String[st.countTokens()];
        int index = 0;
        while (st.hasMoreTokens()) {
            tokens[index] = st.nextToken();
            ++index;
        }
        return tokens;
    }

    private String getClientProperty(String propName) {
        return this.client_.getProperty(propName);
    }

    private Set getClientProperties(String propName) {
        return this.client_.getProperties(propName);
    }

    private String getToken(Set parents, int index) {
        String token = "";
        int i = 0;
        Iterator it = parents.iterator();
        if (index < 0) {
            int size = parents.size();
            index = size + index;
        }
        while (i < index && it.hasNext()) {
            it.next();
            ++i;
        }
        if (it.hasNext()) {
            token = (String)it.next();
        }
        return token;
    }
}

