/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.portal.wireless.services.rendering;

import com.aligo.engine.logging.interfaces.LoggerInterface;
import com.aligo.portal.wireless.services.rendering.CommonLogger;
import com.aligo.portal.wireless.services.rendering.Logger;
import com.aligo.portal.wireless.services.rendering.RenderingEngine;
import com.sun.portal.wireless.services.responsebuffer.ResponseBufferEntry;

public class RenderingEngineFactory {
    private static RenderingEngineFactory actualFactory;
    private LoggerInterface logger;

    private RenderingEngineFactory() {
        this.setLogger(new CommonLogger());
    }

    public static synchronized RenderingEngineFactory getInstance() {
        if (actualFactory == null) {
            actualFactory = new RenderingEngineFactory();
        }
        return actualFactory;
    }

    public void setLogger(LoggerInterface logger) {
        this.logger = logger;
        RenderingEngine.setLogger(logger);
    }

    public LoggerInterface getLogger() {
        return this.logger;
    }

    public RenderingEngine getEngine(ResponseBufferEntry entry, Logger logger) {
        RenderingEngine renderer = new RenderingEngine(entry, logger);
        return renderer;
    }

    public RenderingEngine getEngine(ResponseBufferEntry entry, String logName) {
        return this.getEngine(entry, new Logger(logName));
    }
}

