/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.manager;

import com.aligo.logging.GlobalLogger;
import com.aligo.modules.manager.config.StyleManagerConfig;
import com.aligo.modules.manager.exceptions.StyleManagerException;
import com.aligo.modules.manager.interfaces.StyleManager;
import com.aligo.modules.manager.log.StyleDebugLog;
import com.aligo.modules.manager.log.StyleErrorLog;
import com.aligo.modules.maps.MapContainer;
import com.aligo.modules.maps.interfaces.MapContainerInterface;
import com.aligo.modules.maps.interfaces.MapInterface;
import com.aligo.modules.maps.interfaces.MapMatcherInterface;
import com.aligo.modules.styles.XmlStyleID;
import com.aligo.modules.styles.interfaces.StyleIDInterface;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;

public class StyleManagerImpl
implements StyleManager {
    private static final String GET_REQUEST = "GET";
    private static final long DEFAULT_LOG_FLUSH_PERIOD = 600000L;
    private static String logDir_;
    private static String serverLogFileName_;
    private static String externalLibraryJar_;
    private static String internalLibraryJar_;
    private static Map internalLibrary_;
    private static Map externalLibrary_;
    private static Map externalStyleIDNumber_;
    private static String externalBaseStyleID_;
    private static Timer logTimer_;
    private static Date today;
    private static boolean initialized_;
    private static String confFileName_;

    private StyleManagerImpl() {
    }

    public StyleManagerImpl(InputStreamReader confFile, InputStream internalLib, InputStream externalLib) throws StyleManagerException {
        this.init(confFile, internalLib, externalLib);
    }

    private void init(InputStreamReader confFile, InputStream internalLib, InputStream externalLib) throws StyleManagerException {
        block16: {
            try {
                StyleManagerConfig.init(confFile);
            }
            catch (Exception ex) {
                String msg = "Error loading XML configuration file: ";
                throw new StyleManagerException(msg + ex.getMessage());
            }
            SecurityManager sm = System.getSecurityManager();
            try {
                if (sm != null) {
                    sm.checkPermission(new RuntimePermission("exit"));
                }
                Runtime.getRuntime();
                Runtime.runFinalizersOnExit((boolean)true);
            }
            catch (SecurityException ex) {
                // empty catch block
            }
            try {
                long period;
                logDir_ = StyleManagerConfig.resolve("/StyleManager/LogDir");
                if (logDir_ != null && !logDir_.equals("")) {
                    GlobalLogger.init(logDir_);
                } else {
                    GlobalLogger.init();
                }
                StyleErrorLog.init(true);
                boolean logDebug = Boolean.valueOf(StyleManagerConfig.resolve("/StyleManager/LogDebugFlag"));
                if (logDebug) {
                    StyleDebugLog.init(true);
                } else {
                    StyleDebugLog.init(false);
                }
                String periodStr = StyleManagerConfig.resolve("/StyleManager/LogFlushPeriodMsec");
                try {
                    period = Long.parseLong(periodStr);
                }
                catch (Exception ex) {
                    period = 600000L;
                }
                today = new Date();
                logTimer_ = new Timer(true);
                logTimer_.scheduleAtFixedRate(new TimerTask(){

                    public void run() {
                        today = new Date();
                        StringBuffer msg = new StringBuffer("Timer called at ");
                        msg.append(today);
                        msg.append(".....Flushing logs");
                        StyleDebugLog.log(msg.toString());
                        StyleDebugLog.flush();
                    }
                }, today, period);
                externalStyleIDNumber_ = Collections.synchronizedMap(new HashMap());
                externalBaseStyleID_ = StyleManagerConfig.resolve("/StyleManager/ExternalBaseStyleID");
                internalLibrary_ = Collections.synchronizedMap(new HashMap());
                internalLibraryJar_ = StyleManagerConfig.resolve("/StyleManager/InternalLibrary");
                this.loadLibrary(internalLibrary_, internalLib);
                try {
                    externalLibrary_ = Collections.synchronizedMap(new HashMap());
                    externalLibraryJar_ = StyleManagerConfig.resolve("/StyleManager/ExternalLibrary");
                    if (externalLib != null) {
                        this.loadLibrary(externalLibrary_, externalLib);
                        break block16;
                    }
                    StyleDebugLog.log(this.composeLog("StyleManager.init", "External libarary not provided"));
                }
                catch (Exception ex) {}
            }
            catch (Exception ex) {
                this.throwError("StyleManager.init", "Error configuring StyleManager ", ex);
            }
        }
        initialized_ = true;
    }

    private synchronized void loadStyleMap(Map library, MapInterface styleMap) throws StyleManagerException {
        MapMatcherInterface matcher = styleMap.getMapMatcher();
        String protocol = matcher.getXmlID();
        MapContainer mapContainer = (MapContainer)library.get(protocol);
        mapContainer.addMap(styleMap);
    }

    /*
     * WARNING - void declaration
     */
    private void loadLibrary(Map library, InputStream jarFile) throws StyleManagerException {
        if (jarFile == null) {
            this.throwError("StyleManager.loadLibrary", "jar does not exist,", null);
        } else {
            try {
                ZipEntry entry;
                BufferedInputStream bis = new BufferedInputStream(jarFile);
                JarInputStream jar = new JarInputStream((InputStream)bis, false);
                MapInterface styleMap = null;
                Enumeration styleMaps = null;
                MapContainer mapContainer = null;
                while ((entry = jar.getNextEntry()) != null) {
                    void var5_9;
                    String entryName = var5_9.getName();
                    if (var5_9.isDirectory() || entryName.indexOf(".xml") <= 0) continue;
                    try {
                        InputStreamReader reader = new InputStreamReader(jar);
                        MapContainer tmpMapContainer = new MapContainer();
                        tmpMapContainer.fromXml(reader);
                        styleMaps = tmpMapContainer.getMaps();
                    }
                    catch (Exception xmlex) {
                        StyleErrorLog.log("StyleManager.loadLibrary: Error loading xml file, " + var5_9.getName(), xmlex);
                    }
                    while (styleMaps != null && styleMaps.hasMoreElements()) {
                        styleMap = (MapInterface)styleMaps.nextElement();
                        MapMatcherInterface matcher = styleMap.getMapMatcher();
                        String protocol = matcher.getXmlID();
                        if (protocol == null) {
                            StyleErrorLog.log("StyleManager.loadLibrary: protocol is null");
                            continue;
                        }
                        if (!library.containsKey(protocol)) {
                            mapContainer = new MapContainer();
                            library.put(protocol, mapContainer);
                        } else {
                            mapContainer = (MapContainer)library.get(protocol);
                        }
                        mapContainer.addMap(styleMap);
                    }
                }
            }
            catch (Exception ex) {
                this.throwError("StyleManager.loadLibrary", "Error loading library ", ex);
            }
        }
    }

    private String getStyleFileName(MapInterface styleMap) {
        StringBuffer fileName = new StringBuffer(styleMap.getStyleComponentInterface().getStyleID().toString());
        this.replaceChar(fileName, ' ', '_');
        this.replaceChar(fileName, '/', '_');
        this.replaceChar(fileName, '\\', '_');
        this.replaceChar(fileName, '.', '_');
        StringBuffer outputFileName = new StringBuffer();
        outputFileName.append(String.valueOf(File.separatorChar));
        outputFileName.append(fileName.toString());
        outputFileName.append(".xml");
        return outputFileName.toString();
    }

    private synchronized void saveStyleMapToDisk(MapContainer mapContainer) throws StyleManagerException {
        try {
            String fileName = this.getStyleFileName(mapContainer.getMap(0));
            File file = new File(fileName);
            FileWriter fw = new FileWriter(file);
            fw.write(mapContainer.toXml());
            fw.flush();
            fw.close();
        }
        catch (Exception ex) {
            this.throwError("StyleManager.saveStyleMapToDisk", "Error saving style to external library directory", ex);
        }
    }

    public MapContainer getMapContainer(String protocol) throws StyleManagerException {
        MapContainer styleMaps = this.mergeMapContainers(internalLibrary_, externalLibrary_, protocol);
        if (styleMaps == null) {
            this.throwError("StyleManager.getStyleMaps", "No style maps exist", null);
        }
        return styleMaps;
    }

    public synchronized void createStyleMap(MapInterface styleMap) throws StyleManagerException {
        if (styleMap == null) {
            this.throwError("StyleManager.createStyleMap", "Style map is null", null);
        }
        StringBuffer sb = new StringBuffer(externalBaseStyleID_);
        MapMatcherInterface matcher = styleMap.getMapMatcher();
        String protocol = matcher.getXmlID();
        sb.append("_");
        sb.append(protocol);
        Integer protocolInt = (Integer)externalStyleIDNumber_.get(protocol);
        sb.append("_");
        sb.append(protocolInt.toString());
        XmlStyleID styleID = new XmlStyleID();
        styleID.setName(sb.toString());
        styleMap.getStyleComponentInterface().setStyleID((StyleIDInterface)styleID);
        this.saveStyleMap(styleMap);
    }

    public synchronized void modifyStyleMap(MapInterface styleMap) throws StyleManagerException {
        if (styleMap == null) {
            this.throwError("StyleManager.createStyleMap", "Style map is null", null);
        }
        this.saveStyleMap(styleMap);
    }

    private synchronized void saveStyleMap(MapInterface styleMap) throws StyleManagerException {
        StyleDebugLog.log("StyleManagerImpl.saveStyleMap: Saving style map, styleID=" + styleMap.getStyleComponentInterface().getStyleID().toString());
        try {
            MapContainer tmpMapContainer = new MapContainer();
            tmpMapContainer.addMap(styleMap);
            this.saveStyleMapToDisk(tmpMapContainer);
            this.loadStyleMap(externalLibrary_, styleMap);
        }
        catch (Exception ex) {
            this.throwError("StyleManagerImpl.saveStyleMap", "error saving style map", ex);
        }
    }

    public synchronized void deleteStyleMap(MapInterface styleMap) throws StyleManagerException {
    }

    private void replaceChar(StringBuffer inSB, char searchChar, char newChar) {
        if (inSB != null) {
            int sbLength = inSB.length();
            int i = 0;
            while (i < sbLength) {
                if (inSB.charAt(i) == searchChar) {
                    inSB.setCharAt(i, newChar);
                }
                ++i;
            }
        }
    }

    private String composeLog(String systemStr, String msg) {
        StringBuffer message = new StringBuffer(systemStr);
        message.append(": ");
        message.append(msg);
        return message.toString();
    }

    private void throwError(String systemStr, String msg, Exception exception) throws StyleManagerException {
        String message = this.composeLog(systemStr, msg);
        if (exception == null) {
            StyleErrorLog.log(message);
        } else {
            StyleErrorLog.log(message, exception);
        }
        throw new StyleManagerException(msg);
    }

    private MapContainer mergeMapContainers(Map baseHash, Map mergeHash, String protocol) {
        MapContainer results = new MapContainer();
        MapContainer baseCollection = (MapContainer)baseHash.get(protocol);
        MapContainer mergeCollection = (MapContainer)mergeHash.get(protocol);
        if (baseCollection != null) {
            results.addMaps((MapContainerInterface)baseCollection);
        }
        if (mergeCollection != null) {
            results.addMaps((MapContainerInterface)mergeCollection);
        }
        return results;
    }

    protected void finalize() {
        StyleDebugLog.flush();
        logTimer_.cancel();
    }

    static {
        initialized_ = false;
        confFileName_ = "stylemanager.xml";
    }
}

