/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.PimFieldType;
import com.aligo.pim.PimSortType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimAddressEntryItemFilter;
import com.aligo.pim.interfaces.PimItem;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimMessageItemFilter;
import com.aligo.pim.lotus.LotusPimAddressEntryItemsInterface;
import com.aligo.pim.lotus.LotusPimDistListMemberItems;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimMemberItemsFilter;
import com.aligo.pim.lotus.LotusPimNewPersonalDistListMemberItem;
import com.aligo.pim.lotus.LotusPimOldDistributionListItem;
import com.aligo.pim.lotus.LotusPimOldDistributionListMemberItem;
import com.aligo.pim.lotus.LotusPimOldDummyDistListMemberItem;
import com.aligo.pim.lotus.LotusPimOldGlobalDistListMemberItem;
import com.aligo.pim.lotus.LotusPimOldPersonalDistListMemberItem;
import com.aligo.pim.lotus.LotusPimSession;
import com.aligo.pim.lotus.LotusPimUtility;
import com.aligo.pim.lotus.recycle.Recycle;
import java.util.Vector;
import lotus.domino.Document;
import lotus.domino.ViewEntry;

public class LotusPimOldDistListMemberItems
extends LotusPimDistListMemberItems
implements LotusPimAddressEntryItemsInterface {
    private LotusPimOldDistributionListItem m_oPimDistributionListItem;
    private Vector m_vNewMembers = new Vector();
    private Vector m_vOldMembers = new Vector();
    private PimFieldType[] m_oOrderBy;
    public static PimFieldType m_oDefaultPimFieldType = PimFieldType.NAME;
    public static PimSortType m_oPimSortType = PimSortType.ASCENDING;
    private LotusPimMemberItemsFilter m_oPimAddressEntryItemFilter;
    private boolean m_bIsInitializeCalled = false;

    public LotusPimOldDistListMemberItems(LotusPimSession lotusPimSession, Recycle recycle, LotusPimOldDistributionListItem lotusPimOldDistributionListItem) throws LotusPimException {
        super(lotusPimSession, recycle);
        this.m_oPimDistributionListItem = lotusPimOldDistributionListItem;
    }

    public void initialize() throws LotusPimException {
        try {
            Document document = this.m_oPimDistributionListItem.getLotusDocument();
            if (document.hasItem("Members")) {
                Vector vector = document.getItemValue("Members");
                if (vector.size() > 0) {
                    int n = 0;
                    while (n < vector.size()) {
                        String string = (String)vector.elementAt(n);
                        if (string != null && !string.equals("")) {
                            PimAddressEntryItem pimAddressEntryItem = this.getAppropriateAddressEntryItem(string);
                            if (this.m_oPimAddressEntryItemFilter == null || this.m_oPimAddressEntryItemFilter.isItValid(pimAddressEntryItem)) {
                                this.m_vOldMembers.add(pimAddressEntryItem);
                            }
                        }
                        ++n;
                    }
                }
            }
            this.m_bIsInitializeCalled = true;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimAddressEntryItem getAppropriateAddressEntryItem(String string) throws LotusPimException {
        try {
            ViewEntry viewEntry = LotusPimUtility.checkIfInPublicAddressBook(string, this.getLotusPimSession(), this.getRecycle());
            if (viewEntry != null) {
                return new LotusPimOldGlobalDistListMemberItem(string, viewEntry, this.getLotusPimSession(), this.getRecycle(), this);
            }
            viewEntry = LotusPimUtility.checkIfInPersonalAddressBook(string, this.getLotusPimSession(), this.getRecycle());
            if (viewEntry != null) {
                Document document = viewEntry.getDocument();
                this.getRecycle().add(document);
                String string2 = document.getItemValueString("Form");
                if (string2.equals("Group")) {
                    return new LotusPimOldDistributionListMemberItem(string, viewEntry, this.getLotusPimSession(), this.getRecycle(), this);
                }
                return new LotusPimOldPersonalDistListMemberItem(string, viewEntry, this.getLotusPimSession(), this.getRecycle(), this);
            }
            return new LotusPimOldDummyDistListMemberItem(string, this.getLotusPimSession(), this.getRecycle(), this);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimAddressEntryItem addAddressEntryItem() throws LotusPimException {
        return new LotusPimNewPersonalDistListMemberItem(this);
    }

    public void delete(PimAddressEntryItem pimAddressEntryItem) throws LotusPimException {
        try {
            String string;
            if (!this.m_bIsInitializeCalled) {
                this.initialize();
            }
            boolean bl = false;
            String string2 = pimAddressEntryItem.getID();
            if (this.m_vOldMembers != null) {
                int n = 0;
                while (n < this.m_vOldMembers.size()) {
                    PimAddressEntryItem pimAddressEntryItem2 = (PimAddressEntryItem)this.m_vOldMembers.elementAt(n);
                    string = pimAddressEntryItem2.getID();
                    if (string2.equals(string)) {
                        bl = true;
                        this.m_vOldMembers.remove(n);
                        break;
                    }
                    ++n;
                }
            }
            if (bl) {
                Vector<String> vector = new Vector<String>();
                int n = 0;
                while (n < this.m_vOldMembers.size()) {
                    string = (PimAddressEntryItem)this.m_vOldMembers.elementAt(n);
                    String string3 = string.getID();
                    vector.add(string3);
                    ++n;
                }
                this.m_oPimDistributionListItem.getLotusDocument().replaceItemValue("Members", vector);
                this.m_oPimDistributionListItem.update();
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void delete() throws LotusPimException {
        if (!this.m_bIsInitializeCalled) {
            this.initialize();
        }
        this.m_oPimDistributionListItem.delete();
        this.m_vNewMembers = new Vector();
        this.m_vOldMembers = new Vector();
    }

    public void sort(PimSortType pimSortType) throws LotusPimException {
        if (pimSortType != null) {
            m_oPimSortType = pimSortType;
        }
    }

    public PimSortType getSortType() throws LotusPimException {
        return m_oPimSortType;
    }

    public void setOrderBy(PimFieldType[] pimFieldTypeArray) throws LotusPimException {
        if (pimFieldTypeArray != null) {
            this.m_oOrderBy = new PimFieldType[pimFieldTypeArray.length];
            int n = 0;
            while (n < pimFieldTypeArray.length) {
                if (pimFieldTypeArray[n] != null) {
                    this.m_oOrderBy[n] = pimFieldTypeArray[n];
                }
                ++n;
            }
        }
    }

    public PimFieldType[] getOrderBy() {
        if (this.m_oOrderBy == null || this.m_oOrderBy.length == 0) {
            this.m_oOrderBy = new PimFieldType[1];
            this.m_oOrderBy[0] = m_oDefaultPimFieldType;
        }
        return this.m_oOrderBy;
    }

    public void addAddressEntryItem(PimAddressEntryItem pimAddressEntryItem) throws PimException {
        this.m_vNewMembers.add(pimAddressEntryItem);
    }

    public PimAddressEntryItemFilter getAddressEntryItemFilter() {
        if (this.m_oPimAddressEntryItemFilter == null) {
            this.m_oPimAddressEntryItemFilter = new LotusPimMemberItemsFilter();
        }
        return this.m_oPimAddressEntryItemFilter;
    }

    public PimMessageItemFilter getMessageItemFilter() {
        return this.getAddressEntryItemFilter();
    }

    public void update() throws LotusPimException {
        try {
            if (!this.m_bIsInitializeCalled) {
                this.initialize();
            }
            if (this.m_vNewMembers != null) {
                String string;
                String string2;
                Vector<String> vector = new Vector<String>();
                int n = 0;
                while (n < this.m_vNewMembers.size()) {
                    PimAddressEntryItem pimAddressEntryItem = (PimAddressEntryItem)this.m_vNewMembers.elementAt(n);
                    string2 = pimAddressEntryItem.getEmailAddress();
                    if (string2 != null && !string2.equals("")) {
                        vector.add(string2);
                    } else {
                        string = pimAddressEntryItem.getName();
                        vector.add(string);
                    }
                    ++n;
                }
                int n2 = 0;
                while (n2 < this.m_vOldMembers.size()) {
                    string2 = (PimAddressEntryItem)this.m_vOldMembers.elementAt(n2);
                    string = string2.getEmailAddress();
                    if (string != null && !string.equals("")) {
                        vector.add(string);
                    } else {
                        String string3 = string2.getID();
                        vector.add(string3);
                    }
                    ++n2;
                }
                this.m_oPimDistributionListItem.getLotusDocument().replaceItemValue("Members", vector);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimAddressEntryItem getAddressEntryItem(int n) throws LotusPimException {
        try {
            if (!this.m_bIsInitializeCalled) {
                this.initialize();
            }
            if (this.m_vOldMembers != null && this.m_vOldMembers.size() > n) {
                return (PimAddressEntryItem)this.m_vOldMembers.elementAt(n);
            }
            return null;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimAddressEntryItem getAddressEntryItem(String string) throws LotusPimException {
        try {
            int n = this.getCount();
            int n2 = 0;
            while (n2 < n) {
                PimAddressEntryItem pimAddressEntryItem = this.getAddressEntryItem(n2);
                if (string.equals(pimAddressEntryItem.getID())) {
                    return pimAddressEntryItem;
                }
                ++n2;
            }
            return null;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public int getCount() throws LotusPimException {
        if (!this.m_bIsInitializeCalled) {
            this.initialize();
        }
        return this.m_vOldMembers.size();
    }

    public PimAddressEntryItem getFirstAddressEntryItem() throws LotusPimException {
        try {
            return this.getAddressEntryItem(this.getFirstIndex());
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimAddressEntryItem getLastAddressEntryItem() throws LotusPimException {
        try {
            return this.getAddressEntryItem(this.getLastIndex());
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimAddressEntryItem getNextAddressEntryItem() throws LotusPimException {
        try {
            return this.getAddressEntryItem(this.getNextIndex());
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimAddressEntryItem getPreviousAddressEntryItem() throws LotusPimException {
        try {
            return this.getAddressEntryItem(this.getPreviousIndex());
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimItem addItem() throws LotusPimException {
        return this.addMessageItem();
    }

    public PimItem getItem(int n) throws LotusPimException {
        return this.getMessageItem(n);
    }

    public PimItem getItem(String string) throws LotusPimException {
        return this.getMessageItem(string);
    }

    public PimItem getFirstItem() throws LotusPimException {
        return this.getFirstMessageItem();
    }

    public PimItem getLastItem() throws LotusPimException {
        return this.getLastMessageItem();
    }

    public PimItem getNextItem() throws LotusPimException {
        return this.getNextMessageItem();
    }

    public PimItem getPreviousItem() throws LotusPimException {
        return this.getPreviousMessageItem();
    }

    public PimMessageItem addMessageItem() throws LotusPimException {
        return this.addAddressEntryItem();
    }

    public PimMessageItem getMessageItem(int n) throws LotusPimException {
        return this.getAddressEntryItem(n);
    }

    public PimMessageItem getMessageItem(String string) throws LotusPimException {
        return this.getAddressEntryItem(string);
    }

    public PimMessageItem getFirstMessageItem() throws LotusPimException {
        return this.getFirstAddressEntryItem();
    }

    public PimMessageItem getLastMessageItem() throws LotusPimException {
        return this.getLastAddressEntryItem();
    }

    public PimMessageItem getNextMessageItem() throws LotusPimException {
        return this.getNextAddressEntryItem();
    }

    public PimMessageItem getPreviousMessageItem() throws LotusPimException {
        return this.getPreviousAddressEntryItem();
    }
}

