/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.sun.portal.util.SystemProperties;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class Debug {
    public static final int OFF = 0;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int MESSAGE = 3;
    public static final int ON = 4;
    private static Map debugMap = new HashMap();
    private static DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 1, Locale.US);
    private final String debugName;
    private PrintWriter debugFile = null;
    private int debug = 0;
    private static final String sccsID = "@(#)Debug.java\t1.20 00/04/13 Sun Microsystems, Inc.";

    public Debug(String string) {
        File file = new File(this.getDebugBaseDir());
        if (!file.exists()) {
            file.mkdirs();
        }
        this.debugName = string;
        Map map = debugMap;
        synchronized (map) {
            debugMap.put(string, this);
        }
    }

    public static synchronized Debug getInstance(String string) {
        Debug debug = (Debug)debugMap.get(string);
        if (debug == null) {
            debug = new Debug(string);
        }
        return debug;
    }

    public boolean debugEnabled() {
        return this.debug > 2;
    }

    public boolean messageEnabled() {
        return this.debug > 2;
    }

    public boolean warningEnabled() {
        return this.debug > 1;
    }

    public boolean errorEnabled() {
        return this.debug > 0;
    }

    public int getState() {
        return this.debug;
    }

    public void message(String string) {
        if (this.debug > 2) {
            this.message(string, null);
        }
    }

    public void message(String string, Throwable throwable) {
        if (this.debug > 2) {
            this.formatAndWrite(null, string, throwable);
        }
    }

    public void warning(String string) {
        if (this.debug > 1) {
            this.formatAndWrite("WARNING: ", string, null);
        }
    }

    public void warning(String string, Throwable throwable) {
        if (this.debug > 1) {
            this.formatAndWrite("WARNING: ", string, throwable);
        }
    }

    public void error(String string) {
        if (this.debug > 0) {
            this.formatAndWrite("ERROR: ", string, null);
        }
    }

    public void error(String string, Throwable throwable) {
        if (this.debug > 0) {
            this.formatAndWrite("ERROR: ", string, throwable);
        }
    }

    private void formatAndWrite(String string, String string2, Throwable throwable) {
        if (this.debug == 4) {
            if (string2 != null) {
                if (string == null) {
                    System.out.println(string2);
                } else {
                    System.out.println(string + string2);
                }
            }
            if (throwable != null) {
                System.out.println(throwable.getMessage());
                throwable.printStackTrace(System.out);
            }
            return;
        }
        StringWriter stringWriter = new StringWriter(160);
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        DateFormat dateFormat = Debug.dateFormat;
        synchronized (dateFormat) {
            printWriter.write(Debug.dateFormat.format(new Date()));
        }
        printWriter.write(": ");
        printWriter.write(Thread.currentThread().toString());
        printWriter.write("\n");
        if (string != null) {
            printWriter.write(string);
        }
        if (string2 != null) {
            printWriter.write(string2);
        }
        if (throwable != null) {
            printWriter.write("\n");
            throwable.printStackTrace(printWriter);
        }
        printWriter.flush();
        this.write(stringWriter.toString());
    }

    private synchronized void write(String string) {
        try {
            if (this.debugFile == null) {
                FileOutputStream fileOutputStream = new FileOutputStream(this.getDebugBaseDir() + "/" + this.debugName, true);
                this.debugFile = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8")), true);
                this.debugFile.println("******************************************************");
            }
            this.debugFile.println(string);
        }
        catch (IOException iOException) {
            System.err.println("Disabling debug log : " + this.debugName);
            this.debug = 0;
        }
    }

    public void setDebug(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.debug = n;
                break;
            }
        }
    }

    public void setDebug() {
        try {
            String string = SystemProperties.get("gateway.debug", "error");
            this.setDebug(string);
        }
        catch (Exception exception) {
            System.out.println("Error getting debug attribute: ");
            exception.printStackTrace();
        }
    }

    public void setDebug(String string) {
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("error")) {
            this.debug = 1;
        } else if (string.equalsIgnoreCase("warning")) {
            this.debug = 2;
        } else if (string.equalsIgnoreCase("message")) {
            this.debug = 3;
        } else if (string.equalsIgnoreCase("on")) {
            this.debug = 4;
        } else if (string.equalsIgnoreCase("off")) {
            this.debug = 0;
        } else if (string.equals("*")) {
            this.debug = 4;
        } else {
            if (string.endsWith("*")) {
                string = string.substring(0, string.length() - 1);
            }
            if (this.debugName.startsWith(string)) {
                this.debug = 4;
            }
        }
    }

    public void destroy() {
        this.finalize();
    }

    protected void finalize() {
        Map map = debugMap;
        synchronized (map) {
            debugMap.remove(this.debugName);
        }
        Debug debug = this;
        synchronized (debug) {
            if (this.debugFile == null) {
                return;
            }
            this.debug = 0;
            this.debugFile.flush();
            this.debugFile.close();
            this.debugFile = null;
        }
    }

    private String getDebugBaseDir() {
        try {
            return SystemProperties.get("gateway.debug.dir", "/var/opt/SUNWps/debug");
        }
        catch (Exception exception) {
            System.out.println("Error setting basedir: ");
            exception.printStackTrace();
            return null;
        }
    }
}

