/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.configservlet.server;

import com.iplanet.am.util.AdminUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceNotFoundException;
import com.sun.portal.rproxy.configservlet.GatewayRequest;
import com.sun.portal.rproxy.configservlet.Request;
import com.sun.portal.rproxy.configservlet.Response;
import com.sun.portal.rproxy.configservlet.ServiceHandler;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;

public class GatewayServiceHandler
implements ServiceHandler {
    private static final String RETRIEVE_INSTANCE = "retrieveInstance";
    public static final String SERVICE_NAME = "srapGatewayService";
    private static final String SUB_SCHEMA_NAME = "Gateway-Profiles";

    public Response handleRequest(Request request) throws RemoteException {
        String string = request.getRequestType();
        if (RETRIEVE_INSTANCE.equals(string)) {
            Map map = GatewayServiceHandler.executeRetrieveInstance(request);
            return new Response(request.getServiceName(), request.getRequestType(), map);
        }
        return new Response(request.getServiceName(), request.getRequestType(), new RemoteException("Not able to find the method to execute"));
    }

    private static Map executeRetrieveInstance(Request request) throws RemoteException {
        try {
            GatewayRequest gatewayRequest = (GatewayRequest)request;
            String string = gatewayRequest.getInstanceName();
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager(SERVICE_NAME, GatewayServiceHandler.getSSOToken(request));
            ServiceConfig serviceConfig = serviceConfigManager.getGlobalConfig(null);
            ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(SUB_SCHEMA_NAME);
            ServiceConfig serviceConfig3 = serviceConfig2.getSubConfig(string);
            return null != serviceConfig3 ? serviceConfig3.getAttributes() : new HashMap();
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            throw new RemoteException("service Not Found!!!, load service", serviceNotFoundException);
        }
        catch (SMSException sMSException) {
            throw new RemoteException("SMSException in retrieveing gateway config", sMSException);
        }
        catch (SSOException sSOException) {
            throw new RemoteException("SSOException in retrieveing gateway config", sSOException);
        }
    }

    private static SSOToken getSSOToken(Request request) throws RemoteException {
        try {
            String string = new String(AdminUtils.getAdminPassword());
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            return sSOTokenManager.createSSOToken(new Principal(){

                public String getName() {
                    return AdminUtils.getAdminDN();
                }
            }, string);
        }
        catch (SSOException sSOException) {
            throw new RemoteException("Not able to get the token", sSOException);
        }
    }
}

