/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainercommon.descriptor;

import com.sun.portal.common.logging.Level;
import com.sun.portal.common.logging.Logger;
import com.sun.portal.portletcontainercommon.descriptor.PreferenceDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jdom.Namespace;

public class PortletPreferencesDescriptor {
    public static final String PREFERENCE = "preference";
    public static final String PREFERENCES_VALIDATOR = "preferences-validator";
    private List _preferenceDescriptors = new ArrayList();
    private String _portletName;
    private String _validatorName;
    private Logger _logger;

    public PortletPreferencesDescriptor(Logger logger, String portletName) {
        this._logger = logger;
        this._portletName = portletName;
    }

    public void load(Element element, Namespace namespace) {
        List preferenceElements = element.getChildren(PREFERENCE, namespace);
        if (preferenceElements.isEmpty() && this._logger.isLoggable(Level.WARNING)) {
            this._logger.logp(Level.WARNING, "PortletPreferencesDescriptor", "load()", "preference element is missing for portlet: " + this._portletName);
        }
        Iterator iterator = preferenceElements.iterator();
        while (iterator.hasNext()) {
            Element preferenceElement = (Element)iterator.next();
            PreferenceDescriptor preferenceDescriptor = new PreferenceDescriptor(this._logger, this._portletName);
            preferenceDescriptor.load(preferenceElement, namespace);
            this._preferenceDescriptors.add(preferenceDescriptor);
        }
        this._validatorName = element.getChildTextTrim(PREFERENCES_VALIDATOR, namespace);
    }

    public List getPreferenceDescriptors() {
        return this._preferenceDescriptors;
    }

    public PreferenceDescriptor getPreferenceDescriptor(String preferenceName) {
        PreferenceDescriptor preference = null;
        boolean stop = false;
        Iterator iterator = this._preferenceDescriptors.iterator();
        while (iterator.hasNext() && !stop) {
            PreferenceDescriptor preferenceDescriptor = (PreferenceDescriptor)iterator.next();
            if (!preferenceDescriptor.getPrefName().equals(preferenceName)) continue;
            preference = preferenceDescriptor;
            stop = true;
        }
        return preference;
    }

    public String getPreferencesValidatorName() {
        return this._validatorName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PortletPreferencesDescriptor [");
        Iterator iterator = this._preferenceDescriptors.iterator();
        while (iterator.hasNext()) {
            PreferenceDescriptor preferenceDescriptor = (PreferenceDescriptor)iterator.next();
            sb.append(preferenceDescriptor.toString());
        }
        if (this._validatorName != null) {
            sb.append(" preferences validator name [");
            sb.append(this._validatorName);
            sb.append("] ");
        }
        sb.append("]");
        return sb.toString();
    }
}

