/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.server;

import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWNSSInit;
import com.sun.portal.util.SRAPServerSocket;
import com.sun.portal.util.ServiceIdentifier;
import com.sun.portal.util.SystemProperties;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.jss.ssl.SSLServerSocket;
import org.mozilla.jss.ssl.SSLSocket;

public class ServerSocketFactory {
    private static final String HTTPPROXY_PORT = "HTTPProxyPort";
    private static final int HTTPPROXY_DEFAULT_PORT = 10443;
    private static boolean allow40bitBrowser;
    private static boolean enableSSLV2;
    private static boolean enableSSLV3;
    private static boolean disableNullCiphers;
    private static boolean individualCipherSelectionMode;
    private static List enabledSSL2CipherList;
    private static List enabledSSL3CipherList;
    private static List enabledTLSCipherList;

    private ServerSocketFactory() {
    }

    public static ServerSocket createNormalServerSocket(int n) {
        try {
            String string = "127.0.0.1";
            ServerSocket serverSocket = new ServerSocket(n, 50, InetAddress.getByName(string));
            if (PerfContextObject.ENABLE_PERF) {
                SocketCount.incrementServerSockets();
            }
            return serverSocket;
        }
        catch (IOException iOException) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("FATAL: Not able to create Http Server Socket:" + n, iOException);
            }
            return null;
        }
    }

    public static ServerSocket createSSLSocketServer(int n) {
        SSLServerSocket sSLServerSocket;
        block12: {
            boolean bl;
            SSLServerSocket.configServerSessionIDCache((int)15000, (int)86400, (int)86400, null);
            ServerSocketFactory.certificationAdministration();
            sSLServerSocket = null;
            int n2 = GatewayProfile.getInt("EProxyConnectionQueue", 50);
            String string = SystemProperties.get("gateway.bindipaddress");
            try {
                if (string == null) {
                    string = "127.0.0.1";
                }
                sSLServerSocket = new SSLServerSocket(n, n2, InetAddress.getByName(string));
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("ServerSocketFactory:createSSLSocketServer  nickname = " + GWNSSInit.nickname);
                }
                sSLServerSocket.setServerCertNickname(GWNSSInit.nickname);
                if (PerfContextObject.ENABLE_PERF) {
                    SocketCount.incrementServerSockets();
                }
            }
            catch (UnknownHostException unknownHostException) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("ServerSocketFactory:createSSLSocketServer localhost unknown host", unknownHostException);
                }
                sSLServerSocket = null;
            }
            catch (IOException iOException) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("ServerSocketFactory:createSSLSocketServer cannot create server socket", iOException);
                }
                sSLServerSocket = null;
            }
            String string2 = SystemProperties.get("gateway.host", null);
            List list = ServerSocketFactory.toLowerCase(GatewayProfile.getStringList("CertificateEnabledList"));
            boolean bl2 = bl = list.contains(string2.toLowerCase()) && ServiceIdentifier.isGateway();
            if (bl) {
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("Doing PDC");
                }
                try {
                    sSLServerSocket.requestClientAuth(true);
                }
                catch (SocketException socketException) {
                    if (!GWDebug.debug.errorEnabled()) break block12;
                    GWDebug.debug.error("Unable to request client authentication");
                }
            }
        }
        return sSLServerSocket;
    }

    private static void certificationAdministration() {
        if (individualCipherSelectionMode) {
            GWNSSInit.disableAllCiphers();
            ServerSocketFactory.enableCipherList(enabledSSL2CipherList);
            ServerSocketFactory.enableCipherList(enabledSSL3CipherList);
            ServerSocketFactory.enableCipherList(enabledTLSCipherList);
        } else {
            if (!enableSSLV2) {
                GWNSSInit.disableCipher(GWNSSInit.cipherSuites128BitSSL2);
            }
            if (!enableSSLV3) {
                GWNSSInit.disableCipher(GWNSSInit.cipherSuites128BitSSL3);
            }
            if (disableNullCiphers || !allow40bitBrowser) {
                GWNSSInit.disableCipher(GWNSSInit.cipherSuitesSSL3Null);
            }
            if (!allow40bitBrowser) {
                GWNSSInit.disableCipher(GWNSSInit.cipherSuites40BitSSL2);
                GWNSSInit.disableCipher(GWNSSInit.cipherSuites40BitSSL3);
                GWNSSInit.disableCipher(GWNSSInit.cipherSuitesOthersSSL2);
                GWNSSInit.disableCipher(GWNSSInit.cipherSuitesOthersSSL3);
                GWNSSInit.disableCipher(GWNSSInit.cipherSuitesOthersTLS);
            } else {
                if (!enableSSLV2) {
                    GWNSSInit.disableCipher(GWNSSInit.cipherSuites40BitSSL2);
                    GWNSSInit.disableCipher(GWNSSInit.cipherSuitesOthersSSL2);
                }
                if (!enableSSLV3) {
                    GWNSSInit.disableCipher(GWNSSInit.cipherSuites40BitSSL3);
                    GWNSSInit.disableCipher(GWNSSInit.cipherSuitesOthersSSL3);
                    GWNSSInit.disableCipher(GWNSSInit.cipherSuitesSSL3Null);
                    GWNSSInit.disableCipher(GWNSSInit.cipherSuitesOthersTLS);
                }
            }
        }
    }

    private static void enableCipherList(List list) {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            ServerSocketFactory.enableCipher((String)list.get(n2));
            ++n2;
        }
    }

    private static void enableCipher(String string) {
        if (!enableSSLV2 && string.toLowerCase().indexOf("ssl2") != -1) {
            return;
        }
        if (!enableSSLV3 && string.toLowerCase().indexOf("ssl3") != -1) {
            return;
        }
        if (!enableSSLV3 && string.toLowerCase().indexOf("ssl_rsa_fips") != -1) {
            return;
        }
        if (disableNullCiphers && string.toLowerCase().indexOf("null") != -1) {
            return;
        }
        string = string.trim();
        if (!allow40bitBrowser && (string.equalsIgnoreCase("SSL2_RC2_128_CBC_EXPORT40_WITH_MD5") || string.equalsIgnoreCase("SSL2_RC4_128_EXPORT40_WITH_MD5") || string.equalsIgnoreCase("SSL3_RSA_EXPORT_WITH_RC4_40_MD5") || string.equalsIgnoreCase("SSL3_RSA_EXPORT_WITH_RC2_CBC_40_MD5") || string.equalsIgnoreCase("SSL2_DES_64_CBC_WITH_MD5") || string.equalsIgnoreCase("SSL3_RSA_WITH_DES_CBC_SHA") || string.equalsIgnoreCase("SSL3_RSA_WITH_NULL_MD5") || string.equalsIgnoreCase("TLS_RSA_EXPORT1024_WITH_DES_CBC_SHA") || string.equalsIgnoreCase("TLS_RSA_EXPORT1024_WITH_RC4_56_SHA") || string.equalsIgnoreCase("SSL_RSA_FIPS_WITH_DES_CBC_SHA") || string.equalsIgnoreCase("SSL3_FORTEZZA_DMS_WITH_NULL_SHA") || string.equalsIgnoreCase("SSL3_FORTEZZA_DMS_WITH_FORTEZZA_CBC_SHA"))) {
            return;
        }
        if (string.equalsIgnoreCase("SSL2_RC2_128_CBC_WITH_MD5")) {
            SSLSocket.setCipherPreference((int)65283, (boolean)true);
        } else if (string.equalsIgnoreCase("SSL2_DES_192_EDE3_CBC_WITH_MD5")) {
            SSLSocket.setCipherPreference((int)65287, (boolean)true);
        } else if (string.equalsIgnoreCase("SSL2_RC4_128_WITH_MD5")) {
            SSLSocket.setCipherPreference((int)65281, (boolean)true);
        } else if (string.equalsIgnoreCase("SSL3_RSA_WITH_3DES_EDE_CBC_SHA")) {
            SSLSocket.setCipherPreference((int)10, (boolean)true);
        } else if (string.equalsIgnoreCase("SSL3_RSA_WITH_RC4_128_MD5")) {
            SSLSocket.setCipherPreference((int)4, (boolean)true);
        } else if (string.equalsIgnoreCase("SSL3_RSA_WITH_RC4_128_SHA")) {
            SSLSocket.setCipherPreference((int)5, (boolean)true);
        } else if (string.equalsIgnoreCase("SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA")) {
            SSLSocket.setCipherPreference((int)65279, (boolean)true);
        } else if (string.equalsIgnoreCase("SSL3_FORTEZZA_DMS_WITH_RC4_128_SHA")) {
            SSLSocket.setCipherPreference((int)30, (boolean)true);
        } else if (string.equalsIgnoreCase("SSL2_RC2_128_CBC_EXPORT40_WITH_MD5")) {
            SSLSocket.setCipherPreference((int)65284, (boolean)true);
        } else if (string.equalsIgnoreCase("SSL2_RC4_128_EXPORT40_WITH_MD5")) {
            SSLSocket.setCipherPreference((int)65282, (boolean)true);
        } else if (string.equalsIgnoreCase("SSL3_RSA_EXPORT_WITH_RC4_40_MD5")) {
            SSLSocket.setCipherPreference((int)3, (boolean)true);
        } else if (string.equalsIgnoreCase("SSL3_RSA_EXPORT_WITH_RC2_CBC_40_MD5")) {
            SSLSocket.setCipherPreference((int)6, (boolean)true);
        } else if (string.equalsIgnoreCase("SSL2_DES_64_CBC_WITH_MD5")) {
            SSLSocket.setCipherPreference((int)65286, (boolean)true);
        } else if (string.equalsIgnoreCase("SSL3_RSA_WITH_DES_CBC_SHA")) {
            SSLSocket.setCipherPreference((int)9, (boolean)true);
        } else if (string.equalsIgnoreCase("SSL3_RSA_WITH_NULL_MD5")) {
            SSLSocket.setCipherPreference((int)1, (boolean)true);
        } else if (string.equalsIgnoreCase("TLS_RSA_EXPORT1024_WITH_DES_CBC_SHA")) {
            SSLSocket.setCipherPreference((int)98, (boolean)true);
        } else if (string.equalsIgnoreCase("TLS_RSA_EXPORT1024_WITH_RC4_56_SHA")) {
            SSLSocket.setCipherPreference((int)100, (boolean)true);
        } else if (string.equalsIgnoreCase("SSL_RSA_FIPS_WITH_DES_CBC_SHA")) {
            SSLSocket.setCipherPreference((int)65278, (boolean)true);
        } else if (string.equalsIgnoreCase("SSL3_FORTEZZA_DMS_WITH_NULL_SHA")) {
            SSLSocket.setCipherPreference((int)28, (boolean)true);
        } else if (string.equalsIgnoreCase("SSL3_FORTEZZA_DMS_WITH_FORTEZZA_CBC_SHA")) {
            SSLSocket.setCipherPreference((int)29, (boolean)true);
        }
    }

    private static List toLowerCase(List list) {
        int n = list.size();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        int n2 = 0;
        while (n2 < n) {
            String string = (String)list.get(n2);
            arrayList.add(string.toLowerCase());
            ++n2;
        }
        return arrayList;
    }

    public static ServerSocket createSRAPServerSocket(int n) {
        int n2 = GatewayProfile.getInt("EProxyConnectionQueue", 50);
        String string = SystemProperties.get("gateway.bindipaddress");
        if (string == null) {
            string = "127.0.0.1";
        }
        try {
            SRAPServerSocket sRAPServerSocket = new SRAPServerSocket(n, n2, InetAddress.getByName(string));
            if (PerfContextObject.ENABLE_PERF) {
                SocketCount.incrementServerSockets();
            }
            return sRAPServerSocket;
        }
        catch (IOException iOException) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("EProxyConnection cannot create server socket on " + n, iOException);
            }
            return null;
        }
    }

    static {
        enableSSLV2 = true;
        enableSSLV3 = true;
        disableNullCiphers = false;
        enabledSSL2CipherList = null;
        enabledSSL3CipherList = null;
        enabledTLSCipherList = null;
        String string = GatewayProfile.getString("Allow40BitConnections", "true");
        allow40bitBrowser = string.equals("true");
        string = GatewayProfile.getString("EnableSSLv2", "true");
        enableSSLV2 = string.equals("true");
        string = GatewayProfile.getString("EnableSSLv3", "true");
        enableSSLV3 = string.equals("true");
        string = GatewayProfile.getString("DisableNull", "false");
        disableNullCiphers = string.equals("true");
        string = GatewayProfile.getString("EnableIndividualCipherSelectionMode", "false");
        individualCipherSelectionMode = string.equals("true");
        if (individualCipherSelectionMode) {
            enabledSSL2CipherList = GatewayProfile.getStringList("EnabledSSL2CipherList");
            enabledSSL3CipherList = GatewayProfile.getStringList("EnabledSSL3CipherList");
            enabledTLSCipherList = GatewayProfile.getStringList("EnabledTLSCipherList");
        }
    }
}

