/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.https;

import com.sun.portal.rproxy.https.ApprovalCallback;
import com.sun.portal.rproxy.https.JSSDebug;
import com.sun.portal.rproxy.https.JSSProxyRunnable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.StringTokenizer;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLSocket;
import sun.misc.RegexpPool;
import sun.net.www.http.HttpClient;
import sun.security.action.GetPropertyAction;

public final class HttpsClient
extends HttpClient {
    private static String secureTunnelHost = null;
    private static int secureTunnelPort = 80;
    private static RegexpPool dontProxy = null;
    private static final int httpsPortNumber = 443;
    public static int jssProxyPort = -1;
    private String instTunnelHost;
    private int instTunnelPort;
    private SSLSocket sslSocket = null;

    protected int getDefaultPort() {
        return 443;
    }

    public static synchronized void resetSecureProperties() {
        Object object;
        String string = HttpsClient.getProperty("https.proxyHost");
        JSSDebug.debug.message("HttpsClient: proxyHost = " + string);
        if (string == null || "".equals(string)) {
            secureTunnelHost = null;
            secureTunnelPort = 80;
        } else {
            secureTunnelHost = string;
            secureTunnelPort = Integer.getInteger("https.proxyPort", 80);
        }
        dontProxy = new RegexpPool();
        String string2 = HttpsClient.getProperty("http.nonProxyHosts");
        JSSDebug.debug.message("HttpsClient: nonProxyHosts = " + string2);
        if (string2 != null) {
            object = new StringTokenizer(string2, "|", false);
            try {
                while (((StringTokenizer)object).hasMoreTokens()) {
                    dontProxy.add(((StringTokenizer)object).nextToken().toLowerCase(), (Object)new Boolean(true));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object = null;
        try {
            object = new ServerSocket(0, 50);
        }
        catch (IOException iOException) {
            object = null;
        }
        if (object != null) {
            jssProxyPort = ((ServerSocket)object).getLocalPort();
            JSSProxyRunnable jSSProxyRunnable = new JSSProxyRunnable((ServerSocket)object);
            Thread thread = new Thread(jSSProxyRunnable);
            thread.start();
        }
    }

    public HttpsClient(URL uRL) throws IOException {
        super(uRL, true);
        JSSDebug.debug.message("HttpsClient: HttpsClient " + uRL);
    }

    public static HttpClient New(URL uRL) throws IOException {
        JSSDebug.debug.message("HttpsClient: New " + uRL);
        HttpsClient httpsClient = (HttpsClient)HttpClient.kac.get(uRL);
        if (httpsClient == null) {
            httpsClient = new HttpsClient(uRL);
        } else {
            httpsClient.url = uRL;
        }
        return httpsClient;
    }

    protected boolean isNonProxyHost() {
        if (dontProxy.match(this.url.getHost().toLowerCase()) != null) {
            return true;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(this.url.getHost());
            String string = inetAddress.getHostAddress();
            if (dontProxy.match(string) != null) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    protected Socket doConnect(String string, int n) throws IOException, UnknownHostException {
        JSSDebug.debug.message("HttpsClient: doConnect(" + string + ", " + n + ")");
        this.instTunnelHost = secureTunnelHost;
        int n2 = this.instTunnelPort = secureTunnelPort < 0 ? super.getDefaultPort() : secureTunnelPort;
        if (this.instTunnelHost == null || this.isNonProxyHost()) {
            this.sslSocket = new SSLSocket(InetAddress.getByName(string), n, null, 0, (SSLCertificateApprovalCallback)ApprovalCallback.getInstance(), null);
        } else {
            JSSDebug.debug.message("HttpsClient: doConnect through proxy " + secureTunnelHost + ":" + secureTunnelPort);
            this.sslSocket = new SSLSocket(InetAddress.getByName("localhost"), jssProxyPort, null, 0, (SSLCertificateApprovalCallback)new ApprovalCallback(string), null);
            Integer n3 = new Integer(this.sslSocket.getLocalPort());
            String string2 = secureTunnelHost + " " + secureTunnelPort + " " + string + " " + n;
            JSSProxyRunnable.connectHashMap.put(n3, string2);
        }
        return this.sslSocket;
    }

    public String getCipherSuite() {
        String string = null;
        try {
            string = this.sslSocket.getStatus().getCipher();
        }
        catch (SocketException socketException) {
            JSSDebug.debug.message("HttpsClient: getCipher failed");
        }
        return string;
    }

    public X509Certificate[] getServerCertificateChain() {
        return null;
    }

    private static String getProperty(String string) {
        SecurityException securityException = null;
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException2) {
            securityException = securityException2;
            try {
                return AccessController.doPrivileged(new GetPropertyAction("prop"));
            }
            catch (LinkageError linkageError) {
                throw securityException;
            }
        }
    }

    static {
        HttpsClient.resetSecureProperties();
    }
}

