/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter.config;

import com.iplanet.am.util.AdminUtils;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.sun.ssoadapter.config.ClientAwareAppContext;
import com.sun.ssoadapter.config.ClientAwareUserContext;
import com.sun.ssoadapter.config.DSAMEConnection;
import com.sun.ssoadapter.config.DSAMEConstants;
import com.sun.ssoadapter.config.DSAMEUtils;
import com.sun.ssoadapter.config.SAALException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class PSClientAwareAuthlessContext
implements ClientAwareUserContext,
DSAMEConstants {
    private static Debug debug = DSAMEConnection.debug;
    private String thisClassName = null;
    private DSAMEConnection dsameConn = null;
    private DSAMEUtils dsameUtils = null;
    private String sessClientType = null;
    private String charset = null;
    private ClientAwareAppContext caAppContext = null;
    private static final String authlessSUID = "ssoadapter.authless.suid";

    public synchronized void init(HttpServletRequest req, ClientAwareAppContext appContext) throws IllegalStateException, SAALException {
        String userDN;
        this.thisClassName = this.getClass().getName();
        this.caAppContext = appContext;
        if (debug.messageEnabled()) {
            debug.message(this.thisClassName + ":init()");
        }
        if ((userDN = (String)req.getAttribute(authlessSUID)) == null) {
            if (debug.messageEnabled()) {
                debug.message("Session not valid");
            }
            throw new IllegalStateException("Session Invalid:");
        }
        this.sessClientType = this.caAppContext.getClientType(req);
        String bindDN = AdminUtils.getAdminDN();
        String password = new String(AdminUtils.getAdminPassword());
        try {
            this.dsameConn = new DSAMEConnection(bindDN, password, userDN);
            this.dsameUtils = DSAMEUtils.getInstance(this.dsameConn);
        }
        catch (SSOException se) {
            throw new SAALException(this.thisClassName + ": " + (Object)((Object)se));
        }
        if (this.dsameUtils == null) {
            throw new SAALException(this.thisClassName + ": DSAMEUtils not Initialized");
        }
    }

    public String getStringAttribute(Map service, String attrName) throws IllegalStateException, IOException {
        return this.getStringAttribute(service, this.getClientType(), attrName);
    }

    public String getStringAttribute(Map service, String client, String attrName) throws IllegalStateException, IOException {
        String val = null;
        Set vals = this.getAttribute(service, client, attrName);
        if (vals != null && vals.size() > 0) {
            Iterator iter = vals.iterator();
            val = (String)iter.next();
        }
        if (debug.messageEnabled()) {
            debug.message(this.thisClassName + ":getStringAttribute(): AttrName = " + attrName + " :: Val = " + val);
        }
        return val;
    }

    public Set getAttribute(Map service, String attrName) throws IllegalStateException, IOException {
        return this.getAttribute(service, this.getClientType(), attrName);
    }

    public Set getAttribute(Map service, String client, String attrName) throws IllegalStateException, IOException {
        String serviceName = this.dsameUtils.getServiceName(service);
        return this.getAttribute(serviceName, client, attrName, true, null, 0, 0);
    }

    private Set getAttribute(String serviceName, String client, String attrName, boolean removeClientInfo, Map awareMap, int scope, int type) throws IllegalStateException, IOException {
        Set vals = null;
        Set retVals = null;
        scope = scope != 0 ? scope : this.dsameUtils.getAttributeScope(serviceName, attrName);
        switch (scope) {
            case 5: {
                vals = this.dsameConn.getGlobalAttribute(serviceName, attrName);
                break;
            }
            case 6: {
                vals = this.dsameConn.getOrganizationAttribute(serviceName, attrName);
                break;
            }
            case 7: {
                break;
            }
            default: {
                vals = this.dsameConn.getAttribute(attrName);
            }
        }
        type = type != 0 ? type : this.dsameUtils.getAttributeType(serviceName, attrName);
        switch (type) {
            case 1: {
                retVals = vals;
                break;
            }
            case 3: {
                retVals = this.dsameUtils.getClientValues(vals, client, awareMap, removeClientInfo);
                break;
            }
            default: {
                retVals = vals;
            }
        }
        if (debug.messageEnabled()) {
            debug.message(this.thisClassName + ":getAttribute(): AttrName = " + attrName + " :: Vals = " + retVals);
        }
        return retVals;
    }

    public void store() {
    }

    public void setStringAttribute(Map service, String attrName, String val) throws IllegalStateException, MissingResourceException, IOException {
        throw new IllegalStateException("Session Operation Not Supported");
    }

    public void setStringAttribute(Map service, String attrName, String val, boolean forceCA) throws IllegalStateException, MissingResourceException, IOException {
        throw new IllegalStateException("Session Operation Not Supported");
    }

    public void setStringAttribute(Map service, String client, String attrName, String val) throws IllegalStateException, MissingResourceException, IOException {
        throw new IllegalStateException("Session Operation Not Supported");
    }

    private void setStringAttribute(Map service, String client, String attrName, String val, boolean forceClientAwareness) throws IllegalStateException, MissingResourceException, IOException {
        throw new IllegalStateException("Session Operation Not Supported");
    }

    public void setAttribute(Map service, String attrName, Set vals) throws IllegalStateException, MissingResourceException, IOException {
        throw new IllegalStateException("Session Operation Not Supported");
    }

    public void setAttribute(Map service, String attrName, Set vals, boolean forceClientAwareness) throws IllegalStateException, MissingResourceException, IOException {
        throw new IllegalStateException("Session Operation Not Supported");
    }

    public void setAttribute(Map service, String client, String attrName, Set vals) throws IllegalStateException, MissingResourceException, IOException {
        throw new IllegalStateException("Session Operation Not Supported");
    }

    private void setAttribute(Map service, String client, String attrName, Set vals, boolean forceCA) throws IllegalStateException, MissingResourceException, IOException {
        throw new IllegalStateException("Session Operation Not Supported");
    }

    public void removeAttribute(Map service, String attrName) throws IllegalStateException, MissingResourceException, IOException {
        throw new IllegalStateException("Session Operation Not Supported");
    }

    public String getClientType() {
        return this.sessClientType;
    }
}

