/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter.calendar.pim;

import com.aligo.pim.PimCalendarType;
import com.aligo.pim.PimRecurrencePatternDayType;
import com.aligo.pim.PimRecurrencePatternType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimAppointmentItem;
import com.aligo.pim.interfaces.PimRecurrencePatternItem;
import com.sun.comclient.calendar.Attach;
import com.sun.comclient.calendar.Attendee;
import com.sun.comclient.calendar.CalendarComponentException;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.OperationNotSupportedException;
import com.sun.comclient.calendar.Organizer;
import com.sun.comclient.calendar.RecurrencePattern;
import com.sun.comclient.calendar.VAlarm;
import com.sun.comclient.calendar.VEvent;
import com.sun.ssoadapter.calendar.pim.APimCalendar;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class APimEvent
extends VEvent {
    private PimAppointmentItem event = null;
    private APimCalendar parentCal = null;
    private PimRecurrencePatternItem rpattern = null;
    private RecurrencePattern[] rpa = new RecurrencePattern[1];
    private SimpleDateFormat isoFormatter;
    private String isoFormat = "yyyyMMdd'T'HHmmss'Z'";
    private boolean isNew = false;
    private TimeZone tz = null;
    private DateTime start = null;
    private DateTime end = null;
    private boolean isAllDay = true;
    private String summary = null;
    private String description = null;
    private String location = null;
    private String id = null;
    private String organizerName = null;
    static final int FOREVER_DURATION = 1490000;
    private static boolean enableCache = true;

    public APimEvent(APimCalendar cal, PimAppointmentItem item, boolean isNew) {
        this.parentCal = cal;
        this.isNew = isNew;
        this.isoFormatter = new SimpleDateFormat(this.isoFormat);
        this.isoFormatter.setTimeZone(new SimpleTimeZone(0, "GMT"));
        this.isoFormatter.setLenient(false);
        this.tz = cal.getTimeZone();
        if (item != null) {
            try {
                this.event = item;
                this.id = item.getID();
                this.summary = this.event.getSubject();
                this.description = this.event.getText();
                this.location = this.event.getLocation();
                this.isAllDay = this.event.isAllDayEvent();
                if (this.event.getType().equals(PimCalendarType.ANNIVERSARY)) {
                    this.isAllDay = true;
                }
                this.start = this.toDateTime(this.event.getStartTime());
                this.end = this.toDateTime(this.event.getEndTime());
                this.organizerName = this.event.getOrganizer().getName();
                this.rpattern = this.event.getRecurrencePatternItem();
                if (enableCache) {
                    this.event = null;
                }
            }
            catch (PimException pex) {
                pex.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public APimEvent(APimCalendar cal, PimAppointmentItem item) {
        this(cal, item, false);
    }

    private DateTime toDateTime(Date date) throws Exception {
        if (date != null) {
            String tmp = this.isoFormatter.format(date);
            return new DateTime(tmp, this.tz);
        }
        return null;
    }

    private RecurrencePattern toRecurrencePattern() throws Exception {
        if (this.rpattern != null) {
            int interval = this.rpattern.getInterval();
            PimRecurrencePatternType pType = this.rpattern.getType();
            int freq = 70;
            if (pType == PimRecurrencePatternType.DAILY) {
                freq = 40;
            } else if (pType == PimRecurrencePatternType.WEEKLY) {
                freq = 50;
            } else if (pType == PimRecurrencePatternType.MONTHLY) {
                freq = 60;
            } else if (pType == PimRecurrencePatternType.YEARLY) {
                freq = 70;
            }
            int cnt = this.rpattern.getNoOfOccurrences();
            Date dt = this.rpattern.getRecurrenceEndDate();
            DateTime start = this.getStart();
            RecurrencePattern rp = new RecurrencePattern(freq, interval, cnt);
            rp.setUntilDate(this.toDateTime(dt));
            if (freq != 40) {
                block19: {
                    String days = null;
                    try {
                        Vector dow = this.rpattern.getDaysOfWeek();
                        StringBuffer str = new StringBuffer();
                        int i = 0;
                        while (i < dow.size()) {
                            Object t = dow.elementAt(i);
                            String tmp = t.toString();
                            str.append(", ");
                            str.append(tmp.substring(0, 2));
                            ++i;
                        }
                        str.setCharAt(0, ' ');
                        days = str.toString().trim();
                        if (freq == 60 || freq == 70) {
                            int weekOfMonth = start.get(8);
                            if (weekOfMonth > 4) {
                                weekOfMonth = -1;
                            }
                            rp.setByDay(weekOfMonth + days);
                        } else {
                            rp.setByDay(days);
                        }
                    }
                    catch (Exception e) {
                        if (freq == 50) break block19;
                        String monthdays = null;
                        try {
                            Vector dom = this.rpattern.getDaysOfMonth();
                            StringBuffer str = new StringBuffer();
                            int i = 0;
                            while (i < dom.size()) {
                                Object t = dom.elementAt(i);
                                String tmp = t.toString();
                                str.append(", ");
                                str.append(tmp);
                                ++i;
                            }
                            str.setCharAt(0, ' ');
                            monthdays = str.toString().trim();
                            rp.setByMonthDay(monthdays);
                        }
                        catch (Exception ep) {
                            ep.printStackTrace();
                            throw new CalendarComponentException(ep.toString());
                        }
                    }
                }
                if (freq == 70) {
                    int month = start.get(2) + 1;
                    rp.setByMonth(month + "");
                }
            }
            return rp;
        }
        return null;
    }

    private void toAPimRecurrencePattern(RecurrencePattern rp) throws Exception {
        if (rp != null) {
            if (this.rpattern == null) {
                throw new OperationNotSupportedException("Can not create new recurrences, only modify existing ones");
            }
            int interval = rp.getInterval();
            String freq = rp.getFrequency();
            PimRecurrencePatternType pType = PimRecurrencePatternType.YEARLY;
            if (freq.equals("DAILY")) {
                pType = PimRecurrencePatternType.DAILY;
            } else if (freq.equals("WEEKLY")) {
                pType = PimRecurrencePatternType.WEEKLY;
            } else if (freq.equals("MONTHLY")) {
                pType = PimRecurrencePatternType.MONTHLY;
            } else if (freq.equals("YEARLY")) {
                pType = PimRecurrencePatternType.YEARLY;
            }
            DateTime dt = rp.getUntilDate();
            int cnt = rp.getCount();
            this.rpattern.setType(pType);
            if (cnt == -1) {
                this.rpattern.setNoOfOccurrences(1490000);
            } else if (dt != null) {
                this.rpattern.setRecurrenceEndDate(dt.getTime());
            } else if (freq.equals("WEEKLY")) {
                this.rpattern.setNoOfInstances(cnt);
            } else {
                this.rpattern.setNoOfOccurrences(cnt);
            }
            this.rpattern.setInterval(interval);
            if (pType == PimRecurrencePatternType.WEEKLY) {
                String days = rp.getByDay();
                if (days != null) {
                    String[] dayArry = this.split(',', days);
                    Vector dow = this.toPimDay(dayArry);
                    this.rpattern.setDaysOfWeek(dow);
                } else {
                    DateTime start = this.getStart();
                    int dow = start.get(7);
                    String[] arr = new String[1];
                    switch (dow) {
                        case 1: {
                            arr[0] = "SU";
                            break;
                        }
                        case 2: {
                            arr[0] = "MO";
                            break;
                        }
                        case 3: {
                            arr[0] = "TU";
                            break;
                        }
                        case 4: {
                            arr[0] = "WE";
                            break;
                        }
                        case 5: {
                            arr[0] = "TH";
                            break;
                        }
                        case 6: {
                            arr[0] = "FR";
                            break;
                        }
                        case 7: {
                            arr[0] = "SA";
                        }
                    }
                    this.rpattern.setDaysOfWeek(this.toPimDay(arr));
                }
            } else if (pType == PimRecurrencePatternType.MONTHLY || pType == PimRecurrencePatternType.YEARLY) {
                String month;
                DateTime start = this.getStart();
                DateTime dateTmp = (DateTime)start.clone();
                String monthday = rp.getByMonthDay();
                if (monthday != null) {
                    String[] arr = this.split(',', monthday);
                    Vector<Integer> monthDays = new Vector<Integer>();
                    int i = 0;
                    while (i < arr.length) {
                        monthDays.add(new Integer(arr[i]));
                        ++i;
                    }
                    this.rpattern.setDaysOfMonth(monthDays);
                } else {
                    String days = rp.getByDay();
                    if (days != null) {
                        String[] arr = this.split(',', days);
                        if (arr.length > 1) {
                            String[] tmp = new String[]{arr[0]};
                            arr = tmp;
                        }
                        int len = arr[0].length();
                        String weekOfMonth = null;
                        if (len > 2) {
                            weekOfMonth = arr[0].substring(0, len - 2);
                            int wom = Integer.parseInt(weekOfMonth);
                            dateTmp.set(8, wom);
                        }
                        if (arr[0].equals("MO")) {
                            dateTmp.set(7, 2);
                        } else if (arr[0].equals("TU")) {
                            dateTmp.set(7, 3);
                        } else if (arr[0].equals("WE")) {
                            dateTmp.set(7, 4);
                        } else if (arr[0].equals("TH")) {
                            dateTmp.set(7, 5);
                        } else if (arr[0].equals("FR")) {
                            dateTmp.set(7, 6);
                        } else if (arr[0].equals("SA")) {
                            dateTmp.set(7, 7);
                        } else if (arr[0].equals("SU")) {
                            dateTmp.set(7, 1);
                        }
                        dateTmp.clear(5);
                        dateTmp.clear(4);
                    } else {
                        int day = start.get(5);
                        Vector<Integer> monthDays = new Vector<Integer>();
                        monthDays.add(new Integer(day));
                        this.rpattern.setDaysOfMonth(monthDays);
                    }
                }
                if (pType == PimRecurrencePatternType.YEARLY && (month = rp.getByMonth()) != null) {
                    int mon = Integer.parseInt(month);
                    dateTmp.set(2, mon - 1);
                }
                if (!start.equals(dateTmp)) {
                    this.setStart(dateTmp);
                }
            }
        }
    }

    private Vector toPimDay(String[] dayArry) {
        Vector<PimRecurrencePatternDayType> dow = new Vector<PimRecurrencePatternDayType>();
        String tmp = null;
        int i = 0;
        while (i < dayArry.length) {
            int len = dayArry[i].length();
            tmp = len > 2 ? dayArry[i].substring(len - 2) : dayArry[i];
            if (tmp.equals("MO")) {
                dow.add(PimRecurrencePatternDayType.MONDAY);
            } else if (tmp.equals("TU")) {
                dow.add(PimRecurrencePatternDayType.TUESDAY);
            } else if (tmp.equals("WE")) {
                dow.add(PimRecurrencePatternDayType.WEDNESDAY);
            } else if (tmp.equals("TH")) {
                dow.add(PimRecurrencePatternDayType.THURSDAY);
            } else if (tmp.equals("FR")) {
                dow.add(PimRecurrencePatternDayType.FRIDAY);
            } else if (tmp.equals("SA")) {
                dow.add(PimRecurrencePatternDayType.SATURDAY);
            } else if (tmp.equals("SU")) {
                dow.add(PimRecurrencePatternDayType.SUNDAY);
            }
            ++i;
        }
        return dow;
    }

    private String[] split(char splitChar, String str) {
        if (str != null) {
            int cnt = 1;
            int i = 0;
            while (i < str.length()) {
                if (str.charAt(i) == splitChar) {
                    ++cnt;
                }
                ++i;
            }
            String[] r = new String[cnt];
            if (cnt > 1) {
                StringTokenizer t = new StringTokenizer(str, String.valueOf(splitChar));
                cnt = 0;
                while (t.hasMoreTokens()) {
                    r[cnt] = t.nextToken().trim();
                    ++cnt;
                }
            } else {
                r[0] = str.trim();
            }
            return r;
        }
        return null;
    }

    public void addAlarmComponent(VAlarm alarm) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void addAttachment(Attach attachment) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void addCategory(String category) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void addExceptionDate(DateTime exceptionDate) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void addExceptionRule(RecurrencePattern exceptionRule) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void addRecurrenceDate(DateTime recurrenceDate) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void addRecurrenceRule(RecurrencePattern recurrenceRule) throws CalendarComponentException {
        this.rpa[0] = recurrenceRule;
    }

    public void addRelatedTo(String relatedTo) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void addResource(String resource) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public VAlarm[] getAlarmComponents() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public Attach[] getAttachments() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public String[] getCategories() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public String getClassification() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public DateTime getCreated() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public String getDescription() throws CalendarComponentException {
        try {
            if (this.event == null) {
                return this.description;
            }
            return this.event.getText();
        }
        catch (Exception pex) {
            pex.printStackTrace();
            throw new CalendarComponentException(pex.getMessage());
        }
    }

    public DateTime[] getExceptionDates() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public RecurrencePattern[] getExceptionRules() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public String getGeo() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public DateTime getLastModified() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public String getLocation() throws CalendarComponentException {
        try {
            if (this.event == null) {
                return this.location;
            }
            return this.event.getLocation();
        }
        catch (Exception pex) {
            pex.printStackTrace();
            throw new CalendarComponentException(pex.getMessage());
        }
    }

    public int getPriority() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public DateTime[] getRecurrenceDates() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public DateTime getRecurrenceID() throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public boolean isRecurring() throws CalendarComponentException {
        try {
            if (this.event == null) {
                if (this.isNew ? this.rpa[0] == null : this.rpattern == null) {
                    return false;
                }
            } else {
                this.rpattern = this.event.getRecurrencePatternItem();
                if (this.rpattern == null) {
                    return false;
                }
            }
        }
        catch (Exception pex) {
            pex.printStackTrace();
        }
        return true;
    }

    public RecurrencePattern[] getRecurrenceRules() throws OperationNotSupportedException, CalendarComponentException {
        RecurrencePattern rp = null;
        try {
            if (this.rpa[0] != null) {
                return this.rpa;
            }
            if (this.event == null) {
                return null;
            }
            if (this.rpattern == null) {
                this.rpattern = this.event.getRecurrencePatternItem();
            }
            if (this.rpattern != null) {
                this.rpa[0] = rp = this.toRecurrencePattern();
                return this.rpa;
            }
            return null;
        }
        catch (Exception pex) {
            pex.printStackTrace();
            throw new CalendarComponentException(pex.getMessage());
        }
    }

    public String[] getRelatedTos() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public String[] getResources() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public int getSequence() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public DateTime getStart() throws CalendarComponentException {
        try {
            if (this.event != null) {
                this.start = this.toDateTime(this.event.getStartTime());
            }
            return this.start;
        }
        catch (Exception pex) {
            pex.printStackTrace();
            throw new CalendarComponentException(pex.getMessage());
        }
    }

    public String getStatus() throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public String getSummary() throws CalendarComponentException {
        try {
            if (this.event != null) {
                return this.event.getSubject();
            }
            return this.summary;
        }
        catch (Exception pex) {
            pex.printStackTrace();
            throw new CalendarComponentException(pex.getMessage());
        }
    }

    public boolean isAllDay() throws CalendarComponentException {
        try {
            if (this.event != null) {
                if (this.event.getType().equals(PimCalendarType.ANNIVERSARY)) {
                    return true;
                }
                return this.event.isAllDayEvent();
            }
            return this.isAllDay;
        }
        catch (Exception pex) {
            pex.printStackTrace();
            throw new CalendarComponentException(pex.getMessage());
        }
    }

    public void removeAlarmComponent(VAlarm alarm) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeAllAlarmComponents() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeAllAttachments() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeAllCategories() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeAllExceptionDates() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeAllExceptionRules() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeAllRecurrenceDates() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeAllRecurrenceRules() {
    }

    public void removeAllRelatedTos() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeAllResources() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeAttachment(Attach attachment) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeCategory(String category) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeExceptionDate(DateTime exceptionDate) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeExceptionRule(RecurrencePattern exceptionRule) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeRecurrenceDate(DateTime recurrenceDate) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeRecurrenceRule(RecurrencePattern recurrenceRule) throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public void removeRelatedTo(String relatedTo) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeResource(String resource) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void setAllDay(boolean allday) throws CalendarComponentException {
        try {
            if (this.event != null) {
                this.event.setAllDayEvent(allday);
            }
            this.isAllDay = allday;
        }
        catch (Exception pex) {
            pex.printStackTrace();
            throw new CalendarComponentException(pex.getMessage());
        }
    }

    public void setClassification(String classification) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void setDescription(String description) throws CalendarComponentException {
        try {
            if (this.event != null) {
                this.event.setText(description);
            }
            this.description = description;
        }
        catch (Exception pex) {
            pex.printStackTrace();
            throw new CalendarComponentException(pex.getMessage());
        }
    }

    public void setDuration(Duration duration) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void setGeo(String geo) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void setLastModified(DateTime lastModified) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void setLocation(String location) throws CalendarComponentException {
        try {
            if (this.event != null) {
                this.event.setLocation(location);
            }
            this.location = location;
        }
        catch (Exception pex) {
            pex.printStackTrace();
            throw new CalendarComponentException(pex.getMessage());
        }
    }

    public void setPriority(int priority) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void setSequence(int sequence) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void setStart(DateTime dtstart) throws CalendarComponentException {
        try {
            if (this.event != null) {
                this.event.setStartTime(dtstart.getTime());
            }
            this.start = dtstart;
        }
        catch (PimException pex) {
            pex.printStackTrace();
            throw new CalendarComponentException(pex.getMessage());
        }
    }

    public void setStatus(String status) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void setSummary(String summary) throws CalendarComponentException {
        try {
            if (this.event != null) {
                this.event.setSubject(summary);
            }
            this.summary = summary;
        }
        catch (Exception pex) {
            pex.printStackTrace();
            throw new CalendarComponentException(pex.getMessage());
        }
    }

    public String toString() {
        try {
            return "\nStart: " + this.getStart() + "\nEnd: " + this.getEnd() + "\nSummary: " + this.getSummary() + "\nDescription: " + this.getDescription() + "\nAllDay: " + this.isAllDay() + "\n" + (this.event == null ? "" : this.event.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public void setEnd(DateTime dtend) throws CalendarComponentException {
        try {
            if (this.event != null) {
                this.event.setEndTime(dtend.getTime());
            }
            this.end = dtend;
        }
        catch (Exception pex) {
            throw new CalendarComponentException(pex.getMessage());
        }
    }

    public DateTime getEnd() throws CalendarComponentException {
        try {
            if (this.event != null) {
                return this.toDateTime(this.event.getEndTime());
            }
            return this.end;
        }
        catch (Exception pex) {
            throw new CalendarComponentException(pex.getMessage());
        }
    }

    public void setCalID(String id) throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public String getCalID() throws CalendarComponentException {
        return this.parentCal.getCalID();
    }

    public String getUrl() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void setUrl(String url) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public String getID() throws CalendarComponentException {
        try {
            if (this.event != null) {
                return this.event.getID();
            }
            return this.id;
        }
        catch (PimException pex) {
            throw new CalendarComponentException(pex.getMessage());
        }
    }

    public void setID(String uid) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeAllRequestStatus() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeRequestStatus(String requeststatus) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void addRequestStatus(String requeststatus) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public String[] getRequestStatus() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void setOrganizer(Organizer organizer) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public Organizer getOrganizer() throws CalendarComponentException, OperationNotSupportedException {
        try {
            if (this.event != null) {
                PimAddressEntryItem paei = this.event.getOrganizer();
            }
        }
        catch (Exception pex) {
            throw new CalendarComponentException(pex.getMessage());
        }
        return null;
    }

    public Duration getDuration() throws CalendarComponentException {
        try {
            if (this.event != null) {
                int i = this.event.getDuration();
                return new Duration(0, i);
            }
            return null;
        }
        catch (Exception pex) {
            throw new CalendarComponentException(pex.getMessage());
        }
    }

    public void setStamp(DateTime dtstamp) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public DateTime getStamp() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeAllComments() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeComment(String comment) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void addComment(String comment) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public String[] getComments() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeAllContacts() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeContact(String contact) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void addContact(String contact) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public String[] getContacts() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeAllAttendees() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeAttendee(Attendee attendee) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void addAttendee(Attendee attendee) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public Attendee[] getAttendees() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public boolean hasAttendee() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public boolean isConfirmed() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public boolean isCalIdTheOrganizer(String calId) throws OperationNotSupportedException, CalendarComponentException {
        try {
            if (this.event != null && calId != null && this.event.getOrganizer() != null) {
                return this.event.getOrganizer().getName().equals(calId);
            }
            if (this.organizerName != null && calId != null) {
                return this.organizerName.equals(calId);
            }
        }
        catch (PimException ex) {
            throw new CalendarComponentException(ex.getMessage());
        }
        return true;
    }

    public Attendee getAttendee(String calid) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void delete() throws PimException {
        if (this.event != null) {
            this.event.delete();
        } else if (this.id != null) {
            this.event = this.parentCal.getAppointmentItems().getAppointmentItem(this.id);
            this.event.delete();
            if (enableCache) {
                this.event = null;
            }
        }
    }

    public void update() throws PimException {
        if (this.event == null) {
            this.event = this.id == null ? this.parentCal.getAppointmentItems().addAppointmentItem() : this.parentCal.getAppointmentItems().getAppointmentItem(this.id);
            if (this.summary != null) {
                this.event.setSubject(this.summary);
            }
            if (this.description != null) {
                this.event.setText(this.description);
            }
            if (this.location != null) {
                this.event.setLocation(this.location);
            }
            if (this.start != null) {
                this.event.setStartTime(this.start.getTime());
            }
            if (this.end != null) {
                this.event.setEndTime(this.end.getTime());
            }
            this.event.setAllDayEvent(this.isAllDay);
        }
        if (this.rpa[0] != null) {
            try {
                if (this.rpattern == null) {
                    this.rpattern = this.event.getRecurrencePatternItem();
                }
                this.toAPimRecurrencePattern(this.rpa[0]);
                this.rpattern.update();
                this.rpa[0] = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.event.update();
        this.isNew = false;
        if (this.id == null) {
            this.id = this.event.getID();
        }
        if (enableCache) {
            this.event = null;
        }
    }

    private void printRecurrencePattern(PimRecurrencePatternItem prpi) throws PimException {
        System.err.println("----[PimRecurrencePatternItem]-------------");
        System.err.println("getID: " + prpi.getID());
        System.err.println("getType: " + prpi.getType());
        System.err.println("Interval: " + prpi.getInterval());
        System.err.println("NoOfOccurrences: " + prpi.getNoOfOccurrences());
        System.err.println("EndDate: " + prpi.getRecurrenceEndDate());
        try {
            System.err.println("DaysOfMonth: " + prpi.getDaysOfMonth());
        }
        catch (PimException pex) {
            System.err.println("DaysOfMonth threw an exception");
        }
        try {
            System.err.println("DaysOfWeek: " + prpi.getDaysOfWeek());
        }
        catch (PimException pex) {
            System.err.println("DaysOfWeek threw an exception");
        }
        System.err.println("-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
    }

    public VAlarm createAlarm() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public boolean isPublic() throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public boolean hasAlarm() throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public int getPendingAttendeesCount() throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public int getTentativeAttendeesCount() throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public int getDeclinedAttendeesCount() throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public int getAcceptedAttendeesCount() throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }
}

