/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter.ab.pim;

import com.aligo.pim.PimFilterOperandType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.interfaces.PimAddressEntryItemFilter;
import com.sun.addressbook.ABSearchTerm;
import com.sun.addressbook.ABStoreException;
import com.sun.ssoadapter.ab.pim.JPimABConstants;
import com.sun.ssoadapter.ab.pim.SchemaElements;
import java.lang.reflect.Method;

public class JPimABSearchTerm
extends ABSearchTerm
implements JPimABConstants {
    private PimAddressEntryItemFilter pimAEItemFilter = null;
    private static final int OPEN = 101;
    private static final int CLOSE = 102;
    private SchemaElements schemaElements = new SchemaElements();

    public JPimABSearchTerm(String name, String value, boolean exact) {
        super(name, value, exact);
    }

    public JPimABSearchTerm(ABSearchTerm term, int op) throws ABStoreException {
        super(term, op);
    }

    public JPimABSearchTerm(ABSearchTerm[] terms, int op) throws ABStoreException {
        super(terms, op);
    }

    public void setAddressEntryItemFilter(PimAddressEntryItemFilter filter) {
        this.pimAEItemFilter = filter;
    }

    public Object compute() throws ABStoreException {
        if (this.pimAEItemFilter == null) {
            throw new ABStoreException("PimAddressEntryItemFilter == null");
        }
        StringBuffer dbgStr = new StringBuffer();
        this.addToFilter(this.pimAEItemFilter, dbgStr);
        System.out.println("Filter equivalent = " + dbgStr);
        return this.pimAEItemFilter;
    }

    private void addToFilter(PimAddressEntryItemFilter pimFilter, StringBuffer dbgStr) throws ABStoreException {
        ABSearchTerm[] searchTerms = this.getTerms();
        if (searchTerms != null) {
            int num_elements = searchTerms.length;
            this.setOperandOnFilter(pimFilter, 101, dbgStr);
            int i = 0;
            while (i < num_elements) {
                JPimABSearchTerm searchTerm = (JPimABSearchTerm)searchTerms[i];
                searchTerm.addToFilter(pimFilter, dbgStr);
                if (i < num_elements - 1 || num_elements == 1) {
                    this.setOperandOnFilter(pimFilter, this.getOp(), dbgStr);
                }
                ++i;
            }
            this.setOperandOnFilter(pimFilter, 102, dbgStr);
        }
        this.setInFilter(pimFilter, dbgStr);
    }

    private void setOperandOnFilter(PimAddressEntryItemFilter pimFilter, int operation, StringBuffer dbgStr) throws ABStoreException {
        if (operation != -1) {
            PimFilterOperandType opType = null;
            switch (operation) {
                case 1: {
                    dbgStr.append("|");
                    opType = PimFilterOperandType.OR;
                    break;
                }
                case 2: {
                    dbgStr.append("&");
                    opType = PimFilterOperandType.AND;
                    break;
                }
                case 101: {
                    dbgStr.append("(");
                    opType = PimFilterOperandType.OPEN;
                    break;
                }
                case 102: {
                    dbgStr.append(")");
                    opType = PimFilterOperandType.CLOSE;
                    break;
                }
                case 0: {
                    dbgStr.append("{NOT}");
                }
                default: {
                    throw new ABStoreException("Operand not supported: " + operation);
                }
            }
            try {
                pimFilter.setOperand(opType);
            }
            catch (PimException pe) {
                pe.printStackTrace();
                throw new ABStoreException("Could not setOperand: " + (Object)((Object)pe));
            }
        }
    }

    private void setInFilter(PimAddressEntryItemFilter pimFilter, StringBuffer dbgStr) throws ABStoreException {
        String name = this.getName();
        String value = this.getValue();
        if (name == null || value == null) {
            return;
        }
        boolean exact = this.isExact();
        Object[] params = new String[]{value};
        Class<?> filterClass = pimFilter.getClass();
        if (name.equalsIgnoreCase("any")) {
            if (value != null && !value.equals("*")) {
                Object[] allPropNames = this.schemaElements.getAEFilterPropertyNames();
                if (allPropNames == null) {
                    return;
                }
                int count = allPropNames.length;
                this.setOperandOnFilter(pimFilter, 101, dbgStr);
                int i = 0;
                while (i < count) {
                    this.setInFilter(pimFilter, filterClass, (String)allPropNames[i], params, dbgStr);
                    if (i < count - 1) {
                        this.setOperandOnFilter(pimFilter, 1, dbgStr);
                    }
                    ++i;
                }
                this.setOperandOnFilter(pimFilter, 102, dbgStr);
            }
        } else {
            this.setInFilter(pimFilter, filterClass, name, params, dbgStr);
        }
    }

    private void setInFilter(PimAddressEntryItemFilter pimFilter, Class filterClass, String propName, Object[] values, StringBuffer dbgStr) throws ABStoreException {
        dbgStr.append(propName + "=" + values[0]);
        String pimElementName = this.schemaElements.getPimElementName(propName);
        if (pimElementName == null) {
            return;
        }
        String setterMethodName = "set" + pimElementName;
        try {
            Method setterMethod = filterClass.getMethod(setterMethodName, JPimABConstants.beanParams);
            setterMethod.invoke((Object)pimFilter, values);
        }
        catch (Exception e) {
            throw new ABStoreException("Could not get/set in PimAddressEntryItemFilter:" + setterMethodName + " :: " + e);
        }
    }
}

