/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav.util.xml;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMWriter {
    private static final String DEFAULT_PARSER_NAME = "dom.wrappers.DOMParser";
    private static boolean setValidation = false;
    private static boolean setNameSpaces = true;
    private static boolean setSchemaSupport = true;
    private static boolean setDeferredDOM = true;
    private static String PRINTWRITER_ENCODING = "UTF8";
    private static String[] MIME2JAVA_ENCODINGS = new String[]{"Default", "UTF-8", "US-ASCII", "ISO-8859-1", "ISO-8859-2", "ISO-8859-3", "ISO-8859-4", "ISO-8859-5", "ISO-8859-6", "ISO-8859-7", "ISO-8859-8", "ISO-8859-9", "ISO-2022-JP", "SHIFT_JIS", "EUC-JP", "GB2312", "BIG5", "EUC-KR", "ISO-2022-KR", "KOI8-R", "EBCDIC-CP-US", "EBCDIC-CP-CA", "EBCDIC-CP-NL", "EBCDIC-CP-DK", "EBCDIC-CP-NO", "EBCDIC-CP-FI", "EBCDIC-CP-SE", "EBCDIC-CP-IT", "EBCDIC-CP-ES", "EBCDIC-CP-GB", "EBCDIC-CP-FR", "EBCDIC-CP-AR1", "EBCDIC-CP-HE", "EBCDIC-CP-CH", "EBCDIC-CP-ROECE", "EBCDIC-CP-YU", "EBCDIC-CP-IS", "EBCDIC-CP-AR2", "UTF-16"};
    protected PrintWriter out;
    protected ArrayList list = new ArrayList();
    private static String PADDING = "    ";
    protected boolean canonical;
    protected boolean ignoreMessyText;

    public DOMWriter(String encoding, boolean canonical) throws UnsupportedEncodingException {
        this(System.out, encoding, canonical);
    }

    public DOMWriter(OutputStream output, String encoding, boolean canonical) throws UnsupportedEncodingException {
        this.out = new PrintWriter(new OutputStreamWriter(output, encoding));
        this.canonical = canonical;
    }

    public DOMWriter(Writer writer, boolean canonical) {
        this.out = new PrintWriter(writer);
        this.canonical = canonical;
    }

    public DOMWriter(boolean canonical) throws UnsupportedEncodingException {
        this(System.out, canonical);
    }

    public DOMWriter(OutputStream output, boolean canonical) throws UnsupportedEncodingException {
        this(output, DOMWriter.getWriterEncoding(), canonical);
    }

    public static String getWriterEncoding() {
        return PRINTWRITER_ENCODING;
    }

    public static void setWriterEncoding(String encoding) {
        if (encoding.equalsIgnoreCase("DEFAULT")) {
            PRINTWRITER_ENCODING = "UTF8";
        } else if (encoding.equalsIgnoreCase("UTF-16")) {
            PRINTWRITER_ENCODING = "Unicode";
        }
    }

    public static boolean isValidJavaEncoding(String encoding) {
        int i = 0;
        while (i < MIME2JAVA_ENCODINGS.length) {
            if (encoding.equals(MIME2JAVA_ENCODINGS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setIgnoreMessyText(boolean ignoreMessyText) {
        this.ignoreMessyText = ignoreMessyText;
    }

    public boolean isIgnoreMessyText() {
        return this.ignoreMessyText;
    }

    public void print(Node node) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                if (!this.canonical) {
                    String Encoding = DOMWriter.getWriterEncoding();
                    if (Encoding.equalsIgnoreCase("DEFAULT")) {
                        Encoding = "UTF-8";
                    } else if (Encoding.equalsIgnoreCase("Unicode")) {
                        Encoding = "UTF-16";
                    }
                    this.out.println("<?xml version=\"1.0\" encoding=\"" + Encoding + "\"?>");
                }
                NodeList children = node.getChildNodes();
                int iChild = 0;
                while (iChild < children.getLength()) {
                    this.print(children.item(iChild));
                    ++iChild;
                }
                this.out.flush();
                break;
            }
            case 1: {
                int len = 0;
                NodeList children = node.getChildNodes();
                if (children != null) {
                    len = children.getLength();
                }
                this.out.print(this.getPadding());
                this.list.add(node.getNodeName());
                this.out.print('<');
                this.out.print(node.getNodeName());
                Attr[] attrs = this.sortAttributes(node.getAttributes());
                int i = 0;
                while (i < attrs.length) {
                    Attr attr = attrs[i];
                    this.out.print(' ');
                    this.out.print(attr.getNodeName());
                    this.out.print("=\"");
                    this.out.print(this.normalize(attr.getNodeValue()));
                    this.out.print('\"');
                    ++i;
                }
                if (len > 0) {
                    if (len == 1 && children.item(0).getNodeType() == 3) {
                        this.out.print('>');
                    } else {
                        this.out.print(">\n");
                    }
                } else {
                    this.out.print("/>\n");
                }
                int i2 = 0;
                while (i2 < len) {
                    this.print(children.item(i2));
                    ++i2;
                }
                break;
            }
            case 5: {
                if (this.canonical) {
                    NodeList children = node.getChildNodes();
                    if (children == null) break;
                    int len = children.getLength();
                    int i = 0;
                    while (i < len) {
                        this.print(children.item(i));
                        ++i;
                    }
                    break;
                }
                this.out.print('&');
                this.out.print(node.getNodeName());
                this.out.print(';');
                break;
            }
            case 4: {
                if (this.canonical) {
                    this.out.print(this.normalize(node.getNodeValue()));
                    break;
                }
                this.out.print("<![CDATA[");
                this.out.print(node.getNodeValue());
                this.out.print("]]>");
                break;
            }
            case 3: {
                this.out.print(this.normalize(node.getNodeValue()));
                break;
            }
            case 7: {
                this.out.print("<?");
                this.out.print(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    this.out.print(' ');
                    this.out.print(data);
                }
                this.out.println("?>");
                break;
            }
        }
        if (type == 1) {
            int len;
            ((AbstractCollection)this.list).remove(node.getNodeName());
            NodeList children = node.getChildNodes();
            if (children != null && (len = children.getLength()) > 0) {
                if (len != 1 || children.item(0).getNodeType() != 3) {
                    this.out.print(this.getPadding());
                }
                this.out.print("</");
                this.out.print(node.getNodeName());
                this.out.print(">\n");
            }
        }
        this.out.flush();
    }

    protected String getPadding() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.list.size()) {
            buffer.append(PADDING);
            ++i;
        }
        return buffer.toString();
    }

    protected Attr[] sortAttributes(NamedNodeMap attrs) {
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        int i = 0;
        while (i < len) {
            array[i] = (Attr)attrs.item(i);
            ++i;
        }
        int i2 = 0;
        while (i2 < len - 1) {
            String name = array[i2].getNodeName();
            int index = i2;
            int j = i2 + 1;
            while (j < len) {
                String curName = array[j].getNodeName();
                if (curName.compareTo(name) < 0) {
                    name = curName;
                    index = j;
                }
                ++j;
            }
            if (index != i2) {
                Attr temp = array[i2];
                array[i2] = array[index];
                array[index] = temp;
            }
            ++i2;
        }
        return array;
    }

    protected String normalize(String s) {
        if (this.ignoreMessyText) {
            s = s.trim();
        }
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    break;
                }
                case '>': {
                    str.append("&gt;");
                    break;
                }
                case '&': {
                    str.append("&amp;");
                    break;
                }
                case '\"': {
                    str.append("&quot;");
                    break;
                }
                case '\n': 
                case '\r': {
                    if (this.canonical && !this.ignoreMessyText) {
                        str.append("&#");
                        str.append(Integer.toString(ch));
                        str.append(';');
                        break;
                    }
                }
                case '\t': {
                    if (!this.ignoreMessyText) {
                        str.append('\t');
                        break;
                    }
                }
                default: {
                    str.append(ch);
                }
            }
            ++i;
        }
        return str.toString();
    }

    private static void printValidJavaEncoding() {
        System.err.println("    ENCODINGS:");
        System.err.print("   ");
        int i = 0;
        while (i < MIME2JAVA_ENCODINGS.length) {
            System.err.print(MIME2JAVA_ENCODINGS[i] + " ");
            if (i % 7 == 0) {
                System.err.println();
                System.err.print("   ");
            }
            ++i;
        }
    }
}

