/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.services;

import com.sun.portal.rewriter.services.DataService;
import com.sun.portal.rewriter.services.DataServiceException;
import com.sun.portal.rewriter.services.idsame.IDSAMEDataService;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.StringHelper;
import java.lang.reflect.Constructor;
import java.util.Properties;

public final class DataServiceFactory {
    private static final String SERVICE_PACKAGE_PREFIX = "com.sun.portal.rewriter.services.";
    private static final String IDS_IMPL = "com.sun.portal.rewriter.services.ids.IDSDataService";
    private static final String FILE_IMPL = "com.sun.portal.rewriter.services.file.FileDataService";
    static /* synthetic */ Class class$java$util$Properties;

    public static DataService create(Properties aDataServiceProps) {
        String lType = StringHelper.normalize(aDataServiceProps.getProperty("DATA_SOURCE_TYPE"));
        DataService dataService = lType.equals("IDS") ? DataServiceFactory.createServiceUsingReflection(IDS_IMPL, aDataServiceProps) : (lType.equals("FILE") ? DataServiceFactory.createServiceUsingReflection(FILE_IMPL, aDataServiceProps) : (lType.equals("CUSTOM") ? DataServiceFactory.createServiceUsingReflection(aDataServiceProps.getProperty("CUSTOM_DATA_SERVICE_IMPLEMENTOR"), aDataServiceProps) : new IDSAMEDataService(aDataServiceProps)));
        return dataService;
    }

    private static DataService createServiceUsingReflection(String aClassName, Properties aProps) {
        System.out.println("Data Service Provider Class: " + aClassName);
        try {
            Class<?> classRef = Class.forName(aClassName);
            Constructor<?> constructor = classRef.getConstructor(class$java$util$Properties == null ? (class$java$util$Properties = DataServiceFactory.class$("java.util.Properties")) : class$java$util$Properties);
            return (DataService)constructor.newInstance(aProps);
        }
        catch (Exception e) {
            System.out.println("Failed to create the DataService : " + aClassName + "\n Exception Was : " + StringHelper.exceptionStack2String(e));
            throw new RuntimeException(StringHelper.exceptionStack2String(e));
        }
    }

    public static void main(String[] args) throws DataServiceException {
        String lBaseDir = args[0];
        String lFileName = args[1];
        Properties props = new Properties();
        props.setProperty("DATA_SOURCE_TYPE", "FILE");
        props.setProperty("DATA_SERVICE_BASE", lBaseDir);
        DataService dataService = DataServiceFactory.create(props);
        Debug.println(dataService.storeXML(lFileName, "one junk data"));
        Debug.println(dataService.retrieveKeys());
        Debug.println(dataService.storeXML(lFileName, "two raja nagendra kumar"));
        Debug.println(dataService.storeXML(lFileName + lFileName, "two raja nagendra kumar"));
        Debug.println(dataService.deleteKey(lFileName));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

