/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.engines;

import com.sun.portal.rewriter.Rewriter;
import com.sun.portal.rewriter.engines.css.CSSRewriter;
import com.sun.portal.rewriter.engines.html.HTMLRewriter;
import com.sun.portal.rewriter.engines.js.JSRewriter;
import com.sun.portal.rewriter.engines.markup.MarkupRewriter;
import com.sun.portal.rewriter.engines.xml.XMLRewriter;
import com.sun.portal.rewriter.rom.RuleSet;

public final class RewriterBroker {
    private final RuleSet ruleSet;
    private HTMLRewriter htmlRewriter;
    private JSRewriter jsRewriter;
    private XMLRewriter xmlRewriter;
    private CSSRewriter cssRewriter;
    private MarkupRewriter markupRewriter;

    public RewriterBroker(RuleSet aRuleSet) {
        this.ruleSet = aRuleSet;
    }

    public Rewriter getInstance(String aMIME) {
        if (aMIME == null) {
            return null;
        }
        if (aMIME.indexOf("text/html") != -1) {
            return this.getHTMLRewriter();
        }
        if (aMIME.indexOf("text/markup") != -1) {
            return this.getMarkupRewriter();
        }
        if (aMIME.indexOf("application/x-javascript") != -1) {
            return this.getJSRewriter();
        }
        if (aMIME.indexOf("text/css") != -1) {
            return this.getCSSRewriter();
        }
        if (aMIME.indexOf("text/xml") != -1) {
            return this.getXMLRewriter();
        }
        return null;
    }

    public MarkupRewriter getMarkupRewriter() {
        if (this.markupRewriter == null) {
            this.markupRewriter = new MarkupRewriter(this);
        }
        return this.markupRewriter;
    }

    public HTMLRewriter getHTMLRewriter() {
        if (this.htmlRewriter == null) {
            this.htmlRewriter = new HTMLRewriter(this);
        }
        return this.htmlRewriter;
    }

    public JSRewriter getJSRewriter() {
        if (this.jsRewriter == null) {
            this.jsRewriter = new JSRewriter(this);
        }
        return this.jsRewriter;
    }

    public XMLRewriter getXMLRewriter() {
        if (this.xmlRewriter == null) {
            this.xmlRewriter = new XMLRewriter(this);
        }
        return this.xmlRewriter;
    }

    public CSSRewriter getCSSRewriter() {
        if (this.cssRewriter == null) {
            this.cssRewriter = new CSSRewriter(this);
        }
        return this.cssRewriter;
    }

    public RuleSet getRuleSet() {
        return this.ruleSet;
    }
}

