/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.cli;

import com.sun.portal.desktop.DesktopError;
import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.context.DSAMEAdminDPContext;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.desktop.dp.xml.XMLDPRoot;
import com.sun.portal.portlet.cli.PortletDeployerException;
import com.sun.portal.portlet.cli.PortletDeployerLocalizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.w3c.dom.Element;
import org.xml.sax.SAXParseException;

public class PDDPUpdater {
    private DSAMEAdminDPContext dadc = null;
    private String dn = null;
    private boolean verbose = false;
    private boolean global = false;
    public static final int CONTEXT_LINE_NUM = 5;
    XMLDPFactory dpf = XMLDPFactory.getInstance();

    public PDDPUpdater(DSAMEAdminDPContext dadc, String dn, boolean global, boolean verbose) {
        this.dadc = dadc;
        this.dn = dn;
        this.global = global;
        this.verbose = verbose;
    }

    public void addProviders(List providerElements) throws PortletDeployerException {
        DPRoot dpr = this.getDPRoot();
        int i = 0;
        while (i < providerElements.size()) {
            Element element = (Element)providerElements.get(i);
            dpr = this.addProvider(dpr, element);
            ++i;
        }
        if (this.verbose) {
            PortletDeployerLocalizer.debug("dbgValidatingDP");
        }
        String dpDoc = null;
        try {
            dpr = this.setDirty(dpr);
            dpDoc = dpr.toString();
            this.dpf.createRoot((DPContext)this.dadc, dpDoc);
        }
        catch (DesktopError de) {
            Throwable wrapped = de.getWrapped();
            if (wrapped != null && wrapped instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)wrapped;
                int linenum = spe.getLineNumber();
                Object[] tokens = new Object[]{PDDPUpdater.getLines(new StringReader(dpDoc), linenum)};
                throw new PortletDeployerException("errorInvalidXMLText", de, tokens);
            }
        }
        catch (Throwable ex) {
            throw new PortletDeployerException("errorInvalidXML", ex);
        }
        this.storeDPDocument(dpr);
    }

    public DPRoot addProvider(DPRoot dpr, Element element) throws PortletDeployerException {
        if (this.verbose) {
            Object[] tokens = new Object[]{element.getAttribute("name")};
            PortletDeployerLocalizer.debug("dbgAddingProvider", tokens);
            PortletDeployerLocalizer.debug("dbgCreatingDPProvider");
        }
        DPProvider p = null;
        try {
            p = this.dpf.getProvider((DPContext)this.dadc, dpr, element);
        }
        catch (Throwable ex) {
            throw new PortletDeployerException("errorCreateDPProvider", ex);
        }
        if (this.verbose) {
            Object[] tokens = new Object[]{p.getName()};
            PortletDeployerLocalizer.debug("dbgCheckDupName", tokens);
        }
        boolean dupFound = false;
        try {
            XMLDPRoot xdpr = (XMLDPRoot)dpr;
            boolean bl = dupFound = xdpr.getChannelFromThis(p.getName()) != null;
            if (!dupFound) {
                dupFound = xdpr.getProviderFromThis(p.getName()) != null;
            }
        }
        catch (Throwable ex) {
            throw new PortletDeployerException("errorCheckDupName", ex);
        }
        if (dupFound) {
            Object[] tokens = new Object[]{p.getName()};
            PortletDeployerLocalizer.warning("WarningDupName", tokens);
        }
        try {
            dpr.addProvider(p);
        }
        catch (Throwable ex) {
            Object[] tokens = new Object[]{p.getName()};
            throw new PortletDeployerException("errorAddProvider", ex, tokens);
        }
        return dpr;
    }

    public void removeProviders(List providers) throws PortletDeployerException {
        DPRoot dpr = this.getDPRoot();
        int i = 0;
        while (i < providers.size()) {
            String name = (String)providers.get(i);
            dpr = this.removeProvider(dpr, name);
            ++i;
        }
        dpr = this.setDirty(dpr);
        this.storeDPDocument(dpr);
    }

    public DPRoot removeProvider(DPRoot dpr, String name) throws PortletDeployerException {
        if (this.verbose) {
            Object[] tokens = new Object[]{name};
            PortletDeployerLocalizer.debug("dbgRemovingProvider", tokens);
        }
        if (this.verbose) {
            PortletDeployerLocalizer.debug("dbgCheckExistingProvider");
        }
        boolean exists = false;
        try {
            XMLDPRoot xdpr = (XMLDPRoot)dpr;
            exists = xdpr.getProviderFromThis(name) != null;
        }
        catch (Throwable ex) {
            Object[] tokens = new Object[]{name};
            throw new PortletDeployerException("errorLookupProvider", ex, tokens);
        }
        if (!exists) {
            Object[] tokens = new Object[]{name};
            PortletDeployerLocalizer.warning("WarningFindProvider", tokens);
        }
        try {
            dpr.removeProvider(name);
        }
        catch (Throwable ex) {
            Object[] tokens = new Object[]{name};
            throw new PortletDeployerException("errorRemoveProvider", ex, tokens);
        }
        return dpr;
    }

    private DPRoot getDPRoot() throws PortletDeployerException {
        String doc = null;
        try {
            doc = !this.global ? this.dadc.getDPDocumentByDN(this.dn) : this.dadc.getGlobalDPDocument();
        }
        catch (Throwable ex) {
            Object[] tokens = new Object[]{this.global ? PortletDeployerLocalizer.getLocalizedString("msgGlobal") : this.dn};
            throw new PortletDeployerException("errorRetrieveDP", ex, tokens);
        }
        DPRoot dpr = null;
        try {
            dpr = this.dpf.createRoot((DPContext)this.dadc, doc);
        }
        catch (Throwable ex) {
            Object[] tokens = new Object[]{this.dn};
            throw new PortletDeployerException("errorCreateDPRoot", ex, tokens);
        }
        return dpr;
    }

    private void storeDPDocument(DPRoot dpr) throws PortletDeployerException {
        if (this.verbose) {
            PortletDeployerLocalizer.debug("dbgWritingDP");
        }
        try {
            if (!this.global) {
                this.dadc.storeDPDocumentByDN(this.dn, dpr.toString());
            } else {
                this.dadc.storeGlobalDPDocument(dpr.toString());
            }
        }
        catch (Throwable ex) {
            throw new PortletDeployerException("errorStoreDP", ex);
        }
    }

    private DPRoot setDirty(DPRoot dpr) throws PortletDeployerException {
        try {
            if (dpr.isDirty()) {
                dpr.setDirty(false);
            }
        }
        catch (Throwable ex) {
            throw new PortletDeployerException("errorSetDirty", ex);
        }
        return dpr;
    }

    public static String getLines(Reader reader, int linenum) {
        StringBuffer buf = new StringBuffer();
        String line = null;
        BufferedReader br = new BufferedReader(reader);
        try {
            int i = 1;
            int beg = linenum - 5;
            int end = linenum + 5;
            buf.append("\n");
            while ((line = br.readLine()) != null) {
                if (i == linenum) {
                    buf.append("(*)").append(line).append("\n");
                } else if (i >= beg && i <= end) {
                    buf.append("   ").append(line).append("\n");
                }
                ++i;
            }
            buf.append("\n");
        }
        catch (IOException ioe) {
            return "";
        }
        return buf.toString();
    }
}

