/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.rewriter.util.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;

public class ChunkedContent {
    public static byte[] readChunkedContent(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = ChunkedContent.getChunkSize(inputStream);
        while (n > 0) {
            byte[] byArray = new byte[n];
            inputStream.read(byArray);
            ChunkedContent.readCRLF(inputStream);
            byteArrayOutputStream.write(byArray);
            n = ChunkedContent.getChunkSize(inputStream);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static int getChunkSize(InputStream inputStream) throws IOException {
        int n = 0;
        String string = ChunkedContent.readLine(inputStream);
        if (string == null) {
            throw new IOException("Could not read chunk block size");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t \n\r(;");
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                n = Integer.parseInt(string2, 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Chunk size should be a hex number: '" + string + "', '" + string2 + "'.");
            }
        } else {
            throw new IOException("Chunk could not be read.");
        }
        return n;
    }

    public static void readCRLF(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        if (n != 13 && n2 != 10) {
            throw new IOException("Could not read CR & LF correctly: " + n + ", " + n2);
        }
    }

    private static String readLine(InputStream inputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer(50);
        int n2 = -1;
        int n3 = 0;
        while ((n = inputStream.read()) != -1) {
            ++n3;
            if (n2 == 13 && n == 10) {
                stringBuffer.setLength(stringBuffer.length() - 1);
                break;
            }
            stringBuffer.append((char)n);
            n2 = n;
        }
        if (n3 == 0) {
            return null;
        }
        return stringBuffer.toString();
    }
}

