/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.configservlet.server;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.rproxy.configservlet.Request;
import com.sun.portal.rproxy.configservlet.Response;
import com.sun.portal.rproxy.configservlet.ServiceHandler;
import com.sun.portal.rproxy.configservlet.server.UserProfileCache;
import java.rmi.RemoteException;
import java.util.Map;

public class UserAttributesServiceHandler
implements ServiceHandler {
    public Response handleRequest(Request request) throws RemoteException {
        String string = request.getSSOTokenId();
        Response response = UserProfileCache.getResponse(string);
        boolean bl = true;
        response.setRequestType(request.getRequestType());
        response.setServiceName(request.getServiceName());
        response.setNormal(bl);
        return response;
    }

    protected Response fetchUserAttributes(Request request, SSOToken sSOToken) throws RemoteException {
        try {
            AMStoreConnection aMStoreConnection = new AMStoreConnection(sSOToken);
            AMUser aMUser = aMStoreConnection.getUser(sSOToken.getPrincipal().getName());
            Map map = aMUser.getAttributes();
            Response response = new Response(request.getServiceName(), request.getRequestType(), map);
            return response;
        }
        catch (SSOException sSOException) {
            throw new RemoteException("Not able to get Global Attributes", sSOException);
        }
        catch (AMException aMException) {
            throw new RemoteException("Not able to get Global Attributes", aMException);
        }
    }

    protected SSOToken getSSOToken(Request request) throws RemoteException {
        try {
            String string = request.getSSOTokenId();
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            return sSOTokenManager.createSSOToken(string);
        }
        catch (SSOException sSOException) {
            throw new RemoteException("Not able to get the token", sSOException);
        }
    }
}

