/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.configservlet.server;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;

class Operation {
    public static final int INVALID = -1;
    public static final int LESS_THAN = 1;
    public static final int GREATER_THAN = 2;
    public static final int RANGE = 3;
    public static final int EXACT_VALUE = 4;
    public static final int MATCH_ALL = 5;
    public static final String LESS_THAN_STR = "<";
    public static final String GREATER_THAN_STR = ">";
    public static final String RANGE_STR = ",";
    public static final String MATCH_ALL_STR = "*";
    private static final LinkedList operators = new LinkedList();
    private static final HashMap operatorsMap = new HashMap();
    private static final HashMap unaryMap = new HashMap();
    private int operator = -1;
    private int leftOperand = -1;
    private int rightOperand = -1;
    private boolean unary = false;
    private int unaryOperand = -1;
    private String expr = "";

    public Operation(String string) {
        if (string != null) {
            this.expr = string = string.trim();
            Iterator iterator = operators.iterator();
            int n = -1;
            String string2 = null;
            int n2 = -1;
            while (iterator.hasNext()) {
                string2 = iterator.next().toString();
                n2 = string.indexOf(string2);
                if (n2 == -1) continue;
                n = (Integer)operatorsMap.get(string2);
                break;
            }
            this.operator = n;
            if (n != -1) {
                this.unary = (Boolean)unaryMap.get(string2);
                if (this.unary) {
                    string = string.substring(n2 + 1).trim();
                    try {
                        this.unaryOperand = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
                    if (stringTokenizer.countTokens() == 2) {
                        try {
                            this.leftOperand = Integer.parseInt(stringTokenizer.nextToken().trim());
                            this.rightOperand = Integer.parseInt(stringTokenizer.nextToken().trim());
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else {
                        this.operator = -1;
                    }
                }
            } else if (this.expr.equals(MATCH_ALL_STR)) {
                this.operator = 5;
            } else {
                try {
                    this.unaryOperand = Integer.parseInt(string);
                    this.operator = 4;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isValid() {
        return -1 != this.getOperator();
    }

    public int getOperator() {
        return this.operator;
    }

    public int getLeftOperand() {
        return this.leftOperand;
    }

    public int getRightOperand() {
        return this.rightOperand;
    }

    public boolean isUnary() {
        return this.unary;
    }

    public int getUnaryOperand() {
        return this.unaryOperand;
    }

    public boolean evaluate(int n) {
        if (this.isValid()) {
            switch (this.getOperator()) {
                case 1: {
                    if (n >= this.unaryOperand) break;
                    return true;
                }
                case 2: {
                    if (n <= this.unaryOperand) break;
                    return true;
                }
                case 4: {
                    if (n != this.unaryOperand) break;
                    return true;
                }
                case 5: {
                    return true;
                }
                case 3: {
                    if (n < this.leftOperand || n > this.rightOperand) break;
                    return true;
                }
            }
        }
        return false;
    }

    static {
        operators.add(LESS_THAN_STR);
        operators.add(GREATER_THAN_STR);
        operators.add(RANGE_STR);
        operatorsMap.put(LESS_THAN_STR, new Integer(1));
        operatorsMap.put(GREATER_THAN_STR, new Integer(2));
        operatorsMap.put(RANGE_STR, new Integer(3));
        unaryMap.put(LESS_THAN_STR, new Boolean(true));
        unaryMap.put(GREATER_THAN_STR, new Boolean(true));
        unaryMap.put(RANGE_STR, new Boolean(false));
    }
}

