/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.configservlet;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.SSOUtil;
import java.io.Serializable;

public class Request
implements Serializable {
    private String serviceName;
    private String ssoTokenId;
    private String requestType;
    private Object requestObject;
    private Object[] arguments;
    private String gatewaySessionID = null;
    private static int retryCount = 0;
    private static int MIN_RETRY_TIME = 60000;
    private static long prevRetryTime = 0L;

    public Request(String string, String string2, String string3, Object object, Object[] objectArray) {
        this.ssoTokenId = string;
        this.serviceName = string2;
        this.requestType = string3;
        this.requestObject = object;
        this.arguments = objectArray;
    }

    public Request(String string, String string2, String string3, Object object) {
        this(string, string2, string3, object, null);
    }

    public Request(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getSSOTokenId() {
        return this.ssoTokenId;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public Object getRequestObject() {
        return this.requestObject;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public String getGatewaySessionID() {
        return this.gatewaySessionID;
    }

    private static synchronized void retryAddGatewaySessionId(Request request) {
        if (retryCount > 5 || System.currentTimeMillis() - prevRetryTime < (long)MIN_RETRY_TIME) {
            boolean bl = retryCount > 5;
            retryCount = 0;
            if (bl) {
                prevRetryTime = System.currentTimeMillis();
            }
            request.gatewaySessionID = null;
            return;
        }
        GWLogManager.createNewAppSession();
        SSOToken sSOToken = Request.getToken(GWLogManager.appSession);
        if (sSOToken != null) {
            String string;
            request.gatewaySessionID = string = GWLogManager.appSession.getTokenID().toString();
            prevRetryTime = System.currentTimeMillis();
        } else {
            ++retryCount;
            Request.retryAddGatewaySessionId(request);
        }
    }

    public static SSOToken getToken(SSOToken sSOToken) {
        if (sSOToken == null) {
            return null;
        }
        String string = sSOToken.getTokenID().toString();
        SSOToken sSOToken2 = null;
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            sSOToken2 = SSOUtil.getSSOTokenNoDecode(string);
            sSOToken = null;
            if (sSOTokenManager.isValidToken(sSOToken2)) {
                sSOToken = sSOToken2;
            }
        }
        catch (Exception exception) {
            sSOToken = null;
        }
        return sSOToken;
    }

    public void setGatewaySessionID() {
        SSOToken sSOToken = Request.getToken(GWLogManager.appSession);
        if (sSOToken != null) {
            String string;
            this.gatewaySessionID = string = GWLogManager.appSession.getTokenID().toString();
        } else {
            Request.retryAddGatewaySessionId(this);
        }
    }
}

