/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.PimMeetingItemResponseType;
import com.aligo.pim.interfaces.PimAppointmentItem;
import com.aligo.pim.interfaces.PimMailMessageItem;
import com.aligo.pim.interfaces.PimMeetingItem;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.lotus.LotusPimAppointmentItem;
import com.aligo.pim.lotus.LotusPimCalendar;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimMailMessageItem;
import com.aligo.pim.lotus.LotusPimSession;
import com.aligo.pim.lotus.recycle.Recycle;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.RichTextStyle;
import lotus.domino.Session;
import lotus.domino.ViewEntry;

public class LotusPimMeetingItem
extends LotusPimMailMessageItem
implements PimMeetingItem {
    private LotusPimAppointmentItem m_oPimAppointmentItem;
    private LotusPimCalendar m_oPimCalendar;

    public LotusPimMeetingItem(ViewEntry viewEntry, LotusPimCalendar lotusPimCalendar, LotusPimSession lotusPimSession, Recycle recycle) {
        super(viewEntry, lotusPimSession, recycle);
        this.m_oPimCalendar = lotusPimCalendar;
    }

    public LotusPimMeetingItem(Document document, LotusPimCalendar lotusPimCalendar, LotusPimSession lotusPimSession, Recycle recycle) {
        super(document, lotusPimSession, recycle);
        this.m_oPimCalendar = lotusPimCalendar;
    }

    private LotusPimCalendar getLotusPimCalendar() {
        return this.m_oPimCalendar;
    }

    public PimMailMessageItem reply() throws LotusPimException {
        try {
            Document document = this.getLotusDocument().createReplyMessage(false);
            if (document == null) {
                return null;
            }
            this.getRecycle().add(document);
            LotusPimMeetingItem lotusPimMeetingItem = new LotusPimMeetingItem(document, this.getLotusPimCalendar(), this.getLotusPimSession(), this.getRecycle());
            return lotusPimMeetingItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimMailMessageItem replyAll() throws LotusPimException {
        try {
            Document document = this.getLotusDocument().createReplyMessage(true);
            if (document == null) {
                return null;
            }
            this.getRecycle().add(document);
            LotusPimMeetingItem lotusPimMeetingItem = new LotusPimMeetingItem(document, this.getLotusPimCalendar(), this.getLotusPimSession(), this.getRecycle());
            return lotusPimMeetingItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimMessageItem forward() throws LotusPimException {
        try {
            Document document = this.returnForwardDocument();
            if (document == null) {
                return null;
            }
            document.replaceItemValue("Subject", (Object)"FW: Meeting Item forwarded ");
            LotusPimMeetingItem lotusPimMeetingItem = new LotusPimMeetingItem(document, this.getLotusPimCalendar(), this.getLotusPimSession(), this.getRecycle());
            return lotusPimMeetingItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getName() throws LotusPimException {
        return "MeetingItem: " + this.getSubject();
    }

    public PimAppointmentItem getAssociatedAppointmentItem() throws LotusPimException {
        try {
            if (this.m_oPimAppointmentItem == null) {
                this.m_oPimAppointmentItem = new LotusPimAppointmentItem(this.getLotusDocument(), this.getLotusPimSession(), this.getRecycle());
            }
            return this.m_oPimAppointmentItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void respond(PimMeetingItemResponseType pimMeetingItemResponseType) throws LotusPimException {
        Recycle recycle = this.getRecycle();
        try {
            if (pimMeetingItemResponseType.equals(PimMeetingItemResponseType.ACCEPTED) || pimMeetingItemResponseType.equals(PimMeetingItemResponseType.TENTATIVE)) {
                Document document = this.getLotusDatabase().createDocument();
                recycle.add(document);
                this.getLotusDocument().copyAllItems(document, true);
                document.replaceItemValue("NoticeType", (Object)"A");
                document.replaceItemValue("_ViewIcon", (Object)new Integer(83));
                document.replaceItemValue("Subject", (Object)("Accepted: " + this.getLotusDocument().getItemValueString("Topic")));
                document.replaceItemValue("Principal", (Object)this.getLotusSession().getUserName());
                document.replaceItemValue("ExcludeFromView", (Object)"");
                document.replaceItemValue("AppointmentType", (Object)"3");
                document.replaceItemValue("From", (Object)this.getLotusSession().getUserName());
                document.replaceItemValue("SendTo", (Object)this.getLotusDocument().getItemValueString("Chair"));
                LotusPimMailMessageItem lotusPimMailMessageItem = new LotusPimMailMessageItem(document, this.getLotusPimSession(), this.getRecycle());
                lotusPimMailMessageItem.sendMeetingResponse();
                document = this.getLotusDocument();
                document.replaceItemValue("$BusyName", (Object)this.getLotusSession().getUserName());
                document.replaceItemValue("$BusyPriority", (Object)"1");
                lotusPimMailMessageItem = this.getLotusSession().createDateTime(new Date());
                document.replaceItemValue("$Revisions", (Object)lotusPimMailMessageItem);
                document.replaceItemValue("$UpdatedBy", (Object)this.getLotusSession().getUserName());
                Vector vector = document.getItemValue("StartDateTime");
                DateTime dateTime = null;
                if (!vector.isEmpty()) {
                    dateTime = (DateTime)vector.firstElement();
                }
                document.replaceItemValue("CalendarDateTime", (Object)dateTime);
                document.replaceItemValue("Form", (Object)"Appointment");
                document.replaceItemValue("NoticeType", (Object)"A");
                document.replaceItemValue("OrgTable", (Object)"CO");
                Vector<String> vector2 = new Vector<String>();
                vector2.add(document.getItemValueString("Chair"));
                vector2.addAll(document.getItemValue("SendTo"));
                vector2.addAll(document.getItemValue("CopyTo"));
                document.replaceItemValue("Participants", vector2);
                document.replaceItemValue("Subject", (Object)document.getItemValueString("Topic"));
                document.replaceItemValue("SMTPKeepNotesItems", (Object)"1");
                document.replaceItemValue("_ViewIcon", (Object)new Integer(158));
                String string = document.getItemValueString("OrgRepeat");
                if (string != null && string.equals("1")) {
                    document.replaceItemValue("$CSFlags", (Object)"c");
                    document.replaceItemValue("RepeatInstanceDates", (Object)document.getItemValue("RepeatDates"));
                }
                this.update();
                if (string != null && string.equals("1")) {
                    this.addChildDocumentToThisMeetingItem();
                }
            } else if (pimMeetingItemResponseType.equals(PimMeetingItemResponseType.DECLINED)) {
                Document document = this.getLotusDatabase().createDocument();
                recycle.add(document);
                this.getLotusDocument().copyAllItems(document, true);
                document.replaceItemValue("NoticeType", (Object)"R");
                document.replaceItemValue("_ViewIcon", (Object)new Integer(84));
                document.replaceItemValue("Subject", (Object)("Declined: " + this.getLotusDocument().getItemValueString("Topic")));
                document.replaceItemValue("Principal", (Object)this.getLotusSession().getUserName());
                document.replaceItemValue("ExcludeFromView", (Object)"");
                document.replaceItemValue("AppointmentType", (Object)"3");
                document.replaceItemValue("From", (Object)this.getLotusSession().getUserName());
                document.replaceItemValue("SendTo", (Object)this.getLotusDocument().getItemValueString("Chair"));
                LotusPimMailMessageItem lotusPimMailMessageItem = new LotusPimMailMessageItem(document, this.getLotusPimSession(), this.getRecycle());
                lotusPimMailMessageItem.sendMeetingResponse();
                document = this.getLotusDocument();
                document.replaceItemValue("NoticeType", (Object)"R");
                document.replaceItemValue("_ViewIcon", (Object)new Integer(84));
                document.replaceItemValue("Subject", (Object)("Declined: " + this.getLotusDocument().getItemValueString("Topic")));
                document.replaceItemValue("ExcludeFromView", (Object)"");
                document.replaceItemValue("AppointmentType", (Object)"3");
                document.replaceItemValue("From", (Object)this.getLotusDocument().getItemValueString("Chair"));
                this.update();
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private void addChildDocumentToThisMeetingItem() throws LotusPimException {
        try {
            Object object;
            Object object2;
            Recycle recycle = this.getRecycle();
            Document document = this.getLotusDatabase().createDocument();
            recycle.add(document);
            Document document2 = this.getLotusDocument();
            Session session = this.getLotusSession();
            document.replaceItemValue("SendTo", (Object)document2.getItemValue("SendTo"));
            document.replaceItemValue("CopyTo", (Object)document2.getItemValue("CopyTo"));
            document.replaceItemValue("BlindCopyTo", (Object)document2.getItemValue("BlindCopyTo"));
            document.replaceItemValue("OptionalAttendees", (Object)document2.getItemValue("OptionalAttendees"));
            document.replaceItemValue("AltFYINames", (Object)document2.getItemValue("AltFYINames"));
            document.replaceItemValue("AltOptionalNames", (Object)document2.getItemValue("AltOptionalNames"));
            document.replaceItemValue("AltRequiredNames", (Object)document2.getItemValue("AltRequiredNames"));
            document.replaceItemValue("AppointmentType", (Object)"3");
            document.replaceItemValue("FYIAttendees", (Object)document2.getItemValue("FYIAttendees"));
            document.replaceItemValue("INetFYINames", (Object)document2.getItemValue("INetFYINames"));
            document.replaceItemValue("INetOptionalNames", (Object)document2.getItemValue("INetOptionalNames"));
            document.replaceItemValue("INetRequiredNames", (Object)document2.getItemValue("INetRequiredNames"));
            document.replaceItemValue("Recipients", (Object)document2.getItemValue("Recipients"));
            document.replaceItemValue("RequiredAttendees", (Object)document2.getItemValue("RequiredAttendees"));
            document.replaceItemValue("_ViewIcon", (Object)new Integer(158));
            document.replaceItemValue("StorageFYINames", (Object)document2.getItemValue("StorageFYINames"));
            document.replaceItemValue("StorageOptionalNames", (Object)document2.getItemValue("StorageOptionalNames"));
            document.replaceItemValue("StorageRequiredNames", (Object)document2.getItemValue("StorageRequiredNames"));
            document.replaceItemValue("$PublicAccess", (Object)"1");
            document.replaceItemValue("Principal", (Object)session.getUserName());
            document.replaceItemValue("$AltPrincipal", (Object)session.getUserName());
            document.replaceItemValue("$LangPrincipal", (Object)"");
            document.replaceItemValue("Chair", (Object)session.getUserName());
            document.replaceItemValue("AltChair", (Object)session.getUserName());
            document.replaceItemValue("$LangChair", (Object)"");
            Vector<String> vector = new Vector<String>();
            vector.add("D");
            vector.add("S");
            document.replaceItemValue("ExcludeFromView", vector);
            document.replaceItemValue("SequenceNum", (Object)new Integer(1));
            document.replaceItemValue("$CSVersion", (Object)"2");
            document.replaceItemValue("MailFirstPass", (Object)"1");
            document.replaceItemValue("$SMTPKeepNotesItems", (Object)"1");
            document.replaceItemValue("WebDateTimeInit", (Object)"1");
            document.replaceItemValue("OrgTable", (Object)"CO");
            document.replaceItemValue("RepeatFromEnd", (Object)"");
            document.replaceItemValue("OrgRepeat", (Object)"1");
            document.replaceItemValue("$WebFlags", (Object)"J");
            document.replaceItemValue("Form", (Object)"Appointment");
            document.replaceItemValue("$ExpandGroups", (Object)"3");
            document.replaceItemValue("Logo", (Object)"stdNotesLtr0");
            document.replaceItemValue("SaveOptions", (Object)"");
            document.replaceItemValue("MailOptions", (Object)"0");
            document.replaceItemValue("Sign", (Object)"0");
            document.replaceItemValue("Encrypt", (Object)"0");
            document.replaceItemValue("From", (Object)session.getUserName());
            document.replaceItemValue("location", (Object)document2.getItemValue("location"));
            document.replaceItemValue("subject", (Object)document2.getItemValue("subject"));
            try {
                object2 = document.createRichTextItem("Body");
                object = this.getLotusSession().createRichTextStyle();
                object.setFontSize(9);
                object2.appendStyle((RichTextStyle)object);
                object2.appendText(document2.getItemValueString("Body"));
            }
            catch (Exception exception) {
                document.replaceItemValue("Body", (Object)document2.getItemValue("Body"));
            }
            document.replaceItemValue("AppointmentType", (Object)"3");
            document.replaceItemValue("Repeats", (Object)"1");
            document.replaceItemValue("StartDate", (Object)document2.getItemValue("StartDate"));
            document.replaceItemValue("StartTime", (Object)document2.getItemValue("StartTime"));
            document.replaceItemValue("EndDate", (Object)document2.getItemValue("EndDate"));
            document.replaceItemValue("EndTime", (Object)document2.getItemValue("EndTime"));
            document.replaceItemValue("_ViewIcon", (Object)new Integer(158));
            document.replaceItemValue("$RefOptions", (Object)"1");
            document.replaceItemValue("$CSFlags", (Object)"i");
            document.replaceItemValue("$BusyName", (Object)session.getUserName());
            document.replaceItemValue("$BusyPriority", (Object)"1");
            document.replaceItemValue("STARTDATETIME", (Object)document2.getItemValue("RepeatDates"));
            object2 = document2.getItemValue("RepeatDates");
            object = new Vector();
            Vector vector2 = document2.getItemValue("EndTime");
            if (vector2 != null && vector2.size() >= 1) {
                DateTime dateTime = (DateTime)vector2.elementAt(0);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(dateTime.toJavaDate());
                int n = calendar.get(10);
                int n2 = calendar.get(12);
                int n3 = calendar.get(13);
                int n4 = 0;
                while (n4 < ((Vector)object2).size()) {
                    Calendar calendar2 = Calendar.getInstance();
                    calendar2.setTime(((DateTime)((Vector)object2).elementAt(n4)).toJavaDate());
                    Calendar calendar3 = Calendar.getInstance();
                    calendar3.set(calendar2.get(1), calendar2.get(2), calendar2.get(5), n, n2, n3);
                    ((Vector)object).add(session.createDateTime(calendar3.getTime()));
                    ++n4;
                }
            }
            document.replaceItemValue("EndDateTime", object);
            document.replaceItemValue("CalendarDateTime", (Object)document2.getItemValue("RepeatDates"));
            document.replaceItemValue("RepeatInstanceDates", (Object)document2.getItemValue("RepeatDates"));
            document.replaceItemValue("$UpdatedBy", (Object)session.getUserName());
            document.makeResponse(document2);
            document.save(true, true);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void send() throws LotusPimException {
    }

    public void setSubject(String string) throws LotusPimException {
    }

    public void setBody(String string) throws LotusPimException {
    }
}

