/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.PimFilterOperandType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimFilter;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimSession;
import com.aligo.pim.lotus.recycle.Recycle;
import java.util.Vector;
import lotus.domino.ViewEntryCollection;

public abstract class LotusPimFilter
implements PimFilter {
    private LotusPimSession m_oPimSession;
    private Recycle m_oRecycle;
    private FilterCriteria m_oFilterCriteria = new FilterCriteria();

    public LotusPimFilter(LotusPimSession lotusPimSession, Recycle recycle) {
        this.m_oPimSession = lotusPimSession;
        this.m_oRecycle = recycle;
    }

    public LotusPimSession getLotusPimSession() {
        return this.m_oPimSession;
    }

    protected ViewEntryCollection getLotusViewEntryCollection() {
        return null;
    }

    public Recycle getRecycle() {
        return this.m_oRecycle;
    }

    protected FilterCriteria getFilterCriteria() {
        return this.m_oFilterCriteria;
    }

    protected void update() throws LotusPimException {
        try {
            this.getFilterCriteria().update();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setOperand(PimFilterOperandType pimFilterOperandType) throws LotusPimException {
        try {
            this.getFilterCriteria().add(pimFilterOperandType);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public abstract PimFieldItems getFieldItems() throws PimException;

    public class FilterCriteria {
        private Vector m_vFilterVector = new Vector();
        private boolean operandAdded = true;
        private boolean isUpdated = false;

        public void add(String string) {
            this.isUpdated = false;
            if (this.operandAdded) {
                this.m_vFilterVector.add(string);
                this.operandAdded = false;
            } else {
                this.add(PimFilterOperandType.AND);
                this.add(string);
            }
        }

        public void add(PimFilterOperandType pimFilterOperandType) {
            this.isUpdated = false;
            if (pimFilterOperandType.equals(PimFilterOperandType.OR)) {
                this.m_vFilterVector.add(" OR ");
            } else if (pimFilterOperandType.equals(PimFilterOperandType.AND)) {
                this.m_vFilterVector.add(" AND ");
            } else if (pimFilterOperandType.equals(PimFilterOperandType.OPEN)) {
                this.m_vFilterVector.add("(");
            } else if (pimFilterOperandType.equals(PimFilterOperandType.CLOSE)) {
                this.m_vFilterVector.add(")");
            }
            this.operandAdded = true;
        }

        public void update() throws Exception {
            if (this.isUpdated) {
                return;
            }
            if (this.m_vFilterVector != null && this.m_vFilterVector.size() > 0) {
                ViewEntryCollection viewEntryCollection = LotusPimFilter.this.getLotusViewEntryCollection();
                if (viewEntryCollection == null) {
                    return;
                }
                if (viewEntryCollection.getCount() == 0) {
                    return;
                }
                String string = new String();
                int n = 0;
                while (n < this.m_vFilterVector.size()) {
                    String string2 = (String)this.m_vFilterVector.elementAt(n);
                    string = string + string2;
                    ++n;
                }
                try {
                    viewEntryCollection.FTSearch(string);
                }
                catch (Exception exception) {
                    throw new LotusPimException(73L);
                }
                this.m_vFilterVector = new Vector();
                this.operandAdded = true;
                this.isUpdated = true;
            }
        }
    }
}

