/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.PimBusyStatusType;
import com.aligo.pim.PimCalendarType;
import com.aligo.pim.PimImportanceType;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimAppointmentItem;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimRecurrencePatternItem;
import com.aligo.pim.interfaces.PimReminderItem;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimExistingApptExistingReminderItem;
import com.aligo.pim.lotus.LotusPimExistingApptNewReminderItem;
import com.aligo.pim.lotus.LotusPimMeetingItem;
import com.aligo.pim.lotus.LotusPimMessageItem;
import com.aligo.pim.lotus.LotusPimRecipientItems;
import com.aligo.pim.lotus.LotusPimSession;
import com.aligo.pim.lotus.LotusPimUtility;
import com.aligo.pim.lotus.recycle.Recycle;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.RichTextItem;
import lotus.domino.RichTextStyle;
import lotus.domino.ViewEntry;
import lotus.domino.ViewEntryCollection;

public class LotusPimAppointmentItem
extends LotusPimMessageItem
implements PimAppointmentItem {
    public static final String APPOINTMENT_TYPE = "AppointmentType";
    public static final String START_DATE_TIME = "StartDateTime";
    public static final String END_DATE_TIME = "EndDateTime";
    public static final String LOCATION = "location";
    public static final String SUBJECT = "subject";
    public static final String BODY = "Body";
    public static final String END_DATE = "endDate";
    public static final String END_TIME = "endTime";
    public static final String CALENDAR_DATE_TIME = "CalendarDateTime";
    public static final String START_DATE = "StartDate";
    public static final String START_TIME = "StartTime";
    public static final String CHAIR = "Chair";
    public static final String FROM = "From";
    public static final String SEND_TO = "SendTo";
    public static final String FORM = "Form";
    public static final String APPOINTMENT = "Appointment";
    public static final String VIEWICON = "_ViewIcon";
    public static final String NOTICETYPE = "NoticeType";
    public static final String PRINCIPAL = "Principal";
    public static final String COPY_TO = "CopyTo";
    public static final String BLIND_COPY_TO = "BlindCopyTo";
    public static final String NOTICE = "Notice";
    public static final String TOPIC = "Topic";
    public static final String BUSY_NAME = "$BusyName";
    public static final String BUSY_PRIORITY = "$BusyPriority";
    public static final String CS_VERSION = "$CSVersion";
    public static final String EXPAND_GROUPS = "$ExpandGroups";
    public static final String NO_PURGE = "$NoPurge";
    public static final String PUBLIC_ACCESS = "$PublicAccess ";
    public static final String SMTP_KEEP_NOTES_ITEMS = "$SMTPKeepNotesItems";
    public static final String UPDATED_BY = "$UpdatedBy";
    public static final String WEB_FLAGS = "$WebFlags";
    public static final String APPT_ID = "ApptUNID";
    public static final String ENCRYPT = "Encrypt";
    public static final String EXCLUDE_FROM_VIEW = "ExcludeFromView";
    public static final String LOGO = "Logo";
    public static final String MAIL_FIRST_PASS = "MailFirstPass";
    public static final String SEQUENCE_NUM = "SequenceNum";
    public static final String SIGN = "Sign";
    public static final String TMP_OWNER_HW = "tmpOwnerHW";
    public static final String WEB_DATE_TIME_INIT = "WebDateTimeInit";
    public static final String OPTIONAL_ATTENDEES = "OptionalAttendees";
    public static final String ALT_FYI_NAMES = "AltFYINames";
    public static final String ALT_OPTIONAL_NAMES = "AltOptionalNames";
    public static final String ALT_REQ_NAMES = "AltRequiredNames";
    public static final String FYI_ATTENDEES = "FYIAttendees";
    public static final String INET_FYI_NAMES = "INetFYINames";
    public static final String INET_OPT_NAMES = "INetOptionalNames";
    public static final String INET_REQ_NAMES = "INetRequiredNames";
    public static final String RECIPIENTS = "Recipients";
    public static final String REQ_ATTENDEES = "RequiredAttendees";
    public static final String ORG_TABLE = "OrgTable";
    public static final String MAIL_OPTIONS = "MailOptions";
    public static final String STORAGE_CC = "$StorageCc";
    public static final String STORAGE_TO = "$StorageTo";
    public static final String ALT_COPY_TO = "AltCopyTo";
    public static final String ALT_SEND_TO = "AltSendTo";
    public static final String INET_COPY_TO = "InetCopyTo";
    public static final String INET_SEND_TO = "InetSendTo";
    public static final String STORAGE_OPT_NAMES = "StorageOptionalNames";
    public static final String STORAGE_REQ_NAMES = "StorageRequiredNames";
    public static final String STORAGE_FYI_NAMES = "StorageFYINames";
    private LotusPimMeetingItem m_oPimMeetingItem;
    private PimReminderItem m_oPimReminderItem;
    private PimCalendarType m_oPimCalendarType;
    private boolean m_bIsAllDayEvent;

    public LotusPimAppointmentItem(ViewEntry viewEntry, LotusPimSession lotusPimSession, Recycle recycle) {
        super(viewEntry, lotusPimSession, recycle);
    }

    public LotusPimAppointmentItem(ViewEntryCollection viewEntryCollection, LotusPimSession lotusPimSession, Recycle recycle) {
        super(viewEntryCollection, lotusPimSession, recycle);
    }

    public void setLotusAppointmentItem(ViewEntry viewEntry) {
        this.setLotusMessageItem(viewEntry);
    }

    public LotusPimAppointmentItem(Document document, LotusPimSession lotusPimSession, Recycle recycle) {
        super(document, lotusPimSession, recycle);
    }

    public PimRecurrencePatternItem getRecurrencePatternItem() throws LotusPimException {
        try {
            return null;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimCalendarType getType() throws LotusPimException {
        try {
            String string = this.getLotusDocument().getItemValueString(APPOINTMENT_TYPE);
            if (string == null) {
                return null;
            }
            if (string.equals("3")) {
                this.m_oPimCalendarType = PimCalendarType.MEETING;
                return PimCalendarType.MEETING;
            }
            if (string.equals("1")) {
                this.m_oPimCalendarType = PimCalendarType.ANNIVERSARY;
                return PimCalendarType.ANNIVERSARY;
            }
            this.m_oPimCalendarType = PimCalendarType.APPOINTMENT;
            return PimCalendarType.APPOINTMENT;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setType(PimCalendarType pimCalendarType) throws LotusPimException {
        try {
            if (pimCalendarType.equals(PimCalendarType.MEETING)) {
                this.getLotusDocument().replaceItemValue(APPOINTMENT_TYPE, (Object)"3");
                this.m_oPimCalendarType = pimCalendarType;
            } else {
                this.getLotusDocument().replaceItemValue(APPOINTMENT_TYPE, (Object)"0");
                this.m_oPimCalendarType = PimCalendarType.APPOINTMENT;
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public int getDuration() throws LotusPimException {
        try {
            if (this.isAllDayEvent()) {
                return 1440;
            }
            DateTime dateTime = this.getStartDateTime();
            DateTime dateTime2 = this.getEndDateTime();
            if (dateTime != null && dateTime2 != null) {
                int n = dateTime2.timeDifference(dateTime);
                return n / 60;
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return 0;
    }

    private DateTime getStartDateTime() throws LotusPimException {
        try {
            Vector vector;
            if (this.getLotusDocument().hasItem(START_DATE_TIME) && !(vector = this.getLotusDocument().getItemValue(START_DATE_TIME)).isEmpty()) {
                DateTime dateTime = (DateTime)vector.firstElement();
                return dateTime;
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return null;
    }

    private DateTime getEndDateTime() throws LotusPimException {
        try {
            Vector vector;
            if (this.getLotusDocument().hasItem(END_DATE_TIME) && !(vector = this.getLotusDocument().getItemValue(END_DATE_TIME)).isEmpty()) {
                DateTime dateTime = (DateTime)vector.firstElement();
                return dateTime;
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return null;
    }

    public Date getEndTime() throws LotusPimException {
        try {
            DateTime dateTime = this.getEndDateTime();
            if (dateTime != null) {
                return dateTime.toJavaDate();
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return null;
    }

    public PimImportanceType getImportance() throws LotusPimException {
        return PimImportanceType.NORMAL;
    }

    public String getLocation() throws LotusPimException {
        try {
            if (this.getLotusDocument().hasItem(LOCATION)) {
                return this.getLotusDocument().getItemValueString(LOCATION);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public PimAddressEntryItem getOrganizer() throws LotusPimException {
        try {
            if (this.getLotusDocument().hasItem(CHAIR)) {
                return LotusPimUtility.getAddressEntryItem(this.getLotusSession(), this.getLotusDocument().getItemValueString(CHAIR), this.getLotusPimSession(), this.getRecycle());
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return null;
    }

    public Date getStartTime() throws LotusPimException {
        try {
            DateTime dateTime = this.getStartDateTime();
            if (dateTime != null) {
                return dateTime.toJavaDate();
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return null;
    }

    public String getSubject() throws LotusPimException {
        try {
            if (this.getLotusDocument().hasItem(SUBJECT)) {
                return this.getLotusDocument().getItemValueString(SUBJECT);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public String getText() throws LotusPimException {
        try {
            if (this.getLotusDocument().hasItem(BODY)) {
                return this.getLotusDocument().getItemValueString(BODY);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public boolean isAllDayEvent() throws LotusPimException {
        try {
            String string = this.getLotusDocument().getItemValueString(APPOINTMENT_TYPE);
            if (string == null) {
                this.m_bIsAllDayEvent = false;
            }
            this.m_bIsAllDayEvent = string.equals("2");
            return this.m_bIsAllDayEvent;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAllDayEvent(boolean bl) throws LotusPimException {
        try {
            this.m_bIsAllDayEvent = bl;
            if (this.m_bIsAllDayEvent) {
                this.getLotusDocument().replaceItemValue(APPOINTMENT_TYPE, (Object)"2");
                this.getLotusDocument().replaceItemValue(APPOINTMENT_TYPE, (Object)"2");
                this.getLotusDocument().replaceItemValue(ORG_TABLE, (Object)"PO");
                this.getLotusDocument().replaceItemValue(VIEWICON, (Object)new Integer(9));
                this.setAllDayEventDates();
                return;
            }
            if (this.getType().equals(PimCalendarType.APPOINTMENT)) {
                this.getLotusDocument().replaceItemValue(APPOINTMENT_TYPE, (Object)"0");
                this.getLotusDocument().replaceItemValue(MAIL_OPTIONS, (Object)"0");
                this.getLotusDocument().replaceItemValue(ORG_TABLE, (Object)"CO");
                this.getLotusDocument().replaceItemValue(VIEWICON, (Object)new Integer(160));
                return;
            }
            if (!this.getType().equals(PimCalendarType.MEETING)) return;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setEndTime(Date date) throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            Recycle recycle = this.getRecycle();
            DateTime dateTime = this.getLotusSession().createDateTime(date);
            DateTime dateTime2 = this.getStartDateTime();
            if (dateTime2 == null || dateTime.timeDifference(dateTime2) < 0) {
                throw new LotusPimException(13L);
            }
            document.replaceItemValue(END_DATE, (Object)dateTime);
            document.replaceItemValue(END_TIME, (Object)dateTime);
            document.replaceItemValue(END_DATE_TIME, (Object)dateTime);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setImportance(PimImportanceType pimImportanceType) throws LotusPimException {
    }

    public void setBusyStatusType(PimBusyStatusType pimBusyStatusType) throws LotusPimException {
    }

    public void setLocation(String string) throws LotusPimException {
        try {
            this.getLotusDocument().replaceItemValue(LOCATION, (Object)string);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setStartTime(Date date) throws LotusPimException {
        try {
            Recycle recycle = this.getRecycle();
            Document document = this.getLotusDocument();
            DateTime dateTime = this.getLotusSession().createDateTime(date);
            document.replaceItemValue(CALENDAR_DATE_TIME, (Object)dateTime);
            document.replaceItemValue(START_DATE, (Object)dateTime);
            document.replaceItemValue(START_TIME, (Object)dateTime);
            document.replaceItemValue(START_DATE_TIME, (Object)dateTime);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setSubject(String string) throws LotusPimException {
        try {
            this.getLotusDocument().replaceItemValue(SUBJECT, (Object)string);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setText(String string) throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            document.removeItem(BODY);
            document.save(true);
            try {
                RichTextItem richTextItem = document.createRichTextItem(BODY);
                RichTextStyle richTextStyle = this.getLotusSession().createRichTextStyle();
                richTextStyle.setFontSize(9);
                richTextItem.appendStyle(richTextStyle);
                richTextItem.appendText(string);
            }
            catch (Exception exception) {
                this.getLotusDocument().replaceItemValue(BODY, (Object)string);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimMessageItem forward() throws LotusPimException {
        try {
            Document document = this.returnForwardDocument();
            if (document == null) {
                return null;
            }
            document.replaceItemValue("Subject", (Object)"FW: Appointment Item forwarded ");
            LotusPimAppointmentItem lotusPimAppointmentItem = new LotusPimAppointmentItem(document, this.getLotusPimSession(), this.getRecycle());
            return lotusPimAppointmentItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void send() throws LotusPimException {
        try {
            Recycle recycle = this.getRecycle();
            if (this.getLotusDocument().getItemValueInteger(VIEWICON) == 158 && this.getLotusDocument().getItemValueString(APPOINTMENT_TYPE).equals("3")) {
                Document document = this.getLotusDatabase().createDocument();
                recycle.add(document);
                this.getLotusDocument().copyAllItems(document, true);
                document.replaceItemValue(FORM, (Object)NOTICE);
                document.replaceItemValue(VIEWICON, (Object)new Integer(133));
                document.replaceItemValue(SUBJECT, (Object)("Invitation: " + this.getSubject() + " (" + this.getStartTime() + " in " + this.getLocation() + ")"));
                document.replaceItemValue(TOPIC, (Object)this.getSubject());
                document.replaceItemValue(NOTICETYPE, (Object)"I");
                document.replaceItemValue(APPT_ID, (Object)this.getID());
                document.replaceItemValue("$Orig", (Object)this.getID());
                LotusPimRecipientItems lotusPimRecipientItems = this.getLotusPimRecipientItems();
                if (lotusPimRecipientItems != null) {
                    document.replaceItemValue(SEND_TO, (Object)lotusPimRecipientItems.getSendToVector());
                    document.replaceItemValue(COPY_TO, (Object)lotusPimRecipientItems.getCopyToVector());
                    document.replaceItemValue(ALT_COPY_TO, (Object)lotusPimRecipientItems.getCopyToVector());
                    document.replaceItemValue(ALT_SEND_TO, (Object)lotusPimRecipientItems.getSendToVector());
                    document.replaceItemValue(INET_COPY_TO, (Object)lotusPimRecipientItems.getCopyToVector());
                    document.replaceItemValue(INET_SEND_TO, (Object)lotusPimRecipientItems.getSendToVector());
                }
                this.getLotusDocument().replaceItemValue(STORAGE_CC, (Object)this.getLotusDocument().getItemValue(STORAGE_OPT_NAMES));
                this.getLotusDocument().replaceItemValue(STORAGE_TO, (Object)this.getLotusDocument().getItemValue(STORAGE_REQ_NAMES));
                LotusPimAppointmentItem lotusPimAppointmentItem = new LotusPimAppointmentItem(document, this.getLotusPimSession(), this.getRecycle());
                lotusPimAppointmentItem.send();
                return;
            }
            super.send();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setChair(String string) throws LotusPimException {
        try {
            this.getLotusDocument().replaceItemValue(CHAIR, (Object)string);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setFrom(String string) throws LotusPimException {
        try {
            this.getLotusDocument().replaceItemValue(FROM, (Object)string);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setSendTo(String string) throws LotusPimException {
        try {
            this.getLotusDocument().replaceItemValue(SEND_TO, (Object)string);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void updateAsMeetingAccepted() throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            Recycle recycle = this.getRecycle();
            document.replaceItemValue(FORM, (Object)APPOINTMENT);
            document.replaceItemValue(APPOINTMENT_TYPE, (Object)"3");
            document.replaceItemValue(VIEWICON, (Object)new Integer(158));
            document.replaceItemValue(NOTICETYPE, (Object)"A");
            document.replaceItemValue(PRINCIPAL, (Object)this.getLotusSession().getUserName());
            super.update();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void sendMeetingRequest() throws LotusPimException {
    }

    public String getName() throws LotusPimException {
        try {
            return "Appointment: " + this.getSubject() + " in " + this.getLocation();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private boolean checkIfDateSpansOvernight() throws LotusPimException {
        Date date = this.getStartTime();
        Date date2 = this.getEndTime();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        int n = gregorianCalendar.get(2);
        int n2 = gregorianCalendar.get(5);
        int n3 = gregorianCalendar.get(1);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTime(date2);
        int n4 = gregorianCalendar2.get(2);
        int n5 = gregorianCalendar2.get(5);
        int n6 = gregorianCalendar2.get(1);
        return n != n4 || n2 != n5 || n3 != n6;
    }

    public void setAllDayEventDates() throws LotusPimException {
        Date date = this.getStartTime();
        Date date2 = this.getEndTime();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        int n = gregorianCalendar.get(2);
        int n2 = gregorianCalendar.get(5);
        int n3 = gregorianCalendar.get(1);
        Calendar calendar = Calendar.getInstance();
        calendar.set(n3, n, n2, 4, 0, 0);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTime(date2);
        int n4 = gregorianCalendar2.get(2);
        int n5 = gregorianCalendar2.get(5);
        int n6 = gregorianCalendar2.get(1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.set(n6, n4, n5, 20, 0, 0);
        this.setStartTime(calendar.getTime());
        this.setEndTime(calendar2.getTime());
    }

    public PimReminderItem getReminderItem() throws LotusPimException {
        try {
            if (this.m_oPimReminderItem == null) {
                String string = this.getLotusDocument().getItemValueString("Alarms");
                if (string != null && string.equals("1") && this.getLotusDocument().hasItem("$Alarm") && this.getLotusDocument().getItemValueInteger("$Alarm") == 1) {
                    this.m_oPimReminderItem = new LotusPimExistingApptExistingReminderItem(this.getLotusDocument(), this.getLotusPimSession(), this.getRecycle());
                } else {
                    return null;
                }
            }
            return this.m_oPimReminderItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimReminderItem addReminderItem() throws LotusPimException {
        try {
            this.m_oPimReminderItem = this.getReminderItem();
            if (this.m_oPimReminderItem == null) {
                this.m_oPimReminderItem = new LotusPimExistingApptNewReminderItem(this, this.getLotusPimSession(), this.getRecycle());
            }
            return this.m_oPimReminderItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void update() throws LotusPimException {
        Recycle recycle = this.getRecycle();
        try {
            if (this.isThisItemNew()) {
                if (this.m_oPimCalendarType == null) {
                    this.m_oPimCalendarType = PimCalendarType.APPOINTMENT;
                }
                Date date = this.getStartTime();
                Cloneable cloneable = this.getEndTime();
                if (date == null) {
                    date = new Date();
                    this.setStartTime(date);
                }
                if (cloneable == null) {
                    cloneable = date;
                    this.setEndTime((Date)cloneable);
                }
                if (this.getEndDateTime().timeDifference(this.getStartDateTime()) < 0) {
                    throw new LotusPimException(13L);
                }
                date = this.getLotusDocument();
                date.replaceItemValue(BUSY_NAME, this.getLotusSession().getUserName());
                date.replaceItemValue(BUSY_PRIORITY, "1");
                date.replaceItemValue(CS_VERSION, "2");
                date.replaceItemValue(EXPAND_GROUPS, "3");
                date.replaceItemValue(NO_PURGE, this.getStartDateTime());
                date.replaceItemValue(PUBLIC_ACCESS, "1");
                date.replaceItemValue(SMTP_KEEP_NOTES_ITEMS, "1");
                date.replaceItemValue(UPDATED_BY, this.getLotusSession().getUserName());
                date.replaceItemValue(WEB_FLAGS, "J");
                date.replaceItemValue(APPT_ID, this.getID());
                date.replaceItemValue(CHAIR, this.getLotusSession().getUserName());
                date.replaceItemValue(ENCRYPT, "0");
                cloneable = new Vector();
                ((Vector)cloneable).add("D");
                ((Vector)cloneable).add("S");
                date.replaceItemValue(EXCLUDE_FROM_VIEW, cloneable);
                date.replaceItemValue(ENCRYPT, "0");
                date.replaceItemValue(FORM, APPOINTMENT);
                date.replaceItemValue(FROM, this.getLotusSession().getUserName());
                date.replaceItemValue(LOGO, "stdNotesLtr0");
                date.replaceItemValue(MAIL_FIRST_PASS, "1");
                date.replaceItemValue(PRINCIPAL, this.getLotusSession().getUserName());
                date.replaceItemValue(SEQUENCE_NUM, "1");
                date.replaceItemValue(SIGN, "0");
                date.replaceItemValue(TMP_OWNER_HW, "1");
                date.replaceItemValue(WEB_DATE_TIME_INIT, "1");
                if (this.m_oPimCalendarType.equals(PimCalendarType.MEETING)) {
                    if (this.checkIfDateSpansOvernight()) {
                        throw new LotusPimException(54L);
                    }
                    if (this.m_bIsAllDayEvent) {
                        this.setAllDayEventDates();
                    }
                    LotusPimRecipientItems lotusPimRecipientItems = this.getLotusPimRecipientItems();
                    Vector vector = new Vector();
                    Vector vector2 = new Vector();
                    Vector vector3 = new Vector();
                    if (lotusPimRecipientItems != null) {
                        vector = lotusPimRecipientItems.getSendToVector();
                        vector2 = lotusPimRecipientItems.getCopyToVector();
                        vector3 = lotusPimRecipientItems.getBlindCopyToVector();
                        date.replaceItemValue(SEND_TO, vector);
                        date.replaceItemValue(COPY_TO, vector2);
                        date.replaceItemValue(BLIND_COPY_TO, vector3);
                    }
                    date.replaceItemValue(OPTIONAL_ATTENDEES, vector2);
                    date.replaceItemValue(ALT_FYI_NAMES, vector3);
                    date.replaceItemValue(ALT_OPTIONAL_NAMES, vector2);
                    date.replaceItemValue(ALT_REQ_NAMES, vector);
                    date.replaceItemValue(APPOINTMENT_TYPE, "3");
                    date.replaceItemValue(FYI_ATTENDEES, vector3);
                    date.replaceItemValue(INET_FYI_NAMES, vector3);
                    date.replaceItemValue(INET_OPT_NAMES, vector2);
                    date.replaceItemValue(INET_REQ_NAMES, vector);
                    Vector vector4 = new Vector();
                    vector4.addAll(vector);
                    vector4.addAll(vector2);
                    vector4.addAll(vector3);
                    date.replaceItemValue(RECIPIENTS, vector4);
                    date.replaceItemValue(REQ_ATTENDEES, vector);
                    date.replaceItemValue(VIEWICON, new Integer(158));
                    Vector<String> vector5 = new Vector<String>();
                    Vector<String> vector6 = new Vector<String>();
                    Vector<String> vector7 = new Vector<String>();
                    int n = 0;
                    while (n < vector.size()) {
                        vector5.add("1");
                        ++n;
                    }
                    int n2 = 0;
                    while (n2 < vector2.size()) {
                        vector6.add("1");
                        ++n2;
                    }
                    int n3 = 0;
                    while (n3 < vector3.size()) {
                        vector7.add("1");
                        ++n3;
                    }
                    date.replaceItemValue(STORAGE_FYI_NAMES, vector7);
                    date.replaceItemValue(STORAGE_OPT_NAMES, vector6);
                    date.replaceItemValue(STORAGE_REQ_NAMES, vector5);
                } else if (this.m_bIsAllDayEvent) {
                    date.replaceItemValue(APPOINTMENT_TYPE, "2");
                    date.replaceItemValue(ORG_TABLE, "PO");
                    date.replaceItemValue(VIEWICON, new Integer(9));
                    this.setAllDayEventDates();
                } else {
                    if (this.checkIfDateSpansOvernight()) {
                        throw new LotusPimException(54L);
                    }
                    date.replaceItemValue(APPOINTMENT_TYPE, "0");
                    date.replaceItemValue(MAIL_OPTIONS, "0");
                    date.replaceItemValue(ORG_TABLE, "CO");
                    date.replaceItemValue(VIEWICON, new Integer(160));
                }
            }
            super.update();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }
}

