/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.rom.js;

import com.sun.portal.rewriter.rom.Data;
import com.sun.portal.rewriter.rom.DataRule;
import com.sun.portal.rewriter.rom.js.Function;
import com.sun.portal.rewriter.rom.js.JSDataRule;
import com.sun.portal.rewriter.test.util.SampleRuleObjects;
import com.sun.portal.rewriter.util.Constants;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.re.Pattern;
import com.sun.portal.rewriter.util.xml.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class FunctionRule
extends JSDataRule {
    private final Function function;
    private final List argumentSpec;

    public FunctionRule(Function aFunction) {
        super(aFunction);
        this.function = aFunction;
        this.argumentSpec = FunctionRule.parseArgumentPatterns(this.function.getArgumentPatterns());
    }

    public FunctionRule(Node aNode) {
        this(new Function(aNode.getAttributeValue("name"), aNode.getAttributeValue("paramPatterns"), aNode.getAttributeValue("type"), aNode.getAttributeValue("source")));
    }

    public Function getFunction() {
        return this.function;
    }

    private Collection getParsedPatterns() {
        return this.argumentSpec;
    }

    private static List parseArgumentPatterns(String aParamPatterns) {
        if (aParamPatterns.length() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String[]> result = new ArrayList<String[]>();
        Pattern[] tempPatterns = DataRule.createValuePatternSpec(aParamPatterns);
        int i = 0;
        while (i < tempPatterns.length) {
            result.add(StringHelper.tokenize(tempPatterns[i].getInput(), ",", true));
            ++i;
        }
        return result;
    }

    public boolean plugableMatch(Data aMache) {
        if (!(aMache instanceof Function)) {
            return false;
        }
        Function valueObject = (Function)aMache;
        return this.matchCommon(valueObject);
    }

    public boolean isValid() {
        return DataRule.doBasicValidation(new String[]{this.function.getName(), this.function.getArgumentPatterns()});
    }

    public String[] getParamSpec(int aLength) {
        Object[] result = Constants.EMPTY_STRING_ARRAY;
        if (this.getParsedPatterns().size() > 0) {
            result = (String[])this.argumentSpec.get(0);
        }
        if (aLength > result.length) {
            Object[] temp = new String[aLength];
            Arrays.fill(temp, "");
            System.arraycopy(result, 0, temp, 0, result.length);
            result = temp;
        }
        return result;
    }

    public static void main(String[] args) {
        FunctionRule[] functions = SampleRuleObjects.defaultJSFunctions;
        int i = 0;
        while (i < functions.length) {
            Debug.println(functions[i].toXML());
            ++i;
        }
    }
}

