/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchange;

import com.aligo.messaging.exchange.AligoExchangeException;
import com.aligo.messaging.exchange.ExchangeField;
import com.aligo.messaging.exchange.ExchangeFields;
import com.aligo.messaging.exchange.ExchangeMessage;
import com.aligo.pim.PimTaskStatusType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchange.ExchangePimAttachmentItems;
import com.aligo.pim.exchange.ExchangePimException;
import com.aligo.pim.exchange.ExchangePimFieldItems;
import com.aligo.pim.exchange.ExchangePimMessageItem;
import com.aligo.pim.exchange.ExchangePimSession;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimRecipientItems;
import com.aligo.pim.interfaces.PimTaskItem;
import java.util.Calendar;
import java.util.Date;

public class ExchangePimTaskItem
extends ExchangePimMessageItem
implements PimTaskItem {
    private boolean m_bIsItNew;
    private ExchangePimAttachmentItems m_oPimAttachmentItems;
    private String m_szSubject = "";
    private String m_szText = "";
    private Date m_oStartDate;
    private Date m_oDueDate;
    private PimTaskStatusType m_oPimTaskStatusType = PimTaskStatusType.NOT_COMPLETE;

    public ExchangePimTaskItem(Object _oTaskItem, ExchangePimSession pimSession) {
        super(_oTaskItem, pimSession);
    }

    public ExchangePimTaskItem(Object _oTaskItem, ExchangePimSession pimSession, boolean isItNew) {
        super(_oTaskItem, pimSession);
        this.m_bIsItNew = isItNew;
    }

    public boolean isItOldTaskItem() {
        return !this.m_bIsItNew;
    }

    public void setExchangeTaskItem(Object _oTaskItem) {
        this.setExchangeMessage(_oTaskItem);
    }

    public ExchangeMessage getExchangeTaskItem() {
        return (ExchangeMessage)this.getMessageObject();
    }

    public PimFieldItems getFieldItems() throws ExchangePimException {
        try {
            ExchangeFields _oFields = this.getExchangeTaskItem().getFields();
            if (_oFields == null) {
                return null;
            }
            return new ExchangePimFieldItems(_oFields, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            return null;
        }
    }

    public String getID() throws ExchangePimException {
        try {
            if (this.isItOldTaskItem()) {
                return this.getExchangeTaskItem().getId();
            }
            return null;
        }
        catch (AligoExchangeException e) {
            return null;
        }
    }

    public void update() throws ExchangePimException {
        try {
            this.getExchangeTaskItem().setType("IPM.Task");
            this.getExchangeTaskItem().update();
            this.m_bIsItNew = false;
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void update(boolean makePermanent, boolean refreshObject) throws ExchangePimException {
        try {
            this.getExchangeTaskItem().setType("IPM.Task");
            this.getExchangeTaskItem().update(makePermanent, refreshObject);
            this.m_bIsItNew = false;
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void delete() throws ExchangePimException {
        try {
            if (this.isItOldTaskItem()) {
                this.getExchangeTaskItem().delete(true);
            }
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void delete(boolean flag) throws PimException {
        try {
            if (this.isItOldTaskItem()) {
                this.getExchangeTaskItem().delete(flag);
            }
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public ExchangeFields getOFields() throws ExchangePimException {
        try {
            return this.getExchangeTaskItem().getFields();
        }
        catch (AligoExchangeException e) {
            return null;
        }
    }

    public void setSubject(String subject) throws ExchangePimException {
        try {
            this.getExchangeTaskItem().setSubject(subject);
            this.m_szSubject = subject;
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getSubject() throws ExchangePimException {
        try {
            if (this.isItOldTaskItem()) {
                return this.getExchangeTaskItem().getSubject();
            }
            return this.m_szSubject;
        }
        catch (AligoExchangeException e) {
            return this.m_szSubject;
        }
    }

    public void setText(String text) throws ExchangePimException {
        try {
            this.getExchangeTaskItem().setText(text);
            this.m_szText = text;
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getText() throws ExchangePimException {
        try {
            if (this.isItOldTaskItem()) {
                return this.getExchangeTaskItem().getText();
            }
            return this.m_szText;
        }
        catch (AligoExchangeException e) {
            return this.m_szText;
        }
    }

    public void setStartDate(Date startDate) throws ExchangePimException {
        try {
            this.getOFields().add("0x8104", 7, startDate, "0320060000000000C000000000000046");
            this.getOFields().add("0x8516", 7, startDate, "0820060000000000C000000000000046");
            this.m_oStartDate = startDate;
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public Date getStartDate() throws ExchangePimException {
        try {
            if (this.isItOldTaskItem()) {
                ExchangeField startDateField = this.getOFields().getItem("0x8516", "0820060000000000C000000000000046");
                if (startDateField == null) {
                    startDateField = this.getOFields().getItem("0x8104", "0320060000000000C000000000000046");
                }
                return startDateField != null ? (Date)startDateField.getValue() : null;
            }
            return this.m_oStartDate;
        }
        catch (AligoExchangeException e) {
            return null;
        }
    }

    public void setDueDate(Date dueDate) throws ExchangePimException {
        try {
            this.getOFields().add("0x8105", 7, dueDate, "0320060000000000C000000000000046");
            this.getOFields().add("0x8517", 7, dueDate, "0820060000000000C000000000000046");
            this.m_oDueDate = dueDate;
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public Date getDueDate() throws ExchangePimException {
        try {
            if (this.isItOldTaskItem()) {
                ExchangeField dueDateField = this.getOFields().getItem("0x8517", "0820060000000000C000000000000046");
                if (dueDateField == null) {
                    dueDateField = this.getOFields().getItem("0x8105", "0320060000000000C000000000000046");
                }
                return dueDateField != null ? (Date)dueDateField.getValue() : null;
            }
            return this.m_oDueDate;
        }
        catch (AligoExchangeException e) {
            return this.m_oDueDate;
        }
    }

    public void send() throws ExchangePimException {
    }

    public PimMessageItem forward() throws ExchangePimException {
        return null;
    }

    public PimRecipientItems getRecipientItems() throws ExchangePimException {
        return null;
    }

    public String getName() throws ExchangePimException {
        try {
            return "Task Item: " + this.getSubject();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void setStatus(PimTaskStatusType pimTaskStatusType) throws PimException {
        try {
            if (pimTaskStatusType.equals(PimTaskStatusType.COMPLETE)) {
                if (this.getStatus().equals(PimTaskStatusType.NOT_COMPLETE)) {
                    this.getOFields().add("0x811C", 11, new Boolean(true), "0320060000000000C000000000000046");
                    this.getOFields().add("0x8102", 5, new Double(1.0), "0320060000000000C000000000000046");
                    this.getOFields().add("0x8101", 3, new Integer(2), "0320060000000000C000000000000046");
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(new Date());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    this.getOFields().add("0x810F", 7, cal.getTime(), "0320060000000000C000000000000046");
                }
            } else if (this.getStatus().equals(PimTaskStatusType.COMPLETE)) {
                this.getOFields().add("0x811C", 11, new Boolean(false), "0320060000000000C000000000000046");
                this.getOFields().add("0x8102", 5, new Double(0.0), "0320060000000000C000000000000046");
                this.getOFields().add("0x8101", 3, new Integer(0), "0320060000000000C000000000000046");
            }
            this.m_oPimTaskStatusType = pimTaskStatusType;
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public PimTaskStatusType getStatus() throws PimException {
        try {
            if (this.isItOldTaskItem()) {
                ExchangeField taskCompleteField = this.getOFields().getItem("0x811C", "0320060000000000C000000000000046");
                Boolean taskComplete = (Boolean)taskCompleteField.getValue();
                if (taskComplete.booleanValue()) {
                    return PimTaskStatusType.COMPLETE;
                }
                return PimTaskStatusType.NOT_COMPLETE;
            }
            return this.m_oPimTaskStatusType;
        }
        catch (Exception e) {
            return this.m_oPimTaskStatusType;
        }
    }
}

