/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchange;

import com.aligo.messaging.exchange.AligoExchangeException;
import com.aligo.messaging.exchange.ExchangeAppointmentItem;
import com.aligo.messaging.exchange.ExchangeFields;
import com.aligo.messaging.exchange.ExchangeRecipients;
import com.aligo.messaging.exchange.ExchangeRecurrencePattern;
import com.aligo.pim.PimBusyStatusType;
import com.aligo.pim.PimCalendarType;
import com.aligo.pim.PimImportanceType;
import com.aligo.pim.exchange.ExchangePimAddressEntryItem;
import com.aligo.pim.exchange.ExchangePimAttachmentItems;
import com.aligo.pim.exchange.ExchangePimException;
import com.aligo.pim.exchange.ExchangePimFieldItems;
import com.aligo.pim.exchange.ExchangePimImportanceTypeMapper;
import com.aligo.pim.exchange.ExchangePimMeetingRecipientItems;
import com.aligo.pim.exchange.ExchangePimMessageItem;
import com.aligo.pim.exchange.ExchangePimRecurrencePatternItem;
import com.aligo.pim.exchange.ExchangePimReminderItem;
import com.aligo.pim.exchange.ExchangePimSession;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimAppointmentItem;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimRecipientItems;
import com.aligo.pim.interfaces.PimRecurrencePatternItem;
import com.aligo.pim.interfaces.PimReminderItem;
import java.util.Date;

public class ExchangePimAppointmentItem
extends ExchangePimMessageItem
implements PimAppointmentItem {
    private ExchangePimAddressEntryItem m_oPimAddressEntryItem;
    private ExchangePimMeetingRecipientItems m_oPimRecipientItems;
    private ExchangePimAttachmentItems m_oPimAttachmentItems;
    private ExchangePimReminderItem m_oPimReminderItem;
    private PimCalendarType pimCalendarType = PimCalendarType.APPOINTMENT;
    private ExchangePimRecurrencePatternItem m_oPimRecurrencePatternItem;
    private boolean m_bAllDayEvent = false;
    private boolean m_bIsItNewAppointmentItem = false;
    private String m_szSubject = "";
    private PimImportanceType m_oImportanceType = PimImportanceType.NORMAL;
    private String m_szLocation = "";
    private String m_szText = "";
    public Date m_oStartTime;
    public Date m_oEndTime;

    public ExchangePimAppointmentItem(Object _oAppointmentItem, ExchangePimSession pimSession) {
        super(_oAppointmentItem, pimSession);
    }

    public ExchangePimAppointmentItem(Object _oAppointmentItem, boolean isItNew, ExchangePimSession pimSession) {
        super(_oAppointmentItem, pimSession);
        this.m_bIsItNewAppointmentItem = isItNew;
    }

    public void setExchangeAppointmentItem(Object _oAppointmentItem) {
        this.setExchangeMessage(_oAppointmentItem);
    }

    public ExchangeAppointmentItem getExchangeAppointmentItem() {
        return (ExchangeAppointmentItem)this.getMessageObject();
    }

    public PimReminderItem getReminderItem() throws ExchangePimException {
        try {
            if (this.m_oPimReminderItem == null) {
                if (!this.getExchangeAppointmentItem().isReminderSet()) {
                    return null;
                }
                this.m_oPimReminderItem = new ExchangePimReminderItem(this, this.getPimSession());
            }
            return this.m_oPimReminderItem;
        }
        catch (AligoExchangeException e) {
            return null;
        }
    }

    public PimReminderItem addReminderItem() throws ExchangePimException {
        try {
            if (this.m_oPimReminderItem == null) {
                this.m_oPimReminderItem = new ExchangePimReminderItem(this, this.getPimSession());
            }
            return this.m_oPimReminderItem;
        }
        catch (Exception e) {
            return null;
        }
    }

    public PimFieldItems getFieldItems() throws ExchangePimException {
        try {
            ExchangeFields _oFields = this.getExchangeAppointmentItem().getFields();
            if (_oFields == null) {
                return null;
            }
            return new ExchangePimFieldItems(_oFields, this.getPimSession());
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getClassType() throws ExchangePimException {
        try {
            return this.getExchangeAppointmentItem().getClassType();
        }
        catch (AligoExchangeException e) {
            return -1;
        }
    }

    public ExchangePimRecurrencePatternItem getActualRecurrencePatternItem() throws ExchangePimException {
        try {
            if (this.m_oPimRecurrencePatternItem == null) {
                ExchangeRecurrencePattern exchangeRecurrencePattern = this.getExchangeAppointmentItem().getRecurrencePattern();
                if (exchangeRecurrencePattern == null) {
                    return null;
                }
                this.m_oPimRecurrencePatternItem = new ExchangePimRecurrencePatternItem(exchangeRecurrencePattern, this, this.getPimSession());
            }
            return this.m_oPimRecurrencePatternItem;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isItOldAppointmentItem() {
        return !this.m_bIsItNewAppointmentItem;
    }

    public PimRecurrencePatternItem getRecurrencePatternItem() throws ExchangePimException {
        try {
            if (this.isItOldAppointmentItem()) {
                if (this.getExchangeAppointmentItem().isRecurring()) {
                    return this.getActualRecurrencePatternItem();
                }
                return null;
            }
            return this.getActualRecurrencePatternItem();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getSubject() throws ExchangePimException {
        try {
            if (this.isItOldAppointmentItem()) {
                return this.getExchangeAppointmentItem().getSubject();
            }
            return this.m_szSubject;
        }
        catch (AligoExchangeException e) {
            return "";
        }
    }

    public String getID() throws ExchangePimException {
        try {
            if (this.isItOldAppointmentItem()) {
                return this.getExchangeAppointmentItem().getId();
            }
            return null;
        }
        catch (AligoExchangeException e) {
            return null;
        }
    }

    public PimImportanceType getImportance() throws ExchangePimException {
        try {
            if (this.isItOldAppointmentItem()) {
                int importance = this.getExchangeAppointmentItem().getImportance();
                switch (importance) {
                    case 0: {
                        return PimImportanceType.LOW;
                    }
                    case 1: {
                        return PimImportanceType.NORMAL;
                    }
                    case 2: {
                        return PimImportanceType.HIGH;
                    }
                }
                return PimImportanceType.NORMAL;
            }
            return this.m_oImportanceType;
        }
        catch (AligoExchangeException e) {
            return PimImportanceType.NORMAL;
        }
    }

    public PimAddressEntryItem getSender() throws ExchangePimException {
        try {
            if (this.m_oPimAddressEntryItem == null) {
                this.m_oPimAddressEntryItem = new ExchangePimAddressEntryItem(this.getExchangeAppointmentItem().getOrganizer(), this.getPimSession());
            } else {
                this.m_oPimAddressEntryItem.setExchangeAddressEntry(this.getExchangeAppointmentItem().getOrganizer());
            }
            return this.m_oPimAddressEntryItem;
        }
        catch (AligoExchangeException e) {
            return this.getPimSession().getCurrentUser();
        }
    }

    public int getDuration() throws ExchangePimException {
        try {
            return this.getExchangeAppointmentItem().getDuration();
        }
        catch (AligoExchangeException e) {
            return -1;
        }
    }

    public String getLocation() throws ExchangePimException {
        try {
            if (this.isItOldAppointmentItem()) {
                return this.getExchangeAppointmentItem().getLocation();
            }
            return this.m_szLocation;
        }
        catch (AligoExchangeException e) {
            return "";
        }
    }

    public String getText() throws ExchangePimException {
        try {
            if (this.isItOldAppointmentItem()) {
                return this.getExchangeAppointmentItem().getText();
            }
            return this.m_szText;
        }
        catch (AligoExchangeException e) {
            return "";
        }
    }

    public Date getStartTime() throws ExchangePimException {
        try {
            if (this.isItOldAppointmentItem()) {
                return this.getExchangeAppointmentItem().getStartTime();
            }
            return this.m_oStartTime;
        }
        catch (AligoExchangeException e) {
            return this.m_oStartTime;
        }
    }

    public Date getEndTime() throws ExchangePimException {
        try {
            if (this.isItOldAppointmentItem()) {
                return this.getExchangeAppointmentItem().getEndTime();
            }
            return this.m_oEndTime;
        }
        catch (AligoExchangeException e) {
            return this.m_oEndTime;
        }
    }

    public boolean isAllDayEvent() throws ExchangePimException {
        try {
            if (this.isItOldAppointmentItem()) {
                return this.getExchangeAppointmentItem().getAllDayEvent();
            }
            return this.m_bAllDayEvent;
        }
        catch (AligoExchangeException e) {
            return this.m_bAllDayEvent;
        }
    }

    public void setSubject(String subject) throws ExchangePimException {
        try {
            this.getExchangeAppointmentItem().setSubject(subject);
            this.m_szSubject = subject;
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void setBusyStatusType(PimBusyStatusType pimBusyStatusType) throws ExchangePimException {
    }

    public void setLocation(String location) throws ExchangePimException {
        try {
            this.getExchangeAppointmentItem().setLocation(location);
            this.m_szLocation = location;
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void setImportance(PimImportanceType importance) throws ExchangePimException {
        try {
            this.getExchangeAppointmentItem().setImportance(ExchangePimImportanceTypeMapper.getType(importance));
            this.m_oImportanceType = importance;
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void setText(String text) throws ExchangePimException {
        try {
            this.getExchangeAppointmentItem().setText(text);
            this.m_szText = text;
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void setStartTime(Date date) throws ExchangePimException {
        try {
            this.m_oStartTime = date;
            this.getExchangeAppointmentItem().setStartTime(date);
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void setEndTime(Date date) throws ExchangePimException {
        try {
            this.m_oEndTime = date;
            this.getExchangeAppointmentItem().setEndTime(date);
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void delete(boolean flag) throws ExchangePimException {
        try {
            if (this.isItOldAppointmentItem()) {
                this.getExchangeAppointmentItem().delete(flag);
            }
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void delete() throws ExchangePimException {
        try {
            if (this.isItOldAppointmentItem()) {
                this.getExchangeAppointmentItem().delete(true);
            }
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimAddressEntryItem getOrganizer() throws ExchangePimException {
        return this.getSender();
    }

    public void setMeetingStatus(int meetingStatus) throws ExchangePimException {
        try {
            this.getExchangeAppointmentItem().setMeetingStatus(meetingStatus);
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void setAllDayEvent(boolean isAllDayEvent) throws ExchangePimException {
        try {
            this.m_bAllDayEvent = isAllDayEvent;
            this.getExchangeAppointmentItem().setAllDayEvent(isAllDayEvent);
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public boolean isSetAllDayEvent() {
        return this.m_bAllDayEvent;
    }

    public void update() throws ExchangePimException {
        try {
            if (!this.isItOldAppointmentItem() && this.m_oPimRecurrencePatternItem != null && !this.m_oPimRecurrencePatternItem.isItRecurringItem()) {
                this.getExchangeAppointmentItem().clearRecurrencePattern();
            }
            this.update(true, false);
            this.m_bIsItNewAppointmentItem = false;
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void update(boolean makeItPermanent, boolean refreshObject) throws ExchangePimException {
        try {
            this.getExchangeAppointmentItem().update(makeItPermanent, refreshObject);
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimRecipientItems getRecipientItems() throws ExchangePimException {
        try {
            ExchangeRecipients _oRecipients = this.getExchangeAppointmentItem().getRecipients();
            if (_oRecipients == null) {
                return null;
            }
            if (this.m_oPimRecipientItems == null) {
                this.m_oPimRecipientItems = new ExchangePimMeetingRecipientItems(_oRecipients, this.getPimSession());
            } else {
                this.m_oPimRecipientItems.setExchangeRecipients(_oRecipients);
            }
            return this.m_oPimRecipientItems;
        }
        catch (AligoExchangeException e) {
            return null;
        }
    }

    public void send() throws ExchangePimException {
        try {
            if (this.pimCalendarType.equals(PimCalendarType.MEETING)) {
                ExchangeAppointmentItem appointment = this.getExchangeAppointmentItem();
                appointment.setMeetingStatus(1);
                appointment.send();
            }
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void setType(PimCalendarType pimCalendarType) throws ExchangePimException {
        this.pimCalendarType = pimCalendarType;
    }

    public PimCalendarType getType() throws ExchangePimException {
        return this.pimCalendarType;
    }

    public PimMessageItem forward() throws ExchangePimException {
        return null;
    }

    public String getName() throws ExchangePimException {
        return "Appointment: " + this.getSubject() + " in " + this.getLocation();
    }
}

