/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.ab;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.portal.providers.ProviderEditUtility;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.ab.AddressBookApplicationHelper;
import com.sun.portal.providers.ab.AddressBookProvider;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.SSOAdapterDebug;
import com.sun.ssoadapter.SSOAdapterException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LDAPABApplicationHelper
implements AddressBookApplicationHelper {
    public AddressBookProvider provider = null;
    protected String containerName = "";
    public SSOAdapter ssoAdapter = null;
    private MsgExpURL meUrl = null;
    protected String appName = "";
    protected ProviderContext provContext = null;
    public Properties adapterProperties = null;
    private URL ldapABURL = null;
    private long checkInterval;
    private long lastCheckTime = 0L;
    private static String LDAP_DEFAULT_PORT = "389";
    private static String IMAP_DEFAULT_PORT = "143";
    private static String CLIENT_DEFAULT_PORT = "80";
    private static String CLIENT_DEFAULT_PROTOCOL = "http";
    private static final int JSP_URL = 0;
    private static final int SUN_ONE_URL = 1;
    private int urlType = -1;
    private int configIndex = -1;

    public void init(AddressBookProvider provider, SSOAdapter ssoAdapter) throws Exception {
        this.provider = provider;
        this.ssoAdapter = ssoAdapter;
        if (ssoAdapter != null) {
            this.adapterProperties = ssoAdapter.getProperties();
        }
        this.checkInterval = Integer.parseInt(this.adapterProperties.getProperty("checkInterval", "5000"));
        this.provContext = provider.getProviderContext();
    }

    public String getStartURL(AddressBookProvider provider, HttpServletRequest request) {
        String url = null;
        try {
            url = this.getApplicationURL(provider, request);
            ProviderContext pc = provider.getProviderContext();
            url = pc.escape(url);
        }
        catch (Exception me) {
            SSOAdapterDebug.logWarning((String)(this.getClass().getName() + ".getStartURL(): could not determine start url "), (Throwable)me);
        }
        return url;
    }

    public String getApplicationURL(AddressBookProvider provider, HttpServletRequest request) throws Exception {
        ProviderContext pc = provider.getProviderContext();
        String clientURL = null;
        String clientProtocol = this.adapterProperties.getProperty("clientProtocol", "http");
        String clientPort = this.adapterProperties.getProperty("clientPort", this.adapterProperties.getProperty("port", "80"));
        String host = this.adapterProperties.getProperty("host");
        String baseURL = clientProtocol + "://" + host + ":" + clientPort;
        SSOToken tok = this.ssoAdapter.getSSOToken();
        if (tok != null) {
            String enableProxyAuth = this.adapterProperties.getProperty("enableProxyAuth");
            String uid = null;
            String password = null;
            String domain = this.adapterProperties.getProperty("domain");
            if (enableProxyAuth != null && enableProxyAuth.equals("true")) {
                uid = this.adapterProperties.getProperty("proxyAdminUid");
                password = this.adapterProperties.getProperty("proxyAdminPassword");
            } else {
                uid = this.adapterProperties.getProperty("uid");
                password = this.adapterProperties.getProperty("password");
            }
            if (pc.isDebugMessageEnabled()) {
                if (uid != null) {
                    pc.debugMessage((Object)("LDAPApplicationHelper.getApplicationURL(): uid=" + uid));
                }
                if (domain != null) {
                    pc.debugMessage((Object)("LDAPApplicationHelper.getApplicationURL(): domain=" + domain));
                }
                if (baseURL != null) {
                    pc.debugMessage((Object)("LDAPApplicationHelper.getApplicationURL(): baseURL=" + baseURL));
                }
            }
            clientURL = this.getWebmailURL(uid, password, domain, baseURL);
        } else {
            clientURL = baseURL;
        }
        return clientURL;
    }

    private String getWebmailURL(String user, String pass, String domain, String baseUrl) {
        if (baseUrl != null && !baseUrl.equals("") && baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        MsgExpURL newMEUrl = new MsgExpURL(user, pass, baseUrl);
        boolean urlValid = false;
        if (this.meUrl != null && this.meUrl.equals(newMEUrl) && this.isValidSession(this.meUrl)) {
            urlValid = true;
            newMEUrl = this.meUrl;
            SSOAdapterDebug.logMessage((String)"LDAPABSSOAdapter.getWebMailURL(): returning previously generated SSO URL ");
        }
        if (!urlValid) {
            String urlstr = baseUrl + "/login.msc?user=" + URLEncoder.encode(user) + "&password=" + URLEncoder.encode(pass);
            String enableProxyAuth = this.adapterProperties.getProperty("enableProxyAuth");
            if (enableProxyAuth != null && enableProxyAuth.equals("true")) {
                SSOToken tok = null;
                try {
                    tok = this.ssoAdapter.getSSOToken();
                }
                catch (SSOAdapterException ssoae) {
                    tok = null;
                }
                if (tok != null) {
                    AMStoreConnection amsc = null;
                    AMUser auser = null;
                    String puid = null;
                    String usrAttr = this.adapterProperties.getProperty("userAttribute", "uid");
                    try {
                        amsc = new AMStoreConnection(tok);
                        auser = amsc.getUser(tok.getPrincipal().getName());
                        puid = auser.getStringAttribute(usrAttr);
                    }
                    catch (SSOException ssoe) {
                        SSOAdapterDebug.logError((String)(this.getClass().getName() + "getWebmailURL(): proxy uid retrieval failed "), (Throwable)ssoe);
                    }
                    catch (AMException ame) {
                        SSOAdapterDebug.logError((String)(this.getClass().getName() + "getWebmailURL(): proxy uid retrieval failed "), (Throwable)ame);
                    }
                    if (puid != null && puid.length() > 0) {
                        if (domain != null) {
                            puid = puid + "@" + domain;
                        }
                        urlstr = urlstr + "&proxyauth=" + URLEncoder.encode(puid);
                    }
                }
            } else if (domain != null && !domain.equals("")) {
                String fqUser = user + "@" + domain;
                urlstr = baseUrl + "/login.msc?user=" + URLEncoder.encode(fqUser) + "&password=" + URLEncoder.encode(pass);
            } else {
                urlstr = baseUrl + "/login.msc?user=" + URLEncoder.encode(user) + "&password=" + URLEncoder.encode(pass);
                this.provContext.debugMessage((Object)"LDAPABApplicationHelper.getWebmailURL:  domain not set");
            }
            String authUrl = this.getRelativeSsoUrl(urlstr, newMEUrl);
            this.provContext.debugMessage((Object)("LDAPABApplicationHelper.getWebmailURL(): authUrl=" + authUrl));
            if (authUrl != null) {
                newMEUrl.setSsoUri(baseUrl + authUrl);
            } else {
                newMEUrl = null;
                this.provContext.debugMessage((Object)"LDAPABApplicationHelper.getWebmailURL(): Returning NULL single signon uri");
                return null;
            }
        }
        this.meUrl = newMEUrl;
        String mailSessId = null;
        if (newMEUrl != null) {
            mailSessId = newMEUrl.getWebmailSessionId();
            this.provContext.debugMessage((Object)("LDAPABSSOAdapter.getWebmailURL(): mailSessId=" + mailSessId));
        }
        if (mailSessId == null) {
            mailSessId = "";
        }
        if (newMEUrl != null) {
            String test = newMEUrl.getSsoUri();
            this.provContext.debugMessage((Object)("LDAPABSSOAdapter.getWebmailURL(): test=" + test));
            return newMEUrl.getSsoUri();
        }
        return baseUrl;
    }

    private String getRelativeSsoUrl(String urlstr, MsgExpURL meURL) {
        String authUrl = null;
        HttpURLConnection urlconn = null;
        try {
            URL url = new URL(urlstr);
            HttpURLConnection.setFollowRedirects(false);
            urlconn = (HttpURLConnection)url.openConnection();
        }
        catch (MalformedURLException mfe) {
            SSOAdapterDebug.logError((String)("LDAPABSSOAdapter.getRelativeSsoUrl(): Malformed URL: base clientURL = " + meURL.getBaseUri()));
            return null;
        }
        catch (IOException ioe) {
            SSOAdapterDebug.logError((String)"LDAPABSSOAdapter.getRelativeSsoUrl(): Error making url connection ", (Throwable)ioe);
            return null;
        }
        String location = urlconn.getHeaderField("Location");
        int sessionIdBegin = 0;
        sessionIdBegin = location.indexOf("sid");
        if (sessionIdBegin < 0) {
            SSOAdapterDebug.logMessage((String)"LDAPABSSOAdapter.getRelativeSsoUrl(): Cannot find session id in response. Cannot Authenticate!");
            meURL.setWebmailSessionId(null);
            authUrl = null;
        } else {
            String inter = location.substring(sessionIdBegin + 4);
            int sessionIdEnd = inter.indexOf("&");
            String mailSessionId = inter.substring(0, sessionIdEnd);
            meURL.setWebmailSessionId(mailSessionId);
            authUrl = location.charAt(0) != '/' ? "/" + location : location;
        }
        return authUrl;
    }

    private boolean isValidSession(MsgExpURL meURL) {
        Date newCheckDate = new Date();
        long newCheckTime = newCheckDate.getTime();
        long timeSinceLastCheck = newCheckTime - this.lastCheckTime;
        if (timeSinceLastCheck < this.checkInterval) {
            return true;
        }
        this.lastCheckTime = newCheckTime;
        String webmailSessionId = meURL.getWebmailSessionId();
        if (webmailSessionId == null) {
            SSOAdapterDebug.logMessage((String)"LDAPABSSOAdapter.isValidSession():SessionId is null! Generating new URL");
            return false;
        }
        String pageContent = "";
        String urlstr = meURL.baseUri + "/mbox.msc?sid=" + webmailSessionId + "&security=false&mbox=INBOX&start=0&count=20&date=false";
        HttpURLConnection urlconn = null;
        try {
            URL url = new URL(urlstr);
            urlconn = (HttpURLConnection)url.openConnection();
            HttpURLConnection.setFollowRedirects(false);
        }
        catch (IOException ioe) {
            SSOAdapterDebug.logError((String)"LDAPABSSOAdapter.isValidSession(): error making url connection", (Throwable)ioe);
            pageContent = null;
            meURL.setWebmailSessionId(null);
            return false;
        }
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(urlconn.getInputStream()));
            String inputLine = null;
            while ((inputLine = in.readLine()) != null) {
                pageContent = pageContent + inputLine;
            }
            in.close();
        }
        catch (Exception e) {
            SSOAdapterDebug.logError((String)"LDAPABSSOAdapter.isValidSession(): Exception while checking session validity!", (Throwable)e);
            e.printStackTrace();
            pageContent = null;
            meURL.setWebmailSessionId(null);
            return false;
        }
        if (pageContent.indexOf("parent.timeoutCB()") > 0) {
            SSOAdapterDebug.logMessage((String)"LDAPABSSOAdapter.isValidSession(): Messenger Express session timed out.");
            pageContent = null;
            meURL.setWebmailSessionId(null);
            return false;
        }
        return true;
    }

    public void error(ProviderContext pc, String msg) {
        if (pc.isDebugErrorEnabled()) {
            pc.debugError((Object)msg);
        }
    }

    public void warning(ProviderContext pc, String msg) {
        if (pc.isDebugWarningEnabled()) {
            pc.debugWarning((Object)msg);
        }
    }

    public void message(ProviderContext pc, String msg) {
        if (pc.isDebugMessageEnabled()) {
            pc.debugMessage((Object)msg);
        }
    }

    public void error(ProviderContext pc, String msg, Throwable t) {
        if (pc.isDebugErrorEnabled()) {
            pc.debugError((Object)msg, t);
        }
    }

    public void warning(ProviderContext pc, String msg, Throwable t) {
        if (pc.isDebugWarningEnabled()) {
            pc.debugWarning((Object)msg, t);
        }
    }

    public void message(ProviderContext pc, String msg, Throwable t) {
        if (pc.isDebugMessageEnabled()) {
            pc.debugMessage((Object)msg, t);
        }
    }

    protected boolean isEmpty(String line) {
        return line == null || line.equals("");
    }

    protected URL getAppHelperProcessURL(HttpServletRequest req, AddressBookProvider prov) {
        ProviderContext pc = prov.getProviderContext();
        StringBuffer link = new StringBuffer();
        URL returnURL = null;
        try {
            link.append(pc.getDesktopURL(req));
        }
        catch (Exception e) {
            return null;
        }
        String provider = prov.editContainer;
        String targetProvider = prov.targetProvider;
        String containerName = prov.containerName;
        pc.debugMessage((Object)("CalendarExpressHelper.getAppHelperProcessURL():     provider=" + provider + "\n                                                    targetProvider=" + targetProvider + "\n                                                    containerName=" + containerName));
        if (this.isEmpty(provider) || this.isEmpty(targetProvider) || this.isEmpty(containerName)) {
            pc.debugWarning((Object)"getAppHelperProcessURL():  Missing returnURL parameter and attempting to generate default desktop URL\n");
            try {
                returnURL = new URL(link.toString());
            }
            catch (Exception e) {
                pc.debugWarning((Object)"getAppHelperProcessURL():  Unable to generate default desktop URL\n", (Throwable)e);
                return null;
            }
        }
        link.append("?action=edit&provider=" + provider);
        link.append("&targetprovider=" + targetProvider);
        link.append("&containerName=" + containerName);
        try {
            returnURL = new URL(link.toString());
            pc.debugMessage((Object)("CalendarExpressHelper:getAppHelperProcessURL():  returnURL =" + returnURL));
        }
        catch (Exception e) {
            pc.debugError((Object)"Unable to create returnURL", (Throwable)e);
            return null;
        }
        return returnURL;
    }

    public String getAppHelperEditLink(HttpServletRequest req, ProviderContext pc) {
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        StringBuffer link = new StringBuffer();
        try {
            link.append(pc.getDesktopURL(req));
        }
        catch (Exception e) {
            return "";
        }
        link.append("?action=edit&provider=");
        link.append(this.getRequestParameter("provider", req));
        link.append("&targetprovider=" + this.provider.getName());
        link.append("&containerName=");
        link.append(this.getRequestParameter("containerName", req));
        link.append("&appPref=" + this.getName());
        tagTable.put("editLink", link.toString());
        String content = null;
        try {
            String fontTag = pc.getStringProperty(this.provider.getName(), "fontFace1", "Sans-serif");
            tagTable.put("iwtDesktop-fontFace1", fontTag);
            content = pc.getTemplate(this.provider.getName(), "edit-link.template", tagTable).toString();
            pc.debugMessage((Object)("content = \n" + content.toString()));
        }
        catch (Exception e) {
            pc.debugError((Object)"unable to create hyperlink\n", (Throwable)e);
            content = "";
        }
        pc.debugMessage((Object)("LDAPABApplicationHelper: returned value is" + content.toString()));
        return content;
    }

    public void setName(String name) {
        this.appName = name;
    }

    public String getName() {
        return this.appName;
    }

    public StringBuffer getAppPrefsEdit(AddressBookProvider aprov, HttpServletRequest req, HttpServletResponse res) {
        StringBuffer content = new StringBuffer();
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        ProviderContext pc = aprov.getProviderContext();
        Map dpEditMap = null;
        String fontTag = "";
        try {
            List pflist = pc.getClientAndLocalePropertiesFilters();
            dpEditMap = pc.getCollectionProperty(aprov.getName(), "dpEditAttributes", pflist);
            fontTag = pc.getStringProperty(aprov.getName(), "fontFace1", "Sans-serif");
            tagTable.put("iwtDesktop-fontFace1", fontTag);
            tagTable.put("isAppHandler", this.getName());
            ProviderEditUtility.setDefaultPresentation((String)aprov.getName(), (ProviderContext)aprov.getProviderContext(), tagTable);
        }
        catch (ProviderContextException pce) {
            this.error(pc, "Exception thrown retrieving values from the display profile\n", pce);
        }
        if (dpEditMap != null) {
            try {
                content.append((Object)pc.getTemplate(this.provider.getName(), "edit-start.template", tagTable));
            }
            catch (ProviderContextException pce) {
                this.error(pc, "Exception thrown retrieving values from the display profile\n", pce);
            }
            Set entries = dpEditMap.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                StringTokenizer tok = new StringTokenizer(value, "|");
                while (tok.hasMoreElements()) {
                    String type = tok.nextToken();
                    String header = tok.nextToken();
                    content.append((Object)ProviderEditUtility.createEditContent((String)type, (String)header, (String)key, (String)aprov.getName(), (ProviderContext)pc, (boolean)true));
                }
            }
            try {
                content.append((Object)pc.getTemplate(this.provider.getName(), "edit-end.template", tagTable));
            }
            catch (ProviderContextException pce) {
                this.error(pc, "Exception thrown retrieving values from the display profile\n", pce);
            }
        }
        return content;
    }

    public String getSSOProperty(String key) {
        String tmp = this.adapterProperties.getProperty(key);
        if (tmp == null) {
            tmp = "";
        }
        return tmp;
    }

    public String getRequestParameter(String key, HttpServletRequest req) {
        String tmp = req.getParameter(key);
        if (tmp == null) {
            tmp = "";
        }
        return tmp;
    }

    public URL processAppPrefsEdit(AddressBookProvider aprov, HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        URL url = null;
        Object props = null;
        Map dpEditMap = null;
        ProviderContext pc = aprov.getProviderContext();
        StringBuffer returnURL = new StringBuffer();
        try {
            url = this.getAppHelperProcessURL(request, aprov);
            List pflist = pc.getClientAndLocalePropertiesFilters();
            dpEditMap = pc.getCollectionProperty(aprov.getName(), "dpEditAttributes", pflist);
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("LDAPABHelper.processAppPrefsEdit(): \n", (Throwable)pce);
        }
        if (dpEditMap != null) {
            Set entries = dpEditMap.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                StringTokenizer tok = new StringTokenizer(value, "|");
                String type = tok.nextToken();
                try {
                    if (type.equals("string") || type.equals("select") || type.equals("password")) {
                        String reqString = this.getRequestParameter(key, request);
                        if (reqString.equals("")) continue;
                        pc.setStringProperty(aprov.getName(), key, reqString);
                        continue;
                    }
                    if (type.equals("int")) {
                        String reqNumber = this.getRequestParameter(key, request);
                        if (reqNumber.equals("")) continue;
                        pc.setIntegerProperty(aprov.getName(), key, Integer.parseInt(reqNumber));
                        continue;
                    }
                    if (!type.equals("check")) continue;
                    String reqBool = this.getRequestParameter(key, request);
                    Boolean bool = null;
                    bool = reqBool.equals("") ? new Boolean("false") : new Boolean("true");
                    pc.setBooleanProperty(aprov.getName(), key, bool.booleanValue());
                }
                catch (ProviderContextException pce) {
                    throw new ProviderException("LDAPABHelper.processAppPrefsEdit(): \n", (Throwable)pce);
                }
            }
        }
        pc.debugMessage((Object)("LDAPABApplicationHelper::processAppPrefsEdit:  Return url = " + url.toString()));
        return url;
    }

    private class MsgExpURL {
        private String user = null;
        private String pass = null;
        private String baseUri = null;
        private String webmailSessionId = null;
        private String sso_uri = null;

        MsgExpURL(String user, String pass, String baseUri) {
            this.user = user;
            this.pass = pass;
            this.baseUri = baseUri;
        }

        boolean equals(MsgExpURL meUrl2Comp) {
            return meUrl2Comp.baseUri.equals(this.baseUri) && meUrl2Comp.user.equals(this.user) && meUrl2Comp.pass.equals(this.pass);
        }

        String getBaseUri() {
            return this.baseUri;
        }

        String getSsoUri() {
            return this.sso_uri;
        }

        void setSsoUri(String sso_uri) {
            this.sso_uri = sso_uri;
        }

        String getWebmailSessionId() {
            return this.webmailSessionId;
        }

        void setWebmailSessionId(String webmailSessionId) {
            this.webmailSessionId = webmailSessionId;
        }

        void release() {
            this.user = null;
            this.pass = null;
            this.baseUri = null;
            this.sso_uri = null;
            this.webmailSessionId = null;
        }
    }
}

