/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar.socs;

import com.sun.comclient.calendar.Attach;
import com.sun.comclient.calendar.Attendee;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.Organizer;
import com.sun.comclient.calendar.PropertiesException;
import com.sun.comclient.calendar.RecurrencePattern;
import com.sun.comclient.calendar.socs.SOCSAlarm;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TimeZone;

public class SOCSUtils {
    private static final int MINUTE_2_SECONDS = 60;
    private static final int HOUR_2_MINUTES = 60;
    private static final int HOUR_2_SECONDS = 3600;
    private static final int DAY_2_HOURS = 24;
    private static final int DAY_2_MINUTES = 1440;
    private static final int DAY_2_SECONDS = 86400;
    private static final int WEEK_2_DAYS = 7;
    private static final int WEEK_2_HOURS = 168;
    private static final int WEEK_2_MINUTES = 10080;
    private static final int WEEK_2_SECONDS = 604800;
    private static final int NEGATIVE_SIGN = -1;
    private static final int POSITIVE_SIGN = 1;
    static BitSet dontEncode = new BitSet(256);
    static final int caseDiff = 32;

    public static long toSeconds(Duration duration) {
        if (null == duration) {
            return 0L;
        }
        return duration.getSign() * (duration.getSeconds() + duration.getMinutes() * 60 + duration.getHours() * 3600 + duration.getDays() * 86400 + duration.getWeeks() * 604800);
    }

    public static Duration toDuration(long l) throws PropertiesException {
        int n = 1;
        if (0L > l) {
            l = -1L * l;
            n = -1;
        }
        int n2 = (int)l % 60;
        int n3 = (int)((l -= (long)n2) % 3600L) / 60;
        int n4 = (int)((l -= (long)(n3 * 60)) % 86400L) / 3600;
        int n5 = (int)(l -= (long)(n4 * 3600)) / 86400;
        Duration duration = new Duration(n5, n4, n3, n2);
        duration.setSign(n);
        return duration;
    }

    public static DateTime toEndDate(DateTime dateTime, Duration duration) {
        if (null == dateTime || null == duration) {
            return null;
        }
        DateTime dateTime2 = (DateTime)dateTime.clone();
        int n = duration.getSign();
        dateTime2.add(3, n * duration.getWeeks());
        dateTime2.add(6, n * duration.getDays());
        dateTime2.add(11, n * duration.getHours());
        dateTime2.add(12, n * duration.getMinutes());
        dateTime2.add(13, n * duration.getSeconds());
        return dateTime2;
    }

    public static Duration toDuration(DateTime dateTime, DateTime dateTime2) throws PropertiesException {
        if (null == dateTime || null == dateTime2) {
            return null;
        }
        long l = dateTime.getTime().getTime() - dateTime2.getTime().getTime();
        long l2 = l / 1000L;
        return SOCSUtils.toDuration(l2);
    }

    public static String urlEncode(String string) {
        String string2 = null;
        if (string == null) {
            return string;
        }
        try {
            string2 = SOCSUtils.URLEncodeField(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
        return string2;
    }

    public static Attach parseToAttach(Properties properties) {
        Attach attach = new Attach();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (string.equals("FMTTYPE")) {
                attach.setFileType(string2);
                continue;
            }
            if (!string.equals("VALUE")) continue;
            attach.setValue(string2);
        }
        return attach;
    }

    public static Attendee parseToAttendee(Properties properties) throws PropertiesException {
        Attendee attendee = new Attendee();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (string.equals("ROLE")) {
                attendee.setRole(string2);
                continue;
            }
            if (string.equals("CUTYPE")) {
                attendee.setUserType(string2);
                continue;
            }
            if (string.equals("PARTSTAT")) {
                attendee.setParticipantStatus(string2);
                continue;
            }
            if (string.equals("CN")) {
                attendee.setCommonName(string2);
                continue;
            }
            if (string.equals("RSVP")) {
                if (string2.equalsIgnoreCase("TRUE")) {
                    attendee.setRSVPRequired(true);
                    continue;
                }
                attendee.setRSVPRequired(false);
                continue;
            }
            if (string.equals("DELEGATED-FROM")) {
                attendee.setDelegatedFrom(string2);
                continue;
            }
            if (string.equals("DELEGATED-TO")) {
                attendee.setDelegatedTo(string2);
                continue;
            }
            if (string.equals("LANGUAGE")) {
                attendee.setLanguage(string2);
                continue;
            }
            if (string.equals("SENTBY")) {
                attendee.setSentBy(string2);
                continue;
            }
            if (string.equals("DIR")) {
                attendee.setDir(string2);
                continue;
            }
            if (string.equals("MEMBER")) {
                attendee.setMember(string2);
                continue;
            }
            if (!string.equals("ATTENDEE")) continue;
            attendee.setValue(string2);
        }
        return attendee;
    }

    public static String parseAttendeeToSOCS(Attendee attendee) throws PropertiesException {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = attendee.getRole();
        if (null != string) {
            stringBuffer.append("ROLE=" + string + "^");
        }
        if (null != (string = attendee.getUserType())) {
            stringBuffer.append("CUTYPE=" + string + "^");
        }
        if (null == (string = attendee.getParticipantStatus())) {
            PropertiesException propertiesException = new PropertiesException(3);
            throw propertiesException;
        }
        stringBuffer.append("PARTSTAT=" + string + "^");
        string = attendee.getCommonName();
        if (null != string) {
            stringBuffer.append("CN=" + SOCSUtils.urlEncode(string) + "^");
        }
        if (attendee.isRSVPRequired()) {
            stringBuffer.append("RSVP=TRUE^");
        } else {
            stringBuffer.append("RSVP=FALSE^");
        }
        string = attendee.getDelegatedFrom();
        if (null != string) {
            stringBuffer.append("DELEGATED-FROM=" + SOCSUtils.urlEncode(string) + "^");
        }
        if (null != (string = attendee.getDelegatedTo())) {
            stringBuffer.append("DELEGATED-TO=" + SOCSUtils.urlEncode(string) + "^");
        }
        if (null != (string = attendee.getLanguage())) {
            stringBuffer.append("LANGUAGE=" + SOCSUtils.urlEncode(string) + "^");
        }
        if (null != (string = attendee.getSentBy())) {
            stringBuffer.append("SENTBY=" + SOCSUtils.urlEncode(string) + "^");
        }
        if (null != (string = attendee.getDir())) {
            stringBuffer.append("DIR=" + SOCSUtils.urlEncode(string) + "^");
        }
        if (null != (string = attendee.getMember())) {
            stringBuffer.append("MEMBER=" + SOCSUtils.urlEncode(string) + "^");
        }
        if (null == (string = attendee.getValue())) {
            PropertiesException propertiesException = new PropertiesException(3);
            throw propertiesException;
        }
        stringBuffer.append(SOCSUtils.urlEncode(string));
        return stringBuffer.toString();
    }

    public static Organizer parseToOrganizer(Properties properties) {
        Organizer organizer = new Organizer();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (string.equals("CN")) {
                organizer.setCommonName(string2);
                continue;
            }
            if (string.equals("LANGUAGE")) {
                organizer.setLanguage(string2);
                continue;
            }
            if (string.equals("SENTBY")) {
                organizer.setSentBy(string2);
                continue;
            }
            if (string.equals("DIR")) {
                organizer.setDir(string2);
                continue;
            }
            if (!string.equals("ORGANIZER")) continue;
            organizer.setValue(string2);
        }
        return organizer;
    }

    public static SOCSAlarm parseToVAlarm(Properties properties) throws PropertiesException {
        SOCSAlarm sOCSAlarm = new SOCSAlarm();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            Object object;
            Cloneable cloneable;
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (string.equals("DESC")) {
                sOCSAlarm.setDescription(string2);
                continue;
            }
            if (string.equals("ACTION")) {
                sOCSAlarm.setAction(string2);
                continue;
            }
            if (string.equals("ATTENDEE")) {
                Object object2 = properties.get(string);
                if (!(object2 instanceof ArrayList)) continue;
                cloneable = (ArrayList)object2;
                int n = ((ArrayList)cloneable).size();
                int n2 = 0;
                while (n2 < n) {
                    object = (Properties)((ArrayList)cloneable).get(n2);
                    Attendee attendee = SOCSUtils.parseToAttendee((Properties)object);
                    sOCSAlarm.addAttendee(attendee);
                    ++n2;
                }
                continue;
            }
            if (!string.equals("TRIGGER")) continue;
            boolean bl = true;
            cloneable = (Properties)properties.get(string);
            Enumeration<?> enumeration2 = ((Properties)cloneable).propertyNames();
            while (enumeration2.hasMoreElements()) {
                String string3 = (String)enumeration2.nextElement();
                object = ((Properties)cloneable).getProperty(string3);
                if (string3.equals("VALUE")) {
                    if (((String)object).equals("DATE-TIME")) {
                        bl = true;
                        continue;
                    }
                    bl = false;
                    continue;
                }
                if (!string3.equals("TRIGGER")) continue;
                if (bl) {
                    sOCSAlarm.setAbsTrigger((String)object);
                    continue;
                }
                sOCSAlarm.setTrigger(new Duration((String)object));
            }
        }
        return sOCSAlarm;
    }

    public static String parseRecurrencePatternToSOCS(RecurrencePattern recurrencePattern) {
        String string = "\"" + SOCSUtils.urlEncode(recurrencePattern.generatePattern()) + "\"";
        return string;
    }

    public static boolean isDateAllDay(String string) {
        int n = string.indexOf("T");
        return n <= 0;
    }

    public static boolean isUserOrganizer(String string, Organizer organizer) {
        if (organizer == null) {
            return true;
        }
        String string2 = organizer.getValue().trim();
        return string.trim().equals(string2);
    }

    public static boolean isBitSet(int n, int n2) {
        return 0 != (n & n2);
    }

    public static int getSOCSStatus(String string) {
        if ((string = string.toUpperCase()).equals("CONFIRMED")) {
            return 0;
        }
        if (string.equals("CANCELLED")) {
            return 1;
        }
        if (string.equals("TENTATIVE")) {
            return 2;
        }
        if (string.equals("NEEDS-ACTION")) {
            return 3;
        }
        if (string.equals("COMPLETED")) {
            return 4;
        }
        if (string.equals("IN-PROCESS")) {
            return 5;
        }
        if (string.equals("DRAFT")) {
            return 6;
        }
        if (string.equals("FINAL")) {
            return 7;
        }
        return 0;
    }

    public static String URLEncodeField(String string, String string2) throws UnsupportedEncodingException {
        int n = string.length();
        byte[] byArray = string.getBytes(string2);
        StringBuffer stringBuffer = new StringBuffer(n * 4);
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = byArray[n2] & 0xFF;
            if (dontEncode.get(n3)) {
                if (n3 == 32) {
                    n3 = 43;
                }
                stringBuffer.append((char)n3);
            } else {
                stringBuffer.append('%');
                char c = Character.forDigit(n3 >> 4 & 0xF, 16);
                if ('a' <= c && c <= 'f') {
                    c = (char)(c - 32);
                }
                stringBuffer.append(c);
                c = Character.forDigit(n3 & 0xF, 16);
                if ('a' <= c && c <= 'f') {
                    c = (char)(c - 32);
                }
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static DateTime parseToAllDayDateTime(String string, TimeZone timeZone) {
        if (string == null || timeZone == null) {
            return null;
        }
        int n = Integer.parseInt(string.substring(0, 4));
        int n2 = Integer.parseInt(string.substring(4, 6)) - 1;
        int n3 = Integer.parseInt(string.substring(6, 8));
        DateTime dateTime = new DateTime(timeZone);
        dateTime.set(n, n2, n3);
        return dateTime;
    }

    public static String parseAllDayDateTimeToSOCS(DateTime dateTime) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = dateTime.getYear();
        int n2 = dateTime.getMonth() + 1;
        int n3 = dateTime.getDay();
        stringBuffer.append(n);
        if (n2 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n2);
        if (n3 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n3);
        return stringBuffer.toString();
    }

    static {
        int n = 97;
        while (n <= 122) {
            dontEncode.set(n);
            ++n;
        }
        n = 65;
        while (n <= 90) {
            dontEncode.set(n);
            ++n;
        }
        n = 48;
        while (n <= 57) {
            dontEncode.set(n);
            ++n;
        }
        dontEncode.set(32);
        dontEncode.set(45);
        dontEncode.set(95);
        dontEncode.set(46);
        dontEncode.set(42);
    }
}

