/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.simplewebservice.wsdl.impl;

import com.sun.portal.providers.simplewebservice.wsdl.BindingDescriptor;
import com.sun.portal.providers.simplewebservice.wsdl.BindingOperationOutputDescriptor;
import com.sun.portal.providers.simplewebservice.wsdl.DefinitionDescriptor;
import com.sun.portal.providers.simplewebservice.wsdl.impl.BindingDescriptorImpl;
import com.sun.portal.providers.simplewebservice.wsdl.impl.BindingOperationDescriptorImpl;
import com.sun.portal.providers.simplewebservice.wsdl.impl.BindingOperationInputDescriptorImpl;
import com.sun.portal.providers.simplewebservice.wsdl.impl.BindingOperationOutputDescriptorImpl;
import com.sun.portal.providers.simplewebservice.wsdl.impl.DefinitionDescriptorImpl;
import com.sun.portal.providers.simplewebservice.wsdl.impl.MessageDescriptorImpl;
import com.sun.portal.providers.simplewebservice.wsdl.impl.OperationDescriptorImpl;
import com.sun.portal.providers.simplewebservice.wsdl.impl.PartDescriptorImpl;
import com.sun.portal.providers.simplewebservice.wsdl.impl.PortDescriptorImpl;
import com.sun.portal.providers.simplewebservice.wsdl.impl.PortTypeDescriptorImpl;
import com.sun.portal.providers.simplewebservice.wsdl.impl.ServiceDescriptorImpl;
import com.sun.portal.providers.simplewebservice.wsdl.impl.TypeDescriptorImpl;
import com.sun.portal.providers.simplewebservice.wsdl.impl.TypeElementDescriptorImpl;
import com.sun.portal.providers.simplewebservice.wsdl.impl.WSDLException;
import com.sun.portal.providers.simplewebservice.wsdl.impl.WSDLReaderConstants;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WSDLReader
implements WSDLReaderConstants {
    private static final String STRING = "string";
    private static final String INT = "int";
    private static final String FLOAT = "float";
    private static final String DOUBLE = "double";
    private static final String BOOLEAN = "boolean";
    private static final String LONG = "long";
    private static final String BYTE = "byte";
    private static final String SHORT = "short";
    private static final int ELEMENT_STYLE = 1;
    private static final int COMPLEX_TYPE_STYLE = 2;
    private static WSDLReader wsdlReader = new WSDLReader();

    public static WSDLReader getWSDLReader() {
        return wsdlReader;
    }

    public DefinitionDescriptor getWSDLDefinitionDescriptor(String string) throws WSDLException {
        DefinitionDescriptor definitionDescriptor = null;
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            Document document = this.parseXMLDocument(inputStream);
            inputStream.close();
            definitionDescriptor = this.getDefinitionDescriptor(document);
        }
        catch (IOException iOException) {
            throw new WSDLException("INVALID_URL", iOException.getMessage(), iOException);
        }
        catch (WSDLException wSDLException) {
            throw wSDLException;
        }
        catch (Exception exception) {
            throw new WSDLException("OTHER_ERROR", exception.getMessage(), exception);
        }
        return definitionDescriptor;
    }

    private DefinitionDescriptor getDefinitionDescriptor(Document document) throws WSDLException {
        DefinitionDescriptorImpl definitionDescriptorImpl = null;
        Element element = document.getDocumentElement();
        String string = element.getNodeName();
        if (!string.equalsIgnoreCase("definitions")) {
            throw new WSDLException("INVALID_WSDL", "Unable to parse- WSDLdefinitions element not found");
        }
        String string2 = this.getAttribute(element, "name");
        String string3 = this.getAttribute(element, "targetNamespace");
        Map map = this.getNamespaces(element);
        Map map2 = this.getTypeDescriptors(element);
        Map map3 = this.getMessageDescriptors(element);
        Map map4 = this.getPortTypeDescriptors(element);
        Map map5 = this.getBindingDescriptors(element);
        Map map6 = this.getServiceDescriptors(element);
        this.filterNonSOAPPortTypes(map4, map5);
        definitionDescriptorImpl = new DefinitionDescriptorImpl(string2, string3, map, map2, map3, map5, map4, map6);
        return definitionDescriptorImpl;
    }

    private void filterNonSOAPPortTypes(Map map, Map map2) throws WSDLException {
        Iterator iterator = map2.values().iterator();
        HashMap hashMap = new HashMap();
        if (iterator != null) {
            while (iterator.hasNext()) {
                BindingDescriptor bindingDescriptor = (BindingDescriptor)iterator.next();
                String string = bindingDescriptor.getPortTypeDescriptorName();
                if (map.containsKey(string)) {
                    hashMap.put(string, map.get(string));
                }
                if (!map.containsKey(this.removeNS(string))) continue;
                hashMap.put(string, map.get(this.removeNS(string)));
            }
            if (hashMap.size() < 1) {
                throw new WSDLException("OTHER_ERROR", "No Bindings for SOAP found in WSDL.");
            }
            map.clear();
            map.putAll(hashMap);
        }
    }

    private Map getTypeDescriptors(Element element) throws WSDLException {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        NodeList nodeList = element.getElementsByTagName("types");
        if (nodeList != null && nodeList.getLength() != 0) {
            Element element2 = this.getFirstChildElement((Element)nodeList.item(0));
            if (element2 == null) {
                return hashMap;
            }
            String string = element2.getTagName();
            String string2 = this.getNSPrefix(string);
            String string3 = this.getAttribute(element2, "targetNamespace");
            String string4 = this.getAttribute(element2, "xmlns");
            if (string2 == null || string2.length() == 0) {
                string2 = "";
            }
            if (!this.removeNS(string).equals("schema")) {
                throw new WSDLException("INVALID_WSDL", "No schema tag found in types section");
            }
            Element element3 = this.getFirstChildElement(element2);
            if (element3 != null) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                Object object8;
                String string5 = element3.getTagName();
                if (string5.endsWith("import")) {
                    Node node = element3;
                    do {
                        if ((node = node.getNextSibling()) == null) {
                            string5 = "";
                            break;
                        }
                        if (node.getNodeType() != 1) continue;
                        element3 = (Element)node;
                        string5 = element3.getTagName();
                    } while (!element3.getTagName().endsWith("element") && !element3.getTagName().endsWith("complexType"));
                } else {
                    string5 = element3.getTagName();
                }
                int n = 0;
                if (string5.endsWith("element")) {
                    n = 1;
                } else if (string5.endsWith("complexType")) {
                    n = 2;
                } else {
                    throw new WSDLException("INVALID_WSDL", "ComplexType element or complexType not found under the schema");
                }
                Node node = element3;
                while (node != null) {
                    String string6;
                    if (node.getNodeType() == 1 && !(string6 = (object8 = node).getTagName()).endsWith("complexType")) {
                        if (string6.endsWith("element")) {
                            object7 = this.getAttribute((Element)object8, "name");
                            object6 = new HashMap();
                            ArrayList<Object> arrayList = new ArrayList<Object>();
                            object5 = object8.getElementsByTagName(string2 + "element");
                            if (object5 == null || object5.getLength() == 0) {
                                object5 = object8.getElementsByTagName("element");
                            }
                            if (object5 == null || object5.getLength() == 0) {
                                object4 = this.getAttribute((Element)object8, "value");
                                object3 = this.getAttribute((Element)object8, "type");
                                if (object3 == null) {
                                    object2 = this.getFirstChildElement((Element)object8);
                                    object = this.removeNS(object2.getNodeName());
                                    if (!((String)object).equals("complexType")) {
                                        throw new WSDLException("INVALID_WSDL", "ComplexType complexType name: " + (String)object7 + " does not contain any " + "complexContent");
                                    }
                                    if (!object2.hasChildNodes()) {
                                        object3 = STRING;
                                        object4 = "";
                                    }
                                }
                                object2 = new TypeElementDescriptorImpl((String)object7, (String)object3, (String)object4);
                                object6.put(object7, object2);
                                arrayList.add(object7);
                            } else {
                                object4 = element2.getElementsByTagName(string2 + "complexType");
                                if (object4 == null) {
                                    object4 = element2.getElementsByTagName("complexType");
                                }
                                this.parseComplexTypeElementData((NodeList)object4, (NodeList)object5, (Map)object6, arrayList);
                            }
                            object4 = new TypeDescriptorImpl((String)object7, (Map)object6, arrayList, string3);
                            hashMap.put(object7, object4);
                        } else {
                            throw new WSDLException("INVALID_WSDL", "ComplexType element not found");
                        }
                    }
                    node = node.getNextSibling();
                }
                object8 = element2.getElementsByTagName(string2 + "complexType");
                if (object8 == null || object8.getLength() == 0) {
                    object8 = element2.getElementsByTagName("complexType");
                }
                int n2 = 0;
                while (object8 != null && object8.getLength() != 0 && n2 < object8.getLength()) {
                    object7 = (Element)object8.item(n2);
                    object6 = this.getAttribute((Element)object7, "name");
                    boolean bl = false;
                    object5 = null;
                    object4 = new HashMap();
                    object3 = new ArrayList();
                    object2 = object7.getElementsByTagName(string2 + "element");
                    if (object2 == null || object2.getLength() == 0) {
                        object2 = object7.getElementsByTagName("element");
                    }
                    if (object2 != null && object2.getLength() > 0) {
                        this.parseComplexTypeElementData((NodeList)object8, (NodeList)object2, (Map)object4, (List)object3);
                    } else {
                        String string7;
                        object = object7.getElementsByTagName("complexContent");
                        if (object == null || object.getLength() == 0) {
                            object = object7.getElementsByTagName(string2 + "complexContent");
                        }
                        if (object == null || object.getLength() == 0) {
                            throw new WSDLException("INVALID_WSDL", "ComplexType complexType name: " + (String)object6 + " does not contain any " + "complexContent");
                        }
                        Element element4 = (Element)object.item(0);
                        NodeList nodeList2 = element4.getElementsByTagName("restriction");
                        if (nodeList2 == null || nodeList2.getLength() == 0) {
                            nodeList2 = element4.getElementsByTagName(string2 + "restriction");
                        }
                        if (nodeList2 == null || nodeList2.getLength() == 0) {
                            throw new WSDLException("INVALID_WSDL", "ComplexType complexType name: " + (String)object6 + " does not contain any " + "restriction");
                        }
                        String string8 = this.getAttribute((Element)nodeList2.item(0), "base");
                        if (!string8.endsWith("Array")) {
                            throw new WSDLException("INVALID_WSDL", "Restriction base attribute value does not match complexType");
                        }
                        NodeList nodeList3 = ((Element)nodeList2.item(0)).getElementsByTagName("attribute");
                        if (nodeList3 == null || nodeList3.getLength() == 0) {
                            nodeList3 = ((Element)nodeList2.item(0)).getElementsByTagName(string2 + "attribute");
                        }
                        if ((string7 = this.getAttribute((Element)nodeList3.item(0), "wsdl:arrayType")) == null || string7.equals("")) {
                            throw new WSDLException("INVALID_WSDL", "Invalid type specified in <attribute> of " + (String)object6);
                        }
                        bl = true;
                        object5 = string7.substring(0, string7.indexOf(91));
                    }
                    object = new TypeDescriptorImpl((String)object6, (Map)object4, (List)object3, string3);
                    if (bl) {
                        object.setArrayType(bl);
                        object.setArrayTypeName((String)object5);
                    }
                    hashMap.put(object6, object);
                    ++n2;
                }
            }
        }
        return hashMap;
    }

    private void parseComplexTypeElementData(NodeList nodeList, NodeList nodeList2, Map map, List list) throws WSDLException {
        int n = 0;
        while (n < nodeList2.getLength()) {
            Element element = (Element)nodeList2.item(n);
            String string = this.getAttribute(element, "name");
            String string2 = this.getAttribute(element, "value");
            String string3 = this.getAttribute(element, "type");
            if (!this.isSupportedType(string3) && !this.isNestedComplexType(nodeList, string3)) {
                throw new WSDLException("INVALID_WSDL", "ComplexType element name: " + string + " contains an undefined type: " + string3);
            }
            TypeElementDescriptorImpl typeElementDescriptorImpl = new TypeElementDescriptorImpl(string, string3, string2);
            map.put(string, typeElementDescriptorImpl);
            list.add(string);
            ++n;
        }
    }

    private boolean isSupportedType(String string) {
        if (string == null) {
            return false;
        }
        return string.endsWith(STRING) || string.endsWith(INT) || string.endsWith(FLOAT) || string.endsWith(DOUBLE) || string.endsWith(BOOLEAN) || string.endsWith(LONG) || string.endsWith(BYTE) || string.endsWith(SHORT);
    }

    private boolean isNestedComplexType(NodeList nodeList, String string) {
        if (nodeList == null) {
            return false;
        }
        String string2 = this.removeNS(string);
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element = (Element)nodeList.item(n);
            String string3 = this.getAttribute(element, "name");
            if (string3 != null && string3.equals(string2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private Map getMessageDescriptors(Element element) throws WSDLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        NodeList nodeList = element.getElementsByTagName("message");
        this.checkForInvalidNodes(nodeList, "message", "definitions");
        int n = 0;
        while (n < nodeList.getLength()) {
            Object object;
            HashMap<String, PartDescriptorImpl> hashMap2 = new HashMap<String, PartDescriptorImpl>();
            Element element2 = (Element)nodeList.item(n);
            String string = this.getAttribute(element2, "name");
            NodeList nodeList2 = element2.getElementsByTagName("part");
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = 0;
            while (nodeList2 != null && n2 < nodeList2.getLength()) {
                object = (Element)nodeList2.item(n2);
                String string2 = this.getAttribute((Element)object, "name");
                String string3 = this.getAttribute((Element)object, "type");
                if (string3 == null) {
                    string3 = this.getAttribute((Element)object, "element");
                }
                arrayList.add(string2);
                PartDescriptorImpl partDescriptorImpl = new PartDescriptorImpl(string2, string3);
                hashMap2.put(string2, partDescriptorImpl);
                ++n2;
            }
            object = new MessageDescriptorImpl(string, hashMap2, arrayList);
            hashMap.put(string, object);
            ++n;
        }
        return hashMap;
    }

    private Map getPortTypeDescriptors(Element element) throws WSDLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        NodeList nodeList = element.getElementsByTagName("portType");
        this.checkForInvalidNodes(nodeList, "portType", "definitions");
        int n = 0;
        while (n < nodeList.getLength()) {
            Object object;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Element element2 = (Element)nodeList.item(n);
            String string = this.getAttribute(element2, "name");
            NodeList nodeList2 = element2.getElementsByTagName("operation");
            this.checkForInvalidNodes(nodeList2, "operation", "portType:" + string);
            int n2 = 0;
            while (n2 < nodeList2.getLength()) {
                Object object2;
                object = (Element)nodeList2.item(n2);
                String string2 = this.getAttribute((Element)object, "name");
                NodeList nodeList3 = object.getElementsByTagName("input");
                this.checkForInvalidNodes(nodeList3, "input", "operation:" + string2);
                Element element3 = (Element)nodeList3.item(0);
                String string3 = this.getAttribute(element3, "message");
                NodeList nodeList4 = object.getElementsByTagName("output");
                String string4 = null;
                if (nodeList4 != null && nodeList4.getLength() > 0) {
                    object2 = (Element)nodeList4.item(0);
                    string4 = this.getAttribute((Element)object2, "message");
                }
                object2 = new OperationDescriptorImpl(string2, string3, string4);
                arrayList.add(object2);
                ++n2;
            }
            object = new PortTypeDescriptorImpl(string, arrayList);
            hashMap.put(string, object);
            ++n;
        }
        return hashMap;
    }

    private Map getBindingDescriptors(Element element) throws WSDLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        NodeList nodeList = element.getElementsByTagName("binding");
        this.checkForInvalidNodes(nodeList, "binding", "definitions");
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2 = (Element)nodeList.item(n);
            String string = this.getAttribute(element2, "name");
            String string2 = this.getAttribute(element2, "type");
            ArrayList<Object> arrayList = new ArrayList<Object>();
            NodeList nodeList2 = element2.getElementsByTagName("soap:binding");
            if (nodeList2 != null && nodeList2.getLength() != 0) {
                Object object;
                Element element3 = (Element)nodeList2.item(0);
                String string3 = this.getAttribute(element3, "style");
                String string4 = this.getAttribute(element3, "transport");
                NodeList nodeList3 = element2.getElementsByTagName("operation");
                this.checkForInvalidNodes(nodeList3, "operation", "binding:" + string);
                int n2 = 0;
                while (n2 < nodeList3.getLength()) {
                    String string5;
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    Object object6;
                    Object object7;
                    object = (Element)nodeList3.item(n2);
                    String string6 = this.getAttribute((Element)object, "name");
                    NodeList nodeList4 = object.getElementsByTagName("soap:operation");
                    String string7 = null;
                    if (nodeList4 != null && nodeList4.getLength() > 0 && (object7 = (Element)nodeList4.item(0)) != null) {
                        string7 = this.getAttribute((Element)object7, "soapAction");
                    }
                    object7 = object.getElementsByTagName("input");
                    BindingOperationInputDescriptorImpl bindingOperationInputDescriptorImpl = null;
                    if (object7 != null && object7.getLength() > 0) {
                        object6 = (Element)object7.item(0);
                        object5 = object6.getElementsByTagName("soap:body");
                        this.checkForInvalidNodes((NodeList)object5, "soap:body", "input");
                        object4 = (Element)object5.item(0);
                        object3 = this.getAttribute((Element)object4, "use");
                        object2 = this.getAttribute((Element)object4, "namespace");
                        string5 = this.getAttribute((Element)object4, "encodingStyle");
                        bindingOperationInputDescriptorImpl = new BindingOperationInputDescriptorImpl("", (String)object3, (String)object2, string5);
                    }
                    object6 = object.getElementsByTagName("output");
                    object5 = null;
                    if (object6 != null && object6.getLength() > 0) {
                        object4 = (Element)object6.item(0);
                        object3 = object4.getElementsByTagName("soap:body");
                        this.checkForInvalidNodes((NodeList)object3, "soap:body", "output");
                        object2 = (Element)object3.item(0);
                        string5 = this.getAttribute((Element)object2, "use");
                        String string8 = this.getAttribute((Element)object2, "namespace");
                        String string9 = this.getAttribute((Element)object2, "encodingStyle");
                        object5 = new BindingOperationOutputDescriptorImpl("", string5, string8, string9);
                    }
                    object4 = new BindingOperationDescriptorImpl(string6, string7, bindingOperationInputDescriptorImpl, (BindingOperationOutputDescriptor)object5);
                    arrayList.add(object4);
                    ++n2;
                }
                object = new BindingDescriptorImpl(string, string2, arrayList, string3, string4);
                hashMap.put(string, object);
            }
            ++n;
        }
        return hashMap;
    }

    private Map getServiceDescriptors(Element element) throws WSDLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        NodeList nodeList = element.getElementsByTagName("service");
        this.checkForInvalidNodes(nodeList, "service", "definitions");
        int n = 0;
        while (n < nodeList.getLength()) {
            Object object;
            Object object2;
            Object object3;
            Element element2 = (Element)nodeList.item(n);
            String string = this.getAttribute(element2, "name");
            HashMap<String, PortDescriptorImpl> hashMap2 = new HashMap<String, PortDescriptorImpl>();
            String string2 = null;
            NodeList nodeList2 = element2.getElementsByTagName("documentation");
            if (nodeList2 != null && nodeList2.getLength() > 0 && (object3 = (Text)(object2 = (Element)nodeList2.item(0)).getFirstChild()) != null) {
                string2 = object3.getData();
            }
            object2 = null;
            object3 = element.getElementsByTagName("port");
            this.checkForInvalidNodes((NodeList)object3, "port", "service:" + string);
            int n2 = 0;
            while (n2 < object3.getLength()) {
                object = (Element)object3.item(n2);
                String string3 = this.getAttribute((Element)object, "name");
                String string4 = this.getAttribute((Element)object, "binding");
                NodeList nodeList3 = object.getElementsByTagName("soap:address");
                if (nodeList3 != null && nodeList3.getLength() != 0) {
                    object2 = this.getAttribute((Element)nodeList3.item(0), "location");
                    PortDescriptorImpl portDescriptorImpl = new PortDescriptorImpl(string3, string4, (String)object2);
                    hashMap2.put(string3, portDescriptorImpl);
                }
                ++n2;
            }
            object = new ServiceDescriptorImpl(string, string2, hashMap2);
            hashMap.put(string, object);
            ++n;
        }
        return hashMap;
    }

    private Document parseXMLDocument(InputStream inputStream) throws WSDLException {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(inputStream);
        }
        catch (Exception exception) {
            throw new WSDLException("PARSER_ERROR", exception.getMessage(), exception);
        }
        return document;
    }

    private Map getNamespaces(Element element) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            Attr attr = (Attr)namedNodeMap.item(n2);
            String string = attr.getName();
            String string2 = attr.getValue();
            if (string != null && !string.equals("name") && !string.equals("targetNamespace") && string2 != null) {
                hashMap.put(string, string2);
            }
            ++n2;
        }
        return hashMap;
    }

    private String getAttribute(Element element, String string) {
        String string2 = null;
        if (element != null && string != null && (string2 = element.getAttribute(string)) != null && string2.equals("")) {
            string2 = null;
        }
        return string2;
    }

    private void checkForInvalidNodes(NodeList nodeList, String string, String string2) throws WSDLException {
        if (nodeList == null || nodeList.getLength() == 0) {
            throw new WSDLException("INVALID_WSDL", "No " + string + " found in " + string2);
        }
    }

    private Element getFirstChildElement(Element element) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                return (Element)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    private String getNSPrefix(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(58)) != -1) {
            return string.substring(0, n + 1);
        }
        return null;
    }

    private String removeNS(String string) {
        if (string != null) {
            int n = string.lastIndexOf(58);
            if (n < 0) {
                return string;
            }
            return string.substring(n + 1);
        }
        return null;
    }

    public static void main(String[] stringArray) {
        System.out.println("In Main!");
        try {
            WSDLReader wSDLReader = WSDLReader.getWSDLReader();
            DefinitionDescriptor definitionDescriptor = wSDLReader.getWSDLDefinitionDescriptor(stringArray[0]);
            System.out.println("DefinitionDescriptor is-" + definitionDescriptor);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

