/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.pctest;

import com.sun.portal.providers.context.PropertiesFilter;
import com.sun.portal.providers.context.PropertiesFilterException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public class DateLaterThanPropertiesFilter
extends PropertiesFilter {
    private static final DateFormat dateFormat = DateFormat.getDateInstance(3);
    private Date date = null;

    protected void init(String value, boolean required) throws PropertiesFilterException {
        super.init(value, required);
        try {
            this.date = dateFormat.parse(value);
        }
        catch (ParseException pe) {
            throw new PropertiesFilterException("DateLaterThanPropertiesFilter: ", pe);
        }
    }

    public String getCondition() {
        return "dateLaterThan";
    }

    public boolean match(String condition, String value) throws PropertiesFilterException {
        if (!condition.equals("dateLaterThan")) {
            return false;
        }
        Date cdate = null;
        try {
            cdate = dateFormat.parse(value);
        }
        catch (ParseException pe) {
            throw new PropertiesFilterException("DateLaterThanPropertiesFilter.match(): ", pe);
        }
        return cdate.after(this.date);
    }
}

