/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.ROC;
import com.sun.portal.desktop.context.ClientContext;
import com.sun.portal.desktop.context.ConfigContext;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DebugContext;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import com.sun.portal.desktop.context.ServiceAppContext;
import com.sun.portal.desktop.context.SessionAppContext;
import com.sun.portal.desktop.context.TemplateContext;
import com.sun.portal.desktop.perf.PasContext;
import com.sun.portal.desktop.perf.PasContextException;
import com.sun.portal.desktop.template.ParsedTagArray;
import com.sun.portal.desktop.template.TagSwapper;
import com.sun.portal.desktop.util.PIParser;
import com.sun.portal.providers.context.ContainerProviderContext;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;

public class PSDesktopAppContext
implements DesktopAppContext {
    private static final String ROC_SID = "sid";
    private static final String ROC_SUID = "suid";
    private static final String ROC_ISAUTHLESS = "isAuthless";
    protected DebugContext debug = null;
    protected DebugContext perf = null;
    protected PasContext pas = null;
    protected SessionAppContext session = null;
    protected SessionAppContext authlessSession = null;
    protected ServiceAppContext service = null;
    protected ConfigContext config = null;
    protected TemplateContext template = null;
    protected ServletConfig servletConfig = null;
    protected ClientContext client = null;
    protected String configContextClassName = null;
    private static String scratchDir = null;
    private static Map desktopURLs = Collections.synchronizedMap(new HashMap());
    private String suidCookieName = null;
    static /* synthetic */ Class class$com$sun$portal$desktop$context$PSDesktopContext;

    public synchronized void init(ServletConfig sc) {
        DesktopAppContextThreadLocalizer.set(this);
        this.servletConfig = sc;
        this.configContextClassName = sc.getInitParameter("configContextClassName");
        if (this.configContextClassName == null) {
            throw new ContextError("PSDesktopAppContext.init(): could not get config context class name");
        }
        this.initConfigContext();
        this.initServiceAppContext();
        this.initDebugContext();
        this.initPasContext();
        this.initPerfContext();
        this.initTemplateContext();
        this.initClientContext();
        this.initSessionAppContext();
        this.initAuthlessSessionAppContext();
    }

    private static boolean toBoolean(String name) {
        return name != null && name.toLowerCase().equals("true");
    }

    protected DebugContext getDebugContext() {
        if (this.debug == null) {
            throw new ContextError("PSDesktopAppContext.getDebugContext(): not initialized");
        }
        return this.debug;
    }

    protected DebugContext initDebugContext() {
        Class clazz = class$com$sun$portal$desktop$context$PSDesktopContext == null ? (class$com$sun$portal$desktop$context$PSDesktopContext = PSDesktopAppContext.class$("com.sun.portal.desktop.context.PSDesktopContext")) : class$com$sun$portal$desktop$context$PSDesktopContext;
        synchronized (clazz) {
            if (this.debug == null) {
                this.debug = this.getNewDebugContext();
                try {
                    this.debug.init("desktop.debug", this.getConfigContext().getDebugLevel());
                }
                catch (ContextError ce) {
                    throw new ContextError("PSDesktopAppContext().getDebugContext(): " + ce);
                }
            }
            DebugContext debugContext = this.debug;
            return debugContext;
        }
    }

    protected DebugContext getPerfContext() {
        if (this.perf == null) {
            throw new ContextError("PSDesktopAppContext.getPerfContext(): not initialized");
        }
        return this.perf;
    }

    protected DebugContext initPerfContext() {
        Class clazz = class$com$sun$portal$desktop$context$PSDesktopContext == null ? (class$com$sun$portal$desktop$context$PSDesktopContext = PSDesktopAppContext.class$("com.sun.portal.desktop.context.PSDesktopContext")) : class$com$sun$portal$desktop$context$PSDesktopContext;
        synchronized (clazz) {
            if (this.perf == null) {
                this.perf = this.getNewDebugContext();
                try {
                    this.perf.init("desktop.perf", this.getConfigContext().getPerfLevel());
                }
                catch (ContextError ce) {
                    throw new ContextError("PSDesktopAppContext().getPerfContext(): " + ce);
                }
            }
            DebugContext debugContext = this.perf;
            return debugContext;
        }
    }

    protected PasContext getPasContext() {
        if (this.pas == null) {
            throw new ContextError("PSDesktopAppContext.getPasContext(): not initialized");
        }
        return this.pas;
    }

    protected PasContext initPasContext() {
        if (this.pas == null) {
            this.pas = this.getNewPasContext();
            try {
                if (!this.getConfigContext().isPasEnabled()) {
                    this.debugMessage("PSDesktopAppContext.initPasContext(): PAS disabled");
                    return this.pas;
                }
                this.debugMessage("PSDesktopAppContext.initPasContext(): PAS enabled");
                int[] ports = this.getConfigContext().getPasPortNumbers();
                this.pas.init(this.getNewDebugContext(), this.servletConfig.getServletName(), "", ports, false);
            }
            catch (ContextError ce) {
                this.debugError("PSDesktopAppContext().getPasContext(): init failed", ce);
            }
            catch (PasContextException pce) {
                this.debugError("PSDesktopAppContext().getPasContext(): init failed", pce);
            }
        }
        return this.pas;
    }

    protected DebugContext getNewDebugContext() {
        DebugContext d = null;
        try {
            d = (DebugContext)Class.forName(this.getDebugContextClassName()).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new ContextError("DesktopAppContext.getDebugContext()", cnfe);
        }
        catch (NoClassDefFoundError ncdfe) {
            throw new ContextError("DesktopAppContext.getDebugContext()", ncdfe);
        }
        catch (IllegalAccessException iae) {
            throw new ContextError("DesktopAppContext.getDebugContext()", iae);
        }
        catch (ClassCastException cce) {
            throw new ContextError("DesktopAppContext.getDebugContext()", cce);
        }
        catch (InstantiationException ie) {
            throw new ContextError("DesktopAppContext.getDebugContext()", ie);
        }
        catch (SecurityException se) {
            throw new ContextError("DesktopAppContext.getDebugContext()", se);
        }
        return d;
    }

    protected PasContext getNewPasContext() {
        PasContext d = null;
        try {
            d = (PasContext)Class.forName("com.sun.portal.desktop.perf.DesktopPasContext").newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new ContextError("DesktopAppContext.getPasContext()", cnfe);
        }
        catch (NoClassDefFoundError ncdfe) {
            throw new ContextError("DesktopAppContext.getPasContext()", ncdfe);
        }
        catch (IllegalAccessException iae) {
            throw new ContextError("DesktopAppContext.getPasContext()", iae);
        }
        catch (ClassCastException cce) {
            throw new ContextError("DesktopAppContext.getPasContext()", cce);
        }
        catch (InstantiationException ie) {
            throw new ContextError("DesktopAppContext.getPasContext()", ie);
        }
        catch (SecurityException se) {
            throw new ContextError("DesktopAppContext.getPasContext()", se);
        }
        return d;
    }

    protected SessionAppContext getSessionAppContext() {
        if (this.session == null) {
            throw new ContextError("PSDesktopAppContext.getSessionAppContext(): not initialized");
        }
        return this.session;
    }

    protected SessionAppContext initSessionAppContext() {
        if (this.session == null) {
            String sessionAppContextClassName = this.getSessionAppContextClassName();
            if (sessionAppContextClassName == null) {
                throw new ContextError("DesktopAppContext.getSessionAppContext(): class name was null");
            }
            try {
                this.session = (SessionAppContext)Class.forName(sessionAppContextClassName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new ContextError("DesktopContext.getSessionAppContext()", cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new ContextError("DesktopContext.getSessionAppContext()", ncdfe);
            }
            catch (IllegalAccessException iae) {
                throw new ContextError("DesktopContext.getSessionAppContext()", iae);
            }
            catch (ClassCastException cce) {
                throw new ContextError("DesktopContext.getSessionAppContext()", cce);
            }
            catch (InstantiationException ie) {
                throw new ContextError("DesktopContext.getSessionAppContext()", ie);
            }
            catch (SecurityException se) {
                throw new ContextError("DesktopContext.getSessionAppContext()", se);
            }
        }
        return this.session;
    }

    protected ServiceAppContext getServiceAppContext() {
        if (this.service == null) {
            throw new ContextError("PSDesktopAppContext.getServiceAppContext(): not initialized");
        }
        return this.service;
    }

    protected ServiceAppContext initServiceAppContext() {
        if (this.service == null) {
            String serviceAppContextClassName = this.getServiceAppContextClassName();
            if (serviceAppContextClassName == null) {
                throw new ContextError("DesktopContext.getServiceAppContext(): class name was null");
            }
            try {
                this.service = (ServiceAppContext)Class.forName(serviceAppContextClassName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new ContextError("DesktopContext.getServiceAppContext()", cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new ContextError("DesktopContext.getServiceAppContext()", ncdfe);
            }
            catch (IllegalAccessException iae) {
                throw new ContextError("DesktopContext.getServiceAppContext()", iae);
            }
            catch (ClassCastException cce) {
                throw new ContextError("DesktopContext.getServiceAppContext()", cce);
            }
            catch (InstantiationException ie) {
                throw new ContextError("DesktopContext.getServiceAppContext()", ie);
            }
            catch (SecurityException se) {
                throw new ContextError("DesktopContext.getServiceAppContext()", se);
            }
            this.service.init();
        }
        return this.service;
    }

    protected SessionAppContext getAuthlessSessionAppContext() {
        if (this.authlessSession == null) {
            throw new ContextError("PSDesktopAppContext.getAuthlessSessionAppContext(): not initialized");
        }
        return this.authlessSession;
    }

    protected SessionAppContext initAuthlessSessionAppContext() {
        if (this.authlessSession == null) {
            String authlessSessionAppContextClassName = this.getAuthlessSessionAppContextClassName();
            if (authlessSessionAppContextClassName == null) {
                throw new ContextError("PSDesktopAppContext.initAuthlessSessionAppContext(): class name was null");
            }
            try {
                this.authlessSession = (SessionAppContext)Class.forName(authlessSessionAppContextClassName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new ContextError("PSDesktopAppContext.initAuthlessSessionAppContext()", cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new ContextError("PSDesktopAppContext.initAuthlessSessionAppContext()", ncdfe);
            }
            catch (IllegalAccessException iae) {
                throw new ContextError("PSDesktopAppContext.initAuthlessSessionAppContext()", iae);
            }
            catch (ClassCastException cce) {
                throw new ContextError("PSDesktopAppContext.initAuthlessSessionAppContext()", cce);
            }
            catch (InstantiationException ie) {
                throw new ContextError("PSDesktopAppContext.initAuthlessSessionAppContext()", ie);
            }
            catch (SecurityException se) {
                throw new ContextError("PSDesktopAppContext.initAuthlessSessionAppContext()", se);
            }
        }
        return this.authlessSession;
    }

    protected ConfigContext getConfigContext() {
        if (this.config == null) {
            throw new ContextError("PSDesktopAppContext.getConfigContext(): not initialized");
        }
        return this.config;
    }

    protected ConfigContext initConfigContext() {
        if (this.config == null) {
            String configContextClassName = this.getConfigContextClassName();
            if (configContextClassName == null) {
                throw new ContextError("DesktopContext.getConfigContext(): class name was null");
            }
            try {
                this.config = (ConfigContext)Class.forName(configContextClassName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new ContextError("PSDesktopAppContext.getConfigContext()", cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new ContextError("PSDesktopAppContext.getConfigContext()", ncdfe);
            }
            catch (IllegalAccessException iae) {
                throw new ContextError("PSDesktopAppContext.getConfigContext()", iae);
            }
            catch (ClassCastException cce) {
                throw new ContextError("PSDesktopAppContext.getConfigContext()", cce);
            }
            catch (InstantiationException ie) {
                throw new ContextError("PSDesktopAppContext.getConfigContext()", ie);
            }
            catch (SecurityException se) {
                throw new ContextError("PSDesktopAppContext.getConfigContext()", se);
            }
        }
        this.config.init(this.servletConfig);
        return this.config;
    }

    protected ClientContext getClientContext() {
        if (this.client == null) {
            throw new ContextError("PSDesktopAppContext.getClientContext(): not initialized");
        }
        return this.client;
    }

    protected ClientContext initClientContext() {
        if (this.client == null) {
            String clientContextClassName = this.getClientContextClassName();
            if (clientContextClassName == null) {
                throw new ContextError("PSDesktopAppContext.getClientContext(): class name was null");
            }
            try {
                this.client = (ClientContext)Class.forName(clientContextClassName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new ContextError("PSDesktopAppContext.initClientContext()", cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new ContextError("PSDesktopAppContext.initClientContext()", ncdfe);
            }
            catch (IllegalAccessException iae) {
                throw new ContextError("PSDesktopAppContext.initClientContext()", iae);
            }
            catch (ClassCastException cce) {
                throw new ContextError("PSDesktopAppContext.initClientContext()", cce);
            }
            catch (InstantiationException ie) {
                throw new ContextError("PSDesktopAppContext.initClientContext()", ie);
            }
            catch (SecurityException se) {
                throw new ContextError("PSDesktopAppContext.initClientContext()", se);
            }
        }
        this.client.init();
        return this.client;
    }

    private TemplateContext getTemplateContext() {
        if (this.template == null) {
            throw new ContextError("PSDesktopAppContext.getTemplateContext(): not initialized");
        }
        return this.template;
    }

    private TemplateContext initTemplateContext() {
        if (this.template == null) {
            String templateContextClassName = this.getTemplateContextClassName();
            if (templateContextClassName == null) {
                throw new ContextError("PSDesktopAppContext.getTemplateContext(): class name was null");
            }
            try {
                this.template = (TemplateContext)Class.forName(templateContextClassName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new ContextError("PSDesktopAppContext.getTemplateContext()", cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new ContextError("PSDesktopAppContext.getTemplateContext()", ncdfe);
            }
            catch (IllegalAccessException iae) {
                throw new ContextError("PSDesktopAppContext.getTemplateContext()", iae);
            }
            catch (ClassCastException cce) {
                throw new ContextError("PSDesktopAppContext.getTemplateContext()", cce);
            }
            catch (InstantiationException ie) {
                throw new ContextError("PSDesktopAppContext.getTemplateContext()", ie);
            }
            catch (SecurityException se) {
                throw new ContextError("PSDesktopAppContext.getTemplateContext()", se);
            }
            if (this.config != null) {
                this.template.init(this.config.getTemplateScanInterval());
            } else {
                this.template.init(30);
            }
        }
        return this.template;
    }

    protected String getDebugContextClassName() {
        return this.getServiceAppContext().getDebugContextClassName();
    }

    protected String getConfigContextClassName() {
        return this.configContextClassName;
    }

    protected String getSessionAppContextClassName() {
        return this.getServiceAppContext().getSessionAppContextClassName();
    }

    protected String getAuthlessSessionAppContextClassName() {
        return this.getServiceAppContext().getAuthlessSessionAppContextClassName();
    }

    protected String getClientContextClassName() {
        return this.getServiceAppContext().getClientContextClassName();
    }

    protected String getServiceAppContextClassName() {
        return this.getConfigContext().getServiceAppContextClassName();
    }

    public String getDesktopContextClassName() {
        return this.getServiceAppContext().getDesktopContextClassName();
    }

    protected String getTemplateContextClassName() {
        return this.getServiceAppContext().getTemplateContextClassName();
    }

    public String getServiceContextClassName() {
        return this.getServiceAppContext().getServiceContextClassName();
    }

    protected String getSessionContextClassName() {
        return this.getServiceAppContext().getSessionContextClassName();
    }

    public String getNoSessionURL() {
        return this.getServiceAppContext().getNoSessionURL();
    }

    public String getSessionReturnURLParamName() {
        return this.getServiceAppContext().getSessionReturnURLParamName();
    }

    public Map getAuthorizedAuthlessUIDs() {
        return this.getServiceAppContext().getAuthorizedAuthlessUIDs();
    }

    public String getDefaultAuthlessUID() {
        return this.getServiceAppContext().getDefaultAuthlessUID();
    }

    public long getClientSessionReapInterval() {
        return this.getServiceAppContext().getClientSessionReapInterval();
    }

    public long getClientSessionInactiveMax() {
        return this.getServiceAppContext().getClientSessionInactiveMax();
    }

    public long getClientSessionsMax() {
        return this.getServiceAppContext().getClientSessionsMax();
    }

    public boolean isAuthlessEnabled() {
        return this.getServiceAppContext().isAuthlessEnabled();
    }

    public boolean isFederationEnabled() {
        return this.getServiceAppContext().isFederationEnabled();
    }

    public String getPreLoginURL(String absoluteURL, String returnURL, String libertySSOFailedParamName) {
        return this.getServiceAppContext().getPreLoginURL(absoluteURL, returnURL, libertySSOFailedParamName);
    }

    public String getStringAttribute(String name) {
        return this.getServiceAppContext().getStringAttribute(name);
    }

    public void setStringAttribute(String name, String val) {
        this.getServiceAppContext().setStringAttribute(name, val);
    }

    public StringBuffer getRequestServer(HttpServletRequest req) {
        StringBuffer url = new StringBuffer();
        String host = null;
        boolean ignoreHostHeader = false;
        String scheme = req.getScheme();
        url.append(scheme);
        url.append("://");
        String i = this.getClientTypeProperty(this.getClientType(req), "ignoreHostHeader");
        ignoreHostHeader = i == null ? false : PSDesktopAppContext.toBoolean(i);
        if (!ignoreHostHeader) {
            host = req.getHeader("host");
        }
        if (host == null) {
            url.append(req.getServerName());
            int port = req.getServerPort();
            if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
                url.append(':');
                url.append(port);
            }
        } else {
            url.append(host);
        }
        return url;
    }

    public String getDesktopURL(HttpServletRequest req) {
        String requestServer = this.getRequestServer(req).toString();
        String dtURL = (String)desktopURLs.get(requestServer);
        if (dtURL == null) {
            dtURL = requestServer + req.getContextPath() + req.getServletPath();
            desktopURLs.put(requestServer, dtURL);
        }
        return dtURL;
    }

    public String getDesktopURL(HttpServletRequest req, Map query, Map pathInfo) {
        StringBuffer urlBuffer = new StringBuffer(this.getDesktopURL(req));
        if (pathInfo != null && !pathInfo.isEmpty()) {
            HashMap<String, Map> piMap = new HashMap<String, Map>();
            piMap.put("desktop.args", pathInfo);
            String pathInfoString = PIParser.getPathInfoString(piMap);
            urlBuffer.append("/").append(pathInfoString);
        }
        if (query != null && !query.isEmpty()) {
            StringBuffer queryBuffer = new StringBuffer();
            Iterator i = query.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                String value = (String)query.get(key);
                queryBuffer.append(key).append("=").append(value);
                if (!i.hasNext()) continue;
                queryBuffer.append("&");
            }
            urlBuffer.append("?").append(queryBuffer.toString());
        }
        return urlBuffer.toString();
    }

    public String getDesktopURL(HttpServletRequest req, String query) {
        StringBuffer urlBuffer = new StringBuffer(this.getDesktopURL(req));
        if (query != null && query.length() != 0) {
            urlBuffer.append("?").append(query);
        }
        return urlBuffer.toString();
    }

    public boolean validateSession(HttpServletRequest req) {
        boolean valid = false;
        if (this.getSessionAppContext().validateSession(req)) {
            String uid = this.getSessionAppContext().getUserID(req);
            if (uid != null && this.isAuthorizedAuthlessUID(uid)) {
                throw new ContextError("PSDesktopAppContext.validateSession(): cannot use authless uid in authenticated mode, uid=" + uid);
            }
            valid = true;
        }
        return valid;
    }

    public boolean validateAuthlessSession(HttpServletRequest req) {
        boolean valid = false;
        if (this.getAuthlessSessionAppContext().validateSession(req)) {
            valid = true;
        }
        return valid;
    }

    public boolean isAuthless(HttpServletRequest req) {
        boolean authless = false;
        Boolean al = (Boolean)ROC.getObject(ROC_ISAUTHLESS);
        if (al != null) {
            authless = al;
        } else {
            boolean isValidAuthless;
            boolean isValidAuth = this.getSessionAppContext().validateSession(req);
            if (!isValidAuth && (isValidAuthless = this.getAuthlessSessionAppContext().validateSession(req))) {
                authless = true;
            }
            if (authless) {
                ROC.setObject(ROC_ISAUTHLESS, Boolean.TRUE);
            } else {
                ROC.setObject(ROC_ISAUTHLESS, Boolean.FALSE);
            }
        }
        return authless;
    }

    public boolean isAuthorizedAuthlessUID(String uid) {
        Map authorized = this.getAuthorizedAuthlessUIDs();
        Iterator itr = authorized.keySet().iterator();
        while (itr.hasNext()) {
            String suid = (String)itr.next();
            if (!suid.equalsIgnoreCase(uid)) continue;
            uid = suid;
            return true;
        }
        return false;
    }

    public String getSessionID(HttpServletRequest req) {
        String sid = (String)ROC.getObject(ROC_SID);
        if (sid == null) {
            sid = this.isAuthless(req) ? this.getAuthlessSessionAppContext().getSessionID(req) : this.getSessionAppContext().getSessionID(req);
            ROC.setObject(ROC_SID, sid);
        }
        return sid;
    }

    public String getContentType(String clientType) {
        return this.getClientContext().getContentType(clientType);
    }

    public String getClientType(HttpServletRequest req) {
        String clientType = this.getClientContext().getClientType(req);
        return clientType;
    }

    public String getDefaultClientType() {
        return this.getClientContext().getDefaultClientType();
    }

    public String getClientPath(String clientType) {
        return this.getClientContext().getClientPath(clientType);
    }

    public String getClientTypeProperty(String clientType, String key) {
        return this.getClientContext().getClientTypeProperty(clientType, key);
    }

    public Set getClientTypeProperties(String clientType, String key) {
        return this.getClientContext().getClientTypeProperties(clientType, key);
    }

    public String getCharset(String clientType, Locale locale) {
        return this.getClientContext().getCharset(clientType, locale);
    }

    public boolean getCookieSupport(String clientType) {
        return this.getClientContext().getCookieSupport(clientType);
    }

    public short getAuthlessState(String clientType) {
        return this.getClientContext().getAuthlessState(clientType);
    }

    public String getEncoderClassName(String clientType) {
        return this.getClientContext().getEncoderClassName(clientType);
    }

    public short getDebugLevel() {
        return this.getDebugContext().getDebugLevel();
    }

    public void setDebugLevel(short level) {
        this.getDebugContext().setDebugLevel(level);
    }

    public boolean isDebugEnabled() {
        return this.getDebugContext().isDebugEnabled();
    }

    public boolean isDebugErrorEnabled() {
        return this.getDebugContext().isDebugErrorEnabled();
    }

    public boolean isDebugWarningEnabled() {
        return this.getDebugContext().isDebugWarningEnabled();
    }

    public boolean isDebugMessageEnabled() {
        return this.getDebugContext().isDebugMessageEnabled();
    }

    public void debugMessage(Object o) {
        this.getDebugContext().debugMessage(o);
    }

    public void debugWarning(Object o) {
        this.getDebugContext().debugWarning(o);
    }

    public void debugError(Object o) {
        this.getDebugContext().debugError(o);
    }

    public void debugMessage(Object o, Throwable t) {
        this.getDebugContext().debugMessage(o, t);
    }

    public void debugWarning(Object o, Throwable t) {
        this.getDebugContext().debugWarning(o, t);
    }

    public void debugError(Object o, Throwable t) {
        this.getDebugContext().debugError(o, t);
    }

    public void debugTrace(Object o) {
        this.getDebugContext().debugTrace(o);
    }

    public short getPerfLevel() {
        return this.getPerfContext().getDebugLevel();
    }

    public void setPerfLevel(short level) {
        this.getPerfContext().setDebugLevel(level);
    }

    public boolean isPerfEnabled() {
        return this.getPerfContext().isDebugEnabled();
    }

    public boolean isPerfErrorEnabled() {
        return this.getPerfContext().isDebugErrorEnabled();
    }

    public boolean isPerfWarningEnabled() {
        return this.getPerfContext().isDebugWarningEnabled();
    }

    public boolean isPerfMessageEnabled() {
        return this.getPerfContext().isDebugMessageEnabled();
    }

    public void perfMessage(Object o) {
        this.getPerfContext().debugMessage(o);
    }

    public void perfWarning(Object o) {
        this.getPerfContext().debugWarning(o);
    }

    public void perfError(Object o) {
        this.getPerfContext().debugError(o);
    }

    public void perfMessage(Object o, Throwable t) {
        this.getPerfContext().debugMessage(o, t);
    }

    public void perfWarning(Object o, Throwable t) {
        this.getPerfContext().debugWarning(o, t);
    }

    public void perfError(Object o, Throwable t) {
        this.getPerfContext().debugError(o, t);
    }

    public boolean isPasContextActivated() {
        return this.getPasContext().isActivated();
    }

    public void logProcessTime(String name, String operation, String subject, long elapse) {
        try {
            this.getPasContext().logProcessTime(name, operation, subject, elapse);
        }
        catch (PasContextException pce) {
            this.debugError("PSDesktopAppContext().logProcessingTime(): failed" + pce);
        }
    }

    public String getTemplateBaseDir() {
        return this.getConfigContext().getTemplateBaseDir();
    }

    public String getProviderClassBaseDir() {
        return this.getConfigContext().getProviderClassBaseDir();
    }

    public String getJSPScratchDir() {
        if (scratchDir == null) {
            scratchDir = this.servletConfig.getServletContext().getInitParameter("server.root") + "/tmp";
        }
        return scratchDir;
    }

    public String getJSPCompilerWARClassPath() {
        return this.getConfigContext().getJSPCompilerWARClassPath();
    }

    public String getDefaultDesktopType() {
        return this.getConfigContext().getDefaultDesktopType();
    }

    public int getGetterPoolMinSize() {
        return this.getConfigContext().getGetterPoolMinSize();
    }

    public int getGetterPoolMaxSize() {
        return this.getConfigContext().getGetterPoolMaxSize();
    }

    public int getGetterPoolPartitionSize() {
        return this.getConfigContext().getGetterPoolPartitionSize();
    }

    public int getCallerPoolMinSize() {
        return this.getConfigContext().getCallerPoolMinSize();
    }

    public int getCallerPoolMaxSize() {
        return this.getConfigContext().getCallerPoolMaxSize();
    }

    public int getCallerPoolPartitionSize() {
        return this.getConfigContext().getCallerPoolPartitionSize();
    }

    public int getTemplateScanInterval() {
        return this.getConfigContext().getTemplateScanInterval();
    }

    public int getClassLoaderRevalidateInterval() {
        return this.getConfigContext().getClassLoaderRevalidateInterval();
    }

    public int getBrowserCacheInterval() {
        return this.getConfigContext().getBrowserCacheInterval();
    }

    public String getStaticContentPath() {
        return this.servletConfig.getServletContext().getInitParameter("staticContext");
    }

    public String getCookiePrefix() {
        return this.getConfigContext().getCookiePrefix();
    }

    public String getConfigProperty(String key) {
        return this.getConfigContext().getConfigProperty(key);
    }

    public ParsedTagArray getTemplate(String type, String locale, String app, String provider, String clientFilePath, String file, String baseDir) {
        return this.getTemplateContext().getTemplate(baseDir, type, locale, app, provider, clientFilePath, file);
    }

    public StringBuffer getTemplate(String type, String locale, String app, String provider, String clientFilePath, String file, Hashtable table, String baseDir, ContainerProviderContext pc) {
        ParsedTagArray pta = this.getTemplate(type, locale, app, provider, clientFilePath, file, baseDir);
        return TagSwapper.doSwapFromParsedTagArray(pta, pc, app, this.getStaticContentPath(), table);
    }

    public StringBuffer getTemplate(String type, String locale, String app, String provider, String clientFilePath, String file, Hashtable table, String baseDir) {
        return this.getTemplate(type, locale, app, provider, clientFilePath, file, table, baseDir, null);
    }

    public File getTemplatePath(String type, String locale, String app, String provider, String clientFilePath, String file, String baseDir) {
        return this.getTemplateContext().getTemplatePath(baseDir, type, locale, app, provider, clientFilePath, file);
    }

    public File getTemplateMostSpecificPath(String type, String locale, String app, String provider, String clientFilePath, String file, String baseDir) {
        return this.getTemplateContext().getTemplateMostSpecificPath(baseDir, type, locale, app, provider, clientFilePath, file);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

