/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.DesktopRequestThreadLocalizer;
import com.sun.portal.desktop.ROC;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import com.sun.portal.desktop.context.SessionAppContext;
import com.sun.portal.desktop.context.SessionContext;
import com.sun.portal.desktop.context.SessionListener;
import com.sun.portal.desktop.context.UserListener;
import com.sun.portal.desktop.util.Base64;
import com.sun.portal.desktop.util.PIParser;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthlessSessionContext
implements SessionContext,
SessionAppContext {
    private static final String ROC_COOKIES = "cookies";
    private static final String ROC_SUID = "suid";
    private static final String SUID;
    private static final String CLIENT_SID;
    private static final String ROC_CLIENT_SID = "clientSID";
    private static final String CLIENT_PROPERTIES;
    private static final String ROC_CLIENT_PROPERTIES = "clientProperties";
    private static final String ROC_SESSION_VALID = "sessionValid";
    private static final String ROC_CLIENT_PROPERTIES_ENCODED = "clientPropertiesEncoded";
    private static HashMap clientProperties;
    private static Map syncClientProperties;
    private static long lastClientSessionReap;
    private static Random random;
    private static DesktopAppContext dac;

    public void init(HttpServletRequest req) {
    }

    private static ClientSessionData getClientSessionData(String sid) {
        ClientSessionData csd = (ClientSessionData)syncClientProperties.get(sid);
        if (csd != null) {
            csd.setLastAccess();
        }
        return csd;
    }

    private static String getParameter(HttpServletRequest req, String name) {
        String value = req.getParameter(name);
        return value;
    }

    private static Map getCookieMap(HttpServletRequest req) {
        Cookie[] cookies;
        HashMap<String, Cookie> cookieMap = (HashMap<String, Cookie>)ROC.getObject(ROC_COOKIES);
        if (cookieMap == null && (cookies = req.getCookies()) != null) {
            cookieMap = new HashMap<String, Cookie>();
            int i = 0;
            while (i < cookies.length) {
                Cookie c = cookies[i];
                cookieMap.put(c.getName(), c);
                ++i;
            }
            ROC.setObject(ROC_COOKIES, cookieMap);
        }
        return cookieMap;
    }

    private static Cookie getCookie(HttpServletRequest req, String name) {
        Map cookieMap = AuthlessSessionContext.getCookieMap(req);
        if (cookieMap == null) {
            return null;
        }
        return (Cookie)cookieMap.get(name);
    }

    private static String getCookieValue(HttpServletRequest req, String name) {
        Cookie c = AuthlessSessionContext.getCookie(req, name);
        String value = null;
        if (c != null) {
            value = c.getValue();
        }
        return value;
    }

    public String getStringProperty(String name) {
        HttpServletRequest req = DesktopRequestThreadLocalizer.getRequest();
        return AuthlessSessionContext.getStringProperty(req, name);
    }

    private static Map decodeClientProperties(HttpServletRequest req) {
        Map cp = null;
        String p = null;
        if (dac.getCookieSupport(dac.getClientType(req))) {
            p = AuthlessSessionContext.getCookieValue(req, CLIENT_PROPERTIES);
            cp = PIParser.decodeKeyValueString(p);
        } else {
            String pi = req.getPathInfo();
            Map piMap = PIParser.parse(pi);
            cp = (Map)piMap.get("desktop.authless");
        }
        return cp;
    }

    private static String getStringPropertyServer(HttpServletRequest req, String name) {
        ClientSessionData csd;
        String clientSID = AuthlessSessionContext.getClientSID(req);
        String value = null;
        if (clientSID != null && (csd = AuthlessSessionContext.getClientSessionData(clientSID)) != null) {
            Map properties = csd.getProperties();
            value = (String)properties.get(name);
        }
        return value;
    }

    private static String getStringPropertyClient(HttpServletRequest req, String name) {
        String value = null;
        Map cp = AuthlessSessionContext.getClientProperties(req, false);
        if (cp != null) {
            value = (String)cp.get(name);
        }
        return value;
    }

    private static String getStringProperty(HttpServletRequest req, String name) {
        String value = null;
        short authlessState = dac.getAuthlessState(dac.getClientType(req));
        if (authlessState == 1) {
            value = AuthlessSessionContext.getStringPropertyServer(req, name);
        } else if (authlessState == 2) {
            value = AuthlessSessionContext.getStringPropertyClient(req, name);
        }
        if (value == null) {
            value = (String)req.getAttribute(name);
        }
        return value;
    }

    public void setStringProperty(String name, String val) {
        HttpServletRequest req = DesktopRequestThreadLocalizer.getRequest();
        HttpServletResponse res = DesktopRequestThreadLocalizer.getResponse();
        AuthlessSessionContext.setStringProperty(req, res, name, val);
    }

    private static String getNewClientSID(HttpServletRequest req) {
        String sid = null;
        long clientSessionsMax = dac.getClientSessionsMax();
        if ((long)syncClientProperties.size() >= clientSessionsMax) {
            if (dac.isDebugWarningEnabled()) {
                dac.debugWarning("AuthlessSessionContext.getNewClientSID(): max client sessions reached: " + clientSessionsMax);
            }
        } else {
            String server = req.getServerName();
            String pr = Integer.toString(random.nextInt());
            sid = pr + "@" + server;
            sid = Base64.encode(sid);
        }
        return sid;
    }

    protected static void setCookie(HttpServletResponse res, String key, String val) {
        Cookie c = new Cookie(key, val);
        res.addCookie(c);
    }

    protected static void setClientSID(HttpServletRequest req, HttpServletResponse res, String sid) {
        if (dac.getCookieSupport(dac.getClientType(req))) {
            AuthlessSessionContext.setCookie(res, CLIENT_SID, sid);
        }
        ROC.setObject(ROC_CLIENT_SID, sid);
    }

    private static void setStringPropertyServer(HttpServletRequest req, HttpServletResponse res, String name, String val) {
        String clientSID = AuthlessSessionContext.getClientSID(req);
        if (clientSID == null) {
            clientSID = AuthlessSessionContext.getNewClientSID(req);
        }
        if (clientSID != null) {
            AuthlessSessionContext.setClientSID(req, res, clientSID);
            ClientSessionData csd = AuthlessSessionContext.getClientSessionData(clientSID);
            if (csd == null) {
                csd = new ClientSessionData();
                syncClientProperties.put(clientSID, csd);
            }
            Map properties = csd.getProperties();
            properties.put(name, val);
        }
    }

    private static void setStringPropertyClient(HttpServletRequest req, HttpServletResponse res, String name, String val) {
        String pathInfo;
        Map cp = AuthlessSessionContext.getClientProperties(req, true);
        cp.put(name, val);
        AuthlessSessionContext.setEncodedClientProperties(cp);
        if (dac.getCookieSupport(dac.getClientType(req)) && (pathInfo = AuthlessSessionContext.getEncodedClientProperties()) != null) {
            int startIndex = pathInfo.indexOf(61, pathInfo.indexOf("desktop.authless")) + 1;
            String p = pathInfo.substring(startIndex);
            AuthlessSessionContext.setCookie(res, CLIENT_PROPERTIES, p);
        }
    }

    private static void setStringProperty(HttpServletRequest req, HttpServletResponse res, String name, String val) {
        short authlessState = dac.getAuthlessState(dac.getClientType(req));
        if (authlessState == 1) {
            AuthlessSessionContext.setStringPropertyServer(req, res, name, val);
        } else if (authlessState == 2) {
            AuthlessSessionContext.setStringPropertyClient(req, res, name, val);
        }
        req.setAttribute(name, (Object)val);
    }

    public String getSessionID() {
        return this.getUserID();
    }

    public String getSessionID(HttpServletRequest req) {
        return this.getUserID(req);
    }

    public String getUserID() {
        HttpServletRequest req = DesktopRequestThreadLocalizer.getRequest();
        String uid = this.getUserID(req);
        return uid;
    }

    public String getUserID(HttpServletRequest req) {
        String uid = AuthlessSessionContext.getSUID(req);
        return uid;
    }

    public void addSessionListener(SessionListener sl) {
    }

    public void addUserReference() {
    }

    public void addUserListener(UserListener sl) {
    }

    private static Map getClientProperties(HttpServletRequest req, boolean create) {
        HashMap cp = null;
        if (!ROC.containsObject(ROC_CLIENT_PROPERTIES)) {
            cp = AuthlessSessionContext.decodeClientProperties(req);
            if (cp == null && create) {
                cp = new HashMap();
            }
            if (cp != null) {
                ROC.setObject(ROC_CLIENT_PROPERTIES, cp);
            }
        } else {
            cp = (Map)ROC.getObject(ROC_CLIENT_PROPERTIES);
        }
        return cp;
    }

    private static void setEncodedClientProperties() {
        Map m = (Map)ROC.getObject(ROC_CLIENT_PROPERTIES);
        AuthlessSessionContext.setEncodedClientProperties(m);
    }

    private static void setEncodedClientProperties(Map m) {
        if (m != null) {
            HashMap<String, Map> piMap = new HashMap<String, Map>();
            piMap.put("desktop.authless", m);
            String pathInfo = PIParser.getPathInfoString(piMap);
            ROC.setObject(ROC_CLIENT_PROPERTIES_ENCODED, pathInfo);
        }
    }

    private static String getEncodedClientProperties() {
        if (!ROC.containsObject(ROC_CLIENT_PROPERTIES_ENCODED)) {
            AuthlessSessionContext.setEncodedClientProperties();
        }
        String p = (String)ROC.getObject(ROC_CLIENT_PROPERTIES_ENCODED);
        return p;
    }

    public String encodeURL(String url) {
        HttpServletRequest req = DesktopRequestThreadLocalizer.getRequest();
        if (!dac.getCookieSupport(dac.getClientType(req))) {
            String p;
            if (dac.getAuthlessState(dac.getClientType(req)) == 1) {
                String clientSID = AuthlessSessionContext.getClientSID(req);
                if (clientSID != null) {
                    StringBuffer piBuffer = new StringBuffer();
                    piBuffer.append(ROC_CLIENT_SID).append("=").append(clientSID);
                    url = this.appendPI(url, piBuffer.toString());
                }
            } else if (dac.getAuthlessState(dac.getClientType(req)) == 2 && (p = AuthlessSessionContext.getEncodedClientProperties()) != null) {
                url = this.appendPI(url, p);
            }
        }
        return url;
    }

    private String appendPI(String url, String pi) {
        String updatedURL = null;
        int i = url.indexOf("?");
        if (i != -1) {
            String uri = url.substring(0, i);
            String query = url.substring(i, url.length());
            updatedURL = uri + "/" + pi + query;
        } else {
            updatedURL = url + "/" + pi;
        }
        return updatedURL;
    }

    private static String getClientSID(HttpServletRequest req) {
        String clientSID = (String)ROC.getObject(ROC_CLIENT_SID);
        if (clientSID == null) {
            if (dac.getCookieSupport(dac.getClientType(req))) {
                clientSID = AuthlessSessionContext.getCookieValue(req, CLIENT_SID);
            } else {
                int index;
                String pi = req.getPathInfo();
                if (pi != null && pi.length() > 1 && (index = (pi = pi.substring(1)).indexOf(ROC_CLIENT_SID)) != -1) {
                    int startIndex = pi.indexOf(61, index) + 1;
                    clientSID = pi.indexOf("/", index) == -1 ? pi.substring(startIndex) : pi.substring(startIndex, pi.indexOf("/", index));
                }
            }
            if (clientSID != null) {
                if (!syncClientProperties.containsKey(clientSID)) {
                    clientSID = null;
                } else {
                    ROC.setObject(ROC_CLIENT_SID, clientSID);
                }
            }
        }
        return clientSID;
    }

    private static void reapClientSessions() {
        boolean needReap = false;
        long now = System.currentTimeMillis();
        Map map = syncClientProperties;
        synchronized (map) {
            long reapInterval = dac.getClientSessionReapInterval();
            boolean bl = needReap = reapInterval != -1L && now > lastClientSessionReap + reapInterval * 1000L;
            if (needReap) {
                lastClientSessionReap = now;
            }
        }
        if (needReap) {
            HashMap cpClone = null;
            Map map2 = syncClientProperties;
            synchronized (map2) {
                cpClone = (HashMap)clientProperties.clone();
            }
            Iterator i = cpClone.keySet().iterator();
            while (i.hasNext()) {
                String sid = (String)i.next();
                ClientSessionData csd = (ClientSessionData)cpClone.get(sid);
                long lastAccess = csd.getLastAccess();
                if (lastAccess == -1L || lastAccess + dac.getClientSessionInactiveMax() * 1000L >= now) continue;
                syncClientProperties.remove(sid);
            }
        }
    }

    public boolean validateSession(HttpServletRequest req) {
        Boolean valid = (Boolean)ROC.getObject(ROC_SESSION_VALID);
        if (valid == null) {
            String suid = AuthlessSessionContext.getSUID(req);
            if (suid == null) {
                valid = Boolean.FALSE;
            } else {
                boolean v = dac.isAuthorizedAuthlessUID(suid);
                if (v) {
                    valid = Boolean.TRUE;
                    this.setStringProperty(SUID, suid);
                } else {
                    valid = Boolean.FALSE;
                    this.setStringProperty(SUID, null);
                }
            }
            ROC.setObject(ROC_SESSION_VALID, valid);
        }
        AuthlessSessionContext.reapClientSessions();
        return valid;
    }

    protected static String getSUID(HttpServletRequest req) {
        String value = null;
        value = (String)ROC.getObject(ROC_SUID);
        if (value == null || value.length() == 0) {
            value = AuthlessSessionContext.getSUIDParameter(req);
            if (value == null || value.length() == 0) {
                value = AuthlessSessionContext.getStringProperty(req, SUID);
            }
            if (value == null || value.length() == 0) {
                value = dac.getDefaultAuthlessUID();
            }
            if (value != null) {
                ROC.setObject(ROC_SUID, value);
            }
        }
        return value;
    }

    protected static String getSUIDParameter(HttpServletRequest req) {
        String value = AuthlessSessionContext.getParameter(req, SUID);
        return value;
    }

    static {
        clientProperties = null;
        syncClientProperties = null;
        lastClientSessionReap = 0L;
        random = null;
        dac = null;
        dac = DesktopAppContextThreadLocalizer.get();
        String cookiePrefix = dac.getCookiePrefix();
        CLIENT_PROPERTIES = cookiePrefix + ROC_CLIENT_PROPERTIES;
        CLIENT_SID = cookiePrefix + ROC_CLIENT_SID;
        SUID = cookiePrefix + ROC_SUID;
        clientProperties = new HashMap();
        syncClientProperties = Collections.synchronizedMap(clientProperties);
        random = new Random(System.currentTimeMillis());
    }

    private static class ClientSessionData {
        private Map properties = null;
        private long lastAccess = -1L;

        public Map getProperties() {
            if (this.properties == null) {
                this.properties = new HashMap();
            }
            return this.properties;
        }

        public long getLastAccess() {
            return this.lastAccess;
        }

        public void setLastAccess() {
            this.lastAccess = System.currentTimeMillis();
        }
    }
}

