/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletappengine.impl;

import com.sun.portal.common.logging.Level;
import com.sun.portal.common.logging.Logger;
import com.sun.portal.portlet.impl.PortalContextImpl;
import com.sun.portal.portlet.impl.PortletConfigImpl;
import com.sun.portal.portlet.impl.PortletContextImpl;
import com.sun.portal.portletappengine.LifecycleManager;
import com.sun.portal.portletcontainercommon.descriptor.DeploymentDescriptorException;
import com.sun.portal.portletcontainercommon.descriptor.DeploymentDescriptorReader;
import com.sun.portal.portletcontainercommon.descriptor.PortletAppDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.PortletDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.PortletPreferencesDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.PortletsDescriptor;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.PortalContext;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PreferencesValidator;
import javax.portlet.UnavailableException;
import javax.servlet.ServletContext;

public class LifecycleManagerImpl
implements LifecycleManager {
    private PortletAppDescriptor _portletAppDescriptor;
    private PortletContext _portletContext;
    private Logger _logger;
    private Map _portlets = new HashMap();
    private Map _portletConfigs = new HashMap();
    private Map _validators = new HashMap();
    private PortalContext _portalContext;

    public void init(ServletContext context) {
        this._logger = this.initLogger(context);
        InputStream xmlStream = context.getResourceAsStream("/WEB-INF/portlet.xml");
        InputStream xmlExtStream = context.getResourceAsStream("/WEB-INF/sun-portlet.xml");
        String schemaLocation = context.getInitParameter(DeploymentDescriptorReader.PORTLET_SCHEMA_LOCATION);
        this._portletAppDescriptor = this.initDeploymentDescriptor(xmlStream, xmlExtStream, schemaLocation);
        this._portalContext = this.initPortalContext();
        if (this._portletAppDescriptor != null) {
            this._portletContext = this.initPortletContext(context);
            this.createPortlets();
        }
    }

    private PortletContext initPortletContext(ServletContext context) {
        return new PortletContextImpl(context, this._portletAppDescriptor);
    }

    private PortalContext initPortalContext() {
        return new PortalContextImpl();
    }

    private PortletAppDescriptor initDeploymentDescriptor(InputStream xmlStream, InputStream xmlExtStream, String schemaLocation) {
        DeploymentDescriptorReader reader = new DeploymentDescriptorReader(this._logger, schemaLocation);
        PortletAppDescriptor portletAppDescriptor = null;
        try {
            portletAppDescriptor = reader.loadPortletAppDescriptor(xmlStream, xmlExtStream);
        }
        catch (DeploymentDescriptorException de) {
            // empty catch block
        }
        return portletAppDescriptor;
    }

    public PortletAppDescriptor getDeploymentDescriptor() {
        return this._portletAppDescriptor;
    }

    public Portlet getPortlet(String portletName) throws PortletException {
        Portlet p = (Portlet)this._portlets.get(portletName);
        if (p == null) {
            if (this._logger.isLoggable(Level.WARNING)) {
                this._logger.logp(Level.WARNING, "LifecycleManagerImpl", "getPortlet", "Can not get portlet for: " + portletName);
            }
            throw new PortletException("LifecycleManagerImpl.getPortlet(), can not get portlet.");
        }
        return p;
    }

    public PreferencesValidator getPreferencesValidator(String portletName) {
        return (PreferencesValidator)this._validators.get(portletName);
    }

    public void removePortlet(String portletName) {
        Portlet p = (Portlet)this._portlets.get(portletName);
        if (p != null) {
            Map map = this._portlets;
            synchronized (map) {
                this._portlets.put(portletName, null);
            }
        }
    }

    public PortletConfig getPortletConfig(String portletName) {
        PortletConfig config = (PortletConfig)this._portletConfigs.get(portletName);
        if (config == null && this._logger.isLoggable(Level.WARNING)) {
            this._logger.logp(Level.WARNING, "LifecycleManagerImpl", "getPortletConfig", "Can not get portlet config for: " + portletName);
        }
        return config;
    }

    public void removePortletConfig(String portletName) {
        PortletConfig config = (PortletConfig)this._portletConfigs.get(portletName);
        if (config != null) {
            Map map = this._portletConfigs;
            synchronized (map) {
                this._portletConfigs.put(portletName, null);
            }
        }
    }

    public PortletContext getPortletContext() {
        return this._portletContext;
    }

    public PortalContext getPortalContext() {
        return this._portalContext;
    }

    private Logger initLogger(ServletContext context) {
        return (Logger)context.getAttribute("logger");
    }

    public Logger getLogger() {
        return this._logger;
    }

    public void destroy() {
        this._portletAppDescriptor = null;
        this._portletContext = null;
        Iterator i = this._portlets.keySet().iterator();
        while (i.hasNext()) {
            String portletName = (String)i.next();
            Portlet p = (Portlet)this._portlets.get(portletName);
            try {
                p.destroy();
            }
            catch (RuntimeException re) {
                if (!this._logger.isLoggable(Level.WARNING)) continue;
                this._logger.logp(Level.WARNING, "LifecycleManagerImpl", "destroy()", "Error: can not destroy portlet for: " + portletName);
            }
        }
        this._portlets.clear();
        this._portletConfigs.clear();
        this._validators.clear();
    }

    private Portlet createPortlet(String portletName, PortletDescriptor portletDescriptor) throws UnavailableException {
        Portlet portlet;
        String portletClassName = portletDescriptor.getClassName();
        PreferencesValidator validator = null;
        if (portletClassName == null) {
            throw new UnavailableException("LifecycleManagerImpl.getPortlet(), the portlet class name is not defined for portlet: " + portletName);
        }
        if (this._logger.isLoggable(Level.INFO)) {
            this._logger.logp(Level.INFO, "LifecycleManagerImpl", "createPortlet", "portlet class name: " + portletClassName);
        }
        try {
            portlet = (Portlet)Class.forName(portletClassName).newInstance();
            PortletPreferencesDescriptor pPrefDescriptor = portletDescriptor.getPortletPreferencesDescriptor();
            if (pPrefDescriptor != null && (validator = this.instantiatePreferencesValidator(pPrefDescriptor.getPreferencesValidatorName())) != null) {
                this._validators.put(portletName, validator);
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new UnavailableException("LifecycleManagerImpl.createPortlet(): ");
        }
        catch (IllegalAccessException iae) {
            throw new UnavailableException("LifecycleManagerImpl.createPortlet(): ");
        }
        catch (ClassCastException cce) {
            throw new UnavailableException("LifecycleManagerImpl.createPortlet(): ");
        }
        catch (InstantiationException ie) {
            throw new UnavailableException("LifecycleManagerImpl.createPortlet(): ");
        }
        return portlet;
    }

    private void createPortlets() {
        PortletsDescriptor portletsDescriptor = null;
        if (this._portletAppDescriptor != null) {
            portletsDescriptor = this._portletAppDescriptor.getPortletsDescriptor();
        }
        if (portletsDescriptor != null) {
            List names = portletsDescriptor.getPortletNames();
            int i = 0;
            while (i < names.size()) {
                block11: {
                    String portletName = (String)names.get(i);
                    PortletDescriptor portletDescriptor = portletsDescriptor.getPortletDescriptor(portletName);
                    if (portletDescriptor != null) {
                        PortletConfigImpl config = new PortletConfigImpl(portletDescriptor, portletName, this._portletContext);
                        try {
                            Portlet p = this.createPortlet(portletName, portletDescriptor);
                            p.init((PortletConfig)config);
                            this._portlets.put(portletName, p);
                            this._portletConfigs.put(portletName, config);
                            if (this._logger.isLoggable(Level.INFO)) {
                                this._logger.logp(Level.INFO, "LifecycleManagerImpl", "createPortlets", "create: " + portletName);
                            }
                        }
                        catch (UnavailableException ue) {
                            if (this._logger.isLoggable(Level.WARNING)) {
                                this._logger.logp(Level.WARNING, "LifecycleManagerImpl", "createPortlets()", "Error: can not instantiate portlet", (Throwable)ue);
                            }
                        }
                        catch (PortletException pe) {
                            if (this._logger.isLoggable(Level.WARNING)) {
                                this._logger.logp(Level.WARNING, "LifecycleManagerImpl", "createPortlets()", "Error: can not instantiate portlet", (Throwable)pe);
                            }
                        }
                        catch (Throwable e) {
                            if (!this._logger.isLoggable(Level.WARNING)) break block11;
                            this._logger.logp(Level.WARNING, "LifecycleManagerImpl", "createPortlets()", "Error: can not instantiate portlet", e);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private PreferencesValidator instantiatePreferencesValidator(String validatorName) {
        PreferencesValidator validator = null;
        if (validatorName != null) {
            try {
                validator = (PreferencesValidator)Class.forName(validatorName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
            }
            catch (IllegalAccessException iae) {
            }
            catch (ClassCastException cce) {
            }
            catch (InstantiationException ie) {
            }
            catch (SecurityException se) {
                // empty catch block
            }
        }
        return validator;
    }
}

