/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.rproxy.configservlet.client.ClientDetector;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.connectionhandler.Base64;
import com.sun.portal.rproxy.connectionhandler.CookieManager;
import com.sun.portal.rproxy.connectionhandler.DomainWebProxyConfig;
import com.sun.portal.rproxy.connectionhandler.GatewayServletInputStream;
import com.sun.portal.rproxy.connectionhandler.MatchHttps;
import com.sun.portal.rproxy.connectionhandler.Request;
import com.sun.portal.rproxy.connectionhandler.ServletHTTPRequest;
import com.sun.portal.rproxy.connectionhandler.webdav.DavIf;
import com.sun.portal.rproxy.connectionhandler.webdav.ParseException;
import com.sun.portal.rproxy.connectionhandler.webdav.UnRewriter;
import com.sun.portal.rproxy.rewriter.SRAPTranslatorHelper;
import com.sun.portal.rproxy.server.GatewayContext;
import com.sun.portal.rproxy.server.GatewayContextFactory;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.SSOUtil;
import com.sun.portal.util.ServiceIdentifier;
import com.sun.portal.util.SystemProperties;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class HTTPRequest
implements Request,
HttpServletRequest {
    private List _headerLines = new ArrayList();
    private boolean _firstLine = true;
    private boolean _useProxy = false;
    private boolean _forwardCookie = false;
    private boolean _archiveTranslate = true;
    private String _protocol = null;
    private String _crlf = new String(new byte[]{13, 10});
    private char lf = (char)10;
    private String _method = null;
    private String _url = "";
    private String _uri = "";
    private String _port = null;
    private String _host = null;
    private String _gatewayhost = null;
    private String _object = "";
    private String _gwscheme = "";
    private String _proxyHost;
    private int _proxyPort;
    private String _httpVersion = null;
    private boolean _headerComplete = false;
    private Map _headerCache = new HashMap();
    private BufferedInputStream _contentStream;
    private int _size = 0;
    private boolean uriChanged = false;
    private String psScriptReferrerInURI = "";
    private static final String STRING_HTTP_PORT = "80";
    private static final String STRING_HTTPS_PORT = "443";
    private static String _cookieName;
    private static String cookiePrefix;
    private static String _colonString;
    private static boolean _useProxyFlag;
    private static final int PROXY_HTTP_PORT = 8080;
    private static MatchHttps UseWebProxyURL;
    private static MatchHttps DontUseWebProxyURL;
    private static MatchHttps ForwardCookieURL;
    private static String defaultGW;
    private static final String HTTP_1_0 = "HTTP/1.0";
    private static boolean useNewDomainLogic;
    protected String gatewayURL;
    protected String encodedGatewayURL;
    protected String urlSessionInfo = null;
    protected static boolean usePlatformConfURL;
    protected static String httpPlatformConfURLString;
    protected static String httpsPlatformConfURLString;
    protected static URL httpPlatformConfURL;
    protected static URL httpsPlatformConfURL;
    protected boolean isCookieSupported = true;
    protected static final String SessionInURLDelimiter = "SessIDVal";
    protected static boolean forceURLSession;

    public HTTPRequest() {
        this._gatewayhost = defaultGW;
    }

    public HTTPRequest(String string) {
        this._gatewayhost = "";
        this._method = "GET";
        this.parseURI("/" + string);
        this._httpVersion = HTTP_1_0;
    }

    public HTTPRequest(String string, int n) {
        GatewayContext gatewayContext = GatewayContextFactory.getGatewayContext();
        boolean bl = false;
        if (usePlatformConfURL) {
            if (string.equalsIgnoreCase("http") && httpPlatformConfURL != null) {
                this._gatewayhost = httpPlatformConfURL.getHost();
                this.gatewayURL = httpPlatformConfURLString;
                bl = true;
            }
            if (string.equalsIgnoreCase("https") && httpsPlatformConfURL != null) {
                this._gatewayhost = httpsPlatformConfURL.getHost();
                this.gatewayURL = httpsPlatformConfURLString;
                bl = true;
            }
        }
        if (!bl) {
            int n2 = string.equalsIgnoreCase("http") ? gatewayContext.getHttpPort() : gatewayContext.getHttpsPort();
            this._gatewayhost = defaultGW;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string).append("://").append(defaultGW);
            if (string.equalsIgnoreCase("http")) {
                if (n2 != 80) {
                    stringBuffer.append(':').append(n2);
                }
            } else if (n2 != 443) {
                stringBuffer.append(':').append(n2);
            }
            stringBuffer.append('/');
            this.gatewayURL = stringBuffer.toString();
        }
        this.encodedGatewayURL = this.gatewayURL;
        this.urlSessionInfo = null;
    }

    public void addCustomHeader(String string, String string2) {
        int n = string2.length();
        if (string2.charAt(n - 1) != '\n' || string2.charAt(n - 2) != '\r') {
            string2 = string2 + this._crlf;
        }
        this._headerLines.add(string + ": " + string2);
    }

    public void addHeader(String string, String string2) {
        this.setRequestHeader(string, string2 + this._crlf);
    }

    public void setMethod(String string) {
        this._method = string;
    }

    public String getMethod() {
        return this._method;
    }

    public String getURL() {
        return this._url;
    }

    public void setURL(String string) {
        this._url = string;
    }

    public String getURI() {
        return this._uri;
    }

    public String getHTTPVersion() {
        if (this._httpVersion.equals("HTTP/1.1")) {
            return HTTP_1_0;
        }
        return this._httpVersion;
    }

    public byte[] getRequestHeaderBytes() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            String string;
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                dataOutputStream.write((this.getMethod() + " ").getBytes());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                if (this._useProxy && !this._protocol.equals("https")) {
                    dataOutputStream.write(this.getURL().getBytes("ISO-8859-1"));
                } else {
                    dataOutputStream.write(this.getObject().getBytes("ISO-8859-1"));
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                string = this.getHTTPVersion();
                if (string.compareTo("HTTP/0.9") > 0) {
                    dataOutputStream.write((" " + this.getHTTPVersion()).getBytes());
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            dataOutputStream.write("\r\n".getBytes());
            if (this._protocol != null && this._port != null) {
                if (this._protocol.equals("http") && this._port.equals(STRING_HTTP_PORT) || this._protocol.equals("https") && this._port.equals(STRING_HTTPS_PORT)) {
                    dataOutputStream.write(("Host: " + this.getHost() + "\r\n").getBytes());
                } else {
                    dataOutputStream.write(("Host: " + this.getHost() + ":" + this.getPort() + "\r\n").getBytes());
                }
            } else {
                dataOutputStream.write(("Host: " + this.getHost() + "\r\n").getBytes());
            }
            int n = this._headerLines.size();
            int n2 = 0;
            while (n2 < n) {
                string = (String)this._headerLines.get(n2);
                if (!string.regionMatches(true, 0, "host", 0, 4)) {
                    int n3;
                    int n4;
                    if (string.regionMatches(true, 0, "referer", 0, 7)) {
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message(" ******* " + string);
                        }
                        if ((n4 = string.indexOf("//")) == -1) {
                            dataOutputStream.write(string.getBytes());
                        } else {
                            n3 = string.indexOf("/http", n4 + 2);
                            if (n3 == -1) {
                                dataOutputStream.write(string.getBytes());
                            } else {
                                dataOutputStream.write(("Referer: " + string.substring(n3 + 1)).getBytes());
                                if (GWDebug.debug.messageEnabled()) {
                                    GWDebug.debug.message(" ******* Referer: " + string.substring(n3 + 1));
                                }
                            }
                        }
                    } else if (string.regionMatches(true, 0, "Destination", 0, 11)) {
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message(" ******* " + string);
                        }
                        if ((n4 = string.indexOf("//")) == -1) {
                            dataOutputStream.write(string.getBytes());
                        } else {
                            n3 = string.indexOf("/http", n4 + 2);
                            if (n3 == -1) {
                                dataOutputStream.write(string.getBytes());
                            } else {
                                dataOutputStream.write(("Destination: " + string.substring(n3 + 1)).getBytes());
                                if (GWDebug.debug.messageEnabled()) {
                                    GWDebug.debug.message(" ******* Destination: " + string.substring(n3 + 1));
                                }
                            }
                        }
                    } else if (!string.regionMatches(true, 0, "cookie", 0, 6) || this._forwardCookie) {
                        dataOutputStream.write(string.getBytes());
                    } else {
                        String string2 = this.removeSidFromCookie(string);
                        if (string2 != null) {
                            dataOutputStream.write(string2.getBytes());
                        }
                    }
                }
                ++n2;
            }
            dataOutputStream.write("\r\n".getBytes());
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    private String removeSidFromCookie(String string) {
        if (string.length() < 8) {
            return string;
        }
        String string2 = string.substring(7);
        StringBuffer stringBuffer = new StringBuffer("Cookie:");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (string3.startsWith(cookiePrefix)) continue;
            stringBuffer.append(" ").append(string3).append(";");
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) == ':') {
            return null;
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        stringBuffer.append(this._crlf);
        return stringBuffer.toString();
    }

    public String getRequestHeader(String string) {
        String string2 = (String)this._headerCache.get(string);
        if (string2 != null) {
            return string2;
        }
        int n = string.length();
        int n2 = this._headerLines.size();
        int n3 = 0;
        while (n3 < n2) {
            String string3 = (String)this._headerLines.get(n3);
            if (string3.regionMatches(true, 0, string, 0, n)) {
                this._headerCache.put(string, string3);
                return string3;
            }
            ++n3;
        }
        return null;
    }

    public void setRequestHeader(String string, String string2) {
        boolean bl = false;
        if (string == null || string2 == null) {
            return;
        }
        int n = string2.length();
        if (n == 0) {
            bl = true;
        } else if (string2.charAt(n - 1) != '\n' || string2.charAt(n - 2) != '\r') {
            string2 = string2 + this._crlf;
        }
        int n2 = string.length();
        int n3 = this._headerLines.size();
        int n4 = 0;
        while (n4 < n3) {
            String string3 = (String)this._headerLines.get(n4);
            if (string3.regionMatches(true, 0, string, 0, n2)) {
                this._headerLines.remove(n4);
                if (!bl) {
                    this._headerLines.add(string2);
                }
                this._headerCache.remove(string);
                return;
            }
            ++n4;
        }
        if (!bl) {
            this._headerLines.add(string2);
        }
    }

    public String getProtocol() {
        return this._protocol;
    }

    public String getHost() {
        return this._host;
    }

    public String getGatewayHost() {
        return this._gatewayhost;
    }

    public String getPort() {
        return this._port;
    }

    public String getGatewayScheme() {
        return this._gwscheme;
    }

    public String getProxyHost() {
        return this._proxyHost;
    }

    public int getProxyPort() {
        return this._proxyPort;
    }

    public boolean getUseProxy() {
        return this._useProxy;
    }

    public String getObject() {
        return this._object;
    }

    public int getSize() {
        return this._size;
    }

    public void addSize(int n) {
        this._size += n;
    }

    public void setHost(String string) {
        this._host = string;
    }

    public void setPort(String string) {
        this._port = string;
    }

    public void setProtocol(String string) {
        this._protocol = string;
    }

    public void setObject(String string) {
        this._object = string;
    }

    public void setGatewayHost(String string) {
        this._gatewayhost = string;
    }

    public void setArchiveTranslate(boolean bl) {
        this._archiveTranslate = bl;
    }

    public boolean getArchiveTranslate() {
        return this._archiveTranslate;
    }

    public BufferedInputStream getContentStream() {
        return this._contentStream;
    }

    public void setContentStream(BufferedInputStream bufferedInputStream) {
        this._contentStream = bufferedInputStream;
    }

    public void addHeaderLine(String string) {
        if (this._firstLine) {
            int n;
            if (string.equals(this._crlf)) {
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("Persistence Return !!");
                }
                return;
            }
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("First header : " + string);
            }
            if ((n = string.length()) > 0 && string.charAt(n - 1) == this.lf) {
                if (!string.endsWith(this._crlf)) {
                    string = string.substring(0, n - 1) + this._crlf;
                }
                if (string.startsWith(this._crlf)) {
                    string = string.substring(2);
                } else if (string.charAt(0) == this.lf) {
                    string = string.substring(1);
                }
                if (string.equals(this._crlf)) {
                    return;
                }
                this._firstLine = false;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                int n2 = stringTokenizer.countTokens();
                boolean bl = false;
                this._method = stringTokenizer.nextToken();
                if (n2 <= 2) {
                    String string2 = stringTokenizer.nextToken();
                    if (string2.toLowerCase().startsWith("http/")) {
                        this.parseURI("/");
                        this._httpVersion = string2;
                    } else {
                        this.parseURI(this.URLDecode(string2));
                        this._httpVersion = "HTTP/0.9";
                    }
                    this._headerComplete = true;
                    bl = true;
                } else {
                    this.parseURI(this.URLDecode(stringTokenizer.nextToken()));
                }
                if (!bl) {
                    try {
                        this._httpVersion = stringTokenizer.nextToken();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        this._httpVersion = "HTTP/0.9";
                        this._headerComplete = true;
                    }
                }
            }
        } else {
            int n = string.length();
            if (!string.endsWith(this._crlf) && n > 0) {
                string = string.substring(0, n - 1) + this._crlf;
            }
            if (string.equals(this._crlf)) {
                this._headerComplete = true;
                this.requestPostReadProcessor();
            } else if (string.regionMatches(true, 0, "host:", 0, 5)) {
                if (string.length() > 5) {
                    this._gatewayhost = string.substring(5).trim();
                    int n3 = this._gatewayhost.indexOf(58);
                    if (n3 != -1) {
                        this._gatewayhost = this._gatewayhost.substring(0, n3);
                    }
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("HTTPRequest: gateway host is " + this._gatewayhost);
                    }
                }
            } else {
                this._headerLines.add(string);
            }
        }
    }

    private String URLDecode(String string) {
        int n;
        if (ServiceIdentifier.isGateway() && string.length() > 1) {
            string = "/" + SRAPTranslatorHelper.decodeOfuscatedURI((String)string.substring(1));
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        n2 = string.indexOf("://");
        if (n2 == -1 && (n2 = string.indexOf(":/")) != -1) {
            stringBuffer.append(string.substring(0, n2 + 2)).append('/').append(string.substring(n2 + 2));
            string = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        n2 = 0;
        int n3 = string.indexOf(63);
        if (n3 == -1) {
            n3 = string.length();
        }
        do {
            if ((n = string.indexOf(_colonString, n2)) == -1 || n > n3) {
                stringBuffer.append(string.substring(n2));
                break;
            }
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(':');
            n2 = n + _colonString.length();
        } while (n != -1);
        return stringBuffer.toString();
    }

    private String parseGatewayScheme(String string) {
        if (string.length() < 2) {
            return string;
        }
        int n = string.indexOf(47, 1);
        if (n == -1) {
            this._gwscheme = string.substring(1);
            return new String("/");
        }
        if (n == 1) {
            return string.substring(1);
        }
        int n2 = string.indexOf(58, 1);
        if (n2 == -1 || n2 > n) {
            if (n2 != -1) {
                n = string.lastIndexOf(47, n2);
            }
            this._gwscheme = string.substring(1, n);
            return string.substring(n);
        }
        return string;
    }

    private String checkURL(String string, int n) {
        string = string.substring(0, n) + "/" + string.substring(n);
        this._url = string.substring(1);
        int n2 = this._uri.indexOf(63, n);
        this._uri = this._uri.substring(0, n2) + "/" + this._uri.substring(n2);
        return string;
    }

    private void parseURI(String string) {
        int n;
        int n2;
        this._uri = string;
        int n3 = this._uri.indexOf(":/");
        if (n3 != -1) {
            int n4;
            n2 = this._uri.indexOf(58, n3 + 1);
            n = this._uri.indexOf(47, n3 + 3);
            if (n == -1 && (n = this._uri.indexOf(63, n3 + 3)) == -1) {
                n = this._uri.length();
            }
            if ((n2 == -1 || n2 > n) && (n4 = this._uri.indexOf(37, n3 + 1)) != -1) {
                try {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(this._uri.substring(0, n2 + 3));
                    stringBuffer.append(URLDecoder.decode(this._uri.substring(n2 + 3, n)));
                    if (n != this._uri.length()) {
                        stringBuffer.append(this._uri.substring(n));
                    }
                    this._uri = stringBuffer.toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        string = this._uri;
        string = this.parseGatewayScheme(string);
        this._url = string.substring(1);
        n2 = string.indexOf(58);
        if (n2 != -1) {
            this._protocol = string.substring(1, string.indexOf(58));
        }
        if ((n2 = string.indexOf("//")) == -1) {
            n2 = string.indexOf(":/");
        }
        if (n2 != -1) {
            n = string.indexOf(47, n2 + 2);
            if (n == -1 && (n = string.indexOf(63, n2 + 2)) != -1) {
                string = this.checkURL(string, n);
            }
            String string2 = string.substring(n2, n == -1 ? string.length() : n);
            int n5 = string2.indexOf(58, 1);
            int n6 = string2.indexOf("@");
            if (n6 != -1) {
                String string3 = null;
                String string4 = null;
                string3 = string2.substring(2, string2.indexOf(":"));
                string4 = string2.substring(string2.indexOf(":") + 1, string2.indexOf(64));
                string2 = string2.substring(string2.indexOf(64) + 1);
                n5 = string2.indexOf(58, 1);
                this.addBasicAuthInfo(string3, string4);
            } else {
                string2 = string2.substring(2);
                n5 = string2.indexOf(58, 1);
            }
            if (n5 == -1) {
                this._port = this._protocol.equals("https") ? STRING_HTTPS_PORT : STRING_HTTP_PORT;
                this._host = string2;
            } else {
                this._host = string2.substring(0, n5);
                this._port = string2.substring(n5 + 1);
            }
            if (n != -1) {
                this._object = string.substring(n);
            }
        }
        String string5 = this.getCondensedURL(this._protocol, this._host, this._port);
        this.populateWebProxyInfo();
        this._forwardCookie = !ServiceIdentifier.isGateway() ? true : ForwardCookieURL.hasMatch(string5);
        this._useProxy = _useProxyFlag ? this._proxyHost != null && !DontUseWebProxyURL.hasMatch(string5) : this._proxyHost != null && UseWebProxyURL.hasMatch(string5);
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("_useProxy : " + this._useProxy + " testURL : " + string5 + " _proxyHost : " + this._proxyHost);
        }
    }

    private String getCondensedURL(String string, String string2, String string3) {
        if (string == null) {
            string = "";
        }
        if (string3 == null || string3.equals(STRING_HTTP_PORT) && string.equals("http") || string3.equals(STRING_HTTPS_PORT) && string.equals("https")) {
            return string + "://" + string2;
        }
        return string + "://" + string2 + ":" + string3;
    }

    public void populateWebProxyInfo() {
        String string = DomainWebProxyConfig.getWebProxy(this._protocol, this._host);
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("HTTPRequest: proxy:port = " + string);
        }
        if (string == null || string.length() == 0) {
            this._proxyHost = null;
            this._useProxy = false;
        } else {
            this._useProxy = true;
            int n = string.indexOf(58);
            if (n == -1 || n + 1 >= string.length()) {
                this._proxyHost = string;
                this._proxyPort = 8080;
            } else {
                this._proxyHost = string.substring(0, n);
                this._proxyPort = Integer.parseInt(string.substring(n + 1));
            }
        }
    }

    public boolean isHeaderComplete() {
        return this._headerComplete;
    }

    public String getSessionID() {
        String string = this.getRequestHeader("Cookie");
        if (string == null) {
            return null;
        }
        String string2 = string.substring(string.indexOf(58) + 1);
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        while (stringTokenizer.hasMoreTokens() && string3 == null) {
            String string4 = stringTokenizer.nextToken().trim();
            int n = string4.indexOf(61);
            if (n == -1 || !string4.substring(0, n).trim().equals(_cookieName)) continue;
            string3 = string4.substring(n + 1).trim();
        }
        return string3;
    }

    public Properties getNetworkInfo() {
        return null;
    }

    public byte[] getCertificate() {
        return null;
    }

    public String toString() {
        return new String(this.getRequestHeaderBytes());
    }

    public Object getAttribute(String string) {
        return null;
    }

    public Enumeration getAttributeNames() {
        return null;
    }

    public String getAuthType() {
        throw new UnsupportedOperationException("getAuthType() not supported");
    }

    public Cookie[] getCookies() {
        return null;
    }

    public String getCharacterEncoding() {
        return null;
    }

    public int getContentLength() {
        String string = this.getRequestHeader("Content-length");
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken().trim();
        return Integer.parseInt(string2);
    }

    public String getContentType() {
        return null;
    }

    public String getContextPath() {
        return null;
    }

    public long getDateHeader(String string) {
        throw new UnsupportedOperationException("getDateHeader() not supported");
    }

    public String getHeader(String string) {
        return this.getRequestHeader(string);
    }

    public Enumeration getHeaders(String string) {
        throw new UnsupportedOperationException("getHeaders() not supported");
    }

    public Enumeration getHeaderNames() {
        throw new UnsupportedOperationException("getHeaderNames() not supported");
    }

    public ServletInputStream getInputStream() {
        GatewayServletInputStream gatewayServletInputStream = new GatewayServletInputStream(this._contentStream);
        return gatewayServletInputStream;
    }

    public int getIntHeader(String string) {
        throw new UnsupportedOperationException("getIntHeader() not supported");
    }

    public Locale getLocale() {
        return null;
    }

    public Enumeration getLocales() {
        return null;
    }

    public String getParameter(String string) {
        return null;
    }

    public Enumeration getParameterNames() {
        return null;
    }

    public String[] getParameterValues(String string) {
        return null;
    }

    public String getPathInfo() {
        throw new UnsupportedOperationException("getPathInfo() not supported");
    }

    public String getPathTranslated() {
        throw new UnsupportedOperationException("getPathTranslated() not supported");
    }

    public String getQueryString() {
        throw new UnsupportedOperationException("getQueryString() not supported");
    }

    public BufferedReader getReader() {
        return null;
    }

    public String getRealPath(String string) {
        return null;
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public String getRemoteUser() {
        throw new UnsupportedOperationException("getRemoteUser() not supported");
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        return null;
    }

    public String getRequestedSessionId() {
        throw new UnsupportedOperationException("getRequestedSessionId() not supported");
    }

    public String getRequestURI() {
        throw new UnsupportedOperationException("getRequestURI() not supported");
    }

    public String getScheme() {
        return null;
    }

    public String getServerName() {
        return null;
    }

    public int getServerPort() {
        return 0;
    }

    public String getServletPath() {
        throw new UnsupportedOperationException("getServletPath() not supported");
    }

    public HttpSession getSession() {
        throw new UnsupportedOperationException("getSession() not supported");
    }

    public HttpSession getSession(boolean bl) {
        throw new UnsupportedOperationException("getSession() not supported");
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public void removeAttribute(String string) {
    }

    public void setAttribute(String string, Object object) {
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new UnsupportedOperationException("isRequestedSessionIdFromCookie() not supported");
    }

    public boolean isRequestedSessionIdFromUrl() {
        throw new UnsupportedOperationException("isRequestedSessionIdFromUrl() not supported");
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new UnsupportedOperationException("isRequestedSessionIdFromURL() not supported");
    }

    public boolean isRequestedSessionIdValid() {
        throw new UnsupportedOperationException("isRequestedSessionIdValid() not supported");
    }

    public boolean isSecure() {
        return false;
    }

    public boolean isUserInRole(String string) {
        return false;
    }

    public String getGatewayURL() {
        return this.encodedGatewayURL;
    }

    public String getUnEncodedGatewayURL() {
        return this.gatewayURL;
    }

    public List getHeaderAttributeList(String string) {
        int n = string.length();
        int n2 = this._headerLines.size();
        LinkedList<String> linkedList = new LinkedList<String>();
        int n3 = 0;
        while (n3 < n2) {
            String string2;
            String string3 = this._headerLines.get(n3).toString();
            int n4 = string3.indexOf(58);
            if (n4 != -1 && (string2 = string3.substring(0, n4).trim()).equalsIgnoreCase(string)) {
                linkedList.addLast(string3);
            }
            ++n3;
        }
        return linkedList;
    }

    public boolean removeHeader(String string) {
        boolean bl = false;
        int n = this._headerLines.size();
        Iterator iterator = this._headerLines.iterator();
        string = string.trim().toLowerCase();
        while (iterator.hasNext()) {
            String string2;
            String string3 = iterator.next().toString();
            int n2 = string3.indexOf(58);
            if (n2 == -1 || !(string2 = string3.substring(0, n2).trim()).equalsIgnoreCase(string)) continue;
            iterator.remove();
            bl = true;
        }
        this._headerCache.remove(string);
        return bl;
    }

    protected void requestPostReadProcessor() {
        Object object;
        this.parseUrlCookie();
        List list = this.getHeaderAttributeList("If");
        if (list.size() > 0) {
            this.removeHeader("If");
            object = new LinkedList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                try {
                    object.add(DavIf.parseIfHeader(string, this.getGatewayURL(), true) + this._crlf);
                }
                catch (ParseException parseException) {
                    object.add(string);
                }
            }
            iterator = object.iterator();
            while (iterator.hasNext()) {
                this.addHeader("if", iterator.next().toString());
            }
        }
        if ((object = this.getHeader("Destination")) != null) {
            this.removeHeader("Destination");
            this.addHeader("Destination", "Destination: " + UnRewriter.unrewrite(((String)object).substring(((String)object).indexOf(58) + 1).trim()));
        }
    }

    public void setGatewayURL(String string) {
        this.gatewayURL = string;
        if (!this.gatewayURL.endsWith("/")) {
            this.gatewayURL = this.gatewayURL + "/";
        }
        this.encodedGatewayURL = this.urlSessionInfo != null ? this.gatewayURL + this.urlSessionInfo + "/" : this.gatewayURL;
    }

    public boolean isCookieSupported() {
        return this.isCookieSupported;
    }

    protected String removeAndGetSIDFromScheme() {
        String string = "";
        if (this._gwscheme == null || this._gwscheme.length() == 0) {
            return string;
        }
        int n = this._gwscheme.indexOf(SessionInURLDelimiter);
        if (n == -1) {
            return string;
        }
        int n2 = this._gwscheme.indexOf(47, n);
        if (n != 0) {
            String string2 = this._gwscheme;
            this._gwscheme = string2.substring(0, n - 1);
            if (n2 != -1) {
                this._gwscheme = this._gwscheme + string2.substring(n2);
                string = string2.substring(n, n2);
                string = string.substring(SessionInURLDelimiter.length()).trim();
            } else {
                string = string2.substring(n);
                string = string.substring(SessionInURLDelimiter.length()).trim();
            }
        } else if (n2 != -1 && n2 < this._gwscheme.length()) {
            string = this._gwscheme.substring(0, n2);
            string = string.substring(SessionInURLDelimiter.length()).trim();
            this._gwscheme = this._gwscheme.substring(n2 + 1);
        } else {
            string = this._gwscheme;
            string = string.substring(SessionInURLDelimiter.length()).trim();
            this._gwscheme = "";
        }
        return string;
    }

    protected void parseUrlCookie() {
        Object object;
        String string;
        String string2;
        block28: {
            if (!ServiceIdentifier.isGateway()) {
                return;
            }
            boolean bl = this.isCookieSupported = this.detectCookie() && !forceURLSession;
            if (this.isCookieSupported) {
                this.removeAndGetSIDFromScheme();
                return;
            }
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Cookies not Supported : forceURLSession : " + forceURLSession);
            }
            string2 = this.removeAndGetSIDFromScheme();
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("removeAndGetSIDFromScheme : " + string2);
            }
            if (((string = null) == null || string.trim().length() == 0) && this._url != null && this._url.trim().length() > 0) {
                object = null;
                try {
                    SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
                    object = new ServletHTTPRequest(this);
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("Create SSOToken Dummy Servlet HTTP request : " + object);
                        GWDebug.debug.message("***********************EOF Dummy Request******************************");
                    }
                    SSOToken sSOToken = sSOTokenManager.createSSOToken((HttpServletRequest)object);
                    string = sSOToken.getTokenID().toString();
                    string = URLEncoder.encode(string);
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("Got SSoToken from Dummy Request: " + string);
                    }
                    SSOUtil.getSSOToken(string);
                }
                catch (Exception exception) {
                    if (!GWDebug.debug.messageEnabled()) break block28;
                    GWDebug.debug.message("Failed Value for Dummy Request ::::::::::::::" + object.getRequestURI());
                    GWDebug.debug.message("Exception while creating SSOToken from URL .", exception);
                }
            }
        }
        if (string == null && string2 != null && string2.trim().length() > 0) {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("OurSid :::: " + string2);
            }
            string = new String(Base64.decode(string2.getBytes()));
        }
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("sid : " + string);
            GWDebug.debug.message("Cookie : " + this.getRequestHeader("Cookie"));
        }
        if (string != null && string.length() > 0) {
            this.urlSessionInfo = SessionInURLDelimiter + Base64.encode(string);
            this.encodedGatewayURL = this.gatewayURL + this.urlSessionInfo + "/";
            object = this.getRequestHeader("Cookie");
            if (object != null && ((String)object).length() > 0) {
                int n = ((String)object).length();
                if (((String)object).charAt(n - 1) == '\r' || ((String)object).charAt(n - 1) == '\n') {
                    object = ((String)object).substring(0, n - 1);
                    --n;
                }
                if (((String)object).charAt(n - 1) == '\r' || ((String)object).charAt(n - 1) == '\n') {
                    object = ((String)object).substring(0, n - 1);
                    --n;
                }
                int n2 = ((String)object).indexOf(_cookieName);
                while (n2 != -1) {
                    int n3 = ((String)object).indexOf("=", n2 + 1);
                    if (n3 == -1) {
                        n2 = -1;
                        continue;
                    }
                    if (((String)object).substring(n2, n3).trim().equals(_cookieName)) break;
                    n2 = ((String)object).indexOf(_cookieName, n2 + 1);
                }
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("After loop indx : " + n2);
                    GWDebug.debug.message("forceURLSession : " + forceURLSession);
                    GWDebug.debug.message("cookie : " + (String)object);
                }
                if (n2 != -1) {
                    if (forceURLSession) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(((String)object).substring(0, n2));
                        stringBuffer.append(cookiePrefix);
                        n2 = ((String)object).indexOf(59, n2);
                        stringBuffer.append(string);
                        if (n2 != -1) {
                            stringBuffer.append(((String)object).substring(n2));
                        }
                        this.setRequestHeader("Cookie", stringBuffer.toString());
                    } else {
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message("CDM says cookies not supported though we found cookie in request !\n");
                            GWDebug.debug.message("Inserting Session Cookie anyway ...");
                        }
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(((String)object).substring(0, n2));
                        stringBuffer.append(cookiePrefix);
                        n2 = ((String)object).indexOf(59, n2);
                        stringBuffer.append(string);
                        if (n2 != -1) {
                            stringBuffer.append(((String)object).substring(n2));
                        }
                        this.setRequestHeader("Cookie", stringBuffer.toString());
                    }
                } else {
                    StringBuffer stringBuffer = new StringBuffer().append((String)object);
                    if (!((String)object).trim().endsWith(";")) {
                        stringBuffer.append(";");
                    }
                    stringBuffer.append(cookiePrefix).append(string).append(this._crlf).toString();
                    this.setRequestHeader("Cookie", stringBuffer.toString());
                }
            } else {
                this.setRequestHeader("Cookie", "Cookie: " + cookiePrefix + string + this._crlf);
            }
        }
        CookieManager.processCookies(this);
    }

    public void setSessionValue(String string) {
        if (string == null) {
            return;
        }
        this.urlSessionInfo = SessionInURLDelimiter + Base64.encode(string);
        this.encodedGatewayURL = this.gatewayURL + this.urlSessionInfo + "/";
    }

    private void addBasicAuthInfo(String string, String string2) {
        this.addHeader("Authorization", "Authorization: Basic " + Base64.encode(string + ":" + string2));
    }

    public int getGatewayPort() {
        try {
            URL uRL = new URL(this.encodedGatewayURL);
            return uRL.getPort();
        }
        catch (MalformedURLException malformedURLException) {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Gateway Encoded URL throws MalformedURLException" + this.encodedGatewayURL, malformedURLException);
            }
            return -1;
        }
    }

    public String getGatewayProtocol() {
        if (this.encodedGatewayURL.toLowerCase().startsWith("https")) {
            return "https";
        }
        return "http";
    }

    public boolean isGatewayProtocolSecure() {
        return this.encodedGatewayURL.toLowerCase().startsWith("https");
    }

    private boolean detectCookie() {
        String string = ClientDetector.isCookieSupported(this);
        if (string.trim().toLowerCase().equals("false")) {
            return false;
        }
        if (string.trim().toLowerCase().equals("true")) {
            return true;
        }
        String string2 = this.getRequestHeader("Cookie");
        return string2 != null;
    }

    public boolean isForwardCookieHost() {
        return this._forwardCookie;
    }

    public void changeURI() {
        int n;
        int n2;
        int n3 = this._object.indexOf("?psScriptReferrer=");
        if (n3 != -1) {
            this.psScriptReferrerInURI = this._object.substring(n3);
            this._object = this._object.substring(0, n3);
            this.uriChanged = true;
        }
        if ((n2 = this._url.indexOf("?psScriptReferrer=")) != -1) {
            this._url = this._url.substring(0, n2);
            this.uriChanged = true;
        }
        if ((n = this._uri.indexOf("?psScriptReferrer=")) != -1) {
            this._uri = this._uri.substring(0, n);
            this.uriChanged = true;
        }
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("HTTPRequest.changeURI(): new _object: " + this._object);
            GWDebug.debug.message("HTTPRequest.changeURI(): new _url: " + this._url);
            GWDebug.debug.message("HTTPRequest.changeURI(): new _uri: " + this._uri);
        }
    }

    public boolean isURIChanged() {
        return this.uriChanged;
    }

    public void restoreURI() {
        this._url = this._url + this.psScriptReferrerInURI;
        this._uri = this._uri + this.psScriptReferrerInURI;
        this._object = this._object + this.psScriptReferrerInURI;
        this.uriChanged = false;
        this.psScriptReferrerInURI = "";
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("HTTPRequest.restoreURI(): new _object: " + this._object);
            GWDebug.debug.message("HTTPRequest.restoreURI(): new _url: " + this._url);
            GWDebug.debug.message("HTTPRequest.restoreURI(): new _uri: " + this._uri);
        }
    }

    static {
        String string;
        _colonString = "%3A";
        UseWebProxyURL = new MatchHttps("UseWebProxyURL");
        DontUseWebProxyURL = new MatchHttps("DontUseWebProxyURL");
        ForwardCookieURL = new MatchHttps("ForwardCookieURL");
        useNewDomainLogic = false;
        usePlatformConfURL = false;
        httpPlatformConfURLString = "";
        httpsPlatformConfURLString = "";
        httpPlatformConfURL = null;
        httpsPlatformConfURL = null;
        _useProxyFlag = GatewayProfile.getBoolean("UseProxy", false);
        List list = GatewayProfile.getStringList("PortalServerList");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                string = iterator.next().toString();
                URL uRL = new URL(string);
                String string2 = uRL.getProtocol();
                String string3 = uRL.getHost();
                int n = uRL.getPort();
                boolean bl = false;
                ForwardCookieURL.add(string);
                if (n == 80 && string2.equals("http") || n == 443 && string2.equals("https")) {
                    bl = true;
                    ForwardCookieURL.add(string2 + "://" + string3);
                }
                String string4 = InetAddress.getByName(string3).getHostAddress();
                ForwardCookieURL.add(string2 + "://" + string4 + ":" + n);
                if (!bl) continue;
                ForwardCookieURL.add(string2 + "://" + string4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        defaultGW = SystemProperties.get("gateway.host", "");
        _cookieName = com.iplanet.am.util.SystemProperties.get((String)"com.iplanet.am.cookie.name", (String)"iPlanetDirectoryPro");
        cookiePrefix = _cookieName + "=";
        string = SystemProperties.get("gateway.enable.customurl", "false");
        if (string != null) {
            usePlatformConfURL = string.trim().equalsIgnoreCase("true");
        }
        if ((httpPlatformConfURLString = SystemProperties.get("gateway.httpurl")) != null) {
            httpPlatformConfURLString = httpPlatformConfURLString.trim();
            try {
                httpPlatformConfURL = new URL(httpPlatformConfURLString);
            }
            catch (MalformedURLException malformedURLException) {
                httpPlatformConfURL = null;
                httpPlatformConfURLString = null;
            }
        }
        if ((httpsPlatformConfURLString = SystemProperties.get("gateway.httpsurl")) != null) {
            httpsPlatformConfURLString = httpsPlatformConfURLString.trim();
            try {
                httpsPlatformConfURL = new URL(httpsPlatformConfURLString);
            }
            catch (MalformedURLException malformedURLException) {
                httpsPlatformConfURL = null;
                httpsPlatformConfURLString = null;
            }
        }
        forceURLSession = GatewayProfile.getBoolean("MapForceURLSession", false);
    }
}

