/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.util;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyException;
import com.sun.portal.netlet.util.AttributeExtractor;
import com.sun.portal.netlet.util.NetletConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UserAttributes
implements NetletConstants {
    private SSOToken ssoToken = null;
    private AMUser user = null;
    private Map userAttributes;
    private boolean applyDefault;

    public UserAttributes(SSOToken sSOToken) {
        try {
            this.ssoToken = sSOToken;
            AMStoreConnection aMStoreConnection = new AMStoreConnection(this.ssoToken);
            this.user = aMStoreConnection.getUser(sSOToken.getPrincipal().getName());
            this.userAttributes = this.user.getServiceAttributes("srapNetletService");
            this.applyDefault = false;
        }
        catch (SSOException sSOException) {
            this.applyDefault = true;
        }
        catch (AMException aMException) {
            this.applyDefault = true;
        }
    }

    public boolean isPolicyAssigned() {
        boolean bl = false;
        try {
            PolicyEvaluator policyEvaluator = new PolicyEvaluator("srapNetletService");
            bl = policyEvaluator.isAllowed(this.ssoToken, "", "sunPortalNetletExecute", Collections.EMPTY_MAP);
        }
        catch (PolicyException policyException) {
            bl = false;
        }
        catch (SSOException sSOException) {
            bl = false;
        }
        return bl;
    }

    public boolean isServiceAssigned() {
        boolean bl = false;
        try {
            Set set = null;
            set = this.user.getAssignedServices();
            if (set == null || set.isEmpty()) {
                bl = false;
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!"srapNetletService".equalsIgnoreCase(string)) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean isAllowed() {
        return this.isServiceAssigned() && this.isPolicyAssigned();
    }

    public String getString(String string, String string2) {
        return this.applyDefault ? string2 : AttributeExtractor.getString(this.userAttributes, string, string2);
    }

    public String getString(String string) {
        return this.getString(string, "");
    }

    public void setString(String string, String string2) {
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(string2);
        HashMap<String, HashSet<String>> hashMap = new HashMap<String, HashSet<String>>();
        hashMap.put(string, hashSet);
        try {
            this.user.setAttributes(hashMap);
            this.user.store();
        }
        catch (SSOException sSOException) {
        }
        catch (AMException aMException) {
            // empty catch block
        }
    }

    public int getInt(String string, int n) {
        return this.applyDefault ? n : AttributeExtractor.getInt(this.userAttributes, string, n);
    }

    public int getInt(String string) {
        return this.getInt(string, -1);
    }

    public void setInt(String string, int n) {
        String string2 = "" + n;
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(string2);
        HashMap<String, HashSet<String>> hashMap = new HashMap<String, HashSet<String>>();
        hashMap.put(string, hashSet);
        try {
            this.user.setAttributes(hashMap);
            this.user.store();
        }
        catch (SSOException sSOException) {
        }
        catch (AMException aMException) {
            // empty catch block
        }
    }

    public boolean getBoolean(String string, boolean bl) {
        return this.applyDefault ? bl : AttributeExtractor.getBoolean(this.userAttributes, string, bl);
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, false);
    }

    public void setBoolean(String string, boolean bl) {
        String string2 = "" + bl;
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(string2);
        HashMap<String, HashSet<String>> hashMap = new HashMap<String, HashSet<String>>();
        hashMap.put(string, hashSet);
        try {
            this.user.setAttributes(hashMap);
            this.user.store();
        }
        catch (SSOException sSOException) {
        }
        catch (AMException aMException) {
            // empty catch block
        }
    }

    public List getStringList(String string) {
        return this.applyDefault ? new ArrayList() : AttributeExtractor.getStringList(this.userAttributes, string);
    }

    public void setStringList(String string, List list) {
        HashSet hashSet = new HashSet(list);
        HashMap hashMap = new HashMap();
        hashMap.put(string, hashSet);
        try {
            this.user.setAttributes(hashMap);
            this.user.store();
        }
        catch (SSOException sSOException) {
        }
        catch (AMException aMException) {
            // empty catch block
        }
    }

    public String getUserAttribute(String string, String string2) {
        try {
            Set set = this.user.getAttribute(string);
            if (set != null) {
                Iterator iterator = set.iterator();
                return iterator.hasNext() ? (String)iterator.next() : string2;
            }
        }
        catch (SSOException sSOException) {
            return string2;
        }
        catch (AMException aMException) {
            return string2;
        }
        return string2;
    }

    public String getUserAttribute(String string) {
        return this.getUserAttribute(string, "");
    }
}

