/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.sun.portal.netlet.eproxy.GW;
import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.SRAPSocket;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.mozilla.jss.ssl.SSLServerSocket;

public abstract class ProxyConnection {
    private static String dummyLockString = "DummyLockString";
    private String threadName = null;
    private ServerSocket serverSocket = null;
    private String connectionInfoKey = null;

    public ProxyConnection(String string, String string2) {
        this.threadName = string;
        this.connectionInfoKey = string2;
    }

    public void start() {
        Thread.currentThread().setName(this.threadName);
        this.serverSocket = this.makeServerSocket();
        Integer n = new Integer(0);
        GW.run_GW();
        while (this.serverSocket != null) {
            Socket socket = null;
            try {
                try {
                    socket = this.serverSocket.accept();
                    this.incrementSocketCount();
                }
                catch (SocketException socketException) {
                    continue;
                }
                catch (IOException iOException) {
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error(this.threadName + " cannot accept new connection on " + this.serverSocket, iOException);
                    }
                    this.closeServerSocket();
                    this.resetServerSocket();
                    continue;
                }
                if (GWLogManager.loggingEnabled) {
                    n = new Integer(GWLogManager.getLogId());
                    try {
                        GWLogManager.write(this.threadName, GWLocale.getPFString(this.connectionInfoKey, new Object[]{n, socket.getInetAddress().toString(), new Integer(socket.getPort())}));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    socket.setTcpNoDelay(true);
                }
                catch (SocketException socketException) {
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error(this.threadName + " cannot set TcpNoDelay on " + socket, socketException);
                    }
                    this.closeSocket(socket);
                    socket = null;
                    continue;
                }
                this.process(new SRAPSocket(socket), n);
            }
            catch (Throwable throwable) {
                if (!GWDebug.debug.errorEnabled()) continue;
                GWDebug.debug.error(this.threadName + ": Uncaught exception:", throwable);
            }
        }
        this.stop();
    }

    private void resetServerSocket() {
        try {
            Thread.sleep(5L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String string = dummyLockString;
        synchronized (string) {
            GW.unrun_GW();
            GW.setNumberOfInstances(1);
            this.serverSocket = this.makeServerSocket();
            GW.run_GW();
        }
    }

    protected void closeSocket(Socket socket) {
        try {
            block6: {
                try {
                    socket.close();
                    boolean bl = this.serverSocket instanceof SSLServerSocket;
                    if (!PerfContextObject.ENABLE_PERF) break block6;
                    if (bl) {
                        SocketCount.decrementSSLSockets();
                        break block6;
                    }
                    SocketCount.decrementPlainSockets();
                }
                catch (IOException iOException) {
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error(this.threadName + ": IO Exception while closing server socket:", iOException);
                    }
                    Object var4_5 = null;
                    socket = null;
                }
            }
            Object var4_4 = null;
            socket = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            socket = null;
            throw throwable;
        }
    }

    private void closeServerSocket() {
        if (this.serverSocket != null) {
            try {
                block6: {
                    try {
                        this.serverSocket.close();
                        if (!PerfContextObject.ENABLE_PERF) break block6;
                        SocketCount.decrementServerSockets();
                    }
                    catch (IOException iOException) {
                        if (GWDebug.debug.errorEnabled()) {
                            GWDebug.debug.error(this.threadName + " cannot close server socket", iOException);
                        }
                        Object var3_2 = null;
                        this.serverSocket = null;
                    }
                }
                Object var3_1 = null;
                this.serverSocket = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.serverSocket = null;
                throw throwable;
            }
        }
    }

    private void incrementSocketCount() {
        boolean bl = this.serverSocket instanceof SSLServerSocket;
        if (PerfContextObject.ENABLE_PERF) {
            if (bl) {
                SocketCount.incrementSSLSockets();
            } else {
                SocketCount.incrementPlainSockets();
            }
        }
    }

    private void stop() {
        if (GWDebug.debug.errorEnabled()) {
            GWDebug.debug.error("FATAL ERROR: " + this.threadName + " exited");
        }
    }

    protected abstract ServerSocket makeServerSocket();

    protected abstract void process(Socket var1, Integer var2);
}

