/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.CertAdminConstants;
import com.sun.portal.cli.cert.CertAdminHelpText;
import com.sun.portal.cli.cert.CertAdminLocale;
import com.sun.portal.cli.cert.CertAdminPasswordCallback;
import com.sun.portal.cli.cert.CertAdminUtil;
import com.sun.portal.cli.cert.CertContext;
import com.sun.portal.cli.cert.Command;
import com.sun.portal.cli.cert.JSSContext;
import com.sun.portal.cli.cert.JSSUtil;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Calendar;
import java.util.Date;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BOOLEAN;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyPairGenerator;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.cert.CertificateInfo;
import org.mozilla.jss.pkix.cert.Extension;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Name;
import org.mozilla.jss.pkix.primitive.SubjectPublicKeyInfo;
import org.mozilla.jss.util.ConsolePasswordCallback;
import org.mozilla.jss.util.NullPasswordCallback;
import org.mozilla.jss.util.PasswordCallback;

public class CreateSelfSignedCertificate
implements Command {
    private JSSContext cntx;

    public boolean execute(JSSContext jSSContext) {
        int n;
        this.cntx = jSSContext;
        CertAdminUtil.println(CertAdminConstants.newline);
        String string = jSSContext.getHost();
        CertAdminUtil.println(CertAdminHelpText.getDNHelpText());
        String string2 = CertAdminUtil.question(CertAdminLocale.getPFString("q2", "What is the fully-qualified DNS name of this host? [") + string + CertAdminLocale.getPFString("q1", "]"));
        if (string2.equals("")) {
            string2 = string;
        }
        String string3 = CertAdminUtil.question(CertAdminLocale.getPFString("q3", "What is the name of your organization (ex: Company)? [") + CertAdminLocale.getPFString("q1", "]"));
        String string4 = CertAdminUtil.question(CertAdminLocale.getPFString("q4", "What is the name of your organizational unit (ex: division)? [") + CertAdminLocale.getPFString("q1", "]"));
        String string5 = CertAdminUtil.question(CertAdminLocale.getPFString("q5", "What is the name of your City or Locality? [") + CertAdminLocale.getPFString("q1", "]"));
        String string6 = CertAdminUtil.question(CertAdminLocale.getPFString("q6", "What is the name (no abbreviation please) of your State or Province? [") + CertAdminLocale.getPFString("q1", "]"));
        String string7 = CertAdminUtil.question(CertAdminLocale.getPFString("q7", "What is the two-letter country code for this unit? []"));
        while (string7.trim().length() != 2) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m9", "Enter a valid country code!"));
            string7 = CertAdminUtil.question(CertAdminLocale.getPFString("q7", "What is the two-letter country code for this unit? []"));
        }
        CertAdminUtil.println(CertAdminHelpText.getTokenHelpText());
        String string8 = CertAdminUtil.question(CertAdminLocale.getPFString("q8", "Enter the token name []"));
        String string9 = "server-cert";
        String string10 = CertAdminUtil.question(CertAdminLocale.getPFString("q9", "Enter the name you like for this certificate [") + string9 + CertAdminLocale.getPFString("q1", "]"));
        if (string10.equals("")) {
            string10 = string9;
        }
        if (JSSUtil.certExist(jSSContext, string10)) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m10", "Certificate with the specified nickname already exist!"));
            return false;
        }
        int n2 = 6;
        String string11 = CertAdminUtil.question(CertAdminLocale.getPFString("q10", "Enter the validity period for the certificate (months) [") + n2 + CertAdminLocale.getPFString("q1", "]"));
        if (string11.trim().equals("")) {
            n = n2;
        }
        try {
            n = new Integer(string11);
        }
        catch (Exception exception) {
            n = n2;
        }
        try {
            CertAdminPasswordCallback certAdminPasswordCallback;
            Name name = new Name();
            if (!string2.equals("")) {
                name.addCommonName(string2);
            }
            if (!string5.equals("")) {
                name.addLocalityName(string5);
            }
            if (!string6.equals("")) {
                name.addStateOrProvinceName(string6);
            }
            name.addCountryName(string7);
            if (!string3.equals("")) {
                name.addOrganizationName(string3);
            }
            if (!string4.equals("")) {
                name.addOrganizationalUnitName(string4);
            }
            SecureRandom secureRandom = SecureRandom.getInstance("pkcs11prng", "Mozilla-JSS");
            int n3 = this.nextRandInt(secureRandom);
            String string12 = jSSContext.getPasswordContext().generatePassphrase(jSSContext);
            CryptoToken cryptoToken = null;
            if (string8.trim().equals("")) {
                cryptoToken = jSSContext.getCryptoManager().getInternalKeyStorageToken();
                certAdminPasswordCallback = new CertAdminPasswordCallback(string12);
                if (!cryptoToken.passwordIsInitialized()) {
                    cryptoToken.initPassword((PasswordCallback)new NullPasswordCallback(), (PasswordCallback)certAdminPasswordCallback);
                }
            } else {
                cryptoToken = jSSContext.getCryptoManager().getTokenByName(string8);
                certAdminPasswordCallback = new ConsolePasswordCallback();
                if (!cryptoToken.passwordIsInitialized()) {
                    cryptoToken.initPassword((PasswordCallback)new NullPasswordCallback(), (PasswordCallback)certAdminPasswordCallback);
                }
            }
            cryptoToken.login((PasswordCallback)certAdminPasswordCallback);
            String string13 = JSSUtil.getCertWithSubject(cryptoToken, name);
            if (string13 != null) {
                CertAdminUtil.println();
                CertAdminUtil.println(CertAdminLocale.getPFString("m63", "Certificate with the specified Subject DN already exist!"));
                CertAdminUtil.println(CertAdminLocale.getPFString("m64", "Certificate Nickname:") + " " + string13);
                CertAdminUtil.println(CertAdminLocale.getPFString("m65", "Certificate Subject DN:") + " " + name.getRFC1485());
                CertAdminUtil.println(CertAdminLocale.getPFString("m66", "Retry deleting the certificate or change the Subject DN for the new certificate"));
                CertAdminUtil.question(CertAdminLocale.getPFString("m67", "Hit Return to continue!!"));
                CertAdminUtil.println(CertAdminConstants.newline);
                return false;
            }
            CertAdminUtil.println(CertAdminLocale.getPFString("m11", "Generating self-signed certificate..."));
            CertAdminUtil.println(CertAdminLocale.getPFString("m12", "Generating key.  This may take a few moments..."));
            KeyPairGenerator keyPairGenerator = cryptoToken.getKeyPairGenerator(KeyPairAlgorithm.RSA);
            keyPairGenerator.initialize(1024);
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            Certificate certificate = this.makeCert(name, name, n3, keyPair.getPrivate(), keyPair.getPublic(), null, n);
            JSSUtil.verifyCertificate(certificate);
            jSSContext.getCryptoManager().importCertPackage(ASN1Util.encode((ASN1Value)certificate), string10);
            String string14 = jSSContext.getCertdir() + CertAdminConstants.SEPERATOR + ".nickname";
            if (CertAdminUtil.fileExist(string14) && !CertAdminUtil.delete(string14)) {
                CertAdminUtil.println(CertAdminLocale.getPFString("m46", "Could not delete the .nickname file!"));
            }
            if (!CertAdminUtil.writeLine(string10, string14)) {
                CertAdminUtil.println(CertAdminLocale.getPFString("m47", "Could not update .nickname file. Please update it manually!"));
                CertAdminUtil.println(CertAdminConstants.newline);
                CertAdminUtil.println(CertAdminLocale.getPFString("m48", ".nickname file location : "));
            }
        }
        catch (Exception exception) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m13", "Could not generate the self signed certificate!"));
            exception.printStackTrace();
            return false;
        }
        CertAdminUtil.println(CertAdminLocale.getPFString("m14", "Generated 1024-bit RSA KeyPair"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m15", "Self-signed certificate generated"));
        return true;
    }

    public boolean execute(JSSContext jSSContext, CertContext certContext) {
        this.cntx = jSSContext;
        if (JSSUtil.certExist(jSSContext, certContext.nick)) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m10", "Certificate with the specified nickname already exist!"));
            return false;
        }
        try {
            CertAdminPasswordCallback certAdminPasswordCallback;
            Name name = new Name();
            if (!certContext.fqdn.equals("")) {
                name.addCommonName(certContext.fqdn);
            }
            if (!certContext.l.equals("")) {
                name.addLocalityName(certContext.l);
            }
            if (!certContext.s.equals("")) {
                name.addStateOrProvinceName(certContext.s);
            }
            name.addCountryName(certContext.c);
            if (!certContext.o.equals("")) {
                name.addOrganizationName(certContext.o);
            }
            if (!certContext.ou.equals("")) {
                name.addOrganizationalUnitName(certContext.ou);
            }
            SecureRandom secureRandom = SecureRandom.getInstance("pkcs11prng", "Mozilla-JSS");
            int n = this.nextRandInt(secureRandom);
            String string = jSSContext.getPasswordContext().generatePassphrase(jSSContext);
            CryptoToken cryptoToken = null;
            if (certContext.token.trim().equals("")) {
                cryptoToken = jSSContext.getCryptoManager().getInternalKeyStorageToken();
                certAdminPasswordCallback = new CertAdminPasswordCallback(string);
                if (!cryptoToken.passwordIsInitialized()) {
                    cryptoToken.initPassword((PasswordCallback)new NullPasswordCallback(), (PasswordCallback)certAdminPasswordCallback);
                }
            } else {
                cryptoToken = jSSContext.getCryptoManager().getTokenByName(certContext.token);
                certAdminPasswordCallback = new ConsolePasswordCallback();
                if (!cryptoToken.passwordIsInitialized()) {
                    cryptoToken.initPassword((PasswordCallback)new NullPasswordCallback(), (PasswordCallback)certAdminPasswordCallback);
                }
            }
            cryptoToken.login((PasswordCallback)certAdminPasswordCallback);
            String string2 = JSSUtil.getCertWithSubject(cryptoToken, name);
            if (string2 != null) {
                CertAdminUtil.println(CertAdminLocale.getPFString("m63", "Certificate with the specified Subject DN already exist!"));
                CertAdminUtil.println(CertAdminLocale.getPFString("m64", "Certificate Nickname:") + " " + string2);
                CertAdminUtil.println(CertAdminLocale.getPFString("m65", "Certificate Subject DN:") + " " + name.getRFC1485());
                CertAdminUtil.println(CertAdminLocale.getPFString("m66", "Retry deleting the certificate or change the Subject DN for the new certificate"));
                CertAdminUtil.question(CertAdminLocale.getPFString("m67", "Hit Return to continue!!"));
                CertAdminUtil.println(CertAdminConstants.newline);
                return false;
            }
            KeyPairGenerator keyPairGenerator = cryptoToken.getKeyPairGenerator(KeyPairAlgorithm.RSA);
            keyPairGenerator.initialize(1024);
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            Certificate certificate = this.makeCert(name, name, n, keyPair.getPrivate(), keyPair.getPublic(), null, certContext.val);
            JSSUtil.verifyCertificate(certificate);
            jSSContext.getCryptoManager().importCertPackage(ASN1Util.encode((ASN1Value)certificate), certContext.nick);
            String string3 = jSSContext.getCertdir() + CertAdminConstants.SEPERATOR + ".nickname";
            if (CertAdminUtil.fileExist(string3) && !CertAdminUtil.delete(string3)) {
                CertAdminUtil.println(CertAdminLocale.getPFString("m46", "Could not delete the .nickname file!"));
            }
            if (!CertAdminUtil.writeLine(certContext.nick, string3)) {
                CertAdminUtil.println(CertAdminLocale.getPFString("m47", "Could not update .nickname file. Please update it manually!"));
                CertAdminUtil.println(CertAdminConstants.newline);
                CertAdminUtil.println(CertAdminLocale.getPFString("m48", ".nickname file location : "));
            }
        }
        catch (Exception exception) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m13", "Could not generate the self signed certificate!"));
            exception.printStackTrace();
            return false;
        }
        CertAdminUtil.println(CertAdminLocale.getPFString("m14", "Generated 1024-bit RSA KeyPair"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m15", "Self-signed certificate generated"));
        return true;
    }

    protected Certificate makeCert(Name name, Name name2, int n, PrivateKey privateKey, PublicKey publicKey, SEQUENCE sEQUENCE, int n2) throws Exception {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(this.cntx.getSigAlg().toOID());
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        calendar.add(2, n2);
        Date date2 = calendar.getTime();
        SubjectPublicKeyInfo.Template template = new SubjectPublicKeyInfo.Template();
        SubjectPublicKeyInfo subjectPublicKeyInfo = (SubjectPublicKeyInfo)ASN1Util.decode((ASN1Template)template, (byte[])publicKey.getEncoded());
        CertificateInfo certificateInfo = new CertificateInfo(CertificateInfo.v3, new INTEGER((long)n), algorithmIdentifier, name, date, date2, name2, subjectPublicKeyInfo);
        if (sEQUENCE != null) {
            certificateInfo.setExtensions(sEQUENCE);
        }
        return new Certificate(certificateInfo, privateKey, this.cntx.getSigAlg());
    }

    protected Extension makeBasicConstraintsExtension() throws Exception {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addElement((ASN1Value)new BOOLEAN(true));
        OBJECT_IDENTIFIER oBJECT_IDENTIFIER = new OBJECT_IDENTIFIER(new long[]{2L, 5L, 29L, 19L});
        OCTET_STRING oCTET_STRING = new OCTET_STRING(ASN1Util.encode((ASN1Value)sEQUENCE));
        return new Extension(oBJECT_IDENTIFIER, true, oCTET_STRING);
    }

    protected int nextRandInt(SecureRandom secureRandom) throws Exception {
        byte[] byArray = new byte[4];
        secureRandom.nextBytes(byArray);
        return byArray[0] << 24 | byArray[1] << 16 | byArray[2] << 8 | byArray[3];
    }
}

