/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.Codecs;
import HTTPClient.HashVerifier;
import HTTPClient.Log;
import HTTPClient.RoResponse;
import java.io.IOException;

class VerifyMD5
implements HashVerifier {
    RoResponse resp;

    public VerifyMD5(RoResponse roResponse) {
        this.resp = roResponse;
    }

    public void verifyHash(byte[] byArray, long l) throws IOException {
        String string;
        try {
            string = this.resp.getHeader("Content-MD5");
            if (string == null) {
                string = this.resp.getTrailer("Content-MD5");
            }
        }
        catch (IOException iOException) {
            return;
        }
        if (string == null) {
            return;
        }
        byte[] byArray2 = Codecs.base64Decode(string.trim().getBytes("8859_1"));
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                throw new IOException("MD5-Digest mismatch: expected " + VerifyMD5.hex(byArray2) + " but calculated " + VerifyMD5.hex(byArray));
            }
            ++n;
        }
        Log.write(32, "CMD5M: hash successfully verified");
    }

    private static String hex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 3);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(Character.forDigit(byArray[n] >>> 4 & 0xF, 16));
            stringBuffer.append(Character.forDigit(byArray[n] & 0xF, 16));
            stringBuffer.append(':');
            ++n;
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }
}

