/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter.calendar.pim;

import com.aligo.pim.PimFolderType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.interfaces.PimAppointmentItem;
import com.aligo.pim.interfaces.PimAppointmentItemFilter;
import com.aligo.pim.interfaces.PimAppointmentItems;
import com.aligo.pim.interfaces.PimCalendar;
import com.aligo.pim.interfaces.PimContainer;
import com.aligo.pim.interfaces.PimTask;
import com.aligo.pim.interfaces.PimTaskItem;
import com.aligo.pim.interfaces.PimTaskItemFilter;
import com.aligo.pim.interfaces.PimTaskItems;
import com.sun.comclient.calendar.CalendarComponent;
import com.sun.comclient.calendar.CalendarException;
import com.sun.comclient.calendar.CalendarSession;
import com.sun.comclient.calendar.CalendarStore;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.ICalendar;
import com.sun.comclient.calendar.OperationNotSupportedException;
import com.sun.comclient.calendar.VEvent;
import com.sun.comclient.calendar.VTodo;
import com.sun.ssoadapter.calendar.pim.APimCalStore;
import com.sun.ssoadapter.calendar.pim.APimEvent;
import com.sun.ssoadapter.calendar.pim.APimTask;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;

public class APimCalendar
extends ICalendar {
    private PimContainer pimContainer = null;

    PimCalendar getCalendarFolder() throws PimException {
        return (PimCalendar)this.pimContainer.getFolder(PimFolderType.CALENDAR);
    }

    PimTask getTaskFolder() throws PimException {
        return (PimTask)this.pimContainer.getFolder(PimFolderType.TASK);
    }

    PimAppointmentItems getAppointmentItems() throws PimException {
        return this.getCalendarFolder().getAppointmentItems();
    }

    PimTaskItems getTaskItems() throws PimException {
        return this.getTaskFolder().getTaskItems();
    }

    public APimCalendar(CalendarStore store, String calId) throws CalendarException {
        super(store, calId);
        APimCalStore eStore = (APimCalStore)store;
        this.pimContainer = eStore.getPimContainer();
    }

    public VEvent createEvent() throws OperationNotSupportedException {
        try {
            return new APimEvent(this, null, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OperationNotSupportedException(e.getMessage());
        }
    }

    public VTodo createTodo() throws OperationNotSupportedException {
        try {
            return new APimTask(this, null, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OperationNotSupportedException(e.getMessage());
        }
    }

    public String getDisplayName() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("Method getDisplayName() not supported");
    }

    public VTodo[] fetchTodos(String uid, String rid, String modifier) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("Method fetchTodos(String, String, String) not supported");
    }

    public VEvent[] fetchEvents(String uid, String rid, String modifier) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("Method fetchEvents(String, String, String) not supported");
    }

    public CalendarComponent[] fetchComponents(DateTime start, DateTime end, int types) throws CalendarException {
        VEvent[] events = null;
        VTodo[] tasks = null;
        try {
            if ((types & 1) != 0) {
                PimAppointmentItems appItems = this.getAppointmentItems();
                PimAppointmentItemFilter appFilter = appItems.getAppointmentItemFilter();
                appFilter.setStartTime(start.getTime());
                appFilter.setEndTime(end.getTime());
                events = this.toEvents(appItems);
                if (types == 1) {
                    return events;
                }
            }
            if ((types & 2) != 0) {
                PimTaskItems taskItems = this.getTaskItems();
                PimTaskItemFilter taskFilter = taskItems.getTaskItemFilter();
                taskFilter.setStartDate(start.getTime());
                taskFilter.setDueDate(end.getTime());
                tasks = this.toTasks(taskItems);
                if (types == 2) {
                    return tasks;
                }
            }
            if ((types & 4) != 0) {
                // empty if block
            }
            int len = 0;
            if (events != null) {
                len += events.length;
            }
            if (tasks != null) {
                len += tasks.length;
            }
            CalendarComponent[] cc = new CalendarComponent[len];
            int i = 0;
            i = 0;
            while (i < events.length) {
                cc[i] = events[i];
                ++i;
            }
            int j = 0;
            while (j < tasks.length) {
                cc[i] = tasks[j];
                ++i;
                ++j;
            }
            return cc;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CalendarException(e.getMessage());
        }
    }

    public CalendarComponent[] fetchComponents(String uid, String rid, String modifier) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("Method fetchComponents(String, String, String) not supported");
    }

    public void addEvent(VEvent event, boolean notify) throws CalendarException {
        try {
            APimEvent pimEvent = (APimEvent)event;
            pimEvent.update();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CalendarException(e.getMessage());
        }
    }

    public void addTodo(VTodo task, boolean notify) throws CalendarException {
        try {
            APimTask pimTask = (APimTask)task;
            pimTask.update();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CalendarException(e.getMessage());
        }
    }

    public void modifyEvent(VEvent event, String modifier, boolean notify) throws CalendarException {
        try {
            APimEvent pimEvent = (APimEvent)event;
            pimEvent.update();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CalendarException(e.getMessage());
        }
    }

    public void modifyTodo(VTodo task, String modifier, boolean notify) throws CalendarException {
        try {
            APimTask pimTask = (APimTask)task;
            pimTask.update();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CalendarException(e.getMessage());
        }
    }

    public void deleteEvent(VEvent event, String modifier, boolean notify) throws CalendarException {
        try {
            APimEvent pimEvent = (APimEvent)event;
            pimEvent.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CalendarException(e.getMessage());
        }
    }

    public void deleteTodo(VTodo task, String modifier, boolean notify) throws CalendarException {
        try {
            APimTask pimTask = (APimTask)task;
            pimTask.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CalendarException(e.getMessage());
        }
    }

    public Properties getCalProps() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("Method getCalProps() not supported");
    }

    public void setCalProps(Properties props) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("Method getCalProps() not supported");
    }

    private VEvent[] toEvents(PimAppointmentItems pItems) throws PimException {
        if (pItems == null) {
            return null;
        }
        Vector<APimEvent> tmp = new Vector<APimEvent>();
        PimAppointmentItem pItem = pItems.getFirstAppointmentItem();
        while (pItem != null) {
            tmp.addElement(new APimEvent(this, pItem));
            pItem = pItems.getNextAppointmentItem();
        }
        return tmp.toArray(new APimEvent[tmp.size()]);
    }

    private VTodo[] toTasks(PimTaskItems tItems) throws PimException {
        if (tItems == null) {
            return null;
        }
        Vector<APimTask> tmp = new Vector<APimTask>();
        PimTaskItem tItem = tItems.getFirstTaskItem();
        while (tItem != null) {
            tmp.addElement(new APimTask(this, tItem));
            tItem = tItems.getNextTaskItem();
        }
        return tmp.toArray(new APimTask[tmp.size()]);
    }

    public boolean isUserTheOwner(String id) {
        return true;
    }

    public String toString() {
        return "APimCalendar: " + this.calId;
    }

    public String toRFC2445() {
        return null;
    }

    public void setTimeZone(TimeZone tz) {
        CalendarStore cs = this.getStore();
        CalendarSession session = cs.getSession();
        session.setTimeZone(tz);
    }

    public TimeZone getTimeZone() {
        CalendarStore cs = this.getStore();
        CalendarSession session = cs.getSession();
        return session.getTimeZone();
    }
}

