/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.rom;

import com.sun.portal.rewriter.rom.DataRuleCollection;
import com.sun.portal.rewriter.rom.InvalidXMLException;
import com.sun.portal.rewriter.rom.RecursiveRuleCollection;
import com.sun.portal.rewriter.rom.RuleCollection;
import com.sun.portal.rewriter.rom.RuleSetManager;
import com.sun.portal.rewriter.rom.html.HTMLRules;
import com.sun.portal.rewriter.rom.js.JSRules;
import com.sun.portal.rewriter.rom.xml.XMLRules;
import com.sun.portal.rewriter.test.util.SampleRuleObjects;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.xml.Node;

public final class RuleSet
extends RecursiveRuleCollection {
    private static final String XPATH_SPERATOR = "\\";
    private static final String XPATH_ROOT = "\\\\";
    private static final String RULESET_XPATH = "\\\\RuleSet";
    private static final String HTMLRULES_XPATH = "\\\\RuleSet\\HTMLRules";
    private static final String JSRULES_XPATH = "\\\\RuleSet\\JSRules";
    private static final String XMLRULES_XPATH = "\\\\RuleSet\\XMLRules";
    private String cacheRuleSetXML;
    private final String id;
    private final String parentRuleSetID;
    private final RuleSet parentRuleSet;
    private HTMLRules htmlRules;
    private JSRules jsRules;
    private XMLRules xmlRules;

    public RuleSet(String aID, RuleCollection[] aCollection) throws InvalidXMLException {
        this(aID, null, aCollection);
    }

    public RuleSet(String aID, String aChildRuleSetID, RuleCollection[] aCollection) throws InvalidXMLException {
        super("RuleSet", aCollection);
        this.id = this.checkID(aID);
        this.parentRuleSetID = StringHelper.normalize(aChildRuleSetID, "none");
        this.parentRuleSet = RuleSetManager.getDefault() != null ? RuleSetManager.getDefault().fetchRuleSet(this.parentRuleSetID) : null;
    }

    protected RuleSet(Node aNode) throws InvalidXMLException {
        this(aNode.getAttributeValue("id"), aNode.getAttributeValue("extends"), null);
        this.addRuleCollection(new HTMLRules(aNode.selectNode(HTMLRULES_XPATH)));
        this.addRuleCollection(new JSRules(aNode.selectNode(JSRULES_XPATH)));
        this.addRuleCollection(new XMLRules(aNode.selectNode(XMLRULES_XPATH)));
    }

    private String checkID(String aID) throws InvalidXMLException {
        String lResult = StringHelper.normalize(aID);
        if (!lResult.toLowerCase().equals(lResult)) {
            throw new InvalidXMLException("ID of Tag " + this.getCollectionID() + " Should be in Small Case", null, aID, 1004);
        }
        return lResult;
    }

    public String getID() {
        return this.id;
    }

    public String getParentRuleSetID() {
        return this.parentRuleSetID;
    }

    public RuleSet getParentRuleSet() {
        return this.parentRuleSet;
    }

    public HTMLRules getHTMLRules() {
        if (this.htmlRules == null) {
            this.htmlRules = (HTMLRules)this.getRuleCollection("HTMLRules");
        }
        return this.htmlRules;
    }

    public JSRules getJSRules() {
        if (this.jsRules == null) {
            this.jsRules = (JSRules)this.getRuleCollection("JSRules");
        }
        return this.jsRules;
    }

    public XMLRules getXMLRules() {
        if (this.xmlRules == null) {
            this.xmlRules = (XMLRules)this.getRuleCollection("XMLRules");
        }
        return this.xmlRules;
    }

    public DataRuleCollection getDataRuleCollection(String aFirstTag, String aSecondTag) {
        RecursiveRuleCollection lRecursiveRuleCollection = (RecursiveRuleCollection)this.getRuleCollection(aFirstTag);
        return (DataRuleCollection)lRecursiveRuleCollection.getRuleCollection(aSecondTag);
    }

    public final StringBuffer writeCustomAttributes(StringBuffer aBuffer) {
        aBuffer.insert(0, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE RuleSet SYSTEM \"jar://rewriter.jar/resources/RuleSet.dtd\">\n");
        aBuffer.append(" ").append("id").append("=\"").append(this.getID()).append("\"");
        if (!this.parentRuleSetID.equals("none")) {
            aBuffer.append(" ").append("extends").append("=\"").append(this.parentRuleSetID).append("\"");
        }
        return aBuffer;
    }

    public String toString() {
        if (this.cacheRuleSetXML == null) {
            this.cacheRuleSetXML = this.toXML();
        }
        return this.cacheRuleSetXML;
    }

    public static void main(String[] args) {
        String xmlString = SampleRuleObjects.defaultRuleSet.toXML();
        Debug.println(xmlString);
    }
}

