/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.PimSortType;
import com.aligo.pim.interfaces.PimItem;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimMessageItemFilter;
import com.aligo.pim.interfaces.PimTaskItem;
import com.aligo.pim.interfaces.PimTaskItemFilter;
import com.aligo.pim.interfaces.PimTaskItems;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimItems;
import com.aligo.pim.lotus.LotusPimNewTaskItem;
import com.aligo.pim.lotus.LotusPimRecurringTaskItem;
import com.aligo.pim.lotus.LotusPimSession;
import com.aligo.pim.lotus.LotusPimTaskItem;
import com.aligo.pim.lotus.LotusPimTaskItemFilter;
import com.aligo.pim.lotus.recycle.Recycle;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import lotus.domino.Database;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.View;
import lotus.domino.ViewEntry;
import lotus.domino.ViewEntryCollection;

public class LotusPimTaskItems
extends LotusPimItems
implements PimTaskItems {
    private LotusPimTaskItemFilter m_oPimTaskItemFilter;
    private RecurringTaskDateIndexManager m_oRecurringTaskDateIndexManager;
    private View _oView;

    public LotusPimTaskItems(ViewEntryCollection viewEntryCollection, LotusPimSession lotusPimSession, Recycle recycle) throws LotusPimException {
        super(lotusPimSession, recycle);
        try {
            this._oView = viewEntryCollection.getParent();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setLotusTaskItems(ViewEntryCollection viewEntryCollection) throws LotusPimException {
        try {
            this._oView = viewEntryCollection.getParent();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public ViewEntryCollection getLotusViewEntryCollection() throws Exception {
        try {
            ((LotusPimTaskItemFilter)this.getTaskItemFilter()).update();
            return ((LotusPimTaskItemFilter)this.getTaskItemFilter()).getLotusViewEntryCollection();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public View getLotusView() {
        return this._oView;
    }

    public Database getLotusDatabase() throws LotusPimException {
        try {
            Database database = this._oView.getParent();
            return database;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimTaskItem addTaskItem() throws LotusPimException {
        try {
            return new LotusPimNewTaskItem(this.getLotusViewEntryCollection(), this.getLotusPimSession(), this.getRecycle());
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimTaskItemFilter getTaskItemFilter() throws LotusPimException {
        try {
            if (this.m_oPimTaskItemFilter == null) {
                this.m_oPimTaskItemFilter = new LotusPimTaskItemFilter(this, this.getLotusPimSession(), this.getRecycle());
            }
            return this.m_oPimTaskItemFilter;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimMessageItemFilter getMessageItemFilter() throws LotusPimException {
        return this.getTaskItemFilter();
    }

    public ViewEntry getViewEntry(int n) throws LotusPimException {
        try {
            if (this.getCount() <= 0 || n >= this.getCount() || n < 0) {
                return null;
            }
            ViewEntry viewEntry = this.getLotusViewEntryCollection().getNthEntry(n + 1);
            this.getRecycle().add(viewEntry);
            return viewEntry;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private boolean isItRecurringTask(ViewEntry viewEntry) throws LotusPimException {
        try {
            String string = viewEntry.getNoteID();
            Document document = this.getLotusDatabase().getDocumentByID(string);
            if (document == null) {
                return false;
            }
            this.getRecycle().add(document);
            String string2 = document.getItemValueString("OrgRepeat");
            String string3 = document.getItemValueString("Repeats");
            return string2 != null && string2.equals("1") && string3.equals("1");
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimTaskItem getTaskItem(int n) throws LotusPimException {
        try {
            ViewEntry viewEntry = this.getViewEntry(n);
            if (viewEntry == null) {
                return null;
            }
            String string = viewEntry.getNoteID();
            Document document = this.getLotusDatabase().getDocumentByID(string);
            if (document == null) {
                return this.getTaskItem(n + 1);
            }
            this.getRecycle().add(document);
            String string2 = document.getItemValueString("Form");
            if (string2 != null && string2.equals("Task")) {
                if (this.isItRecurringTask(viewEntry)) {
                    return new LotusPimRecurringTaskItem(viewEntry, this.getIndexManager().getFirstIndex(viewEntry), this.getIndexManager().getFirstIndex(viewEntry), this.getLotusPimSession(), this.getRecycle());
                }
                return new LotusPimTaskItem(viewEntry, this.getLotusPimSession(), this.getRecycle());
            }
            return this.getTaskItem(n + 1);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimTaskItem getTaskItem(String string) throws LotusPimException {
        try {
            Document document;
            Object object;
            int n = string.indexOf("+");
            if (n != -1) {
                Document document2;
                Object object2;
                object = null;
                int n2 = -1;
                int n3 = -1;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "+");
                if (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                    object2 = new StringTokenizer(stringTokenizer.nextToken(), ":");
                    n2 = Integer.parseInt(((StringTokenizer)object2).nextToken());
                    n3 = Integer.parseInt(((StringTokenizer)object2).nextToken());
                }
                if ((object2 = this.getLotusDatabase()) != null && (document2 = object2.getDocumentByID((String)object)) != null) {
                    this.getRecycle().add(document2);
                    return new LotusPimRecurringTaskItem(document2, n2, n3, this.getLotusPimSession(), this.getRecycle());
                }
            }
            if ((object = this.getLotusDatabase()) != null && (document = object.getDocumentByUNID(string)) != null) {
                this.getRecycle().add(document);
                LotusPimTaskItem lotusPimTaskItem = new LotusPimTaskItem(document, this.getLotusPimSession(), this.getRecycle());
                return lotusPimTaskItem;
            }
            return null;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimTaskItem getFirstTaskItem() throws LotusPimException {
        try {
            this.getIndexManager().clearHash();
            ViewEntry viewEntry = this.getViewEntry(this.getFirstIndex());
            if (viewEntry == null) {
                return null;
            }
            String string = viewEntry.getNoteID();
            Document document = this.getLotusDatabase().getDocumentByID(string);
            if (document == null) {
                return this.getNextTaskItem();
            }
            this.getRecycle().add(document);
            String string2 = document.getItemValueString("Form");
            if (string2 != null && string2.equals("Task")) {
                if (this.isItRecurringTask(viewEntry)) {
                    int n = this.getIndexManager().getFirstIndex(viewEntry);
                    return new LotusPimRecurringTaskItem(viewEntry, n, n, this.getLotusPimSession(), this.getRecycle());
                }
                return new LotusPimTaskItem(viewEntry, this.getLotusPimSession(), this.getRecycle());
            }
            return this.getNextTaskItem();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimTaskItem getLastTaskItem() throws LotusPimException {
        try {
            ViewEntry viewEntry = this.getViewEntry(this.getLastIndex());
            if (viewEntry == null) {
                return null;
            }
            String string = viewEntry.getNoteID();
            Document document = this.getLotusDatabase().getDocumentByID(string);
            if (document == null) {
                return this.getPreviousTaskItem();
            }
            this.getRecycle().add(document);
            String string2 = document.getItemValueString("Form");
            if (string2 != null && string2.equals("Task")) {
                if (this.isItRecurringTask(viewEntry)) {
                    int n = this.getIndexManager().getLastIndex(viewEntry);
                    return new LotusPimRecurringTaskItem(viewEntry, n, n, this.getLotusPimSession(), this.getRecycle());
                }
                return new LotusPimTaskItem(viewEntry, this.getLotusPimSession(), this.getRecycle());
            }
            return this.getPreviousTaskItem();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimTaskItem getNextTaskItem() throws LotusPimException {
        try {
            ViewEntry viewEntry = this.getViewEntry(this.getNextIndex());
            if (viewEntry == null) {
                return null;
            }
            String string = viewEntry.getNoteID();
            Document document = this.getLotusDatabase().getDocumentByID(string);
            if (document == null) {
                return this.getNextTaskItem();
            }
            this.getRecycle().add(document);
            String string2 = document.getItemValueString("Form");
            if (string2 != null && string2.equals("Task")) {
                if (this.isItRecurringTask(viewEntry)) {
                    int n = this.getIndexManager().getNextIndex(viewEntry);
                    return new LotusPimRecurringTaskItem(viewEntry, n, n, this.getLotusPimSession(), this.getRecycle());
                }
                return new LotusPimTaskItem(viewEntry, this.getLotusPimSession(), this.getRecycle());
            }
            return this.getNextTaskItem();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimTaskItem getPreviousTaskItem() throws LotusPimException {
        try {
            ViewEntry viewEntry = this.getViewEntry(this.getPreviousIndex());
            if (viewEntry == null) {
                return null;
            }
            String string = viewEntry.getNoteID();
            Document document = this.getLotusDatabase().getDocumentByID(string);
            if (document == null) {
                return this.getPreviousTaskItem();
            }
            this.getRecycle().add(document);
            String string2 = document.getItemValueString("Form");
            if (string2 != null && string2.equals("Task")) {
                if (this.isItRecurringTask(viewEntry)) {
                    int n = this.getIndexManager().getPreviousIndex(viewEntry);
                    return new LotusPimRecurringTaskItem(viewEntry, n, n, this.getLotusPimSession(), this.getRecycle());
                }
                return new LotusPimTaskItem(viewEntry, this.getLotusPimSession(), this.getRecycle());
            }
            return this.getPreviousTaskItem();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public int getCount() throws LotusPimException {
        try {
            return this.getLotusViewEntryCollection().getCount();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void delete() throws LotusPimException {
        try {
            this.getLotusViewEntryCollection().removeAll(true);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void sort(PimSortType pimSortType) throws LotusPimException {
    }

    public PimItem addItem() throws LotusPimException {
        return this.addMessageItem();
    }

    public PimItem getItem(int n) throws LotusPimException {
        return this.getMessageItem(n);
    }

    public PimItem getItem(String string) throws LotusPimException {
        return this.getMessageItem(string);
    }

    public PimItem getFirstItem() throws LotusPimException {
        return this.getFirstMessageItem();
    }

    public PimItem getLastItem() throws LotusPimException {
        return this.getLastMessageItem();
    }

    public PimItem getNextItem() throws LotusPimException {
        return this.getNextMessageItem();
    }

    public PimItem getPreviousItem() throws LotusPimException {
        return this.getPreviousMessageItem();
    }

    public PimMessageItem addMessageItem() throws LotusPimException {
        return this.addTaskItem();
    }

    public PimMessageItem getMessageItem(int n) throws LotusPimException {
        return this.getTaskItem(n);
    }

    public PimMessageItem getMessageItem(String string) throws LotusPimException {
        return this.getTaskItem(string);
    }

    public PimMessageItem getFirstMessageItem() throws LotusPimException {
        return this.getFirstTaskItem();
    }

    public PimMessageItem getLastMessageItem() throws LotusPimException {
        return this.getLastTaskItem();
    }

    public PimMessageItem getNextMessageItem() throws LotusPimException {
        return this.getNextTaskItem();
    }

    public PimMessageItem getPreviousMessageItem() throws LotusPimException {
        return this.getPreviousTaskItem();
    }

    private RecurringTaskDateIndexManager getIndexManager() {
        if (this.m_oRecurringTaskDateIndexManager == null) {
            this.m_oRecurringTaskDateIndexManager = new RecurringTaskDateIndexManager();
        }
        return this.m_oRecurringTaskDateIndexManager;
    }

    private DateTime getFilterStartDateTime() throws LotusPimException {
        try {
            return ((LotusPimTaskItemFilter)this.getTaskItemFilter()).getStartDateTime();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private DateTime getFilterEndDateTime() throws LotusPimException {
        try {
            return ((LotusPimTaskItemFilter)this.getTaskItemFilter()).getEndDateTime();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void clearHash() {
        this.getIndexManager().clearHash();
    }

    class RecurringTaskDateIndexManager {
        private HashMap mapOfNoteIdWithDateIndex = new HashMap();

        RecurringTaskDateIndexManager() {
        }

        private HashMap getHashMap() {
            return this.mapOfNoteIdWithDateIndex;
        }

        public void clearHash() {
            this.getHashMap().clear();
        }

        public int getFirstIndex(ViewEntry viewEntry) throws LotusPimException {
            try {
                if (viewEntry == null) {
                    return 0;
                }
                String string = viewEntry.getNoteID();
                if (this.getHashMap().containsKey(string)) {
                    Vector vector = (Vector)this.getHashMap().get(string);
                    int n = (Integer)vector.elementAt(0);
                    if (n < 0) {
                        n = 0;
                        vector.set(0, new Integer(n));
                    }
                    vector.set(1, new Integer(n));
                    return n;
                }
                this.insertNewEntryIntoHashMap(viewEntry);
                return this.getFirstIndex(viewEntry);
            }
            catch (Exception exception) {
                throw new LotusPimException(exception);
            }
        }

        public int getNextIndex(ViewEntry viewEntry) throws LotusPimException {
            try {
                if (viewEntry == null) {
                    return 0;
                }
                String string = viewEntry.getNoteID();
                if (this.getHashMap().containsKey(string)) {
                    Vector vector = (Vector)this.getHashMap().get(string);
                    int n = (Integer)vector.elementAt(1);
                    int n2 = (Integer)vector.elementAt(0);
                    int n3 = (Integer)vector.elementAt(2);
                    if (++n < n2 || n > n3) {
                        n = n2;
                    }
                    vector.set(1, new Integer(n));
                    return n;
                }
                this.insertNewEntryIntoHashMap(viewEntry);
                return this.getNextIndex(viewEntry);
            }
            catch (Exception exception) {
                throw new LotusPimException(exception);
            }
        }

        public int getPreviousIndex(ViewEntry viewEntry) throws LotusPimException {
            try {
                if (viewEntry == null) {
                    return 0;
                }
                String string = viewEntry.getNoteID();
                if (this.getHashMap().containsKey(string)) {
                    Vector vector = (Vector)this.getHashMap().get(string);
                    int n = (Integer)vector.elementAt(1);
                    int n2 = (Integer)vector.elementAt(0);
                    int n3 = (Integer)vector.elementAt(2);
                    if (--n < n2 || n > n3) {
                        n = n3;
                    }
                    vector.set(1, new Integer(n));
                    return n;
                }
                this.insertNewEntryIntoHashMap(viewEntry);
                return this.getPreviousIndex(viewEntry);
            }
            catch (Exception exception) {
                throw new LotusPimException(exception);
            }
        }

        public int getLastIndex(ViewEntry viewEntry) throws LotusPimException {
            try {
                if (viewEntry == null) {
                    return 0;
                }
                String string = viewEntry.getNoteID();
                if (this.getHashMap().containsKey(string)) {
                    Vector vector = (Vector)this.getHashMap().get(string);
                    int n = (Integer)vector.elementAt(2);
                    if (n < 0) {
                        n = 0;
                    }
                    vector.set(1, new Integer(n));
                    return n;
                }
                this.insertNewEntryIntoHashMap(viewEntry);
                return this.getLastIndex(viewEntry);
            }
            catch (Exception exception) {
                throw new LotusPimException(exception);
            }
        }

        private void insertNewEntryIntoHashMap(ViewEntry viewEntry) throws LotusPimException {
            try {
                Document document = LotusPimTaskItems.this.getLotusDatabase().getDocumentByID(viewEntry.getNoteID());
                if (document == null) {
                    return;
                }
                LotusPimTaskItems.this.getRecycle().add(document);
                Vector vector = document.getItemValue("StartDateTime");
                Vector vector2 = document.getItemValue("DueDateTime");
                DateTime dateTime = LotusPimTaskItems.this.getFilterStartDateTime();
                DateTime dateTime2 = LotusPimTaskItems.this.getFilterEndDateTime();
                int n = -1;
                int n2 = -1;
                int n3 = 0;
                while (n3 < vector.size()) {
                    DateTime dateTime3 = (DateTime)vector.elementAt(n3);
                    int n4 = dateTime3.timeDifference(dateTime);
                    if (n4 >= 0) {
                        n = n3;
                        break;
                    }
                    ++n3;
                }
                int n5 = vector2.size() - 1;
                while (n5 >= 0) {
                    DateTime dateTime4 = (DateTime)vector2.elementAt(n5);
                    int n6 = dateTime4.timeDifference(dateTime2);
                    if (n6 <= 0) {
                        n2 = n5;
                        break;
                    }
                    --n5;
                }
                if (n < 0) {
                    n = 0;
                }
                if (n2 < 0) {
                    n2 = 0;
                }
                Vector<Integer> vector3 = new Vector<Integer>();
                vector3.add(0, new Integer(n));
                vector3.add(1, new Integer(-1));
                vector3.add(2, new Integer(n2));
                this.getHashMap().put(viewEntry.getNoteID(), vector3);
            }
            catch (Exception exception) {
                throw new LotusPimException(exception);
            }
        }
    }
}

