/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import com.aligo.pim.PimFieldType;
import com.aligo.pim.PimSortType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimGlobalAddressEntryItems;
import com.aligo.pim.exchangewebdav.util.StringUtility;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimAddressEntryItemFilter;
import com.aligo.pim.interfaces.PimAddressEntryItems;
import com.aligo.pim.interfaces.PimItem;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimMessageItemFilter;

public class ExWebDavPimGlobalAddressEntryItemsProxy
implements PimAddressEntryItems {
    private ExWebDavPimGlobalAddressEntryItems m_oPimAddressEntryItems;
    private boolean m_bIsFilterCalled = false;
    private PimAddressEntryItem m_oPreviousAddressEntryItem;
    private String m_szPreviousFilterCriteria = "";

    public ExWebDavPimGlobalAddressEntryItemsProxy(ExWebDavPimGlobalAddressEntryItems pimAddressEntryItems) {
        this.m_oPimAddressEntryItems = pimAddressEntryItems;
    }

    public PimAddressEntryItem addAddressEntryItem() throws ExWebDavPimException {
        return null;
    }

    public PimAddressEntryItemFilter getAddressEntryItemFilter() throws ExWebDavPimException {
        this.m_bIsFilterCalled = true;
        return this.m_oPimAddressEntryItems.getAddressEntryItemFilter();
    }

    public int getCount() throws ExWebDavPimException {
        try {
            return this.m_oPimAddressEntryItems.getCount();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public PimAddressEntryItem getAddressEntryItem(int itemNumber) throws ExWebDavPimException {
        try {
            if (this.m_bIsFilterCalled) {
                return this.m_oPimAddressEntryItems.getAddressEntryItem(itemNumber);
            }
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressEntryItem getAddressEntryItem(String id) throws ExWebDavPimException {
        try {
            return this.m_oPimAddressEntryItems.getAddressEntryItem(id);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void prepareAddressEntryItems(String filterCriteria) throws ExWebDavPimException {
        try {
            this.m_oPimAddressEntryItems.clearCache();
            PimAddressEntryItemFilter pimAddressEntryItemFilter = this.m_oPimAddressEntryItems.getAddressEntryItemFilter();
            pimAddressEntryItemFilter.setName(filterCriteria);
            this.m_szPreviousFilterCriteria = filterCriteria;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressEntryItem getFirstAddressEntryItem() throws ExWebDavPimException {
        try {
            if (this.m_bIsFilterCalled) {
                return this.m_oPimAddressEntryItems.getFirstAddressEntryItem();
            }
            return this.getFirstAddressEntryItem("a");
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressEntryItem getFirstAddressEntryItem(String filterCriteria) throws ExWebDavPimException {
        try {
            this.prepareAddressEntryItems(filterCriteria);
            PimAddressEntryItem pimAddressEntryItem = this.m_oPimAddressEntryItems.getFirstAddressEntryItem();
            if (pimAddressEntryItem == null) {
                String anotherFilterCriteria = StringUtility.advanceFilterString(filterCriteria);
                if (anotherFilterCriteria == null) {
                    return null;
                }
                return this.getFirstAddressEntryItem(anotherFilterCriteria);
            }
            if (this.m_oPreviousAddressEntryItem != null && this.m_oPreviousAddressEntryItem.getName().equals(pimAddressEntryItem.getName())) {
                return this.getNextAddressEntryItem();
            }
            this.m_oPreviousAddressEntryItem = pimAddressEntryItem;
            return pimAddressEntryItem;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressEntryItem getNextAddressEntryItem() throws ExWebDavPimException {
        try {
            if (this.m_bIsFilterCalled) {
                return this.m_oPimAddressEntryItems.getNextAddressEntryItem();
            }
            PimAddressEntryItem pimAddressEntryItem = this.m_oPimAddressEntryItems.getNextAddressEntryItem();
            if (pimAddressEntryItem == null) {
                String filterCriteria = "";
                int count = this.m_oPimAddressEntryItems.getCount();
                String prevAddressName = this.m_oPreviousAddressEntryItem.getName();
                if (count > 99) {
                    this.m_oPimAddressEntryItems.getPreviousAddressEntryItem();
                    String prevPrevAddressName = this.m_oPimAddressEntryItems.getPreviousAddressEntryItem().getName();
                    int tillCommonIndex = -1;
                    int i = 0;
                    while (i < prevPrevAddressName.length()) {
                        char ch;
                        char prevch = prevPrevAddressName.charAt(i);
                        if (prevch != (ch = prevAddressName.charAt(i))) {
                            tillCommonIndex = i;
                            break;
                        }
                        ++i;
                    }
                    if (tillCommonIndex == -1) {
                        tillCommonIndex = prevPrevAddressName.length();
                    }
                    filterCriteria = tillCommonIndex != -1 ? prevAddressName.substring(0, tillCommonIndex + 1) : prevAddressName;
                } else {
                    filterCriteria = StringUtility.advanceFilterString(this.m_szPreviousFilterCriteria);
                    if (filterCriteria == null) {
                        return null;
                    }
                }
                return this.getFirstAddressEntryItem(filterCriteria);
            }
            this.m_oPreviousAddressEntryItem = pimAddressEntryItem;
            return pimAddressEntryItem;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressEntryItem getLastAddressEntryItem() throws ExWebDavPimException {
        try {
            return this.m_oPimAddressEntryItems.getLastAddressEntryItem();
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressEntryItem getPreviousAddressEntryItem() throws ExWebDavPimException {
        try {
            return this.m_oPimAddressEntryItems.getPreviousAddressEntryItem();
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void delete() throws ExWebDavPimException {
    }

    public void sort(PimSortType type) throws ExWebDavPimException {
        try {
            this.m_oPimAddressEntryItems.sort(type);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setOrderBy(PimFieldType[] pimFieldType) throws ExWebDavPimException {
    }

    public PimMessageItemFilter getMessageItemFilter() throws ExWebDavPimException {
        return this.getAddressEntryItemFilter();
    }

    public PimMessageItem getMessageItem(int itemNumber) throws ExWebDavPimException {
        return this.getAddressEntryItem(itemNumber);
    }

    public PimMessageItem getMessageItem(String id) throws ExWebDavPimException {
        return this.getAddressEntryItem(id);
    }

    public PimMessageItem getFirstMessageItem() throws ExWebDavPimException {
        return this.getFirstAddressEntryItem();
    }

    public PimMessageItem getNextMessageItem() throws ExWebDavPimException {
        return this.getNextAddressEntryItem();
    }

    public PimMessageItem getLastMessageItem() throws ExWebDavPimException {
        return this.getLastAddressEntryItem();
    }

    public PimMessageItem getPreviousMessageItem() throws ExWebDavPimException {
        return this.getPreviousAddressEntryItem();
    }

    public PimMessageItem addMessageItem() throws ExWebDavPimException {
        return this.addAddressEntryItem();
    }

    public PimItem getItem(int itemNumber) throws ExWebDavPimException {
        return this.getMessageItem(itemNumber);
    }

    public PimItem getItem(String id) throws ExWebDavPimException {
        return this.getMessageItem(id);
    }

    public PimItem addItem() throws ExWebDavPimException {
        return this.addMessageItem();
    }

    public PimItem getFirstItem() throws ExWebDavPimException {
        return this.getFirstMessageItem();
    }

    public PimItem getNextItem() throws ExWebDavPimException {
        return this.getNextMessageItem();
    }

    public PimItem getLastItem() throws ExWebDavPimException {
        return this.getLastMessageItem();
    }

    public PimItem getPreviousItem() throws ExWebDavPimException {
        return this.getPreviousMessageItem();
    }

    public void addAddressEntryItem(PimAddressEntryItem pimAddressEntryItem) throws PimException {
    }
}

