/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar;

import com.sun.comclient.calendar.Duration;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class DateTime
extends GregorianCalendar {
    SimpleDateFormat isoFormatter;
    String isoFormat;
    String dateOnlyFormat;
    SimpleDateFormat dateFormatter;
    String dateFormat;
    static HashMap fieldmap = new HashMap(17);

    public DateTime() {
        this.isoFormat = "yyyyMMdd'T'HHmmss'Z'";
        this.dateOnlyFormat = "yyyyMMdd";
        this.dateFormat = "EEE MMM dd hh:mm:ss zzz yyyy";
        this.init();
    }

    public DateTime(TimeZone timeZone) {
        this.isoFormat = "yyyyMMdd'T'HHmmss'Z'";
        this.dateOnlyFormat = "yyyyMMdd";
        this.dateFormat = "EEE MMM dd hh:mm:ss zzz yyyy";
        this.init();
        this.setTimeZone(timeZone);
        this.computeFields();
    }

    public DateTime(int n, int n2, int n3, int n4, int n5, int n6) {
        this.isoFormat = "yyyyMMdd'T'HHmmss'Z'";
        this.dateOnlyFormat = "yyyyMMdd";
        this.dateFormat = "EEE MMM dd hh:mm:ss zzz yyyy";
        this.init();
        this.set(n, n2, n3, n4, n5, n6);
        this.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DateTime(String string) throws ParseException {
        this.isoFormat = "yyyyMMdd'T'HHmmss'Z'";
        this.dateOnlyFormat = "yyyyMMdd";
        this.dateFormat = "EEE MMM dd hh:mm:ss zzz yyyy";
        this.init();
        try {
            try {
                this.setTime(this.isoFormatter.parse(string));
            }
            catch (Exception exception) {
                this.isoFormatter.applyPattern(this.dateOnlyFormat);
                this.setTime(this.isoFormatter.parse(string));
                Object var4_3 = null;
                this.isoFormatter.applyPattern(this.isoFormat);
            }
            Object var4_2 = null;
            this.isoFormatter.applyPattern(this.isoFormat);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.isoFormatter.applyPattern(this.isoFormat);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DateTime(String string, TimeZone timeZone) throws ParseException {
        block4: {
            this.isoFormat = "yyyyMMdd'T'HHmmss'Z'";
            this.dateOnlyFormat = "yyyyMMdd";
            this.dateFormat = "EEE MMM dd hh:mm:ss zzz yyyy";
            this.init();
            TimeZone timeZone2 = this.isoFormatter.getTimeZone();
            try {
                try {
                    this.setTime(this.isoFormatter.parse(string));
                }
                catch (Exception exception) {
                    this.isoFormatter.setTimeZone(timeZone);
                    this.isoFormatter.applyPattern(this.dateOnlyFormat);
                    this.setTime(this.isoFormatter.parse(string));
                    Object var6_5 = null;
                    this.isoFormatter.applyPattern(this.isoFormat);
                    this.isoFormatter.setTimeZone(timeZone2);
                    break block4;
                }
                Object var6_4 = null;
                this.isoFormatter.applyPattern(this.isoFormat);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.isoFormatter.applyPattern(this.isoFormat);
                this.isoFormatter.setTimeZone(timeZone2);
                throw throwable;
            }
            this.isoFormatter.setTimeZone(timeZone2);
        }
        this.setTimeZone(timeZone);
        this.computeFields();
    }

    public void init() {
        this.isoFormatter = new SimpleDateFormat(this.isoFormat);
        this.isoFormatter.setTimeZone(new SimpleTimeZone(0, "GMT"));
        this.isoFormatter.setLenient(false);
        this.dateFormatter = new SimpleDateFormat(this.dateFormat);
        this.dateFormatter.setLenient(false);
    }

    public int getYear() {
        return this.get(1);
    }

    public void setYear(int n) {
        this.set(1, n);
    }

    public int getMonth() {
        return this.get(2);
    }

    public void setMonth(int n) {
        this.set(2, n);
    }

    public int getDay() {
        return this.get(5);
    }

    public void setDay(int n) {
        this.set(5, n);
    }

    public int getHours() {
        return this.get(11);
    }

    public void setHours(int n) {
        this.set(11, n);
    }

    public int getMinutes() {
        return this.get(12);
    }

    public void setMinutes(int n) {
        this.set(12, n);
    }

    public int getSeconds() {
        return this.get(13);
    }

    public void setSeconds(int n) {
        this.set(13, n);
    }

    public void setDate(int n, int n2, int n3) {
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
    }

    public void setTime(int n, int n2, int n3) {
        this.set(11, n);
        this.set(12, n2);
        this.set(13, n3);
    }

    public void add(Duration duration) {
        if (null == duration) {
            return;
        }
        int n = duration.getSign();
        this.add(3, n * duration.getWeeks());
        this.add(6, n * duration.getDays());
        this.add(11, n * duration.getHours());
        this.add(12, n * duration.getMinutes());
        this.add(13, n * duration.getSeconds());
    }

    public String toISO8601() {
        return this.isoFormatter.format(this.getTime());
    }

    public String toISOString() {
        return this.toISO8601();
    }

    public String toString() {
        this.dateFormatter.setTimeZone(this.getTimeZone());
        return this.dateFormatter.format(this.getTime());
    }

    public static Integer mapField(String string) {
        return (Integer)fieldmap.get(string);
    }

    static {
        fieldmap.put("AM", new Integer(0));
        fieldmap.put("PM", new Integer(1));
        fieldmap.put("AM_PM", new Integer(9));
        fieldmap.put("HOUR", new Integer(10));
        fieldmap.put("HOUR_OF_DAY", new Integer(11));
        fieldmap.put("MINUTE", new Integer(12));
        fieldmap.put("SECOND", new Integer(13));
        fieldmap.put("MILLISECOND", new Integer(14));
        fieldmap.put("DATE", new Integer(5));
        fieldmap.put("DAY_OF_MONTH", new Integer(5));
        fieldmap.put("DAY_OF_WEEK", new Integer(7));
        fieldmap.put("DAY_OF_YEAR", new Integer(6));
        fieldmap.put("MONTH", new Integer(2));
        fieldmap.put("YEAR", new Integer(1));
        fieldmap.put("WEEK_OF_MONTH", new Integer(4));
        fieldmap.put("WEEK_OF_YEAR", new Integer(3));
        fieldmap.put("ZONE_OFFSET", new Integer(15));
        fieldmap.put("DST_OFFSET", new Integer(16));
        fieldmap.put("ERA", new Integer(0));
    }
}

