/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.iplanet.log.LogException;
import com.iplanet.log.LogManager;
import com.iplanet.log.LogRecord;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.SSOUtil;
import com.sun.portal.util.SystemProperties;
import java.util.Hashtable;

public class NetletLogMgr {
    private static String logName = "srapNetlet";
    public static LogManager lm = null;
    public static boolean loggingEnabled = false;
    private static int logId = 0;
    public static Hashtable logIdMap = new Hashtable();
    private static String actualLogName = null;
    private static boolean logError = false;
    private static String platformLogName = null;

    public static String getUserId(String string) {
        try {
            SSOToken sSOToken = SSOUtil.getSSOToken(string);
            String string2 = sSOToken.getPrincipal().getName();
            return string2.substring(string2.indexOf("=") + 1, string2.indexOf(","));
        }
        catch (Exception exception) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("NetletLogMgr: Unable to get user ID -> " + exception);
            }
            return "";
        }
    }

    public static synchronized int getLogId() {
        return ++logId;
    }

    public static void createDefault() {
        NetletLogMgr.createDefault(logName);
    }

    private static SSOToken createSession(String string) {
        SSOToken sSOToken = null;
        try {
            sSOToken = SSOUtil.getSSOTokenNoDecode(string);
        }
        catch (SSOException sSOException) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("Unable to create application session!");
            }
            sSOException.printStackTrace();
            sSOToken = null;
        }
        catch (Exception exception) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("Unable to create application session!");
            }
            exception.printStackTrace();
            sSOToken = null;
        }
        return sSOToken;
    }

    public static void createDefault(String string) {
        block5: {
            if (loggingEnabled) {
                lm = new LogManager(GWLogManager.appSession);
                if (string != null && string.length() > 0) {
                    logName = string;
                }
                if (platformLogName != null) {
                    logName = platformLogName;
                }
                try {
                    lm.create(logName);
                    actualLogName = logName;
                }
                catch (LogException logException) {
                    actualLogName = null;
                    if (!GWDebug.debug.errorEnabled()) break block5;
                    GWDebug.debug.error("NetletLogMgr: Unable to create log");
                    GWDebug.debug.error("NetletLogMgr: " + logException.toString());
                }
            }
        }
    }

    public static void write(String string, String string2) {
        if (lm == null) {
            return;
        }
        if (logError) {
            return;
        }
        if (!loggingEnabled) {
            return;
        }
        try {
            LogRecord logRecord = new LogRecord("ACCESS", string2);
            lm.write(logRecord, logName);
        }
        catch (Exception exception) {
            String string3;
            logError = true;
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("NetletLogMgr: Unable to create log record");
                string3 = exception.toString();
                GWDebug.debug.error("NetletLogMgr: " + string3);
            }
            string3 = actualLogName;
            synchronized (string3) {
                if (logError && !NetletLogMgr.isAppSessionValid(GWLogManager.appSession)) {
                    NetletLogMgr.createDefault(actualLogName);
                    logError = false;
                }
            }
        }
    }

    private static boolean isAppSessionValid(SSOToken sSOToken) {
        boolean bl = false;
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            bl = sSOTokenManager.isValidToken(sSOToken);
        }
        catch (SSOException sSOException) {
            // empty catch block
        }
        return bl;
    }

    static {
        platformLogName = SystemProperties.get("netlet.logname");
        if (platformLogName != null && (platformLogName = platformLogName.trim().replace('-', '_')).length() == 0) {
            platformLogName = null;
        }
        loggingEnabled = GatewayProfile.getBoolean("NetletLoggingEnabled", false);
    }
}

