/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.xml;

import com.sun.portal.rewriter.rom.InvalidXMLException;
import com.sun.portal.rewriter.util.Constants;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.Resource;
import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.uri.URI;
import com.sun.portal.rewriter.util.xml.Node;
import com.sun.portal.rewriter.util.xml.Tag;
import com.sun.portal.rewriter.util.xml.TagParser;
import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class Document {
    private org.w3c.dom.Document w3cDocument;

    public Document(org.w3c.dom.Document aDocument) {
        this.w3cDocument = aDocument;
    }

    public Node getRootNode() {
        return new Node(this.w3cDocument.getDocumentElement());
    }

    public static String parseEncoding(String aXMLData) {
        String encoding;
        Tag lTag;
        String result = System.getProperty("file.encoding");
        String lHeadder = Document.parseHeadder(aXMLData);
        if (lHeadder.length() != 0 && (lTag = TagParser.parse(lHeadder.substring(2, lHeadder.length() - 2))).getName().equalsIgnoreCase("xml") && (encoding = lTag.get("encoding")) != null) {
            result = encoding;
        }
        return result;
    }

    public static String parseEncoding(byte[] aXMLData) {
        return Document.parseEncoding(new String(aXMLData));
    }

    public static String parseHeadder(String aXMLData) {
        aXMLData = StringHelper.normalize(aXMLData);
        int i = aXMLData.indexOf("<?");
        int j = aXMLData.indexOf("?>");
        if (i != -1 && j != -1) {
            return aXMLData.substring(i, j + 2);
        }
        return "";
    }

    public static Document create(byte[] aXMLBytes) throws Exception {
        return Document.create(aXMLBytes, true, true);
    }

    public static Document create(byte[] aXMLBytes, boolean aDTDCheck, boolean aNSAware) throws Exception {
        if (aXMLBytes.length == 0) {
            throw new InvalidXMLException("Key May not exist in the Store or Zero length XML Bytes supplied ", new String(aXMLBytes), null, 1002);
        }
        DocumentBuilder lDBuilder = Document.getXMLBuilder(aDTDCheck, aNSAware, true);
        org.w3c.dom.Document lDocument = lDBuilder.parse(new InputSource(new ByteArrayInputStream(aXMLBytes)));
        return new Document(lDocument);
    }

    public static Document create(String aXMLString) throws Exception {
        return Document.create(aXMLString, true, true, true);
    }

    public static Document create(String aXMLString, boolean aDTDCheck, boolean aNSAware, boolean aExpandEntities) throws Exception {
        String check = StringHelper.normalize(aXMLString);
        if (check.length() < 1) {
            throw new InvalidXMLException("Key May not exist in the Store or null XML String supplied ", aXMLString, null, 1002);
        }
        DocumentBuilder lDBuilder = Document.getXMLBuilder(aDTDCheck, aNSAware, aExpandEntities);
        org.w3c.dom.Document lDocument = lDBuilder.parse(new InputSource(new StringReader(aXMLString.toString())));
        return new Document(lDocument);
    }

    private static DocumentBuilder getXMLBuilder(boolean aDTDCheck, boolean aNSAware, boolean aExpandEntities) throws ParserConfigurationException {
        DocumentBuilderFactory lDBFactory = DocumentBuilderFactory.newInstance();
        lDBFactory.setNamespaceAware(aNSAware);
        lDBFactory.setValidating(aDTDCheck);
        lDBFactory.setExpandEntityReferences(aExpandEntities);
        DocumentBuilder lDBuilder = lDBFactory.newDocumentBuilder();
        CustomErrorHandler customHandler = new CustomErrorHandler();
        lDBuilder.setErrorHandler(customHandler);
        lDBuilder.setEntityResolver(customHandler);
        return lDBuilder;
    }

    public static Node[] selectNodes(Document aDocument, String aXPath) {
        if ((aXPath = aXPath.trim()).startsWith("\\")) {
            String[] arrayPath = StringHelper.tokenize(aXPath.substring(2), "\\", true);
            if (aDocument != null && aDocument.w3cDocument != null) {
                org.w3c.dom.Document w3cDocument = aDocument.w3cDocument;
                ArrayList<Node> lNodes = new ArrayList<Node>();
                NodeList nodeList = w3cDocument.getElementsByTagName(arrayPath[arrayPath.length - 1]);
                int i = 0;
                while (i < nodeList.getLength()) {
                    org.w3c.dom.Node childNode = nodeList.item(i);
                    int j = arrayPath.length - 2;
                    while (j >= 0) {
                        org.w3c.dom.Node parentNode = childNode.getParentNode();
                        if (parentNode.getNodeName().equals(arrayPath[j])) {
                            if (j != 0) {
                                childNode = parentNode;
                            } else {
                                lNodes.add(new Node(nodeList.item(i)));
                            }
                        }
                        --j;
                    }
                    ++i;
                }
                if (lNodes.size() > 0) {
                    return lNodes.toArray(Constants.EMPTY_NODE_ARRAY);
                }
            }
        } else {
            Debug.error("bug - in Document.java");
        }
        return Constants.EMPTY_NODE_ARRAY;
    }

    public static void main(String[] args) throws Exception {
        Document.create(Resource.read(args[0]));
    }

    private static class CustomErrorHandler
    extends DefaultHandler {
        private CustomErrorHandler() {
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI = " + systemId + " Line = " + spe.getLineNumber() + ": " + spe.getMessage();
            return info;
        }

        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            this.doRest(message, spe);
        }

        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            this.doRest(message, spe);
        }

        public void warning(SAXParseException spe) throws SAXException {
            String message = "Warning: " + this.getParseExceptionInfo(spe);
            this.doRest(message, spe);
        }

        private void doRest(String aMsg, SAXException aException) throws SAXException {
            Debug.warning(aMsg, aException);
            throw aException;
        }

        public InputSource resolveEntity(String aPublicID, String aSystemID) {
            block5: {
                if (aSystemID != null && StringHelper.startsWithIgnoreCase(aSystemID, "jar://")) {
                    try {
                        String dtdValue;
                        String resourcePath = StringHelper.normalize(new URI(aSystemID).getPath());
                        if (resourcePath.length() != 0 && (dtdValue = StringHelper.normalize(Resource.read(resourcePath))).length() != 0) {
                            if (Debug.isMessageEnabled()) {
                                Debug.message(" System ID: " + aSystemID + "Public ID: " + aPublicID);
                            }
                            return new InputSource(new StringReader(dtdValue));
                        }
                    }
                    catch (Exception e) {
                        if (!Debug.isMessageEnabled()) break block5;
                        Debug.warning("Error while reading the DTD..", e);
                    }
                }
            }
            return null;
        }
    }
}

