/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.urlscraper;

import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.urlscraper.Header;
import com.sun.portal.providers.urlscraper.URLScraperProvider;
import com.sun.portal.rewriter.AbsoluteTranslator;
import com.sun.portal.rewriter.RewriterModule;
import com.sun.portal.rewriter.RewriterPool;
import com.sun.portal.rewriter.Translator;
import com.sun.portal.rewriter.rom.InvalidXMLException;
import com.sun.portal.rewriter.util.uri.PageSpec;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class Fetcher
extends Thread {
    private final int CONTENT_BUFFER_SIZE = 2048;
    private StringBuffer content = null;
    private String data = null;
    private URL url = null;
    private URL requestURL = null;
    private URLScraperProvider provider = null;
    private boolean terminated = false;
    private boolean finished = false;
    private boolean allCookies = false;
    private List cookiesToForwardList = null;
    private ProviderContext context = null;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ResourceBundle bundle = null;
    private String rulesetID = null;
    private String contentType = null;
    private static List ignoreHeaders = new ArrayList();

    public Fetcher(String string, URLScraperProvider uRLScraperProvider, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ResourceBundle resourceBundle, String string2) throws MalformedURLException, ProviderException {
        this.provider = uRLScraperProvider;
        this.context = this.provider.getProviderContext();
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.requestURL = new URL(this.context.getRequestServer(this.request).toString());
        this.url = new URL(this.getAbsURL(string));
        this.bundle = resourceBundle;
        this.rulesetID = string2;
        this.allCookies = this.provider.getBooleanProperty("cookiesToForwardAll");
        this.cookiesToForwardList = this.provider.getListProperty("cookiesToForwardList");
        this.setDaemon(true);
    }

    public StringBuffer getContent() {
        return this.content;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void terminate() {
        this.terminated = true;
        this.interrupt();
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block44: {
            block43: {
                if (this.isTerminated()) {
                    return;
                }
                var1_1 = null;
                var2_2 = null;
                try {
                    try {
                        var3_3 = null;
                        try {
                            var3_3 = (HttpURLConnection)this.url.openConnection();
                        }
                        catch (ClassCastException var4_5) {
                            throw new ProviderException("URLScraperProvider doesn't support ftp, file urls. URL:" + this.url, (Throwable)var4_5);
                        }
                        if (var3_3 == null) {
                            throw new ProviderException("Fetcher.run(): URLConnection object is null");
                        }
                        var3_3.setDoInput(true);
                        var3_3.setUseCaches(false);
                        if (this.request != null) {
                            var4_6 = this.request.getCookies();
                            var5_9 = null;
                            if (var4_6 != null) {
                                var5_9 = new Vector<Cookie>(var4_6.length);
                                var6_12 = 0;
                                while (var6_12 < var4_6.length) {
                                    if (this.provider.forward(var4_6[var6_12].getName(), this.allCookies, this.cookiesToForwardList)) {
                                        var5_9.add(var4_6[var6_12]);
                                    }
                                    ++var6_12;
                                }
                            }
                            if (var5_9 != null && var5_9.size() > 0) {
                                var6_13 = new StringBuffer();
                                if (this.context.isDebugMessageEnabled()) {
                                    this.context.debugMessage((Object)("cookieTable=" + this.provider.cookieTable));
                                }
                                var7_16 = var5_9.iterator();
                                while (true) {
                                    if (!var7_16.hasNext()) {
                                        if (this.context.isDebugMessageEnabled()) {
                                            this.context.debugMessage((Object)("Fetcher.run(): Forwarded cookie header: " + var6_13.toString()));
                                            this.context.debugMessage((Object)("Fetcher.run(): cookieMap=" + this.provider.cookieTable));
                                        }
                                        var3_3.setRequestProperty("Cookie", var6_13.toString());
                                        break;
                                    }
                                    var8_18 = (Cookie)var7_16.next();
                                    var9_19 /* !! */  = null;
                                    var10_21 = null;
                                    var11_22 = var8_18.getName();
                                    var12_23 = URLDecoder.decode(var11_22);
                                    var12_23 = URLEncoder.encode(var12_23);
                                    if (this.provider.cookieTable != null && this.provider.cookieTable.containsKey(var12_23)) {
                                        var13_24 = (domainPathEntry)this.provider.cookieTable.get(var12_23);
                                        var11_22 = var11_22.substring(0, var11_22.indexOf("_"));
                                        var9_19 /* !! */  = (byte[])var13_24.getPath();
                                        var10_21 = var13_24.getDomain();
                                    }
                                    var6_13.append(var11_22).append("=").append(URLEncoder.encode(var8_18.getValue()));
                                    if (var9_19 /* !! */  != null) {
                                        var6_13.append("; ").append("$Path=" + (String)var9_19 /* !! */ );
                                    }
                                    if (var10_21 != null) {
                                        var6_13.append("; ").append("$Domain=" + var10_21);
                                    }
                                    if (!var7_16.hasNext()) continue;
                                    var6_13.append("; ");
                                }
                            }
                        }
                        this.setHeaders(var3_3, this.request);
                        var4_7 = var3_3.getContentLength();
                        var5_10 = var3_3.getResponseCode();
                        if (this.context.isDebugMessageEnabled()) {
                            this.context.debugMessage((Object)("Fetcher.run(): got response, code=" + var5_10));
                        }
                        if (var5_10 == -1) {
                            this.context.debugError((Object)"Fetcher.run(): response code was -1!");
                            var15_25 = null;
                            break block43;
                        }
                        if (var5_10 == 301 || var5_10 == 302) {
                            var6_14 = var3_3.getHeaderField("Location");
                            var7_16 = new Header(var6_14);
                            if (this.context.isDebugMessageEnabled()) {
                                this.context.debugMessage((Object)("Fetcher.run(): got redirect, location=" + var7_16.getValue()));
                            }
                            this.url = new URL(this.getAbsURL(var7_16.getValue()));
                            var9_20 = 1;
                            while (true) {
                                if ((var8_18 = var3_3.getHeaderFieldKey(var9_20)) == null) break;
                                if (var8_18.equalsIgnoreCase("Set-cookie")) {
                                    var10_21 = var3_3.getHeaderField(var9_20);
                                    this.processSetCookieHeader(var10_21);
                                }
                                ++var9_20;
                            }
                            this.run();
                            var15_26 = null;
                            try {
                                if (var1_1 == null) return;
                                var1_1.close();
                                return;
                            }
                            catch (IOException var16_33) {
                                // empty catch block
                            }
                            return;
                        }
                        var7_17 = 1;
                        while (true) {
                            if ((var6_15 = var3_3.getHeaderFieldKey(var7_17)) == null) {
                                this.contentType = var3_3.getContentType();
                                var8_18 = new PageSpec(var3_3.getURL().toString(), this.contentType);
                                var1_1 = var3_3.getInputStream();
                                var9_19 /* !! */  = this.provider.readContent(var1_1, var4_7);
                                var2_2 = this.provider.getContentEncoding(this.contentType, var9_19 /* !! */ , var8_18.getMIME());
                                this.data = var2_2 != null && var2_2.length() != 0 ? new String(var9_19 /* !! */ , var2_2) : new String(var9_19 /* !! */ );
                            }
                            if (var6_15.equalsIgnoreCase("Set-cookie")) {
                                var8_18 = var3_3.getHeaderField(var7_17);
                                this.processSetCookieHeader((String)var8_18);
                            }
                            ++var7_17;
                        }
                        var10_21 = RewriterPool.getDefault().getRewriter(this.rulesetID, (PageSpec)var8_18);
                        if (var10_21 != null) {
                            var11_22 = new AbsoluteTranslator((PageSpec)var8_18);
                            this.content = new StringBuffer(var10_21.rewrite(this.data, (Translator)var11_22));
                        } else {
                            this.content = new StringBuffer(this.data);
                        }
                        if (this.context.isDebugMessageEnabled()) {
                            this.context.debugMessage((Object)("Fetcher.run(): got content=\n" + this.content.toString()));
                        }
                        this.finished = true;
                        break block44;
                    }
                    catch (InvalidXMLException var3_4) {
                        this.context.debugError((Object)"Fetcher.run(): ", (Throwable)var3_4);
                        this.content = new StringBuffer(this.bundle.getString("invalidruleset"));
                        this.finished = true;
                        var15_28 = null;
                        try {}
                        catch (IOException var16_35) {
                            return;
                        }
                        if (var1_1 == null) return;
                        var1_1.close();
                        return;
                    }
                    catch (UnsupportedEncodingException var4_8) {
                        this.context.debugError((Object)("Fetcher.run():Invalid charset " + var2_2));
                        this.context.debugError((Object)"Fetcher.run():Unsupported Encoding.", (Throwable)var4_8);
                        this.content = new StringBuffer(this.bundle.getString("unsupportedencoding"));
                        this.finished = true;
                        var15_29 = null;
                        try {}
                        catch (IOException var16_36) {
                            return;
                        }
                        if (var1_1 == null) return;
                        var1_1.close();
                        return;
                    }
                    catch (Exception var5_11) {
                        this.context.debugError((Object)"Exception in Fetcher:run()", (Throwable)var5_11);
                        this.content = null;
                        this.finished = true;
                        var15_30 = null;
                        try {}
                        catch (IOException var16_37) {
                            return;
                        }
                        if (var1_1 == null) return;
                        var1_1.close();
                        return;
                    }
                }
                catch (Throwable var14_39) {
                    var15_31 = null;
                    ** try [egrp 3[TRYBLOCK] [5 : 1258->1269)] { 
lbl163:
                    // 1 sources

                    if (var1_1 == null) throw var14_39;
                    var1_1.close();
                    throw var14_39;
lbl166:
                    // 1 sources

                    catch (IOException var16_38) {
                        // empty catch block
                    }
                    throw var14_39;
                }
            }
            ** try [egrp 3[TRYBLOCK] [5 : 1258->1269)] { 
lbl171:
            // 1 sources

            if (var1_1 == null) return;
            var1_1.close();
            return;
lbl174:
            // 1 sources

            catch (IOException var16_32) {
                // empty catch block
            }
            return;
        }
        var15_27 = null;
        try {}
        catch (IOException var16_34) {}
        if (var1_1 == null) return;
        var1_1.close();
        return;
    }

    private String getCookieName(String string) {
        String string2 = null;
        int n = string.indexOf("=");
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    private void processSetCookieHeader(String string) {
        block7: {
            String string2 = this.modifyCookieHeader(string);
            if (this.context.isDebugMessageEnabled()) {
                this.context.debugMessage((Object)("Fetcher.processSetCookieHeader(): Original set-cookie=" + string + "Modified set-cookie=" + string2));
            }
            if (string2 != null) {
                string = string2;
            }
            try {
                String string3;
                if (string == null || this.response == null || (string3 = this.getCookieName(string)) == null || !this.provider.forward(string3, this.allCookies, this.cookiesToForwardList)) break block7;
                HttpServletResponse httpServletResponse = this.response;
                synchronized (httpServletResponse) {
                    this.response.addHeader("Set-Cookie", string);
                }
            }
            catch (Exception exception) {
                this.context.debugError((Object)("Fetcher.processSetCookieHeader(): invalid cookie: " + string), (Throwable)exception);
            }
        }
    }

    private String getAbsURL(String string) throws MalformedURLException {
        if (!string.regionMatches(true, 0, "http://", 0, 7) && !string.regionMatches(true, 0, "https://", 0, 8)) {
            String string2 = this.requestURL.getProtocol();
            StringBuffer stringBuffer = new StringBuffer().append(string2).append("://").append(this.requestURL.getHost()).append(":");
            int n = this.requestURL.getPort();
            if (string2.equals("http") && n <= 0) {
                n = 80;
            } else if (string2.equals("https") && n <= 0) {
                n = 443;
            }
            stringBuffer.append(n).append(string);
            return stringBuffer.toString();
        }
        return string;
    }

    private String modifyCookieHeader(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (!stringTokenizer.hasMoreTokens()) {
            return string;
        }
        String string2 = stringTokenizer.nextToken().trim();
        String string3 = this.getCookieName(string);
        String string4 = string2.substring(string3.length() + 1);
        String string5 = this.url.getHost();
        String string6 = this.requestURL.getHost();
        StringBuffer stringBuffer = new StringBuffer();
        String string7 = string3 + "_" + string4;
        string7 = URLDecoder.decode(string7);
        string7 = URLEncoder.encode(string7);
        stringBuffer.append(string7).append("=").append(string4);
        String string8 = null;
        String string9 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string10;
            String string11;
            String string12 = stringTokenizer.nextToken().trim();
            if (string12.length() == 0) continue;
            int n = string12.indexOf(61);
            if (n < 0) {
                string11 = string12;
                string10 = null;
            } else {
                string11 = string12.substring(0, n).trim();
                string10 = n + 1 == string12.length() ? null : string12.substring(n + 1).trim();
            }
            if (string11.equalsIgnoreCase("path")) {
                string8 = string10;
                if (string8 == null || string8.startsWith("/")) continue;
                return null;
            }
            if (string11.equalsIgnoreCase("domain")) {
                string9 = string10;
                if (string9 == null) continue;
                if (string9.charAt(0) != '.' || string9.length() < 4) {
                    return null;
                }
                if (string9.charAt(string9.length() - 1) == '.') {
                    return null;
                }
                if (string5.toLowerCase().endsWith(string9.toLowerCase())) continue;
                return null;
            }
            stringBuffer.append(";" + string12);
        }
        String string13 = this.getDomain(string6);
        if (string9 != null && string8 != null) {
            if (!string9.equalsIgnoreCase(string13) || !string8.equalsIgnoreCase(this.getPath())) {
                this.provider.cookieTable.put(string7, new domainPathEntry(string9, string8));
            }
        } else {
            this.provider.cookieTable.put(string7, new domainPathEntry(string9, string8));
        }
        stringBuffer.append(";domain=").append(string13).append(";path=/");
        return stringBuffer.toString();
    }

    private String getPath() {
        return this.request.getContextPath() + this.request.getServletPath();
    }

    private String getDomain(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        int n2 = string.substring(0, n).lastIndexOf(46);
        if (n == -1 || n2 == -1) {
            return string;
        }
        return string.substring(n2);
    }

    protected void setHeaders(URLConnection uRLConnection, HttpServletRequest httpServletRequest) {
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string == null) continue;
                String string2 = string.toLowerCase();
                String string3 = httpServletRequest.getHeader(string);
                if (this.context.isDebugMessageEnabled()) {
                    this.context.debugMessage((Object)("Fetcher.setHeader():  header:" + string + " = " + string3));
                }
                if (ignoreHeaders.contains(string2) || string3 == null) continue;
                uRLConnection.setRequestProperty(string, string3);
                if (!this.context.isDebugMessageEnabled()) continue;
                this.context.debugMessage((Object)("URLScraperProvider's Fetcher.setHeader(): added header: " + string + " = " + string3));
            }
        }
    }

    String getContentType() {
        return this.contentType;
    }

    static {
        ignoreHeaders.add("host");
        ignoreHeaders.add("cookie");
        ignoreHeaders.add("connection");
        ignoreHeaders.add("content-length");
        ignoreHeaders.add("accept-encoding");
        ignoreHeaders.add("location");
        RewriterModule.initIDSAME();
    }

    static class domainPathEntry {
        String domain = null;
        String path = null;

        domainPathEntry(String string, String string2) {
            this.domain = string;
            this.path = string2;
        }

        String getPath() {
            return this.path;
        }

        String getDomain() {
            return this.domain;
        }
    }
}

