/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainercommon.descriptor;

import com.sun.portal.common.logging.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom.Element;
import org.jdom.Namespace;

public class PortletInfoDescriptor {
    public static final String TITLE = "title";
    public static final String SHORT_TITLE = "short-title";
    public static final String KEYWORDS = "keywords";
    private String _title;
    private String _shortTitle;
    private List _keywords = new ArrayList();
    private Logger _logger;

    public PortletInfoDescriptor(Logger logger) {
        this._logger = logger;
    }

    public void load(Element element, Namespace namespace) {
        this._title = element.getChildTextTrim(TITLE, namespace);
        this._shortTitle = element.getChildTextTrim(SHORT_TITLE, namespace);
        String keywordsStr = element.getChildTextTrim(KEYWORDS, namespace);
        if (keywordsStr != null) {
            this.loadKeywords(keywordsStr);
        }
    }

    public String getTitle() {
        return this._title;
    }

    public String getShortTitle() {
        return this._shortTitle;
    }

    public List getKeywords() {
        return this._keywords;
    }

    private void loadKeywords(String keywordsStr) {
        StringTokenizer st = new StringTokenizer(keywordsStr, ",", false);
        while (st.hasMoreTokens()) {
            this._keywords.add(st.nextToken().trim());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PortletInfoDescriptor ");
        if (this._title != null) {
            sb.append(" title [");
            sb.append(this._title);
            sb.append("]");
        }
        if (this._shortTitle != null) {
            sb.append(" short title [");
            sb.append(this._shortTitle);
            sb.append("]");
        }
        sb.append(" keywords [");
        int i = 0;
        while (i < this._keywords.size()) {
            sb.append((String)this._keywords.get(i));
            sb.append(", ");
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }
}

