/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.rproxy.connectionhandler.CachedSocket;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CSBufferedInputStream
extends BufferedInputStream {
    private CachedSocket _socket = null;
    private int _expectedLength = 0;
    private int _currentPos = 0;
    private boolean _keepAlive = false;

    public CSBufferedInputStream(InputStream inputStream, CachedSocket cachedSocket, int n) {
        this(inputStream);
        this._socket = cachedSocket;
        this._expectedLength = n;
    }

    public CSBufferedInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public void setSocket(CachedSocket cachedSocket) {
        this._socket = cachedSocket;
    }

    public CachedSocket getSocket() {
        return this._socket;
    }

    public void setLength(int n) {
        this._expectedLength = n;
        this._currentPos = 0;
    }

    public int getLength() {
        return this._expectedLength;
    }

    public int getPos() {
        return this._currentPos;
    }

    public void setKeepAlive() {
        this._keepAlive = true;
    }

    public void setClosed() {
        this._keepAlive = false;
    }

    public synchronized int read() {
        int n = -1;
        try {
            if (this._expectedLength != -1) {
                if (this._currentPos == this._expectedLength && this._keepAlive) {
                    this.readToEnd();
                    this._currentPos = 0;
                    this._socket.setIdle();
                    n = -1;
                } else {
                    n = super.read();
                    ++this._currentPos;
                    if (n == -1) {
                        this._currentPos = 0;
                        this._socket.close();
                    }
                }
            } else {
                n = super.read();
                if (n == -1) {
                    this._socket.close();
                }
            }
        }
        catch (IOException iOException) {
            this._currentPos = 0;
            n = -1;
            try {
                this._socket.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
        return n;
    }

    public synchronized int read(byte[] byArray, int n, int n2) {
        int n3 = -1;
        try {
            if (this._expectedLength != -1 && this._currentPos == this._expectedLength && this._keepAlive) {
                this.readToEnd();
                this._currentPos = 0;
                this._socket.setIdle();
                n3 = -1;
            } else if (this._expectedLength != -1) {
                if (this._currentPos + n2 > this._expectedLength) {
                    n2 = this._expectedLength - this._currentPos;
                }
                if (n2 == 0) {
                    this._socket.close();
                    n3 = -1;
                } else {
                    n3 = super.read(byArray, n, n2);
                    if (n3 != -1) {
                        this._currentPos += n3;
                    } else {
                        this._socket.close();
                    }
                }
            } else if (n2 == 0) {
                this._socket.close();
                n3 = -1;
            } else {
                n3 = super.read(byArray, n, n2);
                if (n3 == -1) {
                    this._socket.close();
                }
            }
        }
        catch (IOException iOException) {
            this._currentPos = 0;
            n3 = -1;
            try {
                this._socket.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
        return n3;
    }

    public synchronized long skip(long l) {
        long l2 = 0L;
        try {
            l2 = super.skip(l);
            this._currentPos = (int)((long)this._currentPos + l2);
        }
        catch (IOException iOException) {
            try {
                this._socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return l2;
    }

    public synchronized void readToEnd() {
        if (this._expectedLength != -1) {
            while (this._currentPos < this._expectedLength && this.read() != -1) {
            }
        }
    }
}

