/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.urlscraper;

import com.sun.portal.providers.urlscraper.ContentFilter;
import com.sun.portal.providers.urlscraper.ContentFilterException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class ContentFilterImpl
implements ContentFilter {
    private static final String defaultFilterClassName = "com.sun.portal.providers.urlscraper.ContentFilterImpl";
    private static HashMap filterClassNames = new HashMap();
    private static Map filterClassCache;
    private static ContentFilter defaultFilterInstance;

    ContentFilterImpl() {
    }

    public StringBuffer filter(StringBuffer stringBuffer) {
        return stringBuffer;
    }

    public static ContentFilter getInstance(String string) throws ContentFilterException {
        ContentFilter contentFilter = (ContentFilter)filterClassCache.get(string);
        if (contentFilter == null) {
            String string2 = (String)filterClassNames.get(string);
            if (string2 == null) {
                if (defaultFilterInstance == null) {
                    defaultFilterInstance = ContentFilterImpl.createInstance(defaultFilterClassName);
                }
                contentFilter = defaultFilterInstance;
            } else {
                contentFilter = ContentFilterImpl.createInstance(string2);
            }
            ContentFilterImpl.addToCache(string, contentFilter);
        }
        return contentFilter;
    }

    private static ContentFilter createInstance(String string) throws ContentFilterException {
        ContentFilter contentFilter = null;
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            contentFilter = (ContentFilter)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        if (reflectiveOperationException != null) {
            throw new ContentFilterException("ContentFilterImpl.getInstance failed ", reflectiveOperationException);
        }
        return contentFilter;
    }

    private static void addToCache(String string, ContentFilter contentFilter) {
        Map map = filterClassCache;
        synchronized (map) {
            filterClassCache.put(string, contentFilter);
        }
    }

    static {
        filterClassNames.put("text/vnd.wap.wml", "com.sun.portal.providers.urlscraper.WMLContentFilter");
        filterClassCache = Collections.synchronizedMap(new HashMap());
        defaultFilterInstance = null;
    }
}

